/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.videocall;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.model.videocall.MessageInfo;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.videocall.AuthService;
import org.exoplatform.services.videocall.VideoCallService;
import org.exoplatform.services.videocall.WebNotificationSender;
import org.exoplatform.utils.videocall.PropertyManager;
import org.json.JSONObject;

@Path(value="/weemo/")
public class RESTAuthService
implements ResourceContainer {
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private AuthService authService;

    @GET
    @Path(value="/auth/")
    @RolesAllowed(value={"users"})
    public Response auth() {
        this.authService = new AuthService();
        String profileId = PropertyManager.getProperty("video_profile");
        String content = this.authService.authenticate(null, profileId);
        return Response.ok((Object)content, (String)"application/json").build();
    }

    @GET
    @Path(value="/verify/")
    @RolesAllowed(value={"users"})
    public Response verifyPermission(@QueryParam(value="permissionId") String permissionId) throws Exception {
        this.authService = new AuthService();
        JSONObject json = this.authService.verifyPermission(permissionId);
        return Response.ok((Object)json.toString(), (String)"application/json").build();
    }

    @GET
    @Path(value="/auth/{profileId}/")
    @RolesAllowed(value={"users"})
    public Response auth(@PathParam(value="profileId") String profileId) {
        this.authService = new AuthService();
        String content = this.authService.authenticate(null, profileId);
        return Response.ok((Object)content, (String)"application/json").build();
    }

    @GET
    @Path(value="/hasOneOneCallPermission/{userId}/")
    @RolesAllowed(value={"users"})
    public Response hasOneOneCallPermission(@PathParam(value="userId") String userId) throws Exception {
        VideoCallService videoCallService = new VideoCallService();
        boolean hasOneOneCallPermission = !videoCallService.isTurnOffVideoCallForUser(false, userId);
        return Response.ok((Object)String.valueOf(hasOneOneCallPermission)).build();
    }

    @GET
    @Path(value="/sendMessage/{callee}/{messageType}/{callMode}")
    @RolesAllowed(value={"users"})
    public Response sendMessage(@PathParam(value="callee") String callee, @PathParam(value="messageType") String messageType, @PathParam(value="callMode") String callMode) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        MessageInfo messageInfo = new MessageInfo(messageType, ConversationState.getCurrent().getIdentity().getUserId(), callee, "one");
        WebNotificationSender.sendJsonMessage(callee, messageInfo);
        return Response.ok().cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/getAvatarURL/{userId}/")
    @RolesAllowed(value={"users"})
    public Response getAvatarURL(@PathParam(value="userId") String userId, @Context UriInfo uri) {
        return this.getAvartar(false, userId, uri);
    }

    @GET
    @Path(value="/getSpaceAvartar/{spaceName}/")
    @RolesAllowed(value={"users"})
    public Response getSpaceAvartar(@PathParam(value="spaceName") String spaceName, @Context UriInfo uri) {
        return this.getAvartar(true, spaceName, uri);
    }

    private Response getAvartar(boolean isSpace, String spaceOrUserId, UriInfo uri) {
        CacheControl cacheControl = new CacheControl();
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        String scheme = uri.getBaseUri().getScheme();
        String serverName = uri.getBaseUri().getHost();
        int serverPort = uri.getBaseUri().getPort();
        String serverBase = scheme + "://" + serverName;
        if (serverPort != 80) {
            serverBase = serverBase + ":" + serverPort;
        }
        InputStream in = null;
        URL url = null;
        String avartarURL = "/rest/jcr/repository/social/production/soc:providers/soc:";
        avartarURL = isSpace ? avartarURL.concat("space") : avartarURL.concat("organization");
        avartarURL = avartarURL.concat("/soc:").concat(spaceOrUserId).concat("/soc:profile/soc:avatar");
        try {
            url = new URL(serverBase.concat(avartarURL));
            URLConnection con = url.openConnection();
            con.setDoOutput(true);
            in = con.getInputStream();
        }
        catch (Exception e) {
            try {
                String defaultAvartarURL = "/eXoSkin/skin/images/themes/default/social/skin/ShareImages/UserAvtDefault.png";
                if (isSpace) {
                    defaultAvartarURL = "/weemo-extension/img/SpaceChatAvatar.png";
                }
                url = new URL(serverBase + defaultAvartarURL);
                URLConnection con = url.openConnection();
                con.setDoOutput(true);
                in = con.getInputStream();
            }
            catch (Exception e1) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        return Response.ok((Object)in, (String)"Image").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }
}

