/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.EntityConverter;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure1;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure11;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure13;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure15;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure17;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure19;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure3;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure5;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure7;
import org.exoplatform.wiki.jpa.JPADataStorage$AjcClosure9;
import org.exoplatform.wiki.jpa.dao.DraftPageAttachmentDAO;
import org.exoplatform.wiki.jpa.dao.DraftPageDAO;
import org.exoplatform.wiki.jpa.dao.EmotionIconDAO;
import org.exoplatform.wiki.jpa.dao.PageAttachmentDAO;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.dao.PageMoveDAO;
import org.exoplatform.wiki.jpa.dao.PageVersionDAO;
import org.exoplatform.wiki.jpa.dao.TemplateDAO;
import org.exoplatform.wiki.jpa.dao.WikiDAO;
import org.exoplatform.wiki.jpa.entity.AttachmentEntity;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.DraftPageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.EmotionIconEntity;
import org.exoplatform.wiki.jpa.entity.PageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PageMoveEntity;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;
import org.exoplatform.wiki.jpa.entity.TemplateEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.jpa.search.WikiElasticSearchServiceConnector;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.EmotionIcon;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Template;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.exoplatform.wiki.service.search.TemplateSearchData;
import org.exoplatform.wiki.service.search.TemplateSearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.utils.Utils;
import org.exoplatform.wiki.utils.VersionNameComparatorDesc;

public class JPADataStorage
implements DataStorage {
    public static final String WIKI_TYPE_DRAFT = "draft";
    private WikiDAO wikiDAO;
    private PageDAO pageDAO;
    private PageAttachmentDAO pageAttachmentDAO;
    private DraftPageAttachmentDAO draftPageAttachmentDAO;
    private DraftPageDAO draftPageDAO;
    private PageVersionDAO pageVersionDAO;
    private PageMoveDAO pageMoveDAO;
    private TemplateDAO templateDAO;
    private EmotionIconDAO emotionIconDAO;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public JPADataStorage(WikiDAO wikiDAO, PageDAO pageDAO, PageAttachmentDAO pageAttachmentDAO, DraftPageAttachmentDAO draftPageAttachmentDAO, DraftPageDAO draftPageDAO, PageVersionDAO pageVersionDAO, PageMoveDAO pageMoveDAO, TemplateDAO templateDAO, EmotionIconDAO emotionIconDAO, DataInitializer dataInitializer) {
        this.wikiDAO = wikiDAO;
        this.pageDAO = pageDAO;
        this.pageAttachmentDAO = pageAttachmentDAO;
        this.draftPageAttachmentDAO = draftPageAttachmentDAO;
        this.draftPageDAO = draftPageDAO;
        this.pageVersionDAO = pageVersionDAO;
        this.pageMoveDAO = pageMoveDAO;
        this.templateDAO = templateDAO;
        this.emotionIconDAO = emotionIconDAO;
    }

    public PageList<SearchResult> search(WikiSearchData wikiSearchData) {
        WikiElasticSearchServiceConnector searchService = (WikiElasticSearchServiceConnector)((Object)PortalContainer.getInstance().getComponentInstanceOfType(WikiElasticSearchServiceConnector.class));
        String wikiOwner = wikiSearchData.getWikiOwner();
        if (wikiSearchData.getWikiType().toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.pageDAO.validateGroupWikiOwner(wikiOwner);
        }
        List<SearchResult> searchResults = searchService.searchWiki(this.getSearchedText(wikiSearchData), wikiSearchData.getWikiType(), wikiOwner, (int)wikiSearchData.getOffset(), wikiSearchData.getLimit(), wikiSearchData.getSort(), wikiSearchData.getOrder());
        return new ObjectPageList(searchResults, searchResults.size());
    }

    private String getSearchedText(WikiSearchData wikiSearchData) {
        String searchText = "";
        if (StringUtils.isNotBlank((String)wikiSearchData.getTitle())) {
            searchText = wikiSearchData.getTitle();
        } else if (StringUtils.isNotBlank((String)wikiSearchData.getContent())) {
            searchText = wikiSearchData.getContent();
        }
        return searchText;
    }

    private SearchResult toSearchResult(org.exoplatform.commons.api.search.data.SearchResult input) {
        SearchResult output = new SearchResult();
        output.setTitle(input.getTitle());
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(input.getDate());
        output.setCreatedDate(cal);
        output.setExcerpt(input.getExcerpt());
        output.setPageName(input.getTitle());
        output.setUrl(input.getUrl());
        return output;
    }

    public Wiki getWikiByTypeAndOwner(String wikiType, String wikiOwner) throws WikiException {
        return EntityConverter.convertWikiEntityToWiki(this.wikiDAO.getWikiByTypeAndOwner(wikiType, wikiOwner));
    }

    public List<Wiki> getWikisByType(String wikiType) throws WikiException {
        ArrayList<Wiki> wikis = new ArrayList<Wiki>();
        for (WikiEntity wikiEntity : this.wikiDAO.getWikisByType(wikiType)) {
            wikis.add(EntityConverter.convertWikiEntityToWiki(wikiEntity));
        }
        return wikis;
    }

    @ExoTransactional
    public Wiki createWiki(Wiki wiki) throws WikiException {
        Wiki wiki2 = wiki;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)wiki2);
        Object[] objectArray = new Object[]{this, wiki2, joinPoint};
        return (Wiki)ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Page createPage(Wiki wiki, Page parentPage, Page page) throws WikiException {
        Wiki wiki2 = wiki;
        Page page2 = parentPage;
        Page page3 = page;
        Object[] objectArray = new Object[]{wiki2, page2, page3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, wiki2, page2, page3, joinPoint};
        return (Page)ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public Page getPageOfWikiByName(String wikiType, String wikiOwner, String pageName) throws WikiException {
        if (wikiType == null || wikiOwner == null) {
            return null;
        }
        if (WIKI_TYPE_DRAFT.equals(wikiType)) {
            return EntityConverter.convertDraftPageEntityToDraftPage(this.draftPageDAO.findLatestDraftPageByUserAndName(wikiOwner, pageName));
        }
        return EntityConverter.convertPageEntityToPage(this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, pageName));
    }

    public Page getPageById(String id) throws WikiException {
        return EntityConverter.convertPageEntityToPage((PageEntity)this.pageDAO.find(Long.valueOf(Long.parseLong(id))));
    }

    public Page getParentPageOf(Page page) throws WikiException {
        Page parentPage = null;
        PageEntity childPageEntity = null;
        childPageEntity = page.getId() != null && !page.getId().isEmpty() ? (PageEntity)this.pageDAO.find(Long.valueOf(Long.parseLong(page.getId()))) : this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (childPageEntity != null) {
            parentPage = EntityConverter.convertPageEntityToPage(childPageEntity.getParentPage());
        }
        return parentPage;
    }

    public List<Page> getChildrenPageOf(Page page) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot get children of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<Page> childrenPages = new ArrayList<Page>();
        List<PageEntity> childrenPagesEntities = this.pageDAO.getChildrenPages(pageEntity);
        if (childrenPagesEntities != null) {
            for (PageEntity childPageEntity : childrenPagesEntities) {
                childrenPages.add(EntityConverter.convertPageEntityToPage(childPageEntity));
            }
        }
        return childrenPages;
    }

    @ExoTransactional
    public void deletePage(String wikiType, String wikiOwner, String pageName) throws WikiException {
        String string = wikiType;
        String string2 = wikiOwner;
        String string3 = pageName;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private void deletePageEntity(PageEntity pageEntity) {
        List<PageEntity> childrenPages = this.pageDAO.getChildrenPages(pageEntity);
        if (childrenPages != null) {
            for (PageEntity childPage : childrenPages) {
                this.deletePageEntity(childPage);
            }
        }
        pageEntity.setDeleted(true);
        this.pageDAO.update(pageEntity);
    }

    public void createTemplatePage(Wiki wiki, Template template) throws WikiException {
        template.setWikiId(wiki.getId());
        template.setWikiType(wiki.getType());
        template.setWikiOwner(wiki.getOwner());
        Date createdDate = template.getCreatedDate();
        Date updatedDate = template.getUpdatedDate();
        if (createdDate == null || updatedDate == null) {
            Date now = Calendar.getInstance().getTime();
            if (createdDate == null) {
                template.setCreatedDate(now);
            }
            if (updatedDate == null) {
                template.setUpdatedDate(now);
            }
        }
        this.templateDAO.create(EntityConverter.convertTemplateToTemplateEntity(template, this.wikiDAO));
    }

    public void updateTemplatePage(Template template) throws WikiException {
        TemplateEntity templateEntity = template.getId() != null && !template.getId().isEmpty() ? (TemplateEntity)this.templateDAO.find(Long.valueOf(Long.parseLong(template.getId()))) : this.templateDAO.getTemplateOfWikiByName(template.getWikiType(), template.getWikiOwner(), template.getName());
        if (templateEntity == null) {
            throw new WikiException("Cannot update template " + template.getWikiType() + ":" + template.getWikiOwner() + ":" + template.getName() + " because template does not exist.");
        }
        templateEntity.setName(template.getName());
        templateEntity.setTitle(template.getTitle());
        templateEntity.setDescription(template.getDescription());
        templateEntity.setContent(template.getContent());
        templateEntity.setSyntax(template.getSyntax());
        templateEntity.setUpdatedDate(Calendar.getInstance().getTime());
        this.templateDAO.update(templateEntity);
    }

    public void deleteTemplatePage(String wikiType, String wikiOwner, String templateName) throws WikiException {
        TemplateEntity templateEntity = this.templateDAO.getTemplateOfWikiByName(wikiType, wikiOwner, templateName);
        if (templateEntity == null) {
            throw new WikiException("Cannot delete template " + wikiType + ":" + wikiOwner + ":" + templateName + " because template does not exist.");
        }
        this.templateDAO.delete(templateEntity);
    }

    public Template getTemplatePage(WikiPageParams params, String templateName) throws WikiException {
        TemplateEntity templateEntity = this.templateDAO.getTemplateOfWikiByName(params.getType(), params.getOwner(), templateName);
        return EntityConverter.convertTemplateEntityToTemplate(templateEntity);
    }

    public Map<String, Template> getTemplates(WikiPageParams wikiPageParams) throws WikiException {
        HashMap<String, Template> templates = new HashMap<String, Template>();
        List<TemplateEntity> templatesEntities = this.templateDAO.getTemplatesOfWiki(wikiPageParams.getType(), wikiPageParams.getOwner());
        if (templatesEntities != null) {
            for (TemplateEntity templateEntity : templatesEntities) {
                templates.put(templateEntity.getName(), EntityConverter.convertTemplateEntityToTemplate(templateEntity));
            }
        }
        return templates;
    }

    public void deleteDraftOfPage(Page page, String username) throws WikiException {
        this.draftPageDAO.deleteDraftPagesByUserAndTargetPage(username, Long.valueOf(page.getId()));
    }

    public void deleteDraftByName(String draftPageName, String username) throws WikiException {
        this.draftPageDAO.deleteDraftPagesByUserAndName(draftPageName, username);
    }

    @ExoTransactional
    public void renamePage(String wikiType, String wikiOwner, String pageName, String newName, String newTitle) throws WikiException {
        String string = wikiType;
        String string2 = wikiOwner;
        String string3 = pageName;
        String string4 = newName;
        String string5 = newTitle;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, string5, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void movePage(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws WikiException {
        WikiPageParams wikiPageParams = currentLocationParams;
        WikiPageParams wikiPageParams2 = newLocationParams;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)wikiPageParams, (Object)wikiPageParams2);
        Object[] objectArray = new Object[]{this, wikiPageParams, wikiPageParams2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    public List<PermissionEntry> getWikiPermission(String wikiType, String wikiOwner) throws WikiException {
        WikiEntity wikiEntity = this.wikiDAO.getWikiByTypeAndOwner(wikiType, wikiOwner);
        if (wikiEntity == null) {
            throw new WikiException("Cannot get permissions of wiki " + wikiType + ":" + wikiOwner + " because wiki does not exist.");
        }
        return EntityConverter.convertPermissionEntitiesToPermissionEntries(wikiEntity.getPermissions(), Arrays.asList(PermissionType.VIEWPAGE, PermissionType.EDITPAGE, PermissionType.ADMINPAGE, PermissionType.ADMINSPACE));
    }

    public void updateWikiPermission(String wikiType, String wikiOwner, List<PermissionEntry> permissionEntries) throws WikiException {
        WikiEntity wikiEntity = this.wikiDAO.getWikiByTypeAndOwner(wikiType, wikiOwner);
        if (wikiEntity == null) {
            throw new WikiException("Cannot update permissions of wiki " + wikiType + ":" + wikiOwner + " because wiki does not exist.");
        }
        wikiEntity.setPermissions(EntityConverter.convertPermissionEntriesToPermissionEntities(permissionEntries));
        this.wikiDAO.update(wikiEntity);
    }

    public List<Page> getRelatedPagesOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot get related pages of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<Page> relatedPages = new ArrayList<Page>();
        List<PageEntity> relatedPagesEntities = pageEntity.getRelatedPages();
        if (relatedPagesEntities != null) {
            for (PageEntity relatedPageEntity : relatedPagesEntities) {
                relatedPages.add(EntityConverter.convertPageEntityToPage(relatedPageEntity));
            }
        }
        return relatedPages;
    }

    public Page getRelatedPage(String wikiType, String wikiOwner, String pageName) throws WikiException {
        Page relatedPage = null;
        List<PageMoveEntity> pageMoveEntities = this.pageMoveDAO.findInPageMoves(wikiType, wikiOwner, pageName);
        if (pageMoveEntities != null && !pageMoveEntities.isEmpty()) {
            relatedPage = EntityConverter.convertPageEntityToPage(pageMoveEntities.get(0).getPage());
        }
        return relatedPage;
    }

    public void addRelatedPage(Page page, Page relatedPage) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot add related page to page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        PageEntity relatedPageEntity = this.pageDAO.getPageOfWikiByName(relatedPage.getWikiType(), relatedPage.getWikiOwner(), relatedPage.getName());
        if (relatedPageEntity == null) {
            throw new WikiException("Cannot add related page " + relatedPage.getWikiType() + ":" + relatedPage.getWikiOwner() + ":" + relatedPage.getName() + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because related page does not exist.");
        }
        List<PageEntity> relatedPages = pageEntity.getRelatedPages();
        if (relatedPages == null) {
            relatedPages = new ArrayList<PageEntity>();
        }
        relatedPages.add(relatedPageEntity);
        pageEntity.setRelatedPages(relatedPages);
        this.pageDAO.update(pageEntity);
    }

    public void removeRelatedPage(Page page, Page relatedPage) throws WikiException {
        PageEntity pageEntity = this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        if (pageEntity == null) {
            throw new WikiException("Cannot remove related page to page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        PageEntity relatedPageEntity = this.pageDAO.getPageOfWikiByName(relatedPage.getWikiType(), relatedPage.getWikiOwner(), relatedPage.getName());
        if (relatedPageEntity == null) {
            throw new WikiException("Cannot remove related page " + relatedPage.getWikiType() + ":" + relatedPage.getWikiOwner() + ":" + relatedPage.getName() + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because related page does not exist.");
        }
        List<PageEntity> relatedPages = pageEntity.getRelatedPages();
        if (relatedPages != null) {
            for (int i = 0; i < relatedPages.size(); ++i) {
                if (relatedPages.get(i).getId() != relatedPageEntity.getId()) continue;
                relatedPages.remove(i);
                break;
            }
            pageEntity.setRelatedPages(relatedPages);
            this.pageDAO.update(pageEntity);
        }
    }

    public Page getExsitedOrNewDraftPageById(String wikiType, String wikiOwner, String pageName, String username) throws WikiException {
        DraftPage draftPage;
        if (pageName.contains("_A_A_")) {
            String[] pageNameParts = pageName.split("_A_A_");
            username = pageNameParts[0];
        }
        if ((draftPage = this.getDraft(pageName, username)) == null) {
            Date now = GregorianCalendar.getInstance().getTime();
            draftPage = new DraftPage();
            draftPage.setWikiType(PortalConfig.USER_TYPE);
            draftPage.setWikiOwner(username);
            draftPage.setName(pageName);
            draftPage.setAuthor(username);
            draftPage.setNewPage(true);
            draftPage.setCreatedDate(now);
            draftPage.setUpdatedDate(now);
            if (wikiType != null && wikiOwner != null) {
                Page targetPage = this.getPageOfWikiByName(wikiType, wikiOwner, pageName);
                if (targetPage == null) {
                    throw new WikiException("Cannot get target page for draft (" + wikiType + ":" + wikiOwner + ":" + pageName + ")");
                }
                draftPage.setTargetPageId(targetPage.getId());
                draftPage.setTargetPageRevision("1");
            }
            this.createDraftPageForUser(draftPage, username);
        }
        return draftPage;
    }

    public DraftPage getDraft(WikiPageParams wikiPageParams, String username) throws WikiException {
        BasePageEntity latestDraftEntity;
        DraftPage latestDraft = null;
        Page page = this.getPageOfWikiByName(wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageName());
        if (page != null) {
            List<DraftPageEntity> draftPagesOfUser = this.draftPageDAO.findDraftPagesByUserAndTargetPage(username, Long.valueOf(page.getId()));
            latestDraftEntity = null;
            for (DraftPageEntity draft : draftPagesOfUser) {
                if (latestDraftEntity != null && latestDraftEntity.getUpdatedDate().getTime() >= draft.getUpdatedDate().getTime()) continue;
                latestDraftEntity = draft;
            }
        } else {
            throw new WikiException("Cannot get draft of page " + wikiPageParams.getType() + ":" + wikiPageParams.getOwner() + ":" + wikiPageParams.getPageName() + " because page does not exist.");
        }
        latestDraft = EntityConverter.convertDraftPageEntityToDraftPage(latestDraftEntity);
        return latestDraft;
    }

    public DraftPage getLastestDraft(String username) throws WikiException {
        DraftPageEntity draftPagEntity = this.draftPageDAO.findLatestDraftPageByUser(username);
        return EntityConverter.convertDraftPageEntityToDraftPage(draftPagEntity);
    }

    public DraftPage getDraft(String draftName, String username) throws WikiException {
        DraftPage draftPageOfUser = null;
        List<DraftPage> draftPages = this.getDraftPagesOfUser(username);
        if (draftPages != null) {
            for (DraftPage draftPage : draftPages) {
                if (draftPage.getName() == null || !draftPage.getName().equals(draftName)) continue;
                draftPageOfUser = draftPage;
                break;
            }
        }
        return draftPageOfUser;
    }

    public List<DraftPage> getDraftPagesOfUser(String username) throws WikiException {
        ArrayList<DraftPage> draftPages = new ArrayList<DraftPage>();
        List<DraftPageEntity> draftPagesEntities = this.draftPageDAO.findDraftPagesByUser(username);
        if (draftPagesEntities != null) {
            for (DraftPageEntity draftPageEntity : draftPagesEntities) {
                draftPages.add(EntityConverter.convertDraftPageEntityToDraftPage(draftPageEntity));
            }
        }
        return draftPages;
    }

    public void createDraftPageForUser(DraftPage draftPage, String username) throws WikiException {
        DraftPageEntity draftPageEntity = EntityConverter.convertDraftPageToDraftPageEntity(draftPage, this.pageDAO);
        draftPageEntity.setAuthor(username);
        this.draftPageDAO.create(draftPageEntity);
    }

    public List<TemplateSearchResult> searchTemplate(TemplateSearchData templateSearchData) throws WikiException {
        String wikiOwner = templateSearchData.getWikiOwner();
        if (templateSearchData.getWikiType().toUpperCase().equals(WikiType.GROUP.toString())) {
            wikiOwner = this.templateDAO.validateGroupWikiOwner(wikiOwner);
        }
        List<TemplateEntity> templates = this.templateDAO.searchTemplatesByTitle(templateSearchData.getWikiType(), wikiOwner, templateSearchData.getTitle());
        ArrayList<TemplateSearchResult> searchResults = new ArrayList<TemplateSearchResult>();
        if (templates != null) {
            for (TemplateEntity templateEntity : templates) {
                Calendar createdDateCalendar = null;
                Date createdDate = templateEntity.getCreatedDate();
                if (createdDate != null) {
                    createdDateCalendar = Calendar.getInstance();
                    createdDateCalendar.setTime(createdDate);
                }
                Calendar updatedDateCalendar = null;
                Date updatedDate = templateEntity.getUpdatedDate();
                if (updatedDate != null) {
                    updatedDateCalendar = Calendar.getInstance();
                    updatedDateCalendar.setTime(updatedDate);
                }
                TemplateSearchResult templateSearchResult = new TemplateSearchResult(templateEntity.getWiki().getType(), templateEntity.getWiki().getOwner(), templateEntity.getName(), templateEntity.getTitle(), SearchResultType.TEMPLATE, updatedDateCalendar, createdDateCalendar, null);
                searchResults.add(templateSearchResult);
            }
        }
        return searchResults;
    }

    public List<Attachment> getAttachmentsOfPage(Page page) throws WikiException {
        String pageName;
        String wikiOwner;
        String wikiType;
        ArrayList<AttachmentEntity> attachmentsEntities;
        if (page instanceof DraftPage) {
            DraftPageEntity draftPageEntity = this.draftPageDAO.findLatestDraftPageByUserAndName(page.getAuthor(), page.getName());
            if (draftPageEntity == null) {
                throw new WikiException("Cannot get attachments of draft page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because draft page does not exist.");
            }
            attachmentsEntities = new ArrayList();
            List<DraftPageAttachmentEntity> draftPageAttachmentEntities = draftPageEntity.getAttachments();
            if (draftPageAttachmentEntities != null) {
                attachmentsEntities.addAll(draftPageAttachmentEntities);
            }
            if (draftPageEntity.isNewPage()) {
                wikiType = WIKI_TYPE_DRAFT;
                wikiOwner = draftPageEntity.getAuthor();
                pageName = draftPageEntity.getName();
            } else {
                PageEntity targetPage = draftPageEntity.getTargetPage();
                WikiEntity wiki = targetPage.getWiki();
                wikiType = wiki.getType();
                wikiOwner = wiki.getOwner();
                pageName = targetPage.getName();
            }
        } else {
            PageEntity pageEntity = this.fetchPageEntity(page);
            if (pageEntity == null) {
                throw new WikiException("Cannot get attachments of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            attachmentsEntities = new ArrayList<AttachmentEntity>();
            List<PageAttachmentEntity> pageAttachmentEntities = pageEntity.getAttachments();
            if (pageAttachmentEntities != null) {
                attachmentsEntities.addAll(pageAttachmentEntities);
            }
            WikiEntity wikiEntity = pageEntity.getWiki();
            wikiType = wikiEntity.getType();
            wikiOwner = wikiEntity.getOwner();
            pageName = pageEntity.getName();
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (attachmentsEntities != null) {
            for (AttachmentEntity attachmentEntity : attachmentsEntities) {
                Attachment attachment = EntityConverter.convertAttachmentEntityToAttachment(attachmentEntity);
                if (attachment.getTitle() == null || StringUtils.isEmpty((String)attachment.getTitle())) {
                    attachment.setTitle(attachment.getName());
                }
                if (attachment.getFullTitle() == null || StringUtils.isEmpty((String)attachment.getFullTitle())) {
                    attachment.setFullTitle(attachment.getTitle());
                }
                attachment.setDownloadURL(this.getDownloadURL(wikiType, wikiOwner, pageName, attachmentEntity));
                attachments.add(attachment);
            }
        }
        return attachments;
    }

    @ExoTransactional
    public void addAttachmentToPage(Attachment attachment, Page page) throws WikiException {
        Attachment attachment2 = attachment;
        Page page2 = page;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)attachment2, (Object)page2);
        Object[] objectArray = new Object[]{this, attachment2, page2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void deleteAttachmentOfPage(String attachmentName, Page page) throws WikiException {
        String string = attachmentName;
        Page page2 = page;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)page2);
        Object[] objectArray = new Object[]{this, string, page2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Page getHelpSyntaxPage(String syntaxId, boolean fullContent, List<ValuesParam> syntaxHelpParams, ConfigurationManager configurationManager) throws WikiException {
        Page helpPage = null;
        if (syntaxHelpParams != null) {
            for (ValuesParam syntaxHelpParam : syntaxHelpParams) {
                String syntaxName = syntaxHelpParam.getName();
                if (!syntaxName.equals(syntaxId)) continue;
                try {
                    String tempLine;
                    List syntaxValues = syntaxHelpParam.getValues();
                    String filePath = fullContent ? (String)syntaxValues.get(1) : (String)syntaxValues.get(0);
                    InputStream helpFile = configurationManager.getInputStream(filePath);
                    helpPage = new Page();
                    String realName = syntaxId.replace("/", "");
                    helpPage.setName(realName + " Help Page");
                    helpPage.setSyntax(syntaxId);
                    StringBuilder stringContent = new StringBuilder();
                    BufferedReader bufferReader = new BufferedReader(new InputStreamReader(helpFile));
                    while ((tempLine = bufferReader.readLine()) != null) {
                        stringContent.append(tempLine).append("\n");
                    }
                    helpPage.setContent(stringContent.toString());
                }
                catch (Exception e) {
                    throw new WikiException("Cannot get help page " + syntaxId, (Throwable)e);
                }
            }
        }
        return helpPage;
    }

    public void createEmotionIcon(EmotionIcon emotionIcon) throws WikiException {
        EmotionIconEntity emotionIconEntity = new EmotionIconEntity();
        emotionIconEntity.setName(emotionIcon.getName());
        emotionIconEntity.setImage(emotionIcon.getImage());
        this.emotionIconDAO.create(emotionIconEntity);
    }

    @ExoTransactional
    public List<EmotionIcon> getEmotionIcons() throws WikiException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
    }

    public EmotionIcon getEmotionIconByName(String emotionIconName) throws WikiException {
        return EntityConverter.convertEmotionIconEntityToEmotionIcon(this.emotionIconDAO.getEmotionIconByName(emotionIconName));
    }

    public boolean hasPermissionOnPage(Page page, PermissionType permissionType, Identity identity) throws WikiException {
        String userId = identity.getUserId();
        if (userId.equals(IdentityConstants.SYSTEM)) {
            return true;
        }
        if (userId.equals(page.getOwner())) {
            return true;
        }
        List pagePermissions = page.getPermissions();
        if (pagePermissions == null) {
            Page fetchedPage = page.getId() != null && !page.getId().isEmpty() ? this.getPageById(page.getId()) : this.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
            pagePermissions = fetchedPage.getPermissions();
        }
        if (pagePermissions == null || pagePermissions.isEmpty()) {
            return true;
        }
        return this.hasPermission(pagePermissions, identity, permissionType);
    }

    public boolean hasAdminSpacePermission(String wikiType, String owner, Identity identity) throws WikiException {
        return this.hasPermissionOnWiki(wikiType, owner, identity, PermissionType.ADMINSPACE);
    }

    public boolean hasAdminPagePermission(String wikiType, String owner, Identity identity) throws WikiException {
        return this.hasPermissionOnWiki(wikiType, owner, identity, PermissionType.ADMINPAGE);
    }

    private boolean hasPermissionOnWiki(String wikiType, String owner, Identity identity, PermissionType permissionType) throws WikiException {
        String userId = identity.getUserId();
        if (userId.equals(IdentityConstants.SYSTEM)) {
            return true;
        }
        if (userId.equals(owner)) {
            return true;
        }
        Wiki wiki = this.getWikiByTypeAndOwner(wikiType, owner);
        if (wiki != null) {
            List wikiPermissions = wiki.getPermissions();
            if (wikiPermissions == null || wikiPermissions.isEmpty()) {
                return true;
            }
            return this.hasPermission(wikiPermissions, identity, permissionType);
        }
        throw new WikiException("Cannot check admin space permission on wiki " + wikiType + ":" + owner + " for user " + identity.getUserId() + " because the wiki cannot be fetched");
    }

    private boolean hasPermission(List<PermissionEntry> resourcePermissions, Identity identity, PermissionType permissionType) {
        String userId = identity.getUserId();
        for (PermissionEntry pagePermission : resourcePermissions) {
            block6: for (Permission permission : pagePermission.getPermissions()) {
                if (!permission.isAllowed() || !permission.getPermissionType().equals((Object)permissionType)) continue;
                if (IdentityConstants.ANY.equals(pagePermission.getId())) {
                    return true;
                }
                switch (pagePermission.getIdType()) {
                    case USER: {
                        if (userId.equals(pagePermission.getId())) {
                            return true;
                        }
                    }
                    case GROUP: {
                        if (identity.isMemberOf(pagePermission.getId())) {
                            return true;
                        }
                    }
                    case MEMBERSHIP: {
                        UserACL.Permission membershipPermission = new UserACL.Permission();
                        membershipPermission.setPermissionExpression(pagePermission.getId());
                        if (!identity.isMemberOf(membershipPermission.getGroupId(), membershipPermission.getMembership())) continue block6;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public List<PageVersion> getVersionsOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get versions of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<PageVersion> pageVersions = new ArrayList<PageVersion>();
        List<PageVersionEntity> pageVersionEntities = pageEntity.getVersions();
        if (pageVersionEntities != null) {
            for (PageVersionEntity pageVersionEntity : pageVersionEntities) {
                pageVersions.add(EntityConverter.convertPageVersionEntityToPageVersion(pageVersionEntity));
            }
        }
        Collections.sort(pageVersions, new VersionNameComparatorDesc());
        return pageVersions;
    }

    @ExoTransactional
    public void addPageVersion(Page page) throws WikiException {
        Page page2 = page;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)page2);
        Object[] objectArray = new Object[]{this, page2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void restoreVersionOfPage(String versionName, Page page) throws WikiException {
        PageVersionEntity versionToRestore;
        PageEntity pageEntity;
        if (page != null) {
            pageEntity = this.fetchPageEntity(page);
            if (pageEntity == null) {
                throw new WikiException("Cannot restore version of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            versionToRestore = this.pageVersionDAO.getPageversionByPageIdAndVersion(Long.parseLong(page.getId()), Long.parseLong(versionName));
            if (versionToRestore == null) {
                throw new WikiException("Cannot restore version " + versionName + " of a page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because version does not exist.");
            }
        } else {
            throw new WikiException("Cannot restore version of a page null");
        }
        pageEntity.setContent(versionToRestore.getContent());
        pageEntity.setUpdatedDate(Calendar.getInstance().getTime());
        this.pageDAO.update(pageEntity);
    }

    @ExoTransactional
    public void updatePage(Page page) throws WikiException {
        Page page2 = page;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)page2);
        Object[] objectArray = new Object[]{this, page2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JPADataStorage$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
    }

    public List<String> getPreviousNamesOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get previous names of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        ArrayList<String> previousPageName = new ArrayList<String>();
        List<PageMoveEntity> moves = pageEntity.getMoves();
        if (moves != null) {
            for (PageMoveEntity pageMoveEntity : moves) {
                previousPageName.add(pageMoveEntity.getPageName());
            }
        }
        return previousPageName;
    }

    public List<String> getWatchersOfPage(Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot get watchers of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        return pageEntity.getWatchers() == null ? null : new ArrayList<String>(pageEntity.getWatchers());
    }

    public void addWatcherToPage(String username, Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot add a watcher on page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        if (pageEntity.getWatchers() == null) {
            throw new WikiException("Cannot add a watcher on page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because list of watchers is null.");
        }
        pageEntity.getWatchers().add(username);
        this.pageDAO.update(pageEntity);
    }

    public void deleteWatcherOfPage(String username, Page page) throws WikiException {
        PageEntity pageEntity = this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot delete a watcher of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        Set<String> watchers = pageEntity.getWatchers();
        if (watchers == null || !watchers.contains(username)) {
            throw new WikiException("Cannot remove watcher " + username + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because watcher does not exist.");
        }
        watchers.remove(username);
        pageEntity.setWatchers(watchers);
        this.pageDAO.update(pageEntity);
    }

    public PageEntity fetchPageEntity(Page page) {
        Long pageId = null;
        if (page.getId() != null && !page.getId().isEmpty()) {
            try {
                pageId = Long.parseLong(page.getId());
            }
            catch (NumberFormatException e) {
                pageId = null;
            }
        }
        PageEntity pageEntity = pageId != null ? (PageEntity)this.pageDAO.find(Long.valueOf(Long.parseLong(page.getId()))) : this.pageDAO.getPageOfWikiByName(page.getWikiType(), page.getWikiOwner(), page.getName());
        return pageEntity;
    }

    private String getDownloadURL(String wikiType, String wikiOwner, String pageName, AttachmentEntity attachmentEntity) {
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.getDefaultRestBaseURI()).append("/wiki/attachments/").append(wikiType).append("/").append("space").append("/").append(wikiOwner).append("/").append("page").append("/").append(pageName);
        try {
            sb.append("/").append(URLEncoder.encode(attachmentEntity.getName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            sb.append("/").append(attachmentEntity.getName());
        }
        return sb.toString();
    }

    static {
        JPADataStorage.ajc$preClinit();
    }

    static /* synthetic */ Wiki createWiki_aroundBody0(JPADataStorage ajc$this, Wiki wiki, JoinPoint joinPoint) {
        WikiEntity createdWikiEntity = (WikiEntity)ajc$this.wikiDAO.create(EntityConverter.convertWikiToWikiEntity(wiki, ajc$this.wikiDAO));
        Wiki createdWiki = EntityConverter.convertWikiEntityToWiki(createdWikiEntity);
        Page wikiHomePage = new Page();
        wikiHomePage.setWikiType(wiki.getType());
        wikiHomePage.setWikiOwner(wiki.getOwner());
        wikiHomePage.setName("WikiHome");
        wikiHomePage.setTitle("Wiki Home");
        Date now = Calendar.getInstance().getTime();
        wikiHomePage.setCreatedDate(now);
        wikiHomePage.setUpdatedDate(now);
        wikiHomePage.setContent("= Welcome to " + wiki.getOwner() + " =");
        wikiHomePage.setSyntax(createdWiki.getPreferences().getWikiPreferencesSyntax().getDefaultSyntax());
        ArrayList<PermissionEntry> homePagePermissions = new ArrayList<PermissionEntry>();
        List wikiPermissions = createdWiki.getPermissions();
        for (PermissionEntry wikiPermission : wikiPermissions) {
            PermissionEntry homePagePermission = new PermissionEntry(wikiPermission.getId(), wikiPermission.getFullName(), wikiPermission.getIdType(), null);
            ArrayList<Permission> newPermissions = new ArrayList<Permission>();
            for (Permission permission : wikiPermission.getPermissions()) {
                if (!permission.getPermissionType().equals((Object)PermissionType.VIEWPAGE) && !permission.getPermissionType().equals((Object)PermissionType.EDITPAGE)) continue;
                newPermissions.add(permission);
            }
            homePagePermission.setPermissions(newPermissions.toArray(new Permission[0]));
            homePagePermissions.add(homePagePermission);
        }
        wikiHomePage.setPermissions(homePagePermissions);
        Page createdWikiHomePage = ajc$this.createPage(createdWiki, null, wikiHomePage);
        createdWiki.setWikiHome(createdWikiHomePage);
        return createdWiki;
    }

    static /* synthetic */ Page createPage_aroundBody2(JPADataStorage ajc$this, Wiki wiki, Page parentPage, Page page, JoinPoint joinPoint) {
        WikiEntity wikiEntity = ajc$this.wikiDAO.getWikiByTypeAndOwner(wiki.getType(), wiki.getOwner());
        if (wikiEntity == null) {
            throw new WikiException("Cannot create page " + wiki.getType() + ":" + wiki.getOwner() + ":" + page.getName() + " because wiki does not exist.");
        }
        PageEntity parentPageEntity = null;
        if (parentPage != null && (parentPageEntity = ajc$this.pageDAO.getPageOfWikiByName(wiki.getType(), wiki.getOwner(), parentPage.getName())) == null) {
            throw new WikiException("Cannot create page " + wiki.getType() + ":" + wiki.getOwner() + ":" + page.getName() + " because parent page " + parentPage.getName() + " does not exist.");
        }
        PageEntity pageEntity = EntityConverter.convertPageToPageEntity(page, ajc$this.wikiDAO);
        pageEntity.setWiki(wikiEntity);
        pageEntity.setParentPage(parentPageEntity);
        Date now = GregorianCalendar.getInstance().getTime();
        if (pageEntity.getCreatedDate() == null) {
            pageEntity.setCreatedDate(now);
        }
        if (pageEntity.getUpdatedDate() == null) {
            pageEntity.setUpdatedDate(now);
        }
        pageEntity.setDeleted(false);
        PageEntity createdPageEntity = (PageEntity)ajc$this.pageDAO.create(pageEntity);
        if (parentPage == null) {
            wikiEntity.setWikiHome(createdPageEntity);
            ajc$this.wikiDAO.update(wikiEntity);
        }
        return EntityConverter.convertPageEntityToPage(createdPageEntity);
    }

    static /* synthetic */ void deletePage_aroundBody4(JPADataStorage ajc$this, String wikiType, String wikiOwner, String pageName, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, pageName);
        if (pageEntity == null) {
            throw new WikiException("Cannot delete page " + wikiType + ":" + wikiOwner + ":" + pageName + " because page does not exist.");
        }
        ajc$this.deletePageEntity(pageEntity);
    }

    static /* synthetic */ void renamePage_aroundBody6(JPADataStorage ajc$this, String wikiType, String wikiOwner, String pageName, String newName, String newTitle, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.pageDAO.getPageOfWikiByName(wikiType, wikiOwner, pageName);
        if (pageEntity == null) {
            throw new WikiException("Cannot rename page " + wikiType + ":" + wikiOwner + ":" + pageName + " because page does not exist.");
        }
        List<PageMoveEntity> pageMoves = pageEntity.getMoves();
        if (pageMoves == null) {
            pageMoves = new ArrayList<PageMoveEntity>();
        }
        PageMoveEntity move = new PageMoveEntity(wikiType, wikiOwner, pageName, Calendar.getInstance().getTime());
        move.setPage(pageEntity);
        pageMoves.add(move);
        ajc$this.pageMoveDAO.create(move);
        pageEntity.setName(newName);
        pageEntity.setTitle(newTitle);
        pageEntity.setMoves(pageMoves);
        ajc$this.pageDAO.update(pageEntity);
    }

    static /* synthetic */ void movePage_aroundBody8(JPADataStorage ajc$this, WikiPageParams currentLocationParams, WikiPageParams newLocationParams, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.pageDAO.getPageOfWikiByName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName());
        if (pageEntity == null) {
            throw new WikiException("Cannot move page " + currentLocationParams.getType() + ":" + currentLocationParams.getOwner() + ":" + currentLocationParams.getPageName() + " because page does not exist.");
        }
        PageEntity destinationPageEntity = ajc$this.pageDAO.getPageOfWikiByName(newLocationParams.getType(), newLocationParams.getOwner(), newLocationParams.getPageName());
        if (destinationPageEntity == null) {
            throw new WikiException("Cannot move page " + currentLocationParams.getType() + ":" + currentLocationParams.getOwner() + ":" + currentLocationParams.getPageName() + " to page " + newLocationParams.getType() + ":" + newLocationParams.getOwner() + ":" + newLocationParams.getPageName() + " because destination page does not exist.");
        }
        List<PageMoveEntity> pageMoves = pageEntity.getMoves();
        if (pageMoves == null) {
            pageMoves = new ArrayList<PageMoveEntity>();
        }
        PageMoveEntity move = new PageMoveEntity(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName(), Calendar.getInstance().getTime());
        move.setPage(pageEntity);
        ajc$this.pageMoveDAO.create(move);
        pageEntity.setWiki(destinationPageEntity.getWiki());
        pageEntity.setParentPage(destinationPageEntity);
        pageMoves.add(move);
        pageEntity.setMoves(pageMoves);
        ajc$this.pageDAO.update(pageEntity);
    }

    static /* synthetic */ void addAttachmentToPage_aroundBody10(JPADataStorage ajc$this, Attachment attachment, Page page, JoinPoint joinPoint) {
        if (page instanceof DraftPage) {
            DraftPageEntity draftPageEntity;
            DraftPageAttachmentEntity attachmentEntity = EntityConverter.convertAttachmentToDraftPageAttachmentEntity(attachment);
            Date now = GregorianCalendar.getInstance().getTime();
            if (attachmentEntity.getCreatedDate() == null) {
                attachmentEntity.setCreatedDate(now);
            }
            if (attachmentEntity.getUpdatedDate() == null) {
                attachmentEntity.setUpdatedDate(now);
            }
            if ((draftPageEntity = ajc$this.draftPageDAO.findLatestDraftPageByUserAndName(Utils.getCurrentUser(), page.getName())) == null) {
                throw new WikiException("Cannot add an attachment to draft page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because draft page does not exist.");
            }
            ajc$this.draftPageAttachmentDAO.create(attachmentEntity);
            List<DraftPageAttachmentEntity> attachmentsEntities = draftPageEntity.getAttachments();
            if (attachmentsEntities == null) {
                attachmentsEntities = new ArrayList<DraftPageAttachmentEntity>();
            }
            DraftPageAttachmentEntity draftPageAttachmentEntity = attachmentEntity;
            draftPageAttachmentEntity.setDraftPage(draftPageEntity);
            attachmentsEntities.add(draftPageAttachmentEntity);
            draftPageEntity.setAttachments(attachmentsEntities);
            ajc$this.draftPageDAO.update(draftPageEntity);
        } else {
            PageEntity pageEntity;
            PageAttachmentEntity attachmentEntity = EntityConverter.convertAttachmentToPageAttachmentEntity(attachment);
            Date now = GregorianCalendar.getInstance().getTime();
            if (attachmentEntity.getCreatedDate() == null) {
                attachmentEntity.setCreatedDate(now);
            }
            if (attachmentEntity.getUpdatedDate() == null) {
                attachmentEntity.setUpdatedDate(now);
            }
            if ((pageEntity = ajc$this.fetchPageEntity(page)) == null) {
                throw new WikiException("Cannot add an attachment to page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            attachmentEntity.setPage(pageEntity);
            ajc$this.pageAttachmentDAO.create(attachmentEntity);
            List<PageAttachmentEntity> attachmentsEntities = pageEntity.getAttachments();
            if (attachmentsEntities == null) {
                attachmentsEntities = new ArrayList<PageAttachmentEntity>();
            }
            PageAttachmentEntity pageAttachmentEntity = attachmentEntity;
            pageAttachmentEntity.setPage(pageEntity);
            attachmentsEntities.add(pageAttachmentEntity);
            pageEntity.setAttachments(attachmentsEntities);
            ajc$this.pageDAO.update(pageEntity);
        }
    }

    static /* synthetic */ void deleteAttachmentOfPage_aroundBody12(JPADataStorage ajc$this, String attachmentName, Page page, JoinPoint joinPoint) {
        PageEntity pageEntity = ajc$this.fetchPageEntity(page);
        if (pageEntity == null) {
            throw new WikiException("Cannot delete an attachment of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
        }
        boolean attachmentFound = false;
        List<PageAttachmentEntity> attachmentsEntities = pageEntity.getAttachments();
        if (attachmentsEntities != null) {
            for (int i = 0; i < attachmentsEntities.size(); ++i) {
                AttachmentEntity attachmentEntity = attachmentsEntities.get(i);
                if (attachmentEntity.getName() == null || !attachmentEntity.getName().equals(attachmentName)) continue;
                attachmentFound = true;
                attachmentsEntities.remove(i);
                if (page instanceof DraftPage) {
                    ajc$this.draftPageAttachmentDAO.delete((DraftPageAttachmentEntity)attachmentEntity);
                } else {
                    ajc$this.pageAttachmentDAO.delete((PageAttachmentEntity)attachmentEntity);
                }
                pageEntity.setAttachments(attachmentsEntities);
                ajc$this.pageDAO.update(pageEntity);
                break;
            }
        }
        if (!attachmentFound) {
            throw new WikiException("Cannot delete the attachment " + attachmentName + " of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because attachment does not exist.");
        }
    }

    static /* synthetic */ List getEmotionIcons_aroundBody14(JPADataStorage ajc$this, JoinPoint joinPoint) {
        ArrayList<EmotionIcon> emotionIcons = new ArrayList<EmotionIcon>();
        List emotionIconsEntities = ajc$this.emotionIconDAO.findAll();
        if (emotionIconsEntities != null) {
            for (EmotionIconEntity emotionIconEntity : emotionIconsEntities) {
                emotionIcons.add(EntityConverter.convertEmotionIconEntityToEmotionIcon(emotionIconEntity));
            }
        }
        return emotionIcons;
    }

    static /* synthetic */ void addPageVersion_aroundBody16(JPADataStorage ajc$this, Page page, JoinPoint joinPoint) {
        List<PageVersionEntity> pageVersionEntities;
        PageVersionEntity pageVersionEntity;
        PageEntity pageEntity;
        if (page != null) {
            pageEntity = ajc$this.fetchPageEntity(page);
            if (pageEntity == null) {
                throw new WikiException("Cannot add version of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            pageVersionEntity = new PageVersionEntity();
            Long versionNumber = ajc$this.pageVersionDAO.getLastversionNumberOfPage(pageEntity.getId());
            versionNumber = versionNumber == null ? Long.valueOf(1L) : Long.valueOf(versionNumber + 1L);
            pageVersionEntity.setPage(pageEntity);
            pageVersionEntity.setVersionNumber(versionNumber);
            pageVersionEntity.setName(pageEntity.getName());
            pageVersionEntity.setTitle(pageEntity.getTitle());
            pageVersionEntity.setAuthor(pageEntity.getAuthor());
            pageVersionEntity.setContent(pageEntity.getContent());
            pageVersionEntity.setMinorEdit(pageEntity.isMinorEdit());
            pageVersionEntity.setComment(pageEntity.getComment());
            Date now = Calendar.getInstance().getTime();
            pageVersionEntity.setCreatedDate(now);
            pageVersionEntity.setUpdatedDate(now);
            ajc$this.pageVersionDAO.create(pageVersionEntity);
            pageVersionEntities = pageEntity.getVersions();
            if (pageVersionEntities == null) {
                pageVersionEntities = new ArrayList<PageVersionEntity>();
            }
        } else {
            throw new WikiException("Cannot create version of a page null");
        }
        pageVersionEntities.add(pageVersionEntity);
        pageEntity.setVersions(pageVersionEntities);
        ajc$this.pageDAO.update(pageEntity);
    }

    static /* synthetic */ void updatePage_aroundBody18(JPADataStorage ajc$this, Page page, JoinPoint joinPoint) {
        if (page instanceof DraftPage) {
            DraftPageEntity draftPageEntity = ajc$this.draftPageDAO.findLatestDraftPageByUserAndName(page.getAuthor(), page.getName());
            if (draftPageEntity == null) {
                throw new WikiException("Cannot add an attachment to draft page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because draft page does not exist.");
            }
            draftPageEntity.setTitle(page.getTitle());
            draftPageEntity.setContent(page.getContent());
            draftPageEntity.setUpdatedDate(page.getUpdatedDate());
            ajc$this.draftPageDAO.update(draftPageEntity);
        } else {
            PageEntity pageEntity = ajc$this.fetchPageEntity(page);
            if (pageEntity == null) {
                throw new WikiException("Cannot update page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " because page does not exist.");
            }
            pageEntity.setName(page.getName());
            pageEntity.setTitle(page.getTitle());
            pageEntity.setAuthor(page.getAuthor());
            pageEntity.setContent(page.getContent());
            pageEntity.setSyntax(page.getSyntax());
            pageEntity.setCreatedDate(page.getCreatedDate());
            pageEntity.setUpdatedDate(page.getUpdatedDate());
            pageEntity.setMinorEdit(page.isMinorEdit());
            pageEntity.setComment(page.getComment());
            pageEntity.setUrl(page.getUrl());
            pageEntity.setPermissions(EntityConverter.convertPermissionEntriesToPermissionEntities(page.getPermissions()));
            pageEntity.setActivityId(page.getActivityId());
            ajc$this.pageDAO.update(pageEntity);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPADataStorage.java", JPADataStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createWiki", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.mow.api.Wiki", "wiki", "org.exoplatform.wiki.WikiException", "org.exoplatform.wiki.mow.api.Wiki"), 156);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createPage", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.mow.api.Wiki:org.exoplatform.wiki.mow.api.Page:org.exoplatform.wiki.mow.api.Page", "wiki:parentPage:page", "org.exoplatform.wiki.WikiException", "org.exoplatform.wiki.mow.api.Page"), 196);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletePage", "org.exoplatform.wiki.jpa.JPADataStorage", "java.lang.String:java.lang.String:java.lang.String", "wikiType:wikiOwner:pageName", "org.exoplatform.wiki.WikiException", "void"), 292);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "renamePage", "org.exoplatform.wiki.jpa.JPADataStorage", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "wikiType:wikiOwner:pageName:newName:newTitle", "org.exoplatform.wiki.WikiException", "void"), 407);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "movePage", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.service.WikiPageParams:org.exoplatform.wiki.service.WikiPageParams", "currentLocationParams:newLocationParams", "org.exoplatform.wiki.WikiException", "void"), 434);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addAttachmentToPage", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.mow.api.Attachment:org.exoplatform.wiki.mow.api.Page", "attachment:page", "org.exoplatform.wiki.WikiException", "void"), 799);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteAttachmentOfPage", "org.exoplatform.wiki.jpa.JPADataStorage", "java.lang.String:org.exoplatform.wiki.mow.api.Page", "attachmentName:page", "org.exoplatform.wiki.WikiException", "void"), 867);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEmotionIcons", "org.exoplatform.wiki.jpa.JPADataStorage", "", "", "org.exoplatform.wiki.WikiException", "java.util.List"), 952);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addPageVersion", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.mow.api.Page", "page", "org.exoplatform.wiki.WikiException", "void"), 1109);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updatePage", "org.exoplatform.wiki.jpa.JPADataStorage", "org.exoplatform.wiki.mow.api.Page", "page", "org.exoplatform.wiki.WikiException", "void"), 1182);
    }
}

