/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.List;
import org.exoplatform.addons.es.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.JPADataStorage;
import org.exoplatform.wiki.jpa.entity.AttachmentEntity;
import org.exoplatform.wiki.jpa.entity.PageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.listener.AttachmentWikiListener;

public class AttachmentIndexingListener
extends AttachmentWikiListener {
    private static final Log LOG = ExoLogger.getLogger(AttachmentIndexingListener.class);
    private JPADataStorage jpaDataStorage;

    public AttachmentIndexingListener(JPADataStorage jpaDataStorage) {
        this.jpaDataStorage = jpaDataStorage;
    }

    public void addAttachment(Attachment attachment, Page page) throws WikiException {
        String attachmentId = this.getAttachmentId(attachment.getName(), page);
        if (attachmentId != null) {
            IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
            indexingService.index("wiki-attachment", attachmentId);
            LOG.debug("Index attachment {} with name {} to ES", new Object[]{attachmentId, attachment.getName()});
        }
    }

    public void deleteAttachment(String attachmentName, Page page) throws WikiException {
        String attachmentId = this.getAttachmentId(attachmentName, page);
        if (attachmentId != null) {
            IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
            indexingService.unindex("wiki-attachment", attachmentId);
            LOG.debug("Unindex attachment {} with name {} from ES", new Object[]{attachmentId, attachmentName});
        }
    }

    private String getAttachmentId(String attachmentName, Page page) throws WikiException {
        List<PageAttachmentEntity> attachmentsEntities;
        if (page instanceof DraftPage) {
            return null;
        }
        PageEntity pageEntity = this.jpaDataStorage.fetchPageEntity(page);
        if (pageEntity != null && (attachmentsEntities = pageEntity.getAttachments()) != null) {
            for (int i = 0; i < attachmentsEntities.size(); ++i) {
                AttachmentEntity attachmentEntity = attachmentsEntities.get(i);
                if (attachmentEntity.getName() == null || !attachmentEntity.getName().equals(attachmentName)) continue;
                return String.valueOf(attachmentEntity.getId());
            }
        }
        return null;
    }
}

