/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.wiki.jpa.dao.WikiBaseDAO;
import org.exoplatform.wiki.jpa.entity.TemplateEntity;

public class TemplateDAO
extends WikiBaseDAO<TemplateEntity, Long> {
    public List<TemplateEntity> getTemplatesOfWiki(String wikiType, String wikiOwner) {
        TypedQuery query = this.getEntityManager().createNamedQuery("template.getTemplatesOfWiki", TemplateEntity.class).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner);
        return query.getResultList();
    }

    public TemplateEntity getTemplateOfWikiByName(String wikiType, String wikiOwner, String templateName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("template.getTemplateOfWikiByName", TemplateEntity.class).setParameter("name", (Object)templateName).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner);
        try {
            return (TemplateEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<TemplateEntity> searchTemplatesByTitle(String wikiType, String wikiOwner, String searchText) {
        TypedQuery query = this.getEntityManager().createNamedQuery("template.searchTemplatesByTitle", TemplateEntity.class).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner).setParameter("searchText", (Object)("%" + searchText + "%"));
        return query.getResultList();
    }
}

