/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.constant.ReminderPeriodType;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.exception.AgendaExceptionType;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventDateOption;
import org.exoplatform.agenda.model.EventOccurrence;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.model.EventSearchResult;
import org.exoplatform.agenda.model.GuestUser;
import org.exoplatform.agenda.rest.model.CalendarEntity;
import org.exoplatform.agenda.rest.model.EventAttendeeEntity;
import org.exoplatform.agenda.rest.model.EventDateOptionEntity;
import org.exoplatform.agenda.rest.model.EventEntity;
import org.exoplatform.agenda.rest.model.EventOccurrenceEntity;
import org.exoplatform.agenda.rest.model.EventRecurrenceEntity;
import org.exoplatform.agenda.rest.model.EventReminderEntity;
import org.exoplatform.agenda.rest.model.EventSearchResultEntity;
import org.exoplatform.agenda.rest.model.GuestUserEntity;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.entity.IdentityEntity;

public class RestEntityBuilder {
    private static final String IDENTITIES_REST_PATH = "/v1/social/identities";
    private static final String IDENTITIES_EXPAND = "all";

    private RestEntityBuilder() {
    }

    public static final Calendar toCalendar(CalendarEntity calendarEntity) {
        return new Calendar(calendarEntity.getId(), Long.parseLong(calendarEntity.getOwner().getId()), calendarEntity.isSystem(), calendarEntity.getTitle(), calendarEntity.getDescription(), calendarEntity.getCreated(), calendarEntity.getUpdated(), calendarEntity.getColor(), calendarEntity.getAcl());
    }

    public static final CalendarEntity fromCalendar(IdentityManager identityManager, Calendar calendar) {
        return new CalendarEntity(calendar.getId(), RestEntityBuilder.getIdentityEntity(identityManager, calendar.getOwnerId()), calendar.isSystem(), calendar.getTitle(), calendar.getDescription(), calendar.getCreated(), calendar.getUpdated(), calendar.getColor(), calendar.getAcl());
    }

    public static final Event toEvent(EventEntity eventEntity) {
        ZonedDateTime startDate;
        EventRecurrenceEntity recurrenceEntity = eventEntity.getRecurrence();
        EventRecurrence recurrence = null;
        ZoneId eventZoneId = ZoneId.of(eventEntity.getTimeZoneId());
        if (recurrenceEntity != null) {
            ZonedDateTime untilDate = AgendaDateUtils.parseRFC3339ToZonedDateTime(recurrenceEntity.getUntil(), eventZoneId, false);
            recurrence = new EventRecurrence(recurrenceEntity.getId(), untilDate == null ? null : untilDate.withZoneSameInstant(ZoneOffset.UTC).toLocalDate(), recurrenceEntity.getCount(), recurrenceEntity.getType(), recurrenceEntity.getFrequency(), recurrenceEntity.getInterval(), recurrenceEntity.getBySecond(), recurrenceEntity.getByMinute(), recurrenceEntity.getByHour(), recurrenceEntity.getByDay(), recurrenceEntity.getByMonthDay(), recurrenceEntity.getByYearDay(), recurrenceEntity.getByWeekNo(), recurrenceEntity.getByMonth(), recurrenceEntity.getBySetPos(), null, null);
        }
        EventOccurrenceEntity occurrenceEntity = eventEntity.getOccurrence();
        EventOccurrence occurrence = null;
        if (occurrenceEntity != null) {
            occurrence = new EventOccurrence(AgendaDateUtils.parseRFC3339ToZonedDateTime(occurrenceEntity.getId(), ZoneOffset.UTC));
        }
        ZonedDateTime zonedDateTime = eventEntity.getStart() == null ? null : (startDate = eventEntity.isAllDay() ? AgendaDateUtils.parseAllDayDateToZonedDateTime(eventEntity.getStart()) : AgendaDateUtils.parseRFC3339ToZonedDateTime(eventEntity.getStart(), eventZoneId, false));
        ZonedDateTime endDate = eventEntity.getEnd() == null ? null : (eventEntity.isAllDay() ? AgendaDateUtils.parseAllDayDateToZonedDateTime(eventEntity.getEnd()) : AgendaDateUtils.parseRFC3339ToZonedDateTime(eventEntity.getEnd(), eventZoneId, false));
        return new Event(eventEntity.getId(), eventEntity.getParent() == null ? 0L : eventEntity.getParent().getId(), eventEntity.getCalendar() == null ? 0L : eventEntity.getCalendar().getId(), eventEntity.getCreator() == null ? 0L : Long.parseLong(eventEntity.getCreator().getId()), 0L, AgendaDateUtils.parseRFC3339ToZonedDateTime(eventEntity.getCreated(), ZoneOffset.UTC), AgendaDateUtils.parseRFC3339ToZonedDateTime(eventEntity.getUpdated(), ZoneOffset.UTC), eventEntity.getSummary(), eventEntity.getDescription(), eventEntity.getLocation(), eventEntity.getColor(), eventZoneId, startDate, endDate, eventEntity.isAllDay(), eventEntity.getAvailability(), eventEntity.getStatus(), recurrence, occurrence, eventEntity.getAcl(), eventEntity.isAllowAttendeeToUpdate(), eventEntity.isAllowAttendeeToInvite());
    }

    public static EventDateOption toEventDateOption(EventDateOptionEntity dateOptionEntity, ZoneId userTimeZone) {
        ZonedDateTime startDate = dateOptionEntity.isAllDay() ? AgendaDateUtils.parseAllDayDateToZonedDateTime(dateOptionEntity.getStart()) : AgendaDateUtils.parseRFC3339ToZonedDateTime(dateOptionEntity.getStart(), userTimeZone, false);
        ZonedDateTime endDate = dateOptionEntity.isAllDay() ? AgendaDateUtils.parseAllDayDateToZonedDateTime(dateOptionEntity.getEnd()) : AgendaDateUtils.parseRFC3339ToZonedDateTime(dateOptionEntity.getEnd(), userTimeZone, false);
        return new EventDateOption(dateOptionEntity.getId(), dateOptionEntity.getEventId(), startDate, endDate, dateOptionEntity.isAllDay(), false, null);
    }

    public static EventReminder toEventReminder(long eventId, EventReminderEntity eventReminderEntity) {
        String beforePeriodTypeName = eventReminderEntity.getBeforePeriodType();
        ReminderPeriodType beforePeriodType = null;
        if (StringUtils.isNotBlank((CharSequence)beforePeriodTypeName)) {
            beforePeriodType = ReminderPeriodType.valueOf((String)beforePeriodTypeName.toUpperCase());
        }
        return new EventReminder(eventReminderEntity.getId(), eventId, 0L, eventReminderEntity.getBefore(), beforePeriodType);
    }

    public static EventAttendee toEventAttendee(IdentityManager identityManager, long eventId, EventAttendeeEntity attendeeEntity) throws AgendaException {
        long identityId = 0L;
        IdentityEntity attendeeIdentityEntity = attendeeEntity.getIdentity();
        String providerId = attendeeIdentityEntity.getProviderId();
        String remoteId = attendeeIdentityEntity.getRemoteId();
        if (StringUtils.isNotBlank((CharSequence)providerId) && StringUtils.isNotBlank((CharSequence)remoteId)) {
            Identity identity = identityManager.getOrCreateIdentity(providerId, remoteId);
            identityId = Long.parseLong(identity.getId());
        } else if (StringUtils.isNotBlank((CharSequence)attendeeIdentityEntity.getId())) {
            identityId = Long.parseLong(attendeeIdentityEntity.getId());
        } else {
            throw new AgendaException(AgendaExceptionType.WRONG_EVENT_ATTENDEE_ID);
        }
        return new EventAttendee(attendeeEntity.getId(), eventId, identityId, attendeeEntity.getResponse());
    }

    public static final EventAttendeeEntity fromEventAttendee(IdentityManager identityManager, EventAttendee eventAttendee) {
        return new EventAttendeeEntity(eventAttendee.getId(), RestEntityBuilder.getIdentityEntity(identityManager, eventAttendee.getIdentityId()), eventAttendee.getResponse());
    }

    public static EventDateOptionEntity fromEventDateOption(ZoneId userTimeZone, EventDateOption dateOption) {
        return new EventDateOptionEntity(dateOption.getId(), dateOption.getEventId(), AgendaDateUtils.toRFC3339Date(dateOption.getStart(), userTimeZone, dateOption.isAllDay()), AgendaDateUtils.toRFC3339Date(dateOption.getEnd(), userTimeZone, dateOption.isAllDay()), dateOption.isAllDay(), dateOption.isSelected(), dateOption.getVoters());
    }

    public static final EventReminderEntity fromEventReminder(EventReminder eventReminder) {
        return new EventReminderEntity(eventReminder.getId(), eventReminder.getBefore(), eventReminder.getBeforePeriodType() == null ? null : eventReminder.getBeforePeriodType().name());
    }

    public static final EventSearchResultEntity fromSearchEvent(AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, IdentityManager identityManager, EventSearchResult eventSearchResult, ZoneId userTimeZone) {
        EventSearchResultEntity eventSearchResultEntity = (EventSearchResultEntity)RestEntityBuilder.fromEvent(agendaCalendarService, agendaEventService, identityManager, (Event)eventSearchResult, userTimeZone, true);
        eventSearchResultEntity.setExcerpts(eventSearchResult.getExcerpts());
        return eventSearchResultEntity;
    }

    public static final EventEntity fromEvent(AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, IdentityManager identityManager, Event event, ZoneId userTimeZone) {
        return RestEntityBuilder.fromEvent(agendaCalendarService, agendaEventService, identityManager, event, userTimeZone, false);
    }

    public static final GuestUser toGuestUser(long eventId, GuestUserEntity guestUserEntity) {
        return new GuestUser(guestUserEntity.getId(), guestUserEntity.getGuestEmail(), eventId);
    }

    public static final GuestUserEntity fromGuestUser(GuestUser guestUser) {
        return new GuestUserEntity(guestUser.getId(), guestUser.getGuestEmail(), guestUser.getEventId());
    }

    private static final EventEntity fromEvent(AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, IdentityManager identityManager, Event event, ZoneId userTimeZone, boolean isSearch) {
        EventRecurrence recurrence = event.getRecurrence();
        EventRecurrenceEntity recurrenceEntity = null;
        if (userTimeZone == null) {
            userTimeZone = ZoneOffset.UTC;
        }
        if (recurrence != null) {
            LocalDate until = recurrence.getUntil();
            String untilDateRFC3339 = until == null ? null : AgendaDateUtils.toRFC3339Date(until.plusDays(1L).atStartOfDay(userTimeZone).minusSeconds(1L));
            recurrenceEntity = new EventRecurrenceEntity(recurrence.getId(), untilDateRFC3339, recurrence.getCount(), recurrence.getType(), recurrence.getFrequency(), recurrence.getInterval(), recurrence.getRrule(), recurrence.getBySecond(), recurrence.getByMinute(), recurrence.getByHour(), recurrence.getByDay(), recurrence.getByMonthDay(), recurrence.getByYearDay(), recurrence.getByWeekNo(), recurrence.getByMonth(), recurrence.getBySetPos());
        }
        EventOccurrence occurrence = event.getOccurrence();
        EventOccurrenceEntity occurrenceEntity = null;
        if (occurrence != null) {
            occurrenceEntity = new EventOccurrenceEntity(AgendaDateUtils.toRFC3339Date(occurrence.getId()), occurrence.isExceptional());
        }
        long parentId = event.getParentId();
        EventEntity parentEvent = null;
        if (parentId > 0L && parentId != event.getId()) {
            parentEvent = RestEntityBuilder.getEventEntity(agendaCalendarService, agendaEventService, identityManager, parentId, userTimeZone);
        }
        if (isSearch) {
            return new EventSearchResultEntity(event.getId(), parentEvent, null, 0L, null, RestEntityBuilder.getCalendarEntity(agendaCalendarService, identityManager, event.getCalendarId()), RestEntityBuilder.getIdentityEntity(identityManager, event.getCreatorId()), AgendaDateUtils.toRFC3339Date(event.getCreated()), AgendaDateUtils.toRFC3339Date(event.getUpdated()), event.getSummary(), event.getDescription(), event.getLocation(), event.getColor(), null, AgendaDateUtils.toRFC3339Date(event.getStart(), userTimeZone, event.isAllDay()), AgendaDateUtils.toRFC3339Date(event.getEnd(), userTimeZone, event.isAllDay()), event.isAllDay(), event.getAvailability(), event.getStatus(), recurrenceEntity, occurrenceEntity, event.getAcl(), null, null, null, null, event.isAllowAttendeeToUpdate(), event.isAllowAttendeeToInvite(), false, null);
        }
        return new EventEntity(event.getId(), parentEvent, null, 0L, null, RestEntityBuilder.getCalendarEntity(agendaCalendarService, identityManager, event.getCalendarId()), RestEntityBuilder.getIdentityEntity(identityManager, event.getCreatorId()), AgendaDateUtils.toRFC3339Date(event.getCreated()), AgendaDateUtils.toRFC3339Date(event.getUpdated()), event.getSummary(), event.getDescription(), event.getLocation(), event.getColor(), userTimeZone.getId(), AgendaDateUtils.toRFC3339Date(event.getStart(), userTimeZone, event.isAllDay()), AgendaDateUtils.toRFC3339Date(event.getEnd(), userTimeZone, event.isAllDay()), event.isAllDay(), event.getAvailability(), event.getStatus(), recurrenceEntity, occurrenceEntity, event.getAcl(), null, null, null, null, null, event.isAllowAttendeeToUpdate(), event.isAllowAttendeeToInvite(), false);
    }

    private static CalendarEntity getCalendarEntity(AgendaCalendarService agendaCalendarService, IdentityManager identityManager, long calendarId) {
        if (calendarId <= 0L) {
            return null;
        }
        Calendar calendar = agendaCalendarService.getCalendarById(calendarId);
        return RestEntityBuilder.fromCalendar(identityManager, calendar);
    }

    private static EventEntity getEventEntity(AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, IdentityManager identityManager, long eventId, ZoneId userTimeZone) {
        if (eventId <= 0L) {
            return null;
        }
        Event event = agendaEventService.getEventById(eventId);
        return RestEntityBuilder.fromEvent(agendaCalendarService, agendaEventService, identityManager, event, userTimeZone);
    }

    private static IdentityEntity getIdentityEntity(IdentityManager identityManager, long ownerId) {
        Identity identity = RestEntityBuilder.getIdentity(identityManager, ownerId);
        if (identity == null) {
            return null;
        }
        return EntityBuilder.buildEntityIdentity((Identity)identity, (String)IDENTITIES_REST_PATH, (String)IDENTITIES_EXPAND);
    }

    private static final Identity getIdentity(IdentityManager identityManager, long identityId) {
        return identityManager.getIdentity(String.valueOf(identityId));
    }
}

