/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.RandomUidGenerator;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class NotificationUtils {
    private static final Log LOG = ExoLogger.getLogger(NotificationUtils.class);
    public static final ArgumentLiteral<Event> EVENT_AGENDA = new ArgumentLiteral(Event.class, "event_agenda");
    public static final ArgumentLiteral<List> EVENT_ATTENDEE = new ArgumentLiteral(List.class, "eventAttendee");
    public static final ArgumentLiteral<Long> EVENT_MODIFIER = new ArgumentLiteral(Long.class, "eventModifier");
    public static final ArgumentLiteral<String> EVENT_MODIFICATION_TYPE = new ArgumentLiteral(String.class, "modificationEventType");
    public static final ArgumentLiteral<EventReminder> EVENT_AGENDA_REMINDER = new ArgumentLiteral(EventReminder.class, "event_agenda_reminder");
    public static final ArgumentLiteral<Long> EVENT_PARTICIPANT_ID = new ArgumentLiteral(Long.class, "event_participant_id");
    public static final ArgumentLiteral<EventAttendeeResponse> EVENT_RESPONSE = new ArgumentLiteral(EventAttendeeResponse.class, "event_response");
    public static final ArgumentLiteral<ZonedDateTime> EVENT_OCCURRENCE_ID = new ArgumentLiteral(ZonedDateTime.class, "occurrence_id");
    public static final String AGENDA_EVENT_ADDED_NOTIFICATION_PLUGIN = "EventAddedNotificationPlugin";
    public static final String AGENDA_EVENT_MODIFIED_NOTIFICATION_PLUGIN = "EventModifiedNotificationPlugin";
    public static final String AGENDA_EVENT_CANCELLED_NOTIFICATION_PLUGIN = "EventCanceledNotificationPlugin";
    public static final String AGENDA_REMINDER_NOTIFICATION_PLUGIN = "EventReminderNotificationPlugin";
    public static final String AGENDA_REPLY_NOTIFICATION_PLUGIN = "EventReplyNotificationPlugin";
    public static final String AGENDA_DATE_POLL_NOTIFICATION_PLUGIN = "DatePollNotificationPlugin";
    public static final String AGENDA_VOTE_NOTIFICATION_PLUGIN = "VoteNotificationPlugin";
    private static final String TEMPLATE_VARIABLE_EVENT_URL = "eventURL";
    private static final String TEMPLATE_VARIABLE_IS_CREATOR = "isCreator";
    public static final PluginKey EVENT_ADDED_KEY = PluginKey.key((String)"EventAddedNotificationPlugin");
    public static final PluginKey EVENT_MODIFIED_KEY = PluginKey.key((String)"EventModifiedNotificationPlugin");
    public static final PluginKey EVENT_CANCELLED_KEY = PluginKey.key((String)"EventCanceledNotificationPlugin");
    public static final PluginKey EVENT_REMINDER_KEY = PluginKey.key((String)"EventReminderNotificationPlugin");
    public static final PluginKey EVENT_REPLY_KEY = PluginKey.key((String)"EventReplyNotificationPlugin");
    public static final PluginKey EVENT_DATE_POLL_KEY = PluginKey.key((String)"DatePollNotificationPlugin");
    public static final PluginKey EVENT_DATE_VOTE_KEY = PluginKey.key((String)"VoteNotificationPlugin");
    public static final String STORED_PARAMETER_EVENT_TITLE = "eventTitle";
    public static final String STORED_PARAMETER_EVENT_DESCRIPTION = "eventDescription";
    public static final String STORED_PARAMETER_EVENT_LOCATION = "eventLocation";
    public static final String STORED_PARAMETER_EVENT_OWNER_ID = "ownerId";
    private static final String STORED_PARAMETER_EVENT_ID = "eventId";
    public static final String STORED_PARAMETER_EVENT_MODIFIER = "eventModifier";
    public static final String STORED_PARAMETER_EVENT_CREATOR = "eventCreator";
    public static final String STORED_PARAMETER_EVENT_URL = "Url";
    public static final String STORED_PARAMETER_EVENT_OCCURRENCE_ID = "eventOccurrenceId";
    public static final String STORED_EVENT_MODIFICATION_TYPE = "EVENT_MODIFICATION_TYPE";
    public static final String STORED_PARAMETER_MODIFIER_IDENTITY_ID = "MODIFIER_IDENTITY_ID";
    public static final String STORED_PARAMETER_EVENT_START_DATE = "startDate";
    public static final String STORED_PARAMETER_EVENT_END_DATE = "endDate";
    public static final String STORED_PARAMETER_EVENT_TIMEZONE_NAME = "eventTimeZoneName";
    public static final String STORED_PARAMETER_EVENT_ATTENDEES = "attendees";
    public static final String STORED_PARAMETER_EVENT_CONFERENCE = "conference";
    public static final String STORED_PARAMETER_EVENT_RECURRENT_DETAILS = "recurrenceDetails";
    public static final String STORED_PARAMETER_EVENT_PARTICIPANT_NAME = "participantName";
    public static final String STORED_PARAMETER_EVENT_PARTICIPANT_AVATAR_URL = "participantAvatarUrl";
    public static final String STORED_PARAMETER_EVENT_RESPONSE = "eventResponse";
    public static final String STORED_PARAMETER_EVENT_STATUS = "eventStatus";
    private static final String TEMPLATE_VARIABLE_EVENT_START_DATE = "startDate";
    private static final String TEMPLATE_VARIABLE_EVENT_END_DATE = "endDate";
    private static final String TEMPLATE_VARIABLE_EVENT_MONTH_YEAR_DATE = "monthYearDate";
    private static final String TEMPLATE_VARIABLE_AGENDA_NAME = "agendaName";
    private static final String TEMPLATE_VARIABLE_SUFFIX_IDENTITY_AVATAR = "calendarOwnerAvatarUrl";
    public static final String TEMPLATE_VARIABLE_EVENT_ID = "eventId";
    public static final String TEMPLATE_VARIABLE_EVENT_TITLE = "eventTitle";
    public static final String TEMPLATE_VARIABLE_EVENT_LOCATION = "eventLocation";
    public static final String TEMPLATE_VARIABLE_EVENT_DESCRIPTION = "eventDescription";
    public static final String TEMPLATE_VARIABLE_EVENT_RECURRENT_DETAILS = "recurrenceDetails";
    private static final String TEMPLATE_VARIABLE_EVENT_MODIFICATION_TYPE = "modificationType";
    private static final String TEMPLATE_VARIABLE_EVENT_CREATOR = "creatorName";
    private static final String TEMPLATE_VARIABLE_EVENT_ATTENDEES = "attendees";
    private static final String TEMPLATE_VARIABLE_EVENT_IS_GUEST = "isGuest";
    private static final String TEMPLATE_VARIABLE_EVENT_CONFERENCE = "conference";
    private static final String TEMPLATE_VARIABLE_EVENT_TIMEZONE_NAME = "timeZoneName";
    private static final String TEMPLATE_VARIABLE_RESPONSE_ACCEPTED = "acceptedResponseURL";
    private static final String TEMPLATE_VARIABLE_RESPONSE_DECLINED = "declinedResponseURL";
    private static final String TEMPLATE_VARIABLE_RESPONSE_TENTATIVE = "tentativeResponseURL";
    private static final String TEMPLATE_VARIABLE_EVENT_MODIFIER = "modifierName";
    private static final String TEMPLATE_VARIABLE_EVENT_PARTICIPANT_NAME = "participantName";
    private static final String TEMPLATE_VARIABLE_EVENT_RESPONSE = "responseType";
    private static final String TEMPLATE_VARIABLE_EVENT_PARTICIPANT_AVATAR_URL = "participantAvatarUrl";
    private static final String TEMPLATE_VARIABLE_MODIFIER_IDENTITY_URL = "modifierProfileUrl";
    private static final String TEMPLATE_VARIABLE_EVENT_STATUS = "eventStatus";
    private static volatile String defaultSite;

    private NotificationUtils() {
    }

    public static final long getEventId(NotificationContext ctx) {
        return ((Event)ctx.value(EVENT_AGENDA)).getId();
    }

    public static final long getEventReminderId(NotificationContext ctx) {
        return ((EventReminder)ctx.value(EVENT_AGENDA_REMINDER)).getId();
    }

    public static final void setNotificationRecipients(IdentityManager identityManager, NotificationInfo notification, SpaceService spaceService, List<EventAttendee> eventAttendees, Event event, String typeModification, long modifierId) {
        Identity identityToExclude;
        long userIdentityToExclude;
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        if (typeModification == null) {
            throw new IllegalArgumentException("Modification type is null");
        }
        HashSet<String> recipients = new HashSet<String>();
        HashSet<String> participants = new HashSet<String>();
        for (EventAttendee attendee : eventAttendees) {
            Identity identity = Utils.getIdentityById(identityManager, attendee.getIdentityId());
            if (identity == null) continue;
            if (identity.getProviderId().equals("space")) {
                String spaceName = identity.getRemoteId();
                List<String> memberSpace = Utils.getSpaceMembersBySpaceName(spaceName, spaceService);
                if (memberSpace == null) continue;
                recipients.addAll(memberSpace);
                continue;
            }
            if (!identity.getProviderId().equals("organization") && !identity.getProviderId().equals("GUEST_USER")) continue;
            recipients.add(identity.getRemoteId());
            participants.add(identity.getId());
        }
        String showParticipants = NotificationUtils.getFullUserName(participants, identityManager);
        notification.with("attendees", showParticipants);
        long l = userIdentityToExclude = StringUtils.equals((String)typeModification, (String)"ADDED") ? event.getCreatorId() : modifierId;
        if (userIdentityToExclude > 0L && (identityToExclude = identityManager.getIdentity(String.valueOf(userIdentityToExclude))) != null) {
            recipients.remove(identityToExclude.getRemoteId());
        }
        notification.to(new ArrayList(recipients));
    }

    public static final void setEventReminderNotificationRecipients(IdentityManager identityManager, NotificationInfo notification, Long ... receiverIds) {
        ArrayList<String> receivers = new ArrayList<String>();
        for (Long receiverId : receiverIds) {
            Identity identity = Utils.getIdentityById(identityManager, receiverId);
            if (identity == null || !StringUtils.equals((String)"organization", (String)identity.getProviderId())) continue;
            receivers.add(identity.getRemoteId());
        }
        notification.to(receivers);
    }

    public static final void storeEventParameters(IdentityManager identityManager, NotificationInfo notification, Event event, org.exoplatform.agenda.model.Calendar calendar, String typeModification) {
        String webConferenceLink;
        long modifierId;
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        if (typeModification == null) {
            throw new IllegalArgumentException("Modification type is null");
        }
        Identity identity = Utils.getIdentityById(identityManager, event.getCreatorId());
        String timeZoneName = TimeZone.getTimeZone(event.getTimeZoneId()).getDisplayName() + ": " + event.getTimeZoneId();
        notification.with("eventId", String.valueOf(event.getId())).with("eventTitle", event.getSummary()).with(STORED_PARAMETER_EVENT_OWNER_ID, String.valueOf(calendar.getOwnerId())).with(STORED_PARAMETER_EVENT_URL, NotificationUtils.getEventURL(event)).with(STORED_PARAMETER_EVENT_CREATOR, NotificationUtils.getEventNotificationCreatorOrModifierUserName(identity)).with(STORED_EVENT_MODIFICATION_TYPE, typeModification).with("startDate", AgendaDateUtils.toRFC3339Date(event.getStart())).with("endDate", AgendaDateUtils.toRFC3339Date(event.getEnd())).with("recurrenceDetails", NotificationUtils.getRecurrenceDetails(event)).with(STORED_PARAMETER_EVENT_TIMEZONE_NAME, timeZoneName).with("eventStatus", event.getStatus().name());
        if (StringUtils.isNotBlank((String)event.getDescription())) {
            notification.with("eventDescription", event.getDescription());
        }
        if (StringUtils.isNotBlank((String)event.getLocation())) {
            notification.with("eventLocation", event.getLocation());
        }
        long l = modifierId = event.getModifierId() > 0L ? event.getModifierId() : event.getCreatorId();
        if (modifierId > 0L) {
            identity = Utils.getIdentityById(identityManager, modifierId);
            notification.with(STORED_PARAMETER_EVENT_MODIFIER, NotificationUtils.getEventNotificationCreatorOrModifierUserName(identity)).with(STORED_PARAMETER_MODIFIER_IDENTITY_ID, String.valueOf(modifierId));
        }
        if ((webConferenceLink = NotificationUtils.getWebConferenceLink(event)) != null) {
            notification.with("conference", webConferenceLink);
        }
    }

    public static final void storeEventParameters(NotificationInfo notification, Event event, org.exoplatform.agenda.model.Calendar calendar) {
        notification.with("eventId", String.valueOf(event.getId())).with("eventTitle", event.getSummary()).with(STORED_PARAMETER_EVENT_OWNER_ID, String.valueOf(calendar.getOwnerId())).with(STORED_PARAMETER_EVENT_URL, NotificationUtils.getEventURL(event)).with("startDate", AgendaDateUtils.toRFC3339Date(event.getStart())).with("endDate", AgendaDateUtils.toRFC3339Date(event.getEnd()));
    }

    public static final void storeEventParameters(IdentityManager identityManager, NotificationInfo notification, Event event, ZonedDateTime occurrenceId, long participantId, EventAttendeeResponse response, org.exoplatform.agenda.model.Calendar calendar, AgendaEventAttendeeService eventAttendeeService, SpaceService spaceService) {
        Identity identity = Utils.getIdentityById(identityManager, participantId);
        String timeZoneName = TimeZone.getTimeZone(event.getTimeZoneId()).getDisplayName() + ": " + event.getTimeZoneId();
        HashSet<String> participants = new HashSet<String>();
        List eventAttendee = eventAttendeeService.getEventAttendees(event.getId()).getEventAttendees();
        HashSet<String> spaceParticipants = new HashSet<String>();
        String showSpaceParticipant = null;
        for (EventAttendee attendee : eventAttendee) {
            Identity identityAttendee = Utils.getIdentityById(identityManager, attendee.getIdentityId());
            if (identityAttendee.getProviderId().equals("space")) {
                String spaceName = identityAttendee.getRemoteId();
                if (!StringUtils.isNotBlank((String)spaceName)) continue;
                spaceParticipants.add(spaceName);
                continue;
            }
            if (!identityAttendee.getProviderId().equals("organization")) continue;
            participants.add(identityAttendee.getId());
        }
        String showParticipants = NotificationUtils.getFullUserName(participants, identityManager);
        if (!spaceParticipants.isEmpty()) {
            showSpaceParticipant = NotificationUtils.getSpaceDisplayName(spaceParticipants, spaceService);
            showParticipants = showParticipants.concat(",").concat(showSpaceParticipant);
        }
        notification.with("eventId", String.valueOf(event.getId())).with("eventTitle", event.getSummary()).with("participantAvatarUrl", NotificationUtils.setParticipantAvatarUrl(identity)).with(STORED_PARAMETER_EVENT_URL, NotificationUtils.getEventURL(event, occurrenceId)).with(STORED_PARAMETER_EVENT_OWNER_ID, String.valueOf(calendar.getOwnerId())).with(STORED_PARAMETER_EVENT_RESPONSE, String.valueOf(response)).with("participantName", NotificationUtils.getEventNotificationCreatorOrModifierUserName(identity)).with("startDate", AgendaDateUtils.toRFC3339Date(event.getStart())).with("endDate", AgendaDateUtils.toRFC3339Date(event.getEnd())).with("recurrenceDetails", NotificationUtils.getRecurrenceDetails(event)).with(STORED_PARAMETER_EVENT_TIMEZONE_NAME, timeZoneName).with("attendees", showParticipants);
        if (occurrenceId == null && event.getOccurrence() != null) {
            occurrenceId = event.getOccurrence().getId();
        }
        if (occurrenceId != null) {
            notification.with(STORED_PARAMETER_EVENT_OCCURRENCE_ID, AgendaDateUtils.toRFC3339Date(occurrenceId, ZoneOffset.UTC));
        }
        if (StringUtils.isNotBlank((String)event.getDescription())) {
            notification.with("eventDescription", event.getDescription());
        }
        if (StringUtils.isNotBlank((String)event.getLocation())) {
            notification.with("eventLocation", event.getLocation());
        }
    }

    public static String getDefaultSite() {
        if (defaultSite != null) {
            return defaultSite;
        }
        UserPortalConfigService portalConfig = (UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class);
        defaultSite = portalConfig.getDefaultPortal();
        return defaultSite;
    }

    public static final TemplateContext buildTemplateParameters(String username, SpaceService spaceService, AgendaEventAttendeeService agendaEventAttendeeService, TemplateProvider templateProvider, NotificationInfo notification, ZoneId timeZone) {
        String notificationReceiverUserName = notification.getTo();
        String language = NotificationPluginUtils.getLanguage((String)notificationReceiverUserName);
        TemplateContext templateContext = NotificationUtils.getTemplateContext(templateProvider, notification, language);
        NotificationUtils.setFooter(notification, templateContext);
        NotificationUtils.setRead(notification, templateContext);
        NotificationUtils.setNotificationId(notification, templateContext);
        NotificationUtils.setLasModifiedTime(notification, templateContext, language);
        NotificationUtils.setIdentityNameAndAvatar(spaceService, notification, templateContext);
        NotificationUtils.setSpaceName(notification, templateContext);
        NotificationUtils.setEventDetails(templateContext, notification, timeZone);
        NotificationUtils.setIsGuest(username, templateContext);
        String modificationStoredType = notification.getValueOwnerParameter(STORED_EVENT_MODIFICATION_TYPE);
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_MODIFICATION_TYPE, (Object)modificationStoredType);
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_URL, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_URL));
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_CREATOR, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_CREATOR));
        templateContext.put((Object)"attendees", (Object)notification.getValueOwnerParameter("attendees"));
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_TIMEZONE_NAME, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_TIMEZONE_NAME));
        templateContext.put((Object)"eventStatus", (Object)notification.getValueOwnerParameter("eventStatus"));
        String eventIdString = notification.getValueOwnerParameter("eventId");
        long eventId = Long.parseLong(eventIdString);
        templateContext.put((Object)TEMPLATE_VARIABLE_RESPONSE_ACCEPTED, (Object)NotificationUtils.getResponseURL(agendaEventAttendeeService, eventId, username, EventAttendeeResponse.ACCEPTED));
        templateContext.put((Object)TEMPLATE_VARIABLE_RESPONSE_DECLINED, (Object)NotificationUtils.getResponseURL(agendaEventAttendeeService, eventId, username, EventAttendeeResponse.DECLINED));
        templateContext.put((Object)TEMPLATE_VARIABLE_RESPONSE_TENTATIVE, (Object)NotificationUtils.getResponseURL(agendaEventAttendeeService, eventId, username, EventAttendeeResponse.TENTATIVE));
        if (StringUtils.equals((String)modificationStoredType, (String)AgendaEventModificationType.UPDATED.name()) || StringUtils.equals((String)modificationStoredType, (String)AgendaEventModificationType.DATES_UPDATED.name()) || StringUtils.equals((String)modificationStoredType, (String)AgendaEventModificationType.SWITCHED_DATE_POLL_TO_EVENT.name()) || StringUtils.equals((String)modificationStoredType, (String)AgendaEventModificationType.SWITCHED_EVENT_TO_DATE_POLL.name()) || StringUtils.equals((String)modificationStoredType, (String)AgendaEventModificationType.DELETED.name())) {
            String identityId = notification.getValueOwnerParameter(STORED_PARAMETER_MODIFIER_IDENTITY_ID);
            templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_MODIFIER, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_MODIFIER));
            String userAbsoluteURI = StringUtils.isBlank((String)identityId) || StringUtils.equals((String)"0", (String)identityId) ? "" : NotificationUtils.getUserAbsoluteURI(identityId);
            templateContext.put((Object)TEMPLATE_VARIABLE_MODIFIER_IDENTITY_URL, (Object)userAbsoluteURI);
        }
        if (notification.getValueOwnerParameter("conference") != null) {
            templateContext.put((Object)"conference", (Object)notification.getValueOwnerParameter("conference"));
        }
        return templateContext;
    }

    public static final TemplateContext buildTemplateReminderParameters(SpaceService spaceService, TemplateProvider templateProvider, NotificationInfo notification, ZoneId timeZone) {
        String language = NotificationPluginUtils.getLanguage((String)notification.getTo());
        TemplateContext templateContext = NotificationUtils.getTemplateContext(templateProvider, notification, language);
        NotificationUtils.setFooter(notification, templateContext);
        NotificationUtils.setRead(notification, templateContext);
        NotificationUtils.setNotificationId(notification, templateContext);
        NotificationUtils.setLasModifiedTime(notification, templateContext, language);
        NotificationUtils.setIdentityNameAndAvatar(spaceService, notification, templateContext);
        NotificationUtils.setEventDetails(templateContext, notification, timeZone);
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_URL, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_URL));
        return templateContext;
    }

    public static final TemplateContext buildTemplateReplyParameters(TemplateProvider templateProvider, NotificationInfo notification, ZoneId timeZone, boolean isCreator) {
        String language = NotificationPluginUtils.getLanguage((String)notification.getTo());
        TemplateContext templateContext = NotificationUtils.getTemplateContext(templateProvider, notification, language);
        templateContext.put((Object)TEMPLATE_VARIABLE_IS_CREATOR, (Object)String.valueOf(isCreator));
        NotificationUtils.setFooter(notification, templateContext);
        NotificationUtils.setRead(notification, templateContext);
        NotificationUtils.setNotificationId(notification, templateContext);
        NotificationUtils.setLasModifiedTime(notification, templateContext, language);
        NotificationUtils.setSpaceName(notification, templateContext);
        NotificationUtils.setEventReplyDetails(templateContext, notification, timeZone);
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_URL, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_URL));
        return templateContext;
    }

    public static final TemplateContext buildTemplateDatePollParameters(SpaceService spaceService, TemplateProvider templateProvider, NotificationInfo notification) {
        String language = NotificationPluginUtils.getLanguage((String)notification.getTo());
        TemplateContext templateContext = NotificationUtils.getTemplateContext(templateProvider, notification, language);
        NotificationUtils.setFooter(notification, templateContext);
        NotificationUtils.setRead(notification, templateContext);
        NotificationUtils.setNotificationId(notification, templateContext);
        NotificationUtils.setLasModifiedTime(notification, templateContext, language);
        NotificationUtils.setSpaceName(notification, templateContext);
        NotificationUtils.setIdentityNameAndAvatar(spaceService, notification, templateContext);
        NotificationUtils.setEventDatePollDetails(templateContext, notification);
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_URL, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_URL));
        return templateContext;
    }

    public static final MessageInfo buildMessageSubjectAndBody(TemplateContext templateContext, NotificationInfo notification, String pushNotificationURL) {
        MessageInfo messageInfo = new MessageInfo();
        NotificationUtils.setMessageSubject(messageInfo, templateContext, NotificationUtils.getEventTitle(notification), pushNotificationURL);
        NotificationUtils.setMessageBody(templateContext, messageInfo);
        return messageInfo.end();
    }

    private static final void setEventDetails(TemplateContext templateContext, NotificationInfo notification, ZoneId timeZone) {
        templateContext.put((Object)"eventId", (Object)notification.getValueOwnerParameter("eventId"));
        templateContext.put((Object)"eventTitle", (Object)NotificationUtils.getEventTitle(notification));
        templateContext.put((Object)"eventLocation", (Object)NotificationUtils.getEventLocation(notification));
        templateContext.put((Object)"eventDescription", (Object)NotificationUtils.getEventDescription(notification));
        templateContext.put((Object)"recurrenceDetails", (Object)notification.getValueOwnerParameter("recurrenceDetails"));
        String startDateRFC3339 = notification.getValueOwnerParameter("startDate");
        String endDateRFC3339 = notification.getValueOwnerParameter("endDate");
        ZonedDateTime startDate = ZonedDateTime.parse(startDateRFC3339).withZoneSameInstant(timeZone);
        ZonedDateTime endDate = ZonedDateTime.parse(endDateRFC3339).withZoneSameInstant(timeZone);
        String dateFormatted = AgendaDateUtils.formatWithYearAndMonth(startDate);
        String startDateFormatted = AgendaDateUtils.formatWithHoursAndMinutes(startDate);
        String endDateFormatted = AgendaDateUtils.formatWithHoursAndMinutes(endDate);
        templateContext.put((Object)"startDate", (Object)startDateFormatted);
        templateContext.put((Object)"endDate", (Object)endDateFormatted);
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_MONTH_YEAR_DATE, (Object)dateFormatted);
        templateContext.put((Object)"USER", (Object)notification.getTo());
    }

    private static final void setEventReplyDetails(TemplateContext templateContext, NotificationInfo notification, ZoneId timeZone) {
        templateContext.put((Object)"eventId", (Object)notification.getValueOwnerParameter("eventId"));
        templateContext.put((Object)"eventTitle", (Object)NotificationUtils.getEventTitle(notification));
        templateContext.put((Object)"participantName", (Object)notification.getValueOwnerParameter("participantName"));
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_RESPONSE, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_RESPONSE));
        templateContext.put((Object)"participantAvatarUrl", (Object)notification.getValueOwnerParameter("participantAvatarUrl"));
        templateContext.put((Object)"eventLocation", (Object)NotificationUtils.getEventLocation(notification));
        templateContext.put((Object)"eventDescription", (Object)NotificationUtils.getEventDescription(notification));
        templateContext.put((Object)"recurrenceDetails", (Object)notification.getValueOwnerParameter("recurrenceDetails"));
        String startDateRFC3339 = notification.getValueOwnerParameter("startDate");
        String endDateRFC3339 = notification.getValueOwnerParameter("endDate");
        ZonedDateTime startDate = ZonedDateTime.parse(startDateRFC3339).withZoneSameInstant(timeZone);
        ZonedDateTime endDate = ZonedDateTime.parse(endDateRFC3339).withZoneSameInstant(timeZone);
        String dateFormatted = AgendaDateUtils.formatWithYearAndMonth(startDate);
        String startDateFormatted = AgendaDateUtils.formatWithHoursAndMinutes(startDate);
        String endDateFormatted = AgendaDateUtils.formatWithHoursAndMinutes(endDate);
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_TIMEZONE_NAME, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_TIMEZONE_NAME));
        templateContext.put((Object)"attendees", (Object)notification.getValueOwnerParameter("attendees"));
        templateContext.put((Object)"startDate", (Object)startDateFormatted);
        templateContext.put((Object)"endDate", (Object)endDateFormatted);
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_MONTH_YEAR_DATE, (Object)dateFormatted);
    }

    private static final void setEventDatePollDetails(TemplateContext templateContext, NotificationInfo notification) {
        templateContext.put((Object)"eventId", (Object)notification.getValueOwnerParameter("eventId"));
        templateContext.put((Object)"eventTitle", (Object)NotificationUtils.getEventTitle(notification));
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_CREATOR, (Object)notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_CREATOR));
        templateContext.put((Object)"participantName", (Object)notification.getValueOwnerParameter("participantName"));
        templateContext.put((Object)"USER", (Object)notification.getTo());
    }

    public static String getEventURL(Event event, ZonedDateTime occurrenceId) {
        String currentSite = NotificationUtils.getDefaultSite();
        Object currentDomain = CommonsUtils.getCurrentDomain();
        if (!((String)currentDomain).endsWith("/")) {
            currentDomain = (String)currentDomain + "/";
        }
        Object notificationURL = "";
        notificationURL = event != null ? (occurrenceId == null ? (String)currentDomain + "portal/" + currentSite + "/agenda?eventId=" + event.getId() : (String)currentDomain + "portal/" + currentSite + "/agenda?parentId=" + event.getId() + "&occurrenceId=" + AgendaDateUtils.toRFC3339Date(occurrenceId, ZoneOffset.UTC)) : (String)currentDomain + "portal/" + currentSite + "/agenda";
        return notificationURL;
    }

    public static String getEventURL(Event event) {
        return NotificationUtils.getEventURL(event, null);
    }

    public static String getResponseURL(AgendaEventAttendeeService agendaEventAttendeeService, long eventId, String username, EventAttendeeResponse response) {
        Object notificationURL = "";
        Object currentDomain = CommonsUtils.getCurrentDomain();
        if (!((String)currentDomain).endsWith("/")) {
            currentDomain = (String)currentDomain + "/";
        }
        if (eventId > 0L) {
            String token = agendaEventAttendeeService.generateEncryptedToken(eventId, username, response);
            if (token == null) {
                token = "";
            } else {
                try {
                    token = URLEncoder.encode(token, String.valueOf(Charset.defaultCharset()));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Object)"Error while encoding the token of events", (Throwable)e);
                }
            }
            notificationURL = (String)currentDomain + "portal/rest/v1/agenda/events/" + eventId + "/response/send?response=" + response.name() + "&token=" + token + "&redirect=true";
        }
        return notificationURL;
    }

    public static String getRecurrenceDetails(Event event) {
        EventRecurrence eventRecurrence = event.getRecurrence();
        if (eventRecurrence != null && eventRecurrence.getFrequency() != null) {
            switch (eventRecurrence.getFrequency().name()) {
                case "DAILY": {
                    if (eventRecurrence.getInterval() == 1) {
                        return "daily";
                    }
                    return "Each " + eventRecurrence.getInterval() + "days";
                }
                case "WEEKLY": {
                    if (eventRecurrence.getInterval() == 1) {
                        List dayNamesAbbreviations = eventRecurrence.getByDay();
                        return "Weekly on " + AgendaDateUtils.getDayNameFromDayAbbreviation(dayNamesAbbreviations);
                    }
                    List dayNamesAbbreviations = eventRecurrence.getByDay();
                    return "Each Week " + eventRecurrence.getInterval() + " on " + AgendaDateUtils.getDayNameFromDayAbbreviation(dayNamesAbbreviations);
                }
                case "MONTHLY": {
                    if (eventRecurrence.getInterval() == 1) {
                        String dayNumberMonth = (String)eventRecurrence.getByMonthDay().get(0);
                        return " Monthly on " + dayNumberMonth;
                    }
                    String dayNumberMonth = (String)eventRecurrence.getByMonthDay().get(0);
                    return " Each " + eventRecurrence.getInterval() + " month on " + dayNumberMonth;
                }
                case "YEARLY": {
                    if (eventRecurrence.getInterval() == 1) {
                        String dayNumberInMonth = (String)eventRecurrence.getByMonthDay().get(0);
                        String monthNumber = (String)eventRecurrence.getByMonth().get(0);
                        Month monthName = Month.of(Integer.parseInt(monthNumber));
                        return " Yearly on " + StringUtils.lowerCase((String)String.valueOf(monthName)) + dayNumberInMonth;
                    }
                    String dayNumberInMonth = (String)eventRecurrence.getByMonthDay().get(0);
                    String monthNumber = (String)eventRecurrence.getByMonth().get(0);
                    Month monthName = Month.of(Integer.parseInt(monthNumber));
                    return " Each " + eventRecurrence.getInterval() + " years on " + StringUtils.lowerCase((String)String.valueOf(monthName)) + " " + dayNumberInMonth;
                }
            }
            return "";
        }
        return "";
    }

    private static final void setIdentityNameAndAvatar(SpaceService spaceService, NotificationInfo notification, TemplateContext templateContext) {
        String ownerId = notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_OWNER_ID);
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        Identity identity = identityManager.getIdentity(ownerId);
        String avatarUrl = null;
        if (identity == null) {
            avatarUrl = "/platform-ui/skin/images/avatar/DefaultSpaceAvatar.png";
        } else if ("space".equals(identity.getProviderId())) {
            Space space = spaceService.getSpaceByPrettyName(identity.getRemoteId());
            avatarUrl = LinkProviderUtils.getSpaceAvatarUrl((Space)space);
        } else {
            avatarUrl = LinkProviderUtils.getUserAvatarUrl((Profile)identity.getProfile());
        }
        templateContext.put((Object)TEMPLATE_VARIABLE_SUFFIX_IDENTITY_AVATAR, (Object)avatarUrl);
    }

    private static final void setIsGuest(String username, TemplateContext templateContext) {
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        Identity identity = identityManager.getOrCreateIdentity("organization", username);
        if (identity == null) {
            identity = identityManager.getOrCreateIdentity("GUEST_USER", username);
        }
        templateContext.put((Object)TEMPLATE_VARIABLE_EVENT_IS_GUEST, (Object)(identity != null && identity.getProviderId().equals("GUEST_USER") ? 1 : 0));
    }

    private static final String setParticipantAvatarUrl(Identity identity) {
        return identity.getProfile().getAvatarUrl();
    }

    private static final void setSpaceName(NotificationInfo notification, TemplateContext templateContext) {
        String ownerId = notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_OWNER_ID);
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        SpaceService spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        Identity identity = identityManager.getIdentity(ownerId);
        if (identity == null) {
            templateContext.put((Object)TEMPLATE_VARIABLE_AGENDA_NAME, (Object)"");
        } else {
            Space space = spaceService.getSpaceByPrettyName(identity.getRemoteId());
            String spaceName = space == null ? null : space.getDisplayName();
            templateContext.put((Object)TEMPLATE_VARIABLE_AGENDA_NAME, (Object)spaceName);
        }
    }

    private static final void setMessageSubject(MessageInfo messageInfo, TemplateContext templateContext, String title, String pushNotificationURL) {
        if (pushNotificationURL != null) {
            messageInfo.subject(pushNotificationURL);
        } else {
            messageInfo.subject(TemplateUtils.processSubject((TemplateContext)templateContext) + ":" + title);
        }
    }

    private static String getEventTitle(NotificationInfo notification) {
        return notification.getValueOwnerParameter("eventTitle");
    }

    private static String getEventLocation(NotificationInfo notification) {
        String eventLocation = notification.getValueOwnerParameter("eventLocation");
        if (StringUtils.isNotBlank((String)eventLocation)) {
            return eventLocation;
        }
        return "";
    }

    private static String getEventDescription(NotificationInfo notification) {
        String eventDescription = notification.getValueOwnerParameter("eventDescription");
        if (StringUtils.isNotBlank((String)eventDescription)) {
            return eventDescription;
        }
        return "";
    }

    private static final TemplateContext getTemplateContext(TemplateProvider templateProvider, NotificationInfo notification, String language) {
        PluginKey pluginKey = notification.getKey();
        String pluginId = pluginKey.getId();
        ChannelKey channelKey = templateProvider.getChannelKey();
        return TemplateContext.newChannelInstance((ChannelKey)channelKey, (String)pluginId, (String)language);
    }

    private static final void setMessageBody(TemplateContext templateContext, MessageInfo messageInfo) {
        messageInfo.body(TemplateUtils.processGroovy((TemplateContext)templateContext));
    }

    private static final void setFooter(NotificationInfo notification, TemplateContext templateContext) {
        SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
    }

    private static final void setRead(NotificationInfo notification, TemplateContext templateContext) {
        Boolean isRead = Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()));
        templateContext.put((Object)"READ", (Object)(isRead != null && isRead != false ? "read" : "unread"));
    }

    private static final void setNotificationId(NotificationInfo notification, TemplateContext templateContext) {
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
    }

    private static final void setLasModifiedTime(NotificationInfo notification, TemplateContext templateContext, String language) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(notification.getLastModifiedDate());
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((java.util.Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
    }

    private static final String getEventNotificationCreatorOrModifierUserName(Identity identity) {
        Object fullName = Arrays.stream(identity.getProfile().getFullName().split(" ")).map(t -> t.substring(0, 1).toUpperCase() + t.substring(1)).collect(Collectors.joining(" "));
        if (Utils.isExternal(identity.getRemoteId())) {
            fullName = (String)fullName + " (" + Utils.getResourceBundleLabel(new Locale(Utils.getUserLanguage(identity.getRemoteId())), "external.label.tag") + ")";
        }
        return fullName;
    }

    private static String getUserAbsoluteURI(String identityId) {
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        Identity identity = identityManager.getIdentity(identityId);
        String currentSite = CommonsUtils.getCurrentSite().getName();
        Object currentDomain = CommonsUtils.getCurrentDomain();
        if (!((String)currentDomain).endsWith("/")) {
            currentDomain = (String)currentDomain + "/";
        }
        return (String)currentDomain + "portal/" + currentSite + "/profile/" + identity.getRemoteId();
    }

    private static String getFullUserName(Set<String> participants, IdentityManager identityManager) {
        String showParticipants = participants.stream().limit(3L).map(participant -> Utils.getIdentityById(identityManager, participant).getProfile().getFullName()).collect(Collectors.joining(", "));
        if (participants.size() > 3) {
            showParticipants = showParticipants.concat("...");
        }
        return showParticipants;
    }

    private static String getSpaceDisplayName(Set<String> participants, SpaceService spaceService) {
        ArrayList<String> showParticipants = new ArrayList<String>();
        for (String participant : participants) {
            String displaySpaceName = spaceService.getSpaceByPrettyName(participant).getDisplayName();
            showParticipants.add(displaySpaceName);
        }
        return String.join((CharSequence)", ", showParticipants);
    }

    public static String getWebConferenceLink(Event event) {
        AgendaEventConferenceService agendaEventConferenceService = (AgendaEventConferenceService)ExoContainerContext.getService(AgendaEventConferenceService.class);
        List webConferences = agendaEventConferenceService.getEventConferences(event.getId());
        if (webConferences != null && !webConferences.isEmpty()) {
            return ((EventConference)webConferences.get(0)).getUrl();
        }
        return null;
    }

    public static final void addIcsFile(NotificationInfo notification, MessageInfo messageInfo, ZoneId timeZone) {
        Attachment attachment = new Attachment();
        RandomUidGenerator ug = new RandomUidGenerator();
        Uid uid = ug.generateUid();
        String eventSummary = notification.getValueOwnerParameter("eventTitle");
        String startDateRFC3339 = notification.getValueOwnerParameter("startDate");
        String endDateRFC3339 = notification.getValueOwnerParameter("endDate");
        ZonedDateTime startDate = ZonedDateTime.parse(startDateRFC3339).withZoneSameInstant(timeZone);
        ZonedDateTime endDate = ZonedDateTime.parse(endDateRFC3339).withZoneSameInstant(timeZone);
        net.fortuna.ical4j.model.TimeZone ical4jTimezone = Utils.getICalTimeZone(timeZone);
        DateTime startDateTime = new DateTime(java.util.Date.from(startDate.toInstant()), ical4jTimezone);
        DateTime endDateTime = new DateTime(java.util.Date.from(endDate.toInstant()), ical4jTimezone);
        VEvent vEvent = new VEvent((Date)startDateTime, (Date)endDateTime, eventSummary);
        vEvent.getProperties().add((Property)uid);
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)new ProdId("PRODID:-//eXo Plaform//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        Organizer organizer = new Organizer(URI.create("noreply@noreply.com"));
        organizer.getParameters().add((Parameter)new Cn(notification.getValueOwnerParameter(STORED_PARAMETER_EVENT_CREATOR)));
        calendar.getProperties().add((Property)organizer);
        calendar.getComponents().add((Object)vEvent);
        CalendarOutputter outputter = new CalendarOutputter();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            outputter.output(calendar, (OutputStream)output);
            byte[] bytes = output.toByteArray();
            attachment.setInputStream((InputStream)new ByteArrayInputStream(bytes));
            attachment.setMimeType("text/calendar;charset=utf-8;method=PUBLISH");
            messageInfo.addAttachment(attachment);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to convert event '" + eventSummary + "' to iCal format", e);
        }
    }
}

