/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.pwa;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;

public class EventVoteNotificationPwaPlugin
implements PwaNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(EventVoteNotificationPwaPlugin.class);
    private String notificationId = "VoteNotificationPlugin";
    private static final String TITLE_LABEL_KEY = "pwa.notification.EventVoteNotificationPwaPlugin.title";
    private ResourceBundleService resourceBundleService;

    public EventVoteNotificationPwaPlugin(ResourceBundleService resourceBundleService) {
        this.resourceBundleService = resourceBundleService;
    }

    public String getId() {
        return this.notificationId;
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        String title = this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", notification.getValueOwnerParameter("participantName"));
        notificationMessage.setTitle(title);
        notificationMessage.setBody(notification.getValueOwnerParameter("eventTitle"));
        String url = notification.getValueOwnerParameter("Url").replace(CommonsUtils.getCurrentDomain(), "");
        notificationMessage.setUrl(url);
        return notificationMessage;
    }
}

