/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener.analytics;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class AgendaEventResponseListener
extends Listener<Long, Object> {
    private static final String EVENT_RESPONSE = "eventResponse";
    private AgendaCalendarService agendaCalendarService;
    private AgendaEventService agendaEventService;
    private IdentityManager identityManager;

    public void onEvent(Event<Long, Object> event) throws Exception {
        EventAttendee eventAttendee = (EventAttendee)event.getData();
        this.addEventStatistic(eventAttendee, EVENT_RESPONSE);
    }

    private void addEventStatistic(EventAttendee eventAttendee, String operation) {
        String eventResponse = eventAttendee.getResponse().getValue();
        Long eventId = eventAttendee.getEventId();
        long userId = 0L;
        Identity identity = this.getIdentityManager().getIdentity(String.valueOf(eventAttendee.getIdentityId()));
        if (identity.getProviderId().equals("organization")) {
            userId = eventAttendee.getIdentityId();
        }
        org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(eventId.longValue());
        Calendar calendar = this.getAgendaCalendarService().getCalendarById(agendaEvent.getCalendarId());
        Identity spaceOwnerIdentity = this.getIdentityManager().getIdentity(String.valueOf(calendar.getOwnerId()));
        StatisticData statisticData = new StatisticData();
        if (StringUtils.equals((CharSequence)spaceOwnerIdentity.getProviderId(), (CharSequence)"space")) {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceByPrettyName(spaceOwnerIdentity.getRemoteId());
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        }
        statisticData.setModule("agenda");
        statisticData.setSubModule("event");
        statisticData.setOperation(operation);
        if (userId > 0L) {
            statisticData.setUserId(userId);
        }
        statisticData.addParameter("eventId", (Object)agendaEvent.getId());
        statisticData.addParameter(EVENT_RESPONSE, (Object)eventResponse);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }

    public AgendaCalendarService getAgendaCalendarService() {
        if (this.agendaCalendarService == null) {
            this.agendaCalendarService = (AgendaCalendarService)ExoContainerContext.getService(AgendaCalendarService.class);
        }
        return this.agendaCalendarService;
    }

    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return this.identityManager;
    }
}

