/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.dao.CalendarDAO;
import org.exoplatform.agenda.dao.EventDAO;
import org.exoplatform.agenda.dao.EventRecurrenceDAO;
import org.exoplatform.agenda.entity.CalendarEntity;
import org.exoplatform.agenda.entity.EventEntity;
import org.exoplatform.agenda.entity.EventRecurrenceEntity;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventFilter;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.agenda.util.EntityMapper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AgendaEventStorage {
    private static final Log LOG = ExoLogger.getLogger(AgendaEventStorage.class);
    private static final int DEFAULT_LIMIT = 200;
    private CalendarDAO calendarDAO;
    private EventDAO eventDAO;
    private EventRecurrenceDAO eventRecurrenceDAO;

    public AgendaEventStorage(CalendarDAO calendarDAO, EventDAO eventDAO, EventRecurrenceDAO eventRecurrenceDAO) {
        this.calendarDAO = calendarDAO;
        this.eventDAO = eventDAO;
        this.eventRecurrenceDAO = eventRecurrenceDAO;
    }

    public List<Long> getEventIds(EventFilter eventFilter) {
        ZonedDateTime start = eventFilter.getStart();
        ZonedDateTime end = eventFilter.getEnd();
        Date startDate = new Date(start.withSecond(0).withNano(0).toEpochSecond() * 1000L);
        Date endDate = end == null ? null : new Date(end.withSecond(59).withNano(999999999).toEpochSecond() * 1000L);
        List attendeeIds = eventFilter.getAttendeeId() > 0L ? eventFilter.getAttendeeWithSpacesIds() : null;
        List ownerIds = eventFilter.getOwnerIds();
        List responseTypes = eventFilter.getResponseTypes();
        int limit = eventFilter.getEnd() == null ? 200 : 0;
        return this.eventDAO.getEventIds(startDate, endDate, ownerIds, attendeeIds, responseTypes, limit);
    }

    public List<Event> getParentRecurrentEventIds(ZonedDateTime start, ZonedDateTime end) {
        Date startDate = new Date(start.withSecond(0).withNano(0).toEpochSecond() * 1000L);
        Date endDate = new Date(end.withSecond(59).toEpochSecond() * 1000L);
        List<EventEntity> events = this.eventDAO.getParentRecurrentEventIds(startDate, endDate);
        return events.stream().map(EntityMapper::fromEntity).collect(Collectors.toList());
    }

    public Event getEventById(long eventId) {
        EventEntity eventEntity = (EventEntity)this.eventDAO.find(Long.valueOf(eventId));
        if (eventEntity == null) {
            return null;
        }
        return EntityMapper.fromEntity(eventEntity);
    }

    public void deleteEventById(long eventId) {
        this.eventDAO.deleteEvent(eventId);
    }

    public List<Long> getExceptionalOccurenceIds(long parentRecurrentEventId) {
        return this.eventDAO.getExceptionalOccurenceIds(parentRecurrentEventId);
    }

    public List<Long> getExceptionalOccurenceIdsByPeriod(long parentRecurrentEventId, ZonedDateTime start, ZonedDateTime end) {
        return this.eventDAO.getExceptionalOccurenceIdsByPeriod(parentRecurrentEventId, AgendaDateUtils.toDate(start), AgendaDateUtils.toDate(end));
    }

    public Event createEvent(Event event) {
        EventEntity eventEntity = EntityMapper.toEntity(event);
        eventEntity.setId(null);
        if (event.getParentId() > 0L) {
            EventEntity parentEvent = (EventEntity)this.eventDAO.find(Long.valueOf(event.getParentId()));
            eventEntity.setParent(parentEvent);
        }
        this.updateEventCalendar(event, eventEntity);
        eventEntity = this.eventDAO.create(eventEntity);
        this.createEventRecurrence(event, eventEntity);
        return EntityMapper.fromEntity(eventEntity);
    }

    public void deleteExceptionalOccurences(long parentRecurrentEventId) {
        this.eventDAO.deleteExceptionalOccurences(parentRecurrentEventId);
    }

    public Event getExceptionalOccurrenceEvent(long parentRecurrentEventId, ZonedDateTime occurrenceId) {
        ZonedDateTime start = occurrenceId.toLocalDate().atStartOfDay(ZoneOffset.UTC);
        ZonedDateTime end = occurrenceId.toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L);
        List<Long> exceptionalOccurenceEventIds = this.eventDAO.getExceptionalOccurenceIdsByPeriod(parentRecurrentEventId, AgendaDateUtils.toDate(start), AgendaDateUtils.toDate(end));
        if (exceptionalOccurenceEventIds == null || exceptionalOccurenceEventIds.isEmpty()) {
            return null;
        }
        if (exceptionalOccurenceEventIds.size() > 1) {
            LOG.warn("More than one exceptional event on parent event {} is found for occurrence of day {}. Occurrence ids found: {}", new Object[]{parentRecurrentEventId, occurrenceId, StringUtils.join(exceptionalOccurenceEventIds, (String)",")});
        }
        return this.getEventById(exceptionalOccurenceEventIds.get(0));
    }

    public Event updateEvent(Event event) {
        EventEntity eventEntity = EntityMapper.toEntity(event);
        this.updateEventParent(event, eventEntity);
        this.updateEventCalendar(event, eventEntity);
        this.updateEventRecurrence(event, eventEntity);
        eventEntity = this.eventDAO.update(eventEntity);
        eventEntity = (EventEntity)this.eventDAO.find(eventEntity.getId());
        return EntityMapper.fromEntity(eventEntity);
    }

    public boolean isRecurrentEvent(long eventId) {
        Event event = this.getEventById(eventId);
        if (event == null) {
            return false;
        }
        return event.getRecurrence() != null;
    }

    private void updateEventCalendar(Event event, EventEntity eventEntity) {
        CalendarEntity calendarEntity = (CalendarEntity)this.calendarDAO.find(Long.valueOf(event.getCalendarId()));
        eventEntity.setCalendar(calendarEntity);
    }

    private void updateEventParent(Event event, EventEntity eventEntity) {
        if (event.getParentId() > 0L) {
            EventEntity parentEvent = (EventEntity)this.eventDAO.find(Long.valueOf(event.getParentId()));
            if (parentEvent == null) {
                throw new IllegalStateException("Can't find parent event with id " + event.getParentId());
            }
            eventEntity.setParent(parentEvent);
        }
    }

    private void updateEventRecurrence(Event event, EventEntity eventEntity) {
        EventRecurrence recurrence = event.getRecurrence();
        EventEntity storedEventEntity = (EventEntity)this.eventDAO.find(eventEntity.getId());
        if (storedEventEntity == null) {
            throw new IllegalStateException("Can't find event with id " + eventEntity.getId());
        }
        if (recurrence != null) {
            EventRecurrenceEntity eventRecurrenceEntity = EntityMapper.toEntity(event, recurrence);
            eventRecurrenceEntity.setEvent(eventEntity);
            if (storedEventEntity.getRecurrence() != null) {
                eventRecurrenceEntity.setId(storedEventEntity.getRecurrence().getId());
                eventRecurrenceEntity.setEvent(storedEventEntity);
                eventRecurrenceEntity = (EventRecurrenceEntity)this.eventRecurrenceDAO.update(eventRecurrenceEntity);
            } else {
                eventRecurrenceEntity.setId(null);
                eventRecurrenceEntity.setEvent(eventEntity);
                eventEntity.setRecurrence(eventRecurrenceEntity);
                eventRecurrenceEntity = (EventRecurrenceEntity)this.eventRecurrenceDAO.create(eventRecurrenceEntity);
            }
            eventEntity.setRecurrence(eventRecurrenceEntity);
        } else if (storedEventEntity.getRecurrence() != null) {
            this.eventRecurrenceDAO.delete(storedEventEntity.getRecurrence());
        }
    }

    private void createEventRecurrence(Event event, EventEntity eventEntity) {
        if (event.getRecurrence() != null) {
            EventRecurrenceEntity eventRecurrenceEntity = EntityMapper.toEntity(event, event.getRecurrence());
            eventRecurrenceEntity.setId(null);
            eventRecurrenceEntity.setEvent(eventEntity);
            eventEntity.setRecurrence(eventRecurrenceEntity);
            this.eventRecurrenceDAO.create(eventRecurrenceEntity);
        }
    }
}

