/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventModificationType;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.storage.AgendaEventAttendeeStorage;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class AgendaEventAttendeeServiceImpl
implements AgendaEventAttendeeService {
    private static final Log LOG = ExoLogger.getLogger(AgendaEventAttendeeServiceImpl.class);
    private static final String SEPARATOR = "@@@";
    private AgendaEventAttendeeStorage attendeeStorage;
    private AgendaEventStorage eventStorage;
    private ListenerService listenerService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private CodecInitializer codecInitializer;

    public AgendaEventAttendeeServiceImpl(AgendaEventAttendeeStorage attendeeStorage, AgendaEventStorage eventStorage, ListenerService listenerService, IdentityManager identityManager, SpaceService spaceService, CodecInitializer codecInitializer) {
        this.attendeeStorage = attendeeStorage;
        this.eventStorage = eventStorage;
        this.codecInitializer = codecInitializer;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
    }

    public void saveEventAttendees(Event event, List<EventAttendee> attendees, long creatorUserId, boolean sendInvitations, boolean resetResponses, EventModificationType eventModificationType) {
        long eventId = event.getId();
        List<EventAttendee> savedAttendees = this.getEventAttendees(event.getId());
        List<Object> newAttendees = attendees == null ? Collections.emptyList() : attendees;
        List attendeesToDelete = savedAttendees.stream().filter(attendee -> newAttendees.stream().noneMatch(newAttendee -> newAttendee.getIdentityId() == attendee.getIdentityId())).collect(Collectors.toList());
        for (Object eventAttendee : attendeesToDelete) {
            this.attendeeStorage.removeEventAttendee(eventAttendee.getId());
        }
        List attendeesToCreate = newAttendees.stream().filter(attendee -> savedAttendees.stream().noneMatch(newAttendee -> newAttendee.getIdentityId() == attendee.getIdentityId())).collect(Collectors.toList());
        for (EventAttendee eventAttendee : attendeesToCreate) {
            if (resetResponses || eventAttendee.getResponse() == null) {
                eventAttendee.setResponse(EventAttendeeResponse.NEEDS_ACTION);
            }
            this.attendeeStorage.saveEventAttendee(eventAttendee, eventId);
        }
        if (resetResponses) {
            List attendeesToUpdate = savedAttendees.stream().filter(attendee -> newAttendees.stream().anyMatch(newAttendee -> newAttendee.getIdentityId() == attendee.getIdentityId())).collect(Collectors.toList());
            for (EventAttendee eventAttendee : attendeesToUpdate) {
                try {
                    this.sendEventResponse(eventId, eventAttendee.getIdentityId(), EventAttendeeResponse.NEEDS_ACTION);
                }
                catch (Exception e) {
                    LOG.warn("Error initializing default reminders of event {} for user with id {}", new Object[]{eventId, eventAttendee.getIdentityId(), e});
                }
            }
        }
        try {
            if (creatorUserId > 0L && this.isEventAttendee(eventId, creatorUserId)) {
                if (event.getStatus() == EventStatus.CONFIRMED) {
                    this.sendEventResponse(eventId, creatorUserId, EventAttendeeResponse.ACCEPTED);
                } else if (event.getStatus() == EventStatus.TENTATIVE) {
                    this.sendEventResponse(eventId, creatorUserId, EventAttendeeResponse.TENTATIVE);
                } else if (event.getStatus() == EventStatus.CANCELLED) {
                    this.sendEventResponse(eventId, creatorUserId, EventAttendeeResponse.DECLINED);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error initializing default reminders of event {} for creator with id {}", new Object[]{eventId, creatorUserId, e});
        }
        if (sendInvitations) {
            if (event.getStatus() == EventStatus.CANCELLED) {
                eventModificationType = EventModificationType.DELETED;
            }
            this.sendInvitations(event, attendees, eventModificationType);
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.attendees.saved", eventId, 0);
    }

    public List<EventAttendee> getEventAttendees(long eventId) {
        return this.attendeeStorage.getEventAttendees(eventId);
    }

    public EventAttendeeResponse getEventResponse(long eventId, long identityId) throws ObjectNotFoundException, IllegalAccessException {
        Event event = this.eventStorage.getEventById(eventId);
        if (event == null) {
            throw new ObjectNotFoundException("Event with id " + eventId + " wasn't found");
        }
        if (!this.isEventAttendee(eventId, identityId)) {
            throw new IllegalAccessException("User " + identityId + " is not attendee of event " + eventId);
        }
        EventAttendee attendee = this.attendeeStorage.getEventAttendee(eventId, identityId);
        if (attendee == null) {
            return EventAttendeeResponse.NEEDS_ACTION;
        }
        return attendee.getResponse();
    }

    public void sendEventResponse(long eventId, long identityId, EventAttendeeResponse response) throws ObjectNotFoundException, IllegalAccessException {
        if (response == null) {
            throw new IllegalArgumentException("Attendee response is mandatory");
        }
        Event event = this.eventStorage.getEventById(eventId);
        if (event == null) {
            throw new ObjectNotFoundException("Parent event with id " + eventId + " wasn't found");
        }
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (userIdentity == null) {
            throw new ObjectNotFoundException("Identity with id " + identityId + " wasn't found");
        }
        if (!this.isEventAttendee(eventId, identityId)) {
            throw new IllegalAccessException("User with identity id " + identityId + " isn't attendee of event with id " + eventId);
        }
        this.saveEventAttendee(eventId, identityId, response);
        if (this.eventStorage.isRecurrentEvent(eventId)) {
            List<Long> exceptionalOccurenceEventIds = this.eventStorage.getExceptionalOccurenceIds(eventId);
            for (long exceptionalOccurenceEventId : exceptionalOccurenceEventIds) {
                if (!this.isEventAttendee(exceptionalOccurenceEventId, identityId)) continue;
                this.saveEventAttendee(exceptionalOccurenceEventId, identityId, response);
            }
        }
    }

    public String generateEncryptedToken(long eventId, String email) {
        return this.generateEncryptedToken(eventId, email, null);
    }

    public String generateEncryptedToken(long eventId, String emailOrUsername, EventAttendeeResponse response) {
        if (eventId <= 0L) {
            throw new IllegalArgumentException("eventId is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)emailOrUsername)) {
            throw new IllegalArgumentException("email is mandatory");
        }
        StringBuilder tokenFlatStringBuilder = new StringBuilder().append(String.valueOf(eventId)).append(SEPARATOR).append(emailOrUsername);
        if (response != null) {
            tokenFlatStringBuilder.append(SEPARATOR).append(response.getValue());
        }
        String tokenFlat = tokenFlatStringBuilder.toString();
        try {
            return this.codecInitializer.getCodec().encode(tokenFlat);
        }
        catch (TokenServiceInitializationException e) {
            LOG.warn((Object)"Error generating Token", (Throwable)e);
            return null;
        }
    }

    public Identity decryptUserIdentity(long eventId, String token, EventAttendeeResponse response) throws IllegalAccessException {
        String tokenFlat;
        try {
            tokenFlat = this.codecInitializer.getCodec().decode(token);
        }
        catch (TokenServiceInitializationException e) {
            LOG.warn((Object)"Error decrypting Token", (Throwable)e);
            return null;
        }
        String[] tokenParts = tokenFlat.split("\\@@@");
        if (tokenParts.length < 2) {
            throw new IllegalAccessException("Wrong token format");
        }
        String eventIdString = tokenParts[0];
        if (!eventIdString.equals(String.valueOf(eventId))) {
            throw new IllegalAccessException("Wrong eventId from token");
        }
        if (response != null) {
            String responseString;
            String string = responseString = tokenParts.length > 2 ? tokenParts[2] : null;
            if (!StringUtils.equals((CharSequence)responseString, (CharSequence)response.getValue())) {
                throw new IllegalAccessException("Wrong response from token");
            }
        }
        String emailOrUsername = tokenParts[1];
        return this.identityManager.getOrCreateIdentity("organization", emailOrUsername);
    }

    public boolean isEventAttendee(long eventId, long identityId) {
        List<EventAttendee> eventAttendees = this.getEventAttendees(eventId);
        return Utils.isEventAttendee(this.identityManager, this.spaceService, identityId, eventAttendees);
    }

    public void sendInvitations(Event event, List<EventAttendee> eventAttendees, EventModificationType eventModificationType) {
        String agendaNotificationPluginType = null;
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.EVENT_AGENDA, (Object)event);
        ctx.append(NotificationUtils.EVENT_ATTENDEE, eventAttendees);
        if (eventModificationType.name().equals("ADDED")) {
            agendaNotificationPluginType = "EventAddedNotificationPlugin";
            ctx.append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)"ADDED");
        } else if (eventModificationType.name().equals("UPDATED")) {
            agendaNotificationPluginType = "EventModifiedNotificationPlugin";
            ctx.append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)"UPDATED");
        } else {
            agendaNotificationPluginType = "EventCanceledNotificationPlugin";
            ctx.append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)"DELETED");
        }
        this.dispatch(ctx, agendaNotificationPluginType);
    }

    private void saveEventAttendee(long eventId, long identityId, EventAttendeeResponse response) {
        EventAttendee attendee = this.attendeeStorage.getEventAttendee(eventId, identityId);
        EventAttendee oldAttendee = null;
        if (attendee == null) {
            attendee = new EventAttendee(0L, eventId, identityId, response);
        } else {
            oldAttendee = attendee.clone();
            attendee.setResponse(response);
        }
        this.attendeeStorage.saveEventAttendee(attendee, eventId);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.responseSent", oldAttendee, attendee);
    }

    private void dispatch(NotificationContext ctx, String ... pluginId) {
        ArrayList<NotificationCommand> commands = new ArrayList<NotificationCommand>(pluginId.length);
        for (String p : pluginId) {
            commands.add(ctx.makeCommand(PluginKey.key((String)p)));
        }
        try {
            ctx.getNotificationExecutor().with(commands).execute(ctx);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error sending invitation notifications", (Throwable)e);
        }
    }
}

