/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventAvailability;
import org.exoplatform.agenda.constant.EventRecurrenceFrequency;
import org.exoplatform.agenda.constant.EventRecurrenceType;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventFilter;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.social.core.identity.model.Identity;
import org.junit.Assert;
import org.junit.Test;

public class AgendaEventServiceTest
extends BaseAgendaEventTest {
    @Test
    public void testCreateEvent() throws Exception {
        Event event2;
        try {
            event2 = new Event();
            event2.setId(0L);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, 0L);
            Assert.fail();
        }
        catch (IllegalArgumentException event2) {
            // empty catch block
        }
        try {
            this.agendaEventService.createEvent(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException event2) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(2L);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException event3) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(0L);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException event4) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event5) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event6) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now().plusDays(1L));
            event2.setEnd(ZonedDateTime.now());
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event7) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            long userIdentityId = 2000L;
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, userIdentityId);
            Assert.fail();
        }
        catch (IllegalAccessException event8) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            EventRecurrence recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event9) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            EventRecurrence recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event10) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(12L);
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            EventRecurrence recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event11) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            EventRecurrence recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser4Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException event12) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            EventRecurrence recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser2Identity.getId()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            this.spaceService.addRedactor(this.space, this.testuser1Identity.getRemoteId());
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            EventRecurrence recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException event13) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            EventRecurrence recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            this.agendaEventService.createEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
        }
        catch (AgendaException e) {
            Assert.fail((String)e.getMessage());
        }
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event14 = this.newEventInstance(start, start, allDay);
        LocalDate untilDate = event14.getRecurrence().getUntil();
        Event createdEvent = this.createEvent(event14.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity, this.testuser3Identity);
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        AgendaEventModification eventModification = (AgendaEventModification)eventCreationReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.ADDED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)1L, (long)eventModification.getModificationTypes().size());
        Assert.assertEquals((Object)event14.getSummary(), (Object)createdEvent.getSummary());
        Assert.assertEquals((Object)event14.getDescription(), (Object)createdEvent.getDescription());
        Assert.assertEquals((long)event14.getCalendarId(), (long)createdEvent.getCalendarId());
        Assert.assertEquals((Object)event14.getColor(), (Object)createdEvent.getColor());
        Assert.assertEquals((Object)event14.getStart().toLocalDate(), (Object)createdEvent.getStart().toLocalDate());
        Assert.assertEquals((Object)event14.getEnd().toLocalDate(), (Object)createdEvent.getEnd().toLocalDate());
        Assert.assertEquals((Object)event14.getLocation(), (Object)createdEvent.getLocation());
        Assert.assertEquals((long)Long.parseLong(this.testuser1Identity.getId()), (long)createdEvent.getCreatorId());
        Assert.assertEquals((Object)event14.getAvailability(), (Object)createdEvent.getAvailability());
        Assert.assertEquals((Object)event14.getOccurrence(), (Object)createdEvent.getOccurrence());
        Assert.assertNotNull((Object)createdEvent.getAcl());
        Assert.assertTrue((boolean)createdEvent.getAcl().isCanEdit());
        Assert.assertFalse((boolean)createdEvent.getAcl().isAttendee());
        Assert.assertNotNull((Object)createdEvent.getCreated());
        Assert.assertNull((Object)createdEvent.getUpdated());
        Assert.assertEquals((long)event14.getModifierId(), (long)createdEvent.getModifierId());
        EventRecurrence createdEventRecurrence = createdEvent.getRecurrence();
        Assert.assertNotNull((Object)createdEventRecurrence);
        Assert.assertTrue((createdEventRecurrence.getId() > 0L ? 1 : 0) != 0);
        EventRecurrence eventRecurrence = event14.getRecurrence();
        Assert.assertEquals((Object)eventRecurrence.getFrequency(), (Object)createdEventRecurrence.getFrequency());
        Assert.assertEquals((Object)eventRecurrence.getType(), (Object)createdEventRecurrence.getType());
        Assert.assertEquals((long)eventRecurrence.getInterval(), (long)createdEventRecurrence.getInterval());
        Assert.assertTrue((createdEventRecurrence.getCount() == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)createdEventRecurrence.getUntil());
        Assert.assertEquals((Object)untilDate, (Object)createdEventRecurrence.getUntil());
        Assert.assertEquals((Object)createdEvent.getRecurrence().getOverallEnd().toLocalDate(), (Object)createdEventRecurrence.getUntil());
        Assert.assertEquals((Object)eventRecurrence.getBySecond(), (Object)createdEventRecurrence.getBySecond());
        Assert.assertEquals((Object)eventRecurrence.getByMinute(), (Object)createdEventRecurrence.getByMinute());
        Assert.assertEquals((Object)eventRecurrence.getByHour(), (Object)createdEventRecurrence.getByHour());
        Assert.assertEquals((Object)eventRecurrence.getByDay(), (Object)createdEventRecurrence.getByDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonthDay(), (Object)createdEventRecurrence.getByMonthDay());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonth(), (Object)createdEventRecurrence.getByMonth());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
        Assert.assertNotNull((Object)createdEventRecurrence.getOverallStart());
        Assert.assertEquals((Object)start.toLocalDate(), (Object)createdEventRecurrence.getOverallStart().toLocalDate());
        Assert.assertNotNull((Object)createdEventRecurrence.getOverallEnd());
        Assert.assertEquals((Object)start.plusDays(2L).toLocalDate(), (Object)createdEventRecurrence.getOverallEnd().toLocalDate());
    }

    @Test
    public void testCreateEvent_InSpace_AsMember() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event.setCalendarId(this.spaceCalendar.getId());
        Event createdEvent = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity, this.testuser3Identity);
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        AgendaEventModification eventModification = (AgendaEventModification)eventCreationReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.ADDED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)1L, (long)eventModification.getModificationTypes().size());
        try {
            event = this.newEventInstance(start, start, allDay);
            event.setCalendarId(this.spaceCalendar.getId());
            this.createEvent(event.clone(), Long.parseLong(this.testuser5Identity.getId()), this.testuser2Identity, this.testuser3Identity);
            Assert.fail((String)"testuser5 is not member of space and shouldn't be able to create an event");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateEvent_InSpace_AsManager() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        this.spaceService.addRedactor(this.space, this.testuser1Identity.getRemoteId());
        this.spaceService.setManager(this.space, this.testuser2Identity.getRemoteId(), true);
        Event event = this.newEventInstance(start, start, allDay);
        event.setCalendarId(this.spaceCalendar.getId());
        Event createdEvent = this.createEvent(event.clone(), Long.parseLong(this.testuser2Identity.getId()), this.testuser3Identity);
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        AgendaEventModification eventModification = (AgendaEventModification)eventCreationReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.ADDED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)1L, (long)eventModification.getModificationTypes().size());
    }

    @Test
    public void testGetEventById() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        try {
            this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser3Identity.getId()));
            Assert.fail((String)"Should fail when a non attendee attempts to access event");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser3Identity.getId()));
            Assert.fail((String)"Should fail when a non attendee attempts to access event");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Event createdEvent = this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)event.getSummary(), (Object)createdEvent.getSummary());
        Assert.assertEquals((Object)event.getDescription(), (Object)createdEvent.getDescription());
        Assert.assertEquals((long)event.getCalendarId(), (long)createdEvent.getCalendarId());
        Assert.assertEquals((Object)event.getColor(), (Object)createdEvent.getColor());
        Assert.assertEquals((Object)event.getLocation(), (Object)createdEvent.getLocation());
        Assert.assertEquals((long)event.getCreatorId(), (long)createdEvent.getCreatorId());
        Assert.assertEquals((Object)event.getAvailability(), (Object)createdEvent.getAvailability());
        Assert.assertEquals((Object)event.getOccurrence(), (Object)createdEvent.getOccurrence());
        Assert.assertEquals((Object)event.getStart().withZoneSameLocal(ZoneOffset.UTC), (Object)createdEvent.getStart().withZoneSameLocal(ZoneOffset.UTC));
        Assert.assertEquals((Object)event.getEnd().withZoneSameLocal(ZoneOffset.UTC), (Object)createdEvent.getEnd().withZoneSameLocal(ZoneOffset.UTC));
        Assert.assertNotNull((Object)createdEvent.getAcl());
        Assert.assertFalse((boolean)createdEvent.getAcl().isCanEdit());
        Assert.assertTrue((boolean)createdEvent.getAcl().isAttendee());
        Assert.assertNotNull((Object)createdEvent.getCreated());
        Assert.assertNull((Object)createdEvent.getUpdated());
        Assert.assertEquals((long)0L, (long)createdEvent.getModifierId());
        EventRecurrence createdEventRecurrence = createdEvent.getRecurrence();
        Assert.assertNotNull((Object)createdEventRecurrence);
        Assert.assertTrue((createdEventRecurrence.getId() > 0L ? 1 : 0) != 0);
        EventRecurrence eventRecurrence = event.getRecurrence();
        Assert.assertEquals((Object)eventRecurrence.getFrequency(), (Object)createdEventRecurrence.getFrequency());
        Assert.assertEquals((Object)eventRecurrence.getType(), (Object)createdEventRecurrence.getType());
        Assert.assertEquals((long)eventRecurrence.getInterval(), (long)createdEventRecurrence.getInterval());
        Assert.assertTrue((createdEventRecurrence.getCount() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)start.plusDays(2L).toLocalDate(), (Object)createdEventRecurrence.getUntil());
        Assert.assertEquals((Object)createdEvent.getRecurrence().getOverallEnd().toLocalDate(), (Object)createdEventRecurrence.getUntil());
        Assert.assertEquals((Object)eventRecurrence.getBySecond(), (Object)createdEventRecurrence.getBySecond());
        Assert.assertEquals((Object)eventRecurrence.getByMinute(), (Object)createdEventRecurrence.getByMinute());
        Assert.assertEquals((Object)eventRecurrence.getByHour(), (Object)createdEventRecurrence.getByHour());
        Assert.assertEquals((Object)eventRecurrence.getByDay(), (Object)createdEventRecurrence.getByDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonthDay(), (Object)createdEventRecurrence.getByMonthDay());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonth(), (Object)createdEventRecurrence.getByMonth());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
        Assert.assertNotNull((Object)createdEventRecurrence.getOverallStart());
        Assert.assertEquals((Object)start.toLocalDate(), (Object)createdEventRecurrence.getOverallStart().toLocalDate());
        Assert.assertNotNull((Object)createdEventRecurrence.getOverallEnd());
        Assert.assertEquals((Object)start.plusDays(2L).toLocalDate(), (Object)createdEventRecurrence.getOverallEnd().toLocalDate());
    }

    @Test
    public void testGetEventById_Recurrent() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        ZonedDateTime end = this.getDate().withNano(0).plusHours(2L);
        boolean allDay = false;
        Event event = this.newEventInstance(start, end, allDay);
        Event createdEvent = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        createdEvent = this.agendaEventService.getEventById(createdEvent.getId(), null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)event.getSummary(), (Object)createdEvent.getSummary());
        Assert.assertEquals((Object)event.getDescription(), (Object)createdEvent.getDescription());
        Assert.assertEquals((long)event.getCalendarId(), (long)createdEvent.getCalendarId());
        Assert.assertEquals((Object)event.getColor(), (Object)createdEvent.getColor());
        Assert.assertEquals((Object)event.getLocation(), (Object)createdEvent.getLocation());
        Assert.assertEquals((long)Long.parseLong(this.testuser1Identity.getId()), (long)createdEvent.getCreatorId());
        Assert.assertEquals((Object)event.getAvailability(), (Object)createdEvent.getAvailability());
        Assert.assertEquals((Object)event.getOccurrence(), (Object)createdEvent.getOccurrence());
        Assert.assertEquals((Object)event.getStart().withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getStart().withZoneSameInstant(ZoneOffset.UTC));
        Assert.assertEquals((Object)event.getEnd().withZoneSameInstant(ZoneOffset.UTC), (Object)createdEvent.getEnd().withZoneSameInstant(ZoneOffset.UTC));
        Assert.assertNotNull((Object)createdEvent.getCreated());
        Assert.assertNull((Object)createdEvent.getUpdated());
        Assert.assertEquals((long)0L, (long)createdEvent.getModifierId());
        EventRecurrence createdEventRecurrence = createdEvent.getRecurrence();
        Assert.assertNotNull((Object)createdEventRecurrence);
        Assert.assertTrue((createdEventRecurrence.getId() > 0L ? 1 : 0) != 0);
        EventRecurrence eventRecurrence = event.getRecurrence();
        Assert.assertEquals((Object)eventRecurrence.getFrequency(), (Object)createdEventRecurrence.getFrequency());
        Assert.assertEquals((Object)eventRecurrence.getType(), (Object)createdEventRecurrence.getType());
        Assert.assertEquals((long)eventRecurrence.getInterval(), (long)createdEventRecurrence.getInterval());
        Assert.assertTrue((createdEventRecurrence.getCount() == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)createdEventRecurrence.getUntil());
        Assert.assertEquals((Object)end.plusDays(2L).toLocalDate(), (Object)createdEventRecurrence.getUntil());
        Assert.assertEquals((Object)createdEventRecurrence.getUntil(), (Object)createdEvent.getRecurrence().getOverallEnd().withZoneSameInstant(ZoneOffset.UTC).toLocalDate());
        Assert.assertEquals((Object)eventRecurrence.getBySecond(), (Object)createdEventRecurrence.getBySecond());
        Assert.assertEquals((Object)eventRecurrence.getByMinute(), (Object)createdEventRecurrence.getByMinute());
        Assert.assertEquals((Object)eventRecurrence.getByHour(), (Object)createdEventRecurrence.getByHour());
        Assert.assertEquals((Object)eventRecurrence.getByDay(), (Object)createdEventRecurrence.getByDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonthDay(), (Object)createdEventRecurrence.getByMonthDay());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonth(), (Object)createdEventRecurrence.getByMonth());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
        Assert.assertNotNull((Object)createdEventRecurrence.getOverallStart());
        Assert.assertEquals((Object)start.toLocalDate(), (Object)createdEventRecurrence.getOverallStart().toLocalDate());
        Assert.assertNotNull((Object)createdEventRecurrence.getOverallEnd());
        Assert.assertEquals((Object)end.plusDays(2L).toLocalDate(), (Object)createdEventRecurrence.getOverallEnd().toLocalDate());
        Assert.assertEquals((long)end.plusDays(2L).getHour(), (long)createdEventRecurrence.getOverallEnd().getHour());
        Assert.assertEquals((long)end.plusDays(2L).getMinute(), (long)createdEventRecurrence.getOverallEnd().getMinute());
        Assert.assertEquals((long)end.plusDays(2L).getSecond(), (long)createdEventRecurrence.getOverallEnd().getSecond());
    }

    @Test
    public void testGetEventById_RecurrenceAttributes() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event.getRecurrence().setType(EventRecurrenceType.YEARLY);
        event.getRecurrence().setFrequency(EventRecurrenceFrequency.YEARLY);
        event.getRecurrence().setBySecond(Collections.singletonList("1"));
        event.getRecurrence().setByMinute(Collections.singletonList("1"));
        event.getRecurrence().setByHour(Collections.singletonList("1"));
        event.getRecurrence().setByDay(Collections.singletonList("TU"));
        event.getRecurrence().setByMonthDay(Collections.singletonList("2"));
        event.getRecurrence().setByMonth(Collections.singletonList("3"));
        event.getRecurrence().setByWeekNo(Collections.singletonList("30"));
        event.getRecurrence().setByYearDay(Collections.singletonList("165"));
        event.getRecurrence().setBySetPos(Collections.singletonList("-1"));
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        Event createdEvent = this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        EventRecurrence createdEventRecurrence = createdEvent.getRecurrence();
        Assert.assertNotNull((Object)createdEventRecurrence);
        Assert.assertTrue((createdEventRecurrence.getId() > 0L ? 1 : 0) != 0);
        EventRecurrence eventRecurrence = event.getRecurrence();
        Assert.assertTrue((createdEventRecurrence.getCount() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)eventRecurrence.getType(), (Object)createdEventRecurrence.getType());
        Assert.assertEquals((Object)eventRecurrence.getFrequency(), (Object)createdEventRecurrence.getFrequency());
        Assert.assertEquals((long)eventRecurrence.getInterval(), (long)createdEventRecurrence.getInterval());
        Assert.assertEquals((Object)eventRecurrence.getBySecond(), (Object)createdEventRecurrence.getBySecond());
        Assert.assertEquals((Object)eventRecurrence.getByMinute(), (Object)createdEventRecurrence.getByMinute());
        Assert.assertEquals((Object)eventRecurrence.getByHour(), (Object)createdEventRecurrence.getByHour());
        Assert.assertEquals((Object)eventRecurrence.getByDay(), (Object)createdEventRecurrence.getByDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonthDay(), (Object)createdEventRecurrence.getByMonthDay());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonth(), (Object)createdEventRecurrence.getByMonth());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
    }

    @Test
    public void testGetEventById_Recurrent_AllDayEvent() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        try {
            this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser3Identity.getId()));
            Assert.fail((String)"Should fail when a non attendee attempts to access event");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Event createdEvent = this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)event.getSummary(), (Object)createdEvent.getSummary());
        Assert.assertEquals((Object)event.getDescription(), (Object)createdEvent.getDescription());
        Assert.assertEquals((long)event.getCalendarId(), (long)createdEvent.getCalendarId());
        Assert.assertEquals((Object)event.getColor(), (Object)createdEvent.getColor());
        Assert.assertEquals((Object)event.getLocation(), (Object)createdEvent.getLocation());
        Assert.assertEquals((long)event.getCreatorId(), (long)createdEvent.getCreatorId());
        Assert.assertEquals((Object)event.getAvailability(), (Object)createdEvent.getAvailability());
        Assert.assertEquals((Object)event.getOccurrence(), (Object)createdEvent.getOccurrence());
        Assert.assertEquals((Object)event.getStart().withZoneSameLocal(ZoneOffset.UTC), (Object)createdEvent.getStart().withZoneSameLocal(ZoneOffset.UTC));
        Assert.assertEquals((Object)event.getEnd().withZoneSameLocal(ZoneOffset.UTC), (Object)createdEvent.getEnd().withZoneSameLocal(ZoneOffset.UTC));
        Assert.assertEquals((Object)event.getStart().toLocalDate(), (Object)createdEvent.getEnd().toLocalDate());
        Assert.assertNotNull((Object)createdEvent.getCreated());
        Assert.assertNull((Object)createdEvent.getUpdated());
        Assert.assertEquals((long)0L, (long)createdEvent.getModifierId());
        EventRecurrence createdEventRecurrence = createdEvent.getRecurrence();
        Assert.assertNotNull((Object)createdEventRecurrence);
        Assert.assertTrue((createdEventRecurrence.getId() > 0L ? 1 : 0) != 0);
        EventRecurrence eventRecurrence = event.getRecurrence();
        Assert.assertEquals((Object)eventRecurrence.getFrequency(), (Object)createdEventRecurrence.getFrequency());
        Assert.assertEquals((Object)eventRecurrence.getType(), (Object)createdEventRecurrence.getType());
        Assert.assertEquals((long)eventRecurrence.getInterval(), (long)createdEventRecurrence.getInterval());
        Assert.assertTrue((createdEventRecurrence.getCount() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)start.plusDays(2L).toLocalDate(), (Object)createdEventRecurrence.getUntil());
        Assert.assertEquals((Object)createdEvent.getRecurrence().getOverallEnd().toLocalDate(), (Object)createdEventRecurrence.getUntil());
        Assert.assertEquals((Object)eventRecurrence.getBySecond(), (Object)createdEventRecurrence.getBySecond());
        Assert.assertEquals((Object)eventRecurrence.getByMinute(), (Object)createdEventRecurrence.getByMinute());
        Assert.assertEquals((Object)eventRecurrence.getByHour(), (Object)createdEventRecurrence.getByHour());
        Assert.assertEquals((Object)eventRecurrence.getByDay(), (Object)createdEventRecurrence.getByDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonthDay(), (Object)createdEventRecurrence.getByMonthDay());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
        Assert.assertEquals((Object)eventRecurrence.getByMonth(), (Object)createdEventRecurrence.getByMonth());
        Assert.assertEquals((Object)eventRecurrence.getByYearDay(), (Object)createdEventRecurrence.getByYearDay());
        Assert.assertNotNull((Object)createdEventRecurrence.getOverallStart());
        Assert.assertEquals((Object)start.toLocalDate(), (Object)createdEventRecurrence.getOverallStart().toLocalDate());
        Assert.assertNotNull((Object)createdEventRecurrence.getOverallEnd());
        Assert.assertEquals((Object)start.plusDays(2L).toLocalDate(), (Object)createdEventRecurrence.getOverallEnd().toLocalDate());
    }

    @Test
    public void testCreateEventExceptionalOccurrence() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        EventRecurrence recurrence = new EventRecurrence(0L, start.plusDays(2L).toLocalDate(), 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 1, null, null, null, null, null, null, null, null, null, null, null);
        event.setRecurrence(recurrence);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        try {
            this.agendaEventService.createEventExceptionalOccurrence(5500L, (List)ATTENDEES, (List)CONFERENCES, (List)REMINDERS, start.plusDays(2L));
        }
        catch (AgendaException agendaException) {
            // empty catch block
        }
        try {
            this.agendaEventService.createEventExceptionalOccurrence(event.getId(), (List)ATTENDEES, (List)CONFERENCES, (List)REMINDERS, start.plusDays(3L));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.agendaEventService.createEventExceptionalOccurrence(event.getId(), (List)ATTENDEES, (List)CONFERENCES, (List)REMINDERS, start.minusDays(1L));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ZonedDateTime occurrenceId = start.plusDays(1L);
        Event exceptionalOccurrence = this.agendaEventService.createEventExceptionalOccurrence(event.getId(), (List)ATTENDEES, (List)CONFERENCES, (List)REMINDERS, occurrenceId);
        Assert.assertNotNull((Object)exceptionalOccurrence);
        Assert.assertNotNull((Object)exceptionalOccurrence.getOccurrence());
        Assert.assertEquals((Object)occurrenceId.withZoneSameInstant(ZoneOffset.UTC).toLocalDate(), (Object)exceptionalOccurrence.getOccurrence().getId().withZoneSameInstant(ZoneOffset.UTC).toLocalDate());
        long eventId = exceptionalOccurrence.getId();
        Assert.assertTrue((eventId > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)event.getId(), (long)exceptionalOccurrence.getParentId());
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        Assert.assertTrue((eventAttendees != null && !eventAttendees.isEmpty() ? 1 : 0) != 0);
        List eventConferences = this.agendaEventConferenceService.getEventConferences(eventId);
        Assert.assertTrue((eventConferences != null && !eventConferences.isEmpty() ? 1 : 0) != 0);
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertTrue((eventReminders != null && !eventReminders.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testSaveEventExceptionalOccurrenceWithDST() throws Exception {
        ZoneId dstTimeZone = ZoneId.of("Europe/Paris");
        ZonedDateTime start = ZonedDateTime.of(2021, 9, 15, 10, 0, 0, 0, dstTimeZone);
        Event event = this.newEventInstance(start, start.plusHours(1L), false);
        event.setTimeZoneId(dstTimeZone);
        EventRecurrence recurrence = new EventRecurrence(0L, null, 0, EventRecurrenceType.WEEKLY, EventRecurrenceFrequency.WEEKLY, 1, null, null, null, null, null, null, null, null, null, null, null);
        event.setRecurrence(recurrence);
        event = this.createEvent(event, Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        ZonedDateTime periodStart = ZonedDateTime.of(2021, 12, 3, 0, 0, 0, 0, dstTimeZone);
        List eventOccurrencesInPeriod = this.agendaEventService.getEventOccurrencesInPeriod(event, periodStart, periodStart.plusWeeks(1L), dstTimeZone, 0);
        Assert.assertNotNull((Object)eventOccurrencesInPeriod);
        Assert.assertEquals((long)1L, (long)eventOccurrencesInPeriod.size());
        Event occurrence = (Event)eventOccurrencesInPeriod.get(0);
        Assert.assertNotNull((Object)occurrence);
        Assert.assertNotNull((Object)occurrence.getOccurrence());
        Event exceptionalOccurrence = this.agendaEventService.saveEventExceptionalOccurrence(event.getId(), occurrence.getOccurrence().getId());
        ZonedDateTime exceptionalEventStart = exceptionalOccurrence.getStart().withZoneSameInstant(dstTimeZone);
        Assert.assertNotNull((Object)exceptionalOccurrence);
        Assert.assertNotNull((Object)exceptionalOccurrence.getOccurrence());
        Assert.assertEquals((Object)LocalDate.of(2021, 12, 8), (Object)exceptionalEventStart.toLocalDate());
        Assert.assertEquals((long)start.getHour(), (long)exceptionalEventStart.getHour());
        Assert.assertEquals((long)start.getMinute(), (long)exceptionalEventStart.getMinute());
    }

    @Test
    public void testGetParentRecurrentEvents() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        EventRecurrence recurrence = new EventRecurrence(0L, start.plusDays(2L).toLocalDate(), 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 1, null, null, null, null, null, null, null, null, null, null, null);
        event.setRecurrence(recurrence);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        List parentRecurrentEvents = this.agendaEventService.getParentRecurrentEvents(start, start.plusDays(2L), ZoneId.systemDefault());
        Assert.assertNotNull((Object)parentRecurrentEvents);
        Assert.assertEquals((long)1L, (long)parentRecurrentEvents.size());
        Event exceptionalOccurrence = this.agendaEventService.createEventExceptionalOccurrence(event.getId(), (List)ATTENDEES, (List)CONFERENCES, (List)REMINDERS, start.plusDays(1L));
        Assert.assertNotNull((Object)exceptionalOccurrence);
        parentRecurrentEvents = this.agendaEventService.getParentRecurrentEvents(start, start.plusDays(2L), ZoneId.systemDefault());
        Assert.assertNotNull((Object)parentRecurrentEvents);
        Assert.assertEquals((long)1L, (long)parentRecurrentEvents.size());
    }

    @Test
    public void testGetOccurrenceFromRecurrentEventByCount() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        int count = 3;
        int interval = 1;
        LocalDate untilDate = start.plusDays(6L).toLocalDate();
        EventRecurrence recurrence = new EventRecurrence(0L, untilDate, count, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, interval, null, null, null, null, null, null, null, null, null, null, null);
        event.setRecurrence(recurrence);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        ZonedDateTime occurrenceDate = event.getStart().withZoneSameInstant(event.getTimeZoneId());
        Event eventOccurrence = this.agendaEventService.getEventOccurrence(event.getId(), occurrenceDate, event.getTimeZoneId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventOccurrence);
        occurrenceDate = event.getStart().plusDays(interval).withZoneSameInstant(event.getTimeZoneId());
        eventOccurrence = this.agendaEventService.getEventOccurrence(event.getId(), occurrenceDate, event.getTimeZoneId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventOccurrence);
        occurrenceDate = event.getStart().plusDays(2L).withZoneSameInstant(event.getTimeZoneId());
        eventOccurrence = this.agendaEventService.getEventOccurrence(event.getId(), occurrenceDate, event.getTimeZoneId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventOccurrence);
        occurrenceDate = event.getStart().plusDays(count).withZoneSameInstant(event.getTimeZoneId());
        eventOccurrence = this.agendaEventService.getEventOccurrence(event.getId(), occurrenceDate, event.getTimeZoneId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNull((Object)eventOccurrence);
        occurrenceDate = event.getStart().plusDays(2L).withZoneSameInstant(event.getTimeZoneId());
        eventOccurrence = this.agendaEventService.getEventOccurrence(event.getId(), occurrenceDate, event.getTimeZoneId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventOccurrence);
        Assert.assertNotNull((Object)eventOccurrence.getOccurrence());
        Assert.assertNotNull((Object)eventOccurrence.getOccurrence().getId());
        Assert.assertTrue((eventOccurrence.getId() == 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)occurrenceDate.toLocalDate(), (Object)eventOccurrence.getOccurrence().getId().toLocalDate());
        Assert.assertNotNull((Object)eventOccurrence.getAcl());
        Assert.assertTrue((boolean)eventOccurrence.getAcl().isCanEdit());
        Assert.assertTrue((boolean)eventOccurrence.getAcl().isAttendee());
    }

    @Test
    public void testGetOccurrenceFromRecurrentEventByInterval() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        int count = 0;
        int interval = 3;
        LocalDate untilDate = start.plusDays((long)interval * 2L).toLocalDate();
        EventRecurrence recurrence = new EventRecurrence(0L, untilDate, count, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, interval, null, null, null, null, null, null, null, null, null, null, null);
        event.setRecurrence(recurrence);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        ZonedDateTime occurrenceDate = event.getStart().withZoneSameInstant(event.getTimeZoneId());
        Event eventOccurrence = this.agendaEventService.getEventOccurrence(event.getId(), occurrenceDate, event.getTimeZoneId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventOccurrence);
        occurrenceDate = event.getStart().plusDays(interval).withZoneSameInstant(event.getTimeZoneId());
        eventOccurrence = this.agendaEventService.getEventOccurrence(event.getId(), occurrenceDate, event.getTimeZoneId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventOccurrence);
        occurrenceDate = event.getStart().plusDays((long)interval + 1L).withZoneSameInstant(event.getTimeZoneId());
        eventOccurrence = this.agendaEventService.getEventOccurrence(event.getId(), occurrenceDate, event.getTimeZoneId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNull((Object)eventOccurrence);
        occurrenceDate = event.getStart().plusDays((long)interval * 2L).withZoneSameInstant(event.getTimeZoneId());
        eventOccurrence = this.agendaEventService.getEventOccurrence(event.getId(), occurrenceDate, event.getTimeZoneId(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventOccurrence);
        Assert.assertNotNull((Object)eventOccurrence.getOccurrence());
        Assert.assertNotNull((Object)eventOccurrence.getOccurrence().getId());
        Assert.assertTrue((eventOccurrence.getId() == 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)occurrenceDate.toLocalDate(), (Object)eventOccurrence.getOccurrence().getId().toLocalDate());
        Assert.assertNotNull((Object)eventOccurrence.getAcl());
        Assert.assertTrue((boolean)eventOccurrence.getAcl().isCanEdit());
        Assert.assertTrue((boolean)eventOccurrence.getAcl().isAttendee());
    }

    @Test
    public void testGetExceptionalOccurrenceEvent() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        EventRecurrence recurrence = new EventRecurrence(0L, start.plusDays(2L).toLocalDate(), 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 1, null, null, null, null, null, null, null, null, null, null, null);
        event.setRecurrence(recurrence);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        long eventId = event.getId();
        List exceptionalOccurrenceEvents = this.agendaEventService.getExceptionalOccurrenceEvents(2000L, null, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)exceptionalOccurrenceEvents);
        Assert.assertTrue((boolean)exceptionalOccurrenceEvents.isEmpty());
        try {
            this.agendaEventService.getExceptionalOccurrenceEvents(eventId, null, Long.parseLong(this.testuser3Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Event exceptionalOccurrence = this.agendaEventService.createEventExceptionalOccurrence(eventId, (List)ATTENDEES, (List)CONFERENCES, (List)REMINDERS, start.plusDays(1L));
        Assert.assertNotNull((Object)exceptionalOccurrence);
        Assert.assertTrue((exceptionalOccurrence.getId() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)exceptionalOccurrence.getOccurrence());
        Assert.assertNotNull((Object)exceptionalOccurrence.getOccurrence().getId());
        exceptionalOccurrenceEvents = this.agendaEventService.getExceptionalOccurrenceEvents(eventId, null, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertTrue((boolean)exceptionalOccurrenceEvents.stream().anyMatch(exceptionalOccurrenceEvent -> exceptionalOccurrenceEvent.getId() == exceptionalOccurrence.getId()));
        Event eventOccurrence = this.agendaEventService.getEventOccurrence(exceptionalOccurrence.getParentId(), exceptionalOccurrence.getOccurrence().getId(), ZoneId.systemDefault(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)eventOccurrence);
        Assert.assertEquals((long)eventOccurrence.getId(), (long)exceptionalOccurrence.getId());
        Assert.assertNotNull((Object)eventOccurrence.getAcl());
        Assert.assertTrue((boolean)eventOccurrence.getAcl().isCanEdit());
        Assert.assertTrue((boolean)eventOccurrence.getAcl().isAttendee());
    }

    @Test
    public void testUpdateEvent() throws Exception {
        EventRecurrence recurrence;
        Event event2;
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = false;
        Event createdEvent = this.newEventInstance(start, start, allDay);
        createdEvent = this.createEvent(createdEvent.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        long eventId = createdEvent.getId();
        Event storedEvent = this.agendaEventService.getEventById(eventId, null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)storedEvent);
        Assert.assertTrue((storedEvent.getId() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)storedEvent.getRecurrence());
        try {
            event2 = new Event();
            event2.setId(eventId);
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, 0L);
            Assert.fail();
        }
        catch (IllegalArgumentException event2) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEvent(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException event2) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(0L);
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException event3) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException event4) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(this.spaceCalendar.getId());
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event5) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event6) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            event2.setParentId(eventId);
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event7) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now().plusDays(1L));
            event2.setEnd(ZonedDateTime.now());
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event8) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, 3000L);
            Assert.fail();
        }
        catch (IllegalAccessException event9) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            event2.setRecurrence(new EventRecurrence());
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, 3000L);
            Assert.fail();
        }
        catch (AgendaException event10) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event11) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(1200L);
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event12) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser4Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException event13) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(15000L);
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            this.agendaEventService.updateEvent(event2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException event14) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            event2 = this.agendaEventService.createEvent(event2, Collections.singletonList(new EventAttendee(0L, Long.parseLong(this.testuser2Identity.getId()), EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser2Identity.getId()));
            this.agendaEventService.updateEvent(event2, Collections.singletonList(new EventAttendee(0L, Long.parseLong(this.testuser2Identity.getId()), EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser2Identity.getId()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            this.spaceService.addRedactor(this.space, this.testuser1Identity.getRemoteId());
            event2 = new Event();
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            event2 = this.agendaEventService.createEvent(event2, Collections.singletonList(new EventAttendee(0L, Long.parseLong(this.testuser2Identity.getId()), EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser2Identity.getId()));
            this.agendaEventService.updateEvent(event2, Collections.singletonList(new EventAttendee(0L, Long.parseLong(this.testuser2Identity.getId()), EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException event15) {
            // empty catch block
        }
        try {
            event2 = new Event();
            event2.setId(eventId);
            event2.setCalendarId(this.spaceCalendar.getId());
            event2.setStart(ZonedDateTime.now());
            event2.setEnd(ZonedDateTime.now());
            recurrence = new EventRecurrence();
            event2.setRecurrence(recurrence);
            recurrence.setFrequency(EventRecurrenceFrequency.DAILY);
            recurrence.setInterval(1);
            this.agendaEventService.updateEvent(event2, Collections.singletonList(new EventAttendee(0L, storedEvent.getCreatorId(), EventAttendeeResponse.ACCEPTED)), Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException event16) {
            // empty catch block
        }
        createdEvent = this.newEventInstance(start, start, allDay);
        createdEvent.setRecurrence(null);
        createdEvent = this.createEvent(createdEvent.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        eventId = createdEvent.getId();
        List reminders = this.agendaEventReminderService.getEventReminders(eventId, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)reminders);
        Assert.assertEquals((long)1L, (long)reminders.size());
        EventReminder eventReminder = (EventReminder)reminders.get(0);
        Assert.assertNotNull((Object)eventReminder);
        storedEvent = this.agendaEventService.getEventById(eventId, null, Long.parseLong(this.testuser2Identity.getId()));
        storedEvent.setRecurrence(null);
        this.agendaEventService.updateEvent(storedEvent, null, null, null, null, null, false, Long.parseLong(this.testuser1Identity.getId()));
        AgendaEventModification eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.REMINDER_DELETED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.CONFERENCE_DELETED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.ATTENDEE_DELETED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)4L, (long)eventModification.getModificationTypes().size());
        Event updatedEvent = this.agendaEventService.getEventById(eventId, null, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)updatedEvent);
        Assert.assertNull((Object)updatedEvent.getRecurrence());
        Assert.assertNull((Object)updatedEvent.getOccurrence());
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        Assert.assertTrue((eventAttendees == null || eventAttendees.isEmpty() ? 1 : 0) != 0);
        List eventConferences = this.agendaEventConferenceService.getEventConferences(eventId);
        Assert.assertTrue((eventConferences == null || eventConferences.isEmpty() ? 1 : 0) != 0);
        updatedEvent.setAllowAttendeeToUpdate(true);
        updatedEvent.setAllowAttendeeToInvite(false);
        EventAttendee eventAttendeeTestUser2 = new EventAttendee(0L, updatedEvent.getId(), Long.parseLong(this.testuser2Identity.getId()), null);
        EventAttendee eventAttendeeTestUser1 = new EventAttendee(0L, updatedEvent.getId(), Long.parseLong(this.testuser1Identity.getId()), null);
        updatedEvent = this.agendaEventService.updateEvent(updatedEvent, Arrays.asList(eventAttendeeTestUser1, eventAttendeeTestUser2), null, reminders, null, null, false, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.REMINDER_ADDED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.ALLOW_MODIFY_UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.ATTENDEE_ADDED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)4L, (long)eventModification.getModificationTypes().size());
        try {
            updatedEvent = this.agendaEventService.updateEvent(updatedEvent, Arrays.asList(eventAttendeeTestUser1, eventAttendeeTestUser2), null, null, null, null, false, Long.parseLong(this.testuser3Identity.getId()));
            Assert.fail((String)"shouldn't allow other attendee to update event");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)updatedEvent.isAllowAttendeeToUpdate());
        Assert.assertTrue((String)"allowAttendeeToInvite should be true automatically when allowAttendeeToUpdate is set to true", (boolean)updatedEvent.isAllowAttendeeToInvite());
        reminders = this.agendaEventReminderService.getEventReminders(eventId, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)reminders);
        Assert.assertEquals((long)1L, (long)reminders.size());
        EventReminder sameEventReminder = (EventReminder)reminders.get(0);
        Assert.assertNotNull((Object)sameEventReminder);
        Assert.assertEquals((Object)eventReminder.getDatetime(), (Object)sameEventReminder.getDatetime());
        updatedEvent.setAllowAttendeeToUpdate(false);
        updatedEvent.setStart(updatedEvent.getStart().plusDays(1L));
        updatedEvent.setEnd(updatedEvent.getEnd().plusDays(1L));
        updatedEvent = this.agendaEventService.updateEvent(updatedEvent, Arrays.asList(eventAttendeeTestUser1, eventAttendeeTestUser2), null, null, null, null, false, Long.parseLong(this.testuser2Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.START_DATE_UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.END_DATE_UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.ALLOW_MODIFY_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)4L, (long)eventModification.getModificationTypes().size());
        Assert.assertTrue((String)"Attendees shouldn't be able to modify allowAttendeeToInvite and allowAttendeeToUpdate", (boolean)updatedEvent.isAllowAttendeeToUpdate());
        Assert.assertTrue((boolean)updatedEvent.isAllowAttendeeToInvite());
        reminders = this.agendaEventReminderService.getEventReminders(eventId, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)reminders);
        Assert.assertEquals((long)1L, (long)reminders.size());
        sameEventReminder = (EventReminder)reminders.get(0);
        Assert.assertNotNull((Object)sameEventReminder);
        Assert.assertEquals((Object)sameEventReminder.getDatetime(), (Object)eventReminder.getDatetime().plusDays(1L));
    }

    @Test
    public void testUpdateEventFields() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event createdEvent = this.newEventInstance(start, start, allDay);
        createdEvent = this.createEvent(createdEvent.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        long eventId = createdEvent.getId();
        Event storedEvent = this.agendaEventService.getEventById(eventId, null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)storedEvent);
        Assert.assertTrue((storedEvent.getId() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)storedEvent.getRecurrence());
        try {
            Event event = new Event();
            event.setId(eventId);
            this.agendaEventService.updateEvent(event, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true, 0L);
            Assert.fail();
        }
        catch (IllegalArgumentException event) {
            // empty catch block
        }
        Map<String, List<String>> fields = this.getFields("summary", "fieldValue");
        try {
            this.agendaEventService.updateEventFields(0L, fields, true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, fields, true, true, 0L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, fields, true, true, 2000L);
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, fields, true, true, Long.parseLong(this.testuser5Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("calendarId", "-1"), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("calendarId", "500000"), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("timeZoneId", ""), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("timeZoneId", "Not existant"), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("start", ""), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException agendaException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("end", ""), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException agendaException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("start", "2080-10-10"), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException agendaException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("end", "2010-10-10"), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (AgendaException agendaException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("recurrence", ""), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("id", "2553"), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("parentId", "2553"), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("created", "2020-10-10"), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("occurrence", "2020-10-10"), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.agendaEventService.updateEventFields(eventId, this.getFields("acl", ""), true, true, Long.parseLong(this.testuser1Identity.getId()));
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        createdEvent = this.newEventInstance(start, start, allDay);
        createdEvent = this.createEvent(createdEvent.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity, this.testuser3Identity);
        eventId = createdEvent.getId();
        List reminders = this.agendaEventReminderService.getEventReminders(eventId, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)reminders);
        Assert.assertEquals((long)1L, (long)reminders.size());
        EventReminder eventReminder = (EventReminder)reminders.get(0);
        Assert.assertNotNull((Object)eventReminder);
        String fieldName = "calendarId";
        String fieldValue = String.valueOf(this.spaceCalendar.getId());
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        AgendaEventModification eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.OWNER_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        Event event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)String.valueOf(event.getCalendarId()));
        fieldName = "summary";
        fieldValue = "summaryValue";
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.SUMMARY_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)String.valueOf(event.getSummary()));
        fieldName = "description";
        fieldValue = "descriptionValue";
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.DESCRIPTION_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)String.valueOf(event.getDescription()));
        fieldName = "location";
        fieldValue = "locationValue";
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.LOCATION_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)String.valueOf(event.getLocation()));
        fieldName = "color";
        fieldValue = "colorValue";
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.COLOR_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)String.valueOf(event.getColor()));
        fieldName = "timeZoneId";
        fieldValue = "Europe/Paris";
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.TIMEZONE_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)event.getTimeZoneId().getId());
        reminders = this.agendaEventReminderService.getEventReminders(eventId, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)reminders);
        Assert.assertEquals((long)1L, (long)reminders.size());
        EventReminder sameEventReminder = (EventReminder)reminders.get(0);
        Assert.assertNotNull((Object)sameEventReminder);
        Assert.assertEquals((Object)sameEventReminder.getDatetime(), (Object)eventReminder.getDatetime());
        fieldName = "start";
        fieldValue = AgendaDateUtils.toRFC3339Date((ZonedDateTime)start.minusDays(1L), (ZoneId)ZoneId.systemDefault(), (boolean)allDay);
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.START_DATE_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)AgendaDateUtils.toRFC3339Date((ZonedDateTime)event.getStart(), (ZoneId)ZoneId.systemDefault(), (boolean)allDay));
        reminders = this.agendaEventReminderService.getEventReminders(eventId, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)reminders);
        Assert.assertEquals((long)1L, (long)reminders.size());
        EventReminder updatedEventReminder = (EventReminder)reminders.get(0);
        Assert.assertNotNull((Object)updatedEventReminder);
        Assert.assertNotEquals((Object)updatedEventReminder.getDatetime(), (Object)eventReminder.getDatetime());
        fieldName = "end";
        fieldValue = AgendaDateUtils.toRFC3339Date((ZonedDateTime)start.plusDays(2L), (ZoneId)ZoneId.systemDefault(), (boolean)allDay);
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.END_DATE_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)AgendaDateUtils.toRFC3339Date((ZonedDateTime)event.getEnd(), (ZoneId)ZoneId.systemDefault(), (boolean)allDay));
        fieldName = "allDay";
        fieldValue = String.valueOf(!allDay);
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.START_DATE_UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.END_DATE_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)3L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)String.valueOf(event.isAllDay()));
        fieldName = "availability";
        fieldValue = EventAvailability.BUSY.name();
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.AVAILABILITY_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)event.getAvailability().name());
        fieldName = "status";
        fieldValue = EventStatus.TENTATIVE.name();
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.STATUS_UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.SWITCHED_EVENT_TO_DATE_POLL));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)3L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)event.getStatus().name());
        fieldName = "status";
        fieldValue = EventStatus.CONFIRMED.name();
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.STATUS_UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.SWITCHED_DATE_POLL_TO_EVENT));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)3L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)event.getStatus().name());
        fieldName = "allowAttendeeToUpdate";
        fieldValue = String.valueOf(!event.isAllowAttendeeToUpdate());
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.ALLOW_MODIFY_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)String.valueOf(event.isAllowAttendeeToUpdate()));
        fieldName = "allowAttendeeToInvite";
        fieldValue = String.valueOf(!event.isAllowAttendeeToInvite());
        this.agendaEventService.updateEventFields(eventId, this.getFields(fieldName, fieldValue), true, true, Long.parseLong(this.testuser1Identity.getId()));
        eventModification = (AgendaEventModification)eventUpdateReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.UPDATED));
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.ALLOW_INVITE_UPDATED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)2L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId);
        Assert.assertEquals((Object)fieldValue, (Object)String.valueOf(event.isAllowAttendeeToInvite()));
    }

    @Test
    public void testUpdateEvent_InSpace_AsMember() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event.setCalendarId(this.spaceCalendar.getId());
        event.setAllowAttendeeToUpdate(true);
        Event createdEvent = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity, this.testuser3Identity);
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        String newDescription = "Desc2";
        createdEvent.setDescription(newDescription);
        this.agendaEventService.updateEvent(createdEvent, null, null, null, null, null, false, Long.parseLong(this.testuser2Identity.getId()));
        Event updatedEvent = this.agendaEventService.getEventById(createdEvent.getId(), null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)updatedEvent);
        Assert.assertEquals((Object)newDescription, (Object)updatedEvent.getDescription());
        this.spaceService.removeMember(this.space, this.testuser2Identity.getRemoteId());
        try {
            this.agendaEventService.updateEvent(updatedEvent, null, null, null, null, null, false, Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail((String)"testuser2 shouldn't be able to update a previously created event by him, while he's not member of space anymore");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteEvent() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        long eventId = event.getId();
        try {
            this.agendaEventService.deleteEventById(eventId, Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail((String)("Event with id " + eventId + " shouldn't be deletable by an attendee"));
        }
        catch (IllegalAccessException e) {
            event = this.agendaEventService.getEventById(eventId, null, Long.parseLong(this.testuser1Identity.getId()));
            Assert.assertNotNull((Object)event);
        }
        this.agendaEventService.deleteEventById(eventId, Long.parseLong(this.testuser1Identity.getId()));
        AgendaEventModification eventModification = (AgendaEventModification)eventDeletionReference.get();
        Assert.assertNotNull((Object)eventModification);
        Assert.assertTrue((boolean)eventModification.hasModification(AgendaEventModificationType.DELETED));
        Assert.assertEquals((String)("Modification types are more than expected : " + eventModification.getModificationTypes()), (long)1L, (long)eventModification.getModificationTypes().size());
        event = this.agendaEventService.getEventById(eventId, null, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNull((Object)event);
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        Assert.assertTrue((eventAttendees == null || eventAttendees.isEmpty() ? 1 : 0) != 0);
        List eventConferences = this.agendaEventConferenceService.getEventConferences(eventId);
        Assert.assertTrue((eventConferences == null || eventConferences.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetEvents_Recurrent_WithExceptionalEvent() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        ZonedDateTime end = this.getDate().plusHours(2L).withNano(0);
        boolean allDay = false;
        Event event = this.newEventInstance(start, end, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        Event createdEvent = this.agendaEventService.getEventById(event.getId(), ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        EventFilter eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, this.getDate().plusHours(1L), this.getDate().plusMinutes(90L), 0);
        List events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((long)0L, (long)((Event)events.get(0)).getId());
        Event exceptionalEvent = ((Event)events.get(0)).clone();
        exceptionalEvent = this.createEvent(exceptionalEvent, Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, this.getDate().plusHours(1L), this.getDate().plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertTrue((((Event)events.get(0)).getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)exceptionalEvent.getId(), (long)((Event)events.get(0)).getId());
        eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, this.getDate().plusHours(1L).plusDays(1L), this.getDate().plusMinutes(90L).plusDays(1L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((long)0L, (long)((Event)events.get(0)).getId());
        exceptionalEvent.setEnd(exceptionalEvent.getEnd().plusDays(1L));
        exceptionalEvent.setStart(exceptionalEvent.getStart().plusDays(1L));
        this.agendaEventService.updateEvent(exceptionalEvent, (List)ATTENDEES, null, null, null, null, false, Long.parseLong(this.testuser1Identity.getId()));
        eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, this.getDate().plusHours(1L), this.getDate().plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)0L, (long)events.size());
        eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, this.getDate().plusHours(1L).plusDays(1L), this.getDate().plusMinutes(90L).plusDays(1L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertTrue((boolean)events.stream().noneMatch(occurrenceEvent -> occurrenceEvent.getOccurrence() == null));
        Assert.assertTrue((boolean)events.stream().anyMatch(occurrenceEvent -> occurrenceEvent.getOccurrence().isExceptional()));
        Assert.assertTrue((boolean)events.stream().anyMatch(occurrenceEvent -> !occurrenceEvent.getOccurrence().isExceptional()));
    }

    @Test
    public void testGetEvents_SpaceMembers() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", this.space.getPrettyName());
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), spaceIdentity);
        Event createdEvent = this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)createdEvent);
        Assert.assertTrue((createdEvent.getId() > 0L ? 1 : 0) != 0);
        try {
            this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser4Identity.getId()));
            Assert.fail((String)"Should throw an exception when a non member user attempts to access a space event");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        EventFilter eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, this.getDate().plusHours(1L), this.getDate().plusMinutes(90L), 0);
        List events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        eventFilter = new EventFilter(Long.parseLong(this.testuser4Identity.getId()), null, null, this.getDate().plusHours(1L), this.getDate().plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)0L, (long)events.size());
    }

    @Test
    public void testGetEvents() throws Exception {
        ZonedDateTime date = this.getDate();
        ZonedDateTime start = date.withNano(0);
        ZonedDateTime end = start.plusHours(2L);
        Event event = this.newEventInstance(start, end, false);
        Event event1 = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity, this.testuser3Identity);
        event1 = this.agendaEventService.getEventById(event1.getId(), null, Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)event1);
        EventFilter eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, start, end, 0);
        List events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Event occurrenceEvent = (Event)events.get(0);
        Assert.assertEquals((long)0L, (long)occurrenceEvent.getId());
        Assert.assertEquals((long)event1.getId(), (long)occurrenceEvent.getParentId());
        eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((long)0L, (long)occurrenceEvent.getId());
        Assert.assertEquals((long)event1.getId(), (long)occurrenceEvent.getParentId());
        event = this.newEventInstance(start, start, true);
        this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.size());
        eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, date.plusHours(1L), date.plusMinutes(90L).plusDays(1L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)4L, (long)events.size());
        eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, event1.getRecurrence().getUntil().plusDays(2L).atStartOfDay(ZoneId.systemDefault()), event1.getRecurrence().getUntil().plusDays(4L).atStartOfDay(ZoneId.systemDefault()).minusSeconds(1L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)0L, (long)events.size());
        event = this.newEventInstance(start, end, false);
        event.setCalendarId(this.spaceCalendar.getId());
        this.createEvent(event, Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity, this.testuser3Identity);
        eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, date.plusHours(1L), date.plusMinutes(90L).plusDays(1L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)6L, (long)events.size());
        this.spaceService.deleteSpace(this.space);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)4L, (long)events.size());
    }

    @Test
    public void testGetEventsByOwner() throws Exception {
        ZonedDateTime date = this.getDate();
        ZonedDateTime start = date.withNano(0);
        ZonedDateTime end = start.plusHours(2L);
        long testuser1Id = Long.parseLong(this.testuser1Identity.getId());
        try {
            EventFilter eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), Collections.singletonList(testuser1Id), null, date.plusHours(1L), date.plusMinutes(90L), 0);
            this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail((String)"User 'testuser2' shouldn't be able to access calendar of user 'testuser1'");
        }
        catch (IllegalAccessException eventFilter) {
            // empty catch block
        }
        Event event = this.newEventInstance(start, end, false);
        Event event1 = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        event1 = this.agendaEventService.getEventById(event1.getId(), null, Long.parseLong(this.testuser1Identity.getId()));
        EventFilter eventFilter = new EventFilter(Long.parseLong(this.testuser1Identity.getId()), Collections.singletonList(testuser1Id), null, date.plusHours(1L), date.plusMinutes(90L), 0);
        List events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Event occurrenceEvent = (Event)events.get(0);
        Assert.assertEquals((long)0L, (long)occurrenceEvent.getId());
        Assert.assertEquals((long)event1.getId(), (long)occurrenceEvent.getParentId());
        eventFilter = new EventFilter(Long.parseLong(this.testuser1Identity.getId()), Collections.singletonList(testuser1Id), null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((long)0L, (long)occurrenceEvent.getId());
        Assert.assertEquals((long)event1.getId(), (long)occurrenceEvent.getParentId());
        event = this.newEventInstance(start, start, true);
        this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        eventFilter = new EventFilter(Long.parseLong(this.testuser1Identity.getId()), Collections.singletonList(testuser1Id), null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.size());
        eventFilter = new EventFilter(Long.parseLong(this.testuser1Identity.getId()), Collections.singletonList(testuser1Id), null, date.plusHours(1L), date.plusMinutes(90L).plusDays(1L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser1Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)4L, (long)events.size());
    }

    @Test
    public void testGetEventsByOwnersAndAttendee() throws Exception {
        EventFilter eventFilter2;
        ZonedDateTime date = this.getDate();
        ZonedDateTime start = date.withNano(0);
        ZonedDateTime end = start.plusHours(2L);
        long testuser1Id = Long.parseLong(this.testuser1Identity.getId());
        try {
            eventFilter2 = new EventFilter(testuser1Id, Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())), null, date.plusHours(1L), date.plusMinutes(90L), 0);
            this.agendaEventService.getEvents(eventFilter2, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail((String)"User 'testuser2' shouldn't be able to access calendar of user 'testuser1'");
        }
        catch (IllegalAccessException eventFilter2) {
            // empty catch block
        }
        try {
            eventFilter2 = new EventFilter(Long.parseLong(this.testuser5Identity.getId()), Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())), null, date.plusHours(1L), date.plusMinutes(90L), 0);
            this.agendaEventService.getEvents(eventFilter2, ZoneId.systemDefault(), Long.parseLong(this.testuser5Identity.getId()));
            Assert.fail((String)"User 'testuser2' shouldn't be able to access calendar of user 'testuser1'");
        }
        catch (IllegalAccessException eventFilter3) {
            // empty catch block
        }
        Event event = this.newEventInstance(start, end, false);
        event.setCalendarId(this.spaceCalendar.getId());
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        event = this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser1Identity.getId()));
        EventFilter eventFilter4 = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())), null, date.plusHours(1L), date.plusMinutes(90L), 0);
        List events = this.agendaEventService.getEvents(eventFilter4, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        eventFilter4 = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), Collections.singletonList(Long.parseLong(this.testuser2Identity.getId())), null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter4, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)0L, (long)events.size());
        eventFilter4 = new EventFilter(Long.parseLong(this.testuser3Identity.getId()), Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())), null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter4, ZoneId.systemDefault(), Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)0L, (long)events.size());
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(event.getId()).getEventAttendees();
        eventAttendees.add(new EventAttendee(0L, event.getId(), Long.parseLong(this.spaceIdentity.getId()), null));
        this.agendaEventAttendeeService.saveEventAttendees(event, eventAttendees, testuser1Id, false, false, new AgendaEventModification(event.getId(), event.getCalendarId(), testuser1Id, Collections.singleton(AgendaEventModificationType.ADDED)));
        eventFilter4 = new EventFilter(Long.parseLong(this.testuser3Identity.getId()), Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())), null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter4, ZoneId.systemDefault(), Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
    }

    @Test
    public void testGetEventsByLimit() throws Exception {
        ZonedDateTime date = this.getDate();
        ZonedDateTime start = date.withNano(0);
        ZonedDateTime end = start.plusHours(2L);
        Event event = this.newEventInstance(start, end, false);
        event.setRecurrence(new EventRecurrence(0L, null, 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 2, null, null, null, null, null, null, null, null, null, null, null));
        event.setCalendarId(this.spaceCalendar.getId());
        this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        EventFilter eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), Collections.singletonList(Long.parseLong(this.spaceIdentity.getId())), null, date.plusHours(1L), null, 10);
        List events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)10L, (long)events.size());
    }

    @Test
    public void testGetEventsByAttendee() throws Exception {
        ZonedDateTime date = this.getDate();
        ZonedDateTime start = date.withNano(0);
        ZonedDateTime end = start.plusHours(2L);
        long testuser1Id = Long.parseLong(this.testuser1Identity.getId());
        try {
            EventFilter eventFilter = new EventFilter(testuser1Id, null, null, date.plusHours(1L), date.plusMinutes(90L), 0);
            this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
            Assert.fail((String)"User 'testuser2' shouldn't be able to access calendar of user 'testuser1'");
        }
        catch (IllegalAccessException eventFilter) {
            // empty catch block
        }
        Event event = this.newEventInstance(start, end, false);
        event.setCalendarId(this.spaceCalendar.getId());
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        event = this.agendaEventService.getEventById(event.getId(), null, Long.parseLong(this.testuser1Identity.getId()));
        EventFilter eventFilter = new EventFilter(Long.parseLong(this.testuser2Identity.getId()), null, null, date.plusHours(1L), date.plusMinutes(90L), 0);
        List events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        eventFilter = new EventFilter(Long.parseLong(this.testuser3Identity.getId()), null, null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)0L, (long)events.size());
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(event.getId()).getEventAttendees();
        eventAttendees.add(new EventAttendee(0L, event.getId(), Long.parseLong(this.spaceIdentity.getId()), null));
        this.agendaEventAttendeeService.saveEventAttendees(event, eventAttendees, testuser1Id, false, false, new AgendaEventModification(event.getId(), event.getCalendarId(), testuser1Id, Collections.singleton(AgendaEventModificationType.ADDED)));
        eventFilter = new EventFilter(Long.parseLong(this.testuser3Identity.getId()), null, null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
        eventFilter = new EventFilter(Long.parseLong(this.testuser4Identity.getId()), null, null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)0L, (long)events.size());
        eventAttendees = this.agendaEventAttendeeService.getEventAttendees(event.getId()).getEventAttendees();
        eventAttendees.add(new EventAttendee(0L, event.getId(), Long.parseLong(this.testuser4Identity.getId()), null));
        this.agendaEventAttendeeService.saveEventAttendees(event, eventAttendees, testuser1Id, false, false, new AgendaEventModification(event.getId(), event.getCalendarId(), testuser1Id, Collections.singleton(AgendaEventModificationType.ADDED)));
        eventFilter = new EventFilter(Long.parseLong(this.testuser4Identity.getId()), null, null, date.plusHours(1L), date.plusMinutes(90L), 0);
        events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.size());
    }

    @Test
    public void testGetEventsByResponseTypes() throws Exception {
        ZonedDateTime date = this.getDate();
        ZonedDateTime start = date.withNano(0);
        ZonedDateTime end = start.plusHours(2L);
        Event event = this.newEventInstance(start, end, false);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity, this.testuser3Identity);
        ArrayList<EventAttendeeResponse> responseTypes = new ArrayList<EventAttendeeResponse>();
        List events = new ArrayList();
        this.agendaEventAttendeeService.sendEventResponse(event.getId(), Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.TENTATIVE);
        responseTypes.add(EventAttendeeResponse.TENTATIVE);
        EventFilter eventFilter = new EventFilter(Long.parseLong(this.testuser3Identity.getId()), null, responseTypes, start, end, 0);
        try {
            events = this.agendaEventService.getEvents(eventFilter, ZoneId.systemDefault(), Long.parseLong(this.testuser3Identity.getId()));
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Assert.assertNotNull(events);
        Assert.assertEquals((long)1L, (long)events.size());
        event = this.newEventInstance(start, end, false);
        Event event1 = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity, this.testuser3Identity);
        this.agendaEventAttendeeService.sendEventResponse(event1.getId(), Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.TENTATIVE);
        ArrayList<EventAttendeeResponse> responseTypes1 = new ArrayList<EventAttendeeResponse>();
        responseTypes1.add(EventAttendeeResponse.TENTATIVE);
        EventFilter eventFilter1 = new EventFilter(Long.parseLong(this.testuser3Identity.getId()), null, responseTypes1, start, end, 0);
        events = this.agendaEventService.getEvents(eventFilter1, ZoneId.systemDefault(), Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertNotNull(events);
        Assert.assertEquals((long)2L, (long)events.size());
        event = this.newEventInstance(start, end, false);
        Event event2 = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity, this.testuser3Identity);
        this.agendaEventAttendeeService.sendEventResponse(event2.getId(), Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.ACCEPTED);
        ArrayList<EventAttendeeResponse> responseTypes2 = new ArrayList<EventAttendeeResponse>();
        responseTypes2.add(EventAttendeeResponse.TENTATIVE);
        responseTypes2.add(EventAttendeeResponse.ACCEPTED);
        EventFilter eventFilter2 = new EventFilter(Long.parseLong(this.testuser3Identity.getId()), null, responseTypes2, start, end, 0);
        events = this.agendaEventService.getEvents(eventFilter2, ZoneId.systemDefault(), Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertNotNull(events);
        Assert.assertEquals((long)3L, (long)events.size());
    }

    @Test
    public void testCountPendingEvents() throws Exception {
        ZonedDateTime start = this.getDate();
        ZonedDateTime end = start.plusHours(1L);
        Event event = this.newEventInstance(start, end, false);
        event.setCalendarId(this.spaceCalendar.getId());
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        event = this.createEvent(event, userIdentityId, this.spaceIdentity, this.testuser4Identity);
        long eventId = event.getId();
        this.agendaEventAttendeeService.sendEventResponse(eventId, userIdentityId, EventAttendeeResponse.DECLINED);
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.ACCEPTED);
        long countPendingEvents = this.agendaEventService.countPendingEvents(null, userIdentityId);
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        ZonedDateTime occurrenceId = start.plusDays(1L);
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceId);
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceId.plusDays(1L));
        Event exceptionalOccurrenceEvent = this.agendaEventService.getExceptionalOccurrenceEvent(eventId, occurrenceId);
        Assert.assertNotNull((Object)exceptionalOccurrenceEvent);
        Assert.assertNotNull((Object)exceptionalOccurrenceEvent.getOccurrence());
        countPendingEvents = this.agendaEventService.countPendingEvents(null, userIdentityId);
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        String exceptionalEventEndDateRFC3339 = AgendaDateUtils.toRFC3339Date((ZonedDateTime)exceptionalOccurrenceEvent.getEnd().plusHours(1L));
        Map<String, List<String>> dateFields = this.getFields("end", exceptionalEventEndDateRFC3339);
        this.agendaEventService.updateEventFields(exceptionalOccurrenceEvent.getId(), dateFields, false, false, userIdentityId);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, userIdentityId);
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)2L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertEquals((long)2L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        exceptionalOccurrenceEvent = this.agendaEventService.getEventById(exceptionalOccurrenceEvent.getId());
        ArrayList<EventAttendee> eventAttendees = new ArrayList<EventAttendee>(this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees());
        eventAttendees.add(new EventAttendee(0L, 0L, Long.parseLong(this.testuser5Identity.getId()), null));
        this.agendaEventService.updateEvent(exceptionalOccurrenceEvent, eventAttendees, null, null, null, null, false, userIdentityId);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, userIdentityId);
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)2L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertEquals((long)2L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
    }

    @Test
    public void testCountPastPendingEvents() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().minusHours(1L);
        ZonedDateTime end = ZonedDateTime.now().minusMinutes(1L);
        Event event = this.newEventInstance(start, end, false);
        event.setCalendarId(this.spaceCalendar.getId());
        event.setRecurrence(null);
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        event = this.createEvent(event, userIdentityId, this.spaceIdentity, this.testuser4Identity);
        long eventId = event.getId();
        this.agendaEventAttendeeService.sendEventResponse(eventId, userIdentityId, EventAttendeeResponse.DECLINED);
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.ACCEPTED);
        long countPendingEvents = this.agendaEventService.countPendingEvents(null, userIdentityId);
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser4Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(null, Long.parseLong(this.testuser5Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
    }

    @Test
    public void testGetPendingEvents() throws Exception {
        ZonedDateTime start = this.getDate();
        ZonedDateTime end = start.plusHours(1L);
        Event event = this.newEventInstance(start, end, false);
        event.setCalendarId(this.spaceCalendar.getId());
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        event = this.createEvent(event, userIdentityId, this.spaceIdentity, this.testuser4Identity);
        long eventId = event.getId();
        this.agendaEventAttendeeService.sendEventResponse(eventId, userIdentityId, EventAttendeeResponse.DECLINED);
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.ACCEPTED);
        List pendingEvents = this.agendaEventService.getPendingEvents(null, userIdentityId, (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser2Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser3Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser4Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser5Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        ZonedDateTime occurrenceId = start.plusDays(1L);
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceId);
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceId.plusDays(1L));
        Event exceptionalOccurrenceEvent = this.agendaEventService.getExceptionalOccurrenceEvent(eventId, occurrenceId);
        Assert.assertNotNull((Object)exceptionalOccurrenceEvent);
        Assert.assertNotNull((Object)exceptionalOccurrenceEvent.getOccurrence());
        pendingEvents = this.agendaEventService.getPendingEvents(null, userIdentityId, (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser2Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser3Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser4Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser5Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        String exceptionalEventEndDateRFC3339 = AgendaDateUtils.toRFC3339Date((ZonedDateTime)exceptionalOccurrenceEvent.getEnd().plusHours(1L));
        Map<String, List<String>> dateFields = this.getFields("end", exceptionalEventEndDateRFC3339);
        this.agendaEventService.updateEventFields(exceptionalOccurrenceEvent.getId(), dateFields, false, false, userIdentityId);
        pendingEvents = this.agendaEventService.getPendingEvents(null, userIdentityId, (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser2Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)2L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
        Assert.assertEquals((long)event.getId(), (long)((Event)pendingEvents.get(1)).getId());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser3Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser4Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)2L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
        Assert.assertEquals((long)event.getId(), (long)((Event)pendingEvents.get(1)).getId());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser5Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        exceptionalOccurrenceEvent = this.agendaEventService.getEventById(exceptionalOccurrenceEvent.getId());
        ArrayList<EventAttendee> eventAttendees = new ArrayList<EventAttendee>(this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees());
        eventAttendees.add(new EventAttendee(0L, 0L, Long.parseLong(this.testuser5Identity.getId()), null));
        this.agendaEventService.updateEvent(exceptionalOccurrenceEvent, eventAttendees, null, null, null, null, false, userIdentityId);
        pendingEvents = this.agendaEventService.getPendingEvents(null, userIdentityId, (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser2Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)2L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
        Assert.assertEquals((long)event.getId(), (long)((Event)pendingEvents.get(1)).getId());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser3Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser4Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)2L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
        Assert.assertEquals((long)event.getId(), (long)((Event)pendingEvents.get(1)).getId());
        pendingEvents = this.agendaEventService.getPendingEvents(null, Long.parseLong(this.testuser5Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
    }

    @Test
    public void testCountPendingEventsByOwnerIds() throws Exception {
        ZonedDateTime start = this.getDate();
        ZonedDateTime end = start.plusHours(1L);
        Event event = this.newEventInstance(start, end, false);
        event.setCalendarId(this.spaceCalendar.getId());
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        event = this.createEvent(event, userIdentityId, this.spaceIdentity, this.testuser4Identity);
        long eventId = event.getId();
        this.agendaEventAttendeeService.sendEventResponse(eventId, userIdentityId, EventAttendeeResponse.DECLINED);
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.ACCEPTED);
        List<Long> ownerIds = Collections.singletonList(Long.parseLong(this.spaceIdentity.getId()));
        long countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, userIdentityId);
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        try {
            this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser4Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser5Identity.getId()));
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ZonedDateTime occurrenceId = start.plusDays(1L);
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceId);
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceId.plusDays(1L));
        Event exceptionalOccurrenceEvent = this.agendaEventService.getExceptionalOccurrenceEvent(eventId, occurrenceId);
        Assert.assertNotNull((Object)exceptionalOccurrenceEvent);
        Assert.assertNotNull((Object)exceptionalOccurrenceEvent.getOccurrence());
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, userIdentityId);
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        String exceptionalEventEndDateRFC3339 = AgendaDateUtils.toRFC3339Date((ZonedDateTime)exceptionalOccurrenceEvent.getEnd().plusHours(1L));
        Map<String, List<String>> dateFields = this.getFields("end", exceptionalEventEndDateRFC3339);
        this.agendaEventService.updateEventFields(exceptionalOccurrenceEvent.getId(), dateFields, false, false, userIdentityId);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, userIdentityId);
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)2L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
        exceptionalOccurrenceEvent = this.agendaEventService.getEventById(exceptionalOccurrenceEvent.getId());
        ArrayList<EventAttendee> eventAttendees = new ArrayList<EventAttendee>(this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees());
        eventAttendees.add(new EventAttendee(0L, 0L, Long.parseLong(this.testuser5Identity.getId()), null));
        this.agendaEventService.updateEvent(exceptionalOccurrenceEvent, eventAttendees, null, null, null, null, false, userIdentityId);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, userIdentityId);
        Assert.assertEquals((long)0L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser2Identity.getId()));
        Assert.assertEquals((long)2L, (long)countPendingEvents);
        countPendingEvents = this.agendaEventService.countPendingEvents(ownerIds, Long.parseLong(this.testuser3Identity.getId()));
        Assert.assertEquals((long)1L, (long)countPendingEvents);
    }

    @Test
    public void testGetPendingEventsByOwnerIds() throws Exception {
        ZonedDateTime start = this.getDate();
        ZonedDateTime end = start.plusHours(1L);
        Event event = this.newEventInstance(start, end, false);
        event.setCalendarId(this.spaceCalendar.getId());
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        event = this.createEvent(event, userIdentityId, this.spaceIdentity, this.testuser4Identity);
        long eventId = event.getId();
        this.agendaEventAttendeeService.sendEventResponse(eventId, userIdentityId, EventAttendeeResponse.DECLINED);
        this.agendaEventAttendeeService.sendEventResponse(eventId, Long.parseLong(this.testuser3Identity.getId()), EventAttendeeResponse.ACCEPTED);
        List<Long> ownerIds = Collections.singletonList(Long.parseLong(this.spaceIdentity.getId()));
        List pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, userIdentityId, (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser2Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser3Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        try {
            this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser4Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser5Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
            Assert.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ZonedDateTime occurrenceId = start.plusDays(1L);
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceId);
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceId.plusDays(1L));
        Event exceptionalOccurrenceEvent = this.agendaEventService.getExceptionalOccurrenceEvent(eventId, occurrenceId);
        Assert.assertNotNull((Object)exceptionalOccurrenceEvent);
        Assert.assertNotNull((Object)exceptionalOccurrenceEvent.getOccurrence());
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, userIdentityId, (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser2Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser3Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        String exceptionalEventEndDateRFC3339 = AgendaDateUtils.toRFC3339Date((ZonedDateTime)exceptionalOccurrenceEvent.getEnd().plusHours(1L));
        Map<String, List<String>> dateFields = this.getFields("end", exceptionalEventEndDateRFC3339);
        this.agendaEventService.updateEventFields(exceptionalOccurrenceEvent.getId(), dateFields, false, false, userIdentityId);
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, userIdentityId, (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser2Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)2L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
        Assert.assertEquals((long)event.getId(), (long)((Event)pendingEvents.get(1)).getId());
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser3Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
        exceptionalOccurrenceEvent = this.agendaEventService.getEventById(exceptionalOccurrenceEvent.getId());
        ArrayList<EventAttendee> eventAttendees = new ArrayList<EventAttendee>(this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees());
        eventAttendees.add(new EventAttendee(0L, 0L, Long.parseLong(this.testuser5Identity.getId()), null));
        this.agendaEventService.updateEvent(exceptionalOccurrenceEvent, eventAttendees, null, null, null, null, false, userIdentityId);
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, userIdentityId, (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)0L, (long)pendingEvents.size());
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser2Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)2L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
        Assert.assertEquals((long)event.getId(), (long)((Event)pendingEvents.get(1)).getId());
        pendingEvents = this.agendaEventService.getPendingEvents(ownerIds, Long.parseLong(this.testuser3Identity.getId()), (ZoneId)ZoneOffset.UTC, 0, 10);
        Assert.assertEquals((long)1L, (long)pendingEvents.size());
        Assert.assertEquals((long)exceptionalOccurrenceEvent.getId(), (long)((Event)pendingEvents.get(0)).getId());
    }

    @Test
    public void testAddIcsFile() throws IOException {
        ZonedDateTime start = this.getDate();
        ZonedDateTime end = start.plusHours(1L);
        ZoneId dstTimeZone = ZoneId.of("Europe/Paris");
        NotificationInfo notification = new NotificationInfo();
        notification.with("eventTitle", "eventSummary").with("eventCreator", "Root Root").with("startDate", AgendaDateUtils.toRFC3339Date((ZonedDateTime)start)).with("endDate", AgendaDateUtils.toRFC3339Date((ZonedDateTime)end));
        MessageInfo messageInfo = new MessageInfo();
        NotificationUtils.addIcsFile((NotificationInfo)notification, (MessageInfo)messageInfo, (ZoneId)dstTimeZone);
        Assert.assertNotNull((Object)messageInfo.getAttachment());
        Assert.assertEquals((long)1L, (long)messageInfo.getAttachment().size());
        String text = new String(((Attachment)messageInfo.getAttachment().get(0)).getInputStream().readAllBytes(), StandardCharsets.UTF_8);
        List<String> lines = text.contains("\r\n") ? List.of(text.split("\r\n")) : List.of(text.split("\n"));
        String dtStart = lines.stream().filter(s -> s.contains("DTSTART")).findAny().get();
        String dtEnd = lines.stream().filter(s -> s.contains("DTEND")).findAny().get();
        Assert.assertNotNull((Object)dtStart);
        Assert.assertNotNull((Object)dtEnd);
        String icsStartDate = dtStart.substring(dtStart.indexOf(":") + 1);
        String icsEndDate = dtEnd.substring(dtEnd.indexOf(":") + 1);
        String startDateRFC3339 = notification.getValueOwnerParameter("startDate");
        ZonedDateTime startDate = ZonedDateTime.parse(startDateRFC3339).withZoneSameInstant(dstTimeZone);
        String startDateFormatted = AgendaDateUtils.formatDateTimeWithSeconds((TemporalAccessor)startDate);
        String endDateRFC3339 = notification.getValueOwnerParameter("endDate");
        ZonedDateTime endDate = ZonedDateTime.parse(endDateRFC3339).withZoneSameInstant(dstTimeZone);
        String endDateFormatted = AgendaDateUtils.formatDateTimeWithSeconds((TemporalAccessor)endDate);
        Assert.assertEquals((Object)icsStartDate, (Object)startDateFormatted);
        Assert.assertEquals((Object)icsEndDate, (Object)endDateFormatted);
    }
}

