/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.exoplatform.agenda.dao.CalendarDAO;
import org.exoplatform.agenda.entity.CalendarEntity;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.agenda.storage.cached.CachedAgendaCalendarStorage;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class AgendaCalendarStorageTest {
    private CachedAgendaCalendarStorage agendaCalendarStorage;
    private CalendarDAO calendarDAO;

    @Before
    public void setUp() throws Exception {
        CacheService cacheService = (CacheService)Mockito.mock(CacheService.class);
        this.calendarDAO = (CalendarDAO)Mockito.mock(CalendarDAO.class);
        AgendaEventStorage agendaEventStorage = (AgendaEventStorage)Mockito.mock(AgendaEventStorage.class);
        ListenerService listenerService = new ListenerService(new ExoContainerContext(null));
        listenerService = (ListenerService)Mockito.spy((Object)listenerService);
        Mockito.when((Object)cacheService.getCacheInstance("agenda.calendar")).thenReturn((Object)new ConcurrentFIFOExoCache("agenda.calendar", 500));
        this.agendaCalendarStorage = new CachedAgendaCalendarStorage(cacheService, agendaEventStorage, this.calendarDAO, listenerService);
    }

    @Test
    public void testGetCalendarById() {
        CalendarEntity calendarEntity = new CalendarEntity();
        calendarEntity.setColor("color");
        calendarEntity.setDescription("description");
        calendarEntity.setCreatedDate(new Date());
        calendarEntity.setUpdatedDate(new Date());
        calendarEntity.setId(Long.valueOf(1L));
        calendarEntity.setOwnerId(Long.valueOf(2L));
        calendarEntity.setSystem(true);
        Mockito.when((Object)((CalendarEntity)this.calendarDAO.find((Serializable)Long.valueOf(Mockito.eq((long)2L))))).thenReturn((Object)calendarEntity);
        Calendar notExistingCalendar = this.agendaCalendarStorage.getCalendarById(1L);
        Assert.assertNull((Object)notExistingCalendar);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Mockito.anyLong()));
        Calendar calendar = this.agendaCalendarStorage.getCalendarById(2L);
        Assert.assertNotNull((Object)calendar);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)2))).find((Serializable)Long.valueOf(Mockito.anyLong()));
        this.agendaCalendarStorage.getCalendarById(2L);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)2))).find((Serializable)Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void testGetCalendarIdsByOwnerIds() {
        Mockito.when((Object)this.calendarDAO.getCalendarIdsByOwnerIds(Mockito.eq((int)0), Mockito.eq((int)10), (Long[])Mockito.anyVararg())).thenReturn(Collections.singletonList(2L));
        List result = this.agendaCalendarStorage.getCalendarIdsByOwnerIds(0, 10, new Long[]{2L});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)1))).getCalendarIdsByOwnerIds(0, 10, new Long[]{2L});
        this.agendaCalendarStorage.getCalendarIdsByOwnerIds(0, 10, new Long[]{2L});
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)2))).getCalendarIdsByOwnerIds(0, 10, new Long[]{2L});
    }

    @Test
    public void testCountCalendarsByOwners() {
        Mockito.when((Object)this.calendarDAO.countCalendarsByOwnerIds((Long[])Mockito.anyVararg())).thenReturn((Object)1);
        int count = this.agendaCalendarStorage.countCalendarsByOwners(new Long[]{2L});
        Assert.assertEquals((long)1L, (long)count);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)1))).countCalendarsByOwnerIds(new Long[]{2L});
        this.agendaCalendarStorage.countCalendarsByOwners(new Long[]{2L});
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)2))).countCalendarsByOwnerIds(new Long[]{2L});
    }

    @Test
    public void testCreateCalendar() throws Exception {
        Calendar calendar = new Calendar(0L, 2L, true, null, "description", null, null, "color", null);
        Mockito.when((Object)this.calendarDAO.create((CalendarEntity)Mockito.anyObject())).thenAnswer((Answer)new Answer<CalendarEntity>(this){

            public CalendarEntity answer(InvocationOnMock invocation) throws Throwable {
                CalendarEntity calendarEntity = (CalendarEntity)invocation.getArgument(0, CalendarEntity.class);
                calendarEntity.setId(Long.valueOf(1L));
                calendarEntity.setCreatedDate(new Date());
                return calendarEntity;
            }
        });
        Calendar createdCalendar = this.agendaCalendarStorage.createCalendar(calendar);
        Assert.assertNotNull((Object)createdCalendar);
        Assert.assertEquals((long)createdCalendar.getId(), (long)1L);
        Assert.assertNotNull((Object)createdCalendar.getCreated());
        calendar.setId(createdCalendar.getId());
        calendar.setCreated(createdCalendar.getCreated());
        Assert.assertEquals((Object)calendar, (Object)createdCalendar);
    }

    @Test
    public void testUpdateCalendar() throws Exception {
        long calendarId = 1L;
        CalendarEntity calendarEntity = new CalendarEntity();
        calendarEntity.setId(Long.valueOf(calendarId));
        calendarEntity.setOwnerId(Long.valueOf(2L));
        calendarEntity.setDescription("description");
        calendarEntity.setCreatedDate(new Date());
        calendarEntity.setSystem(true);
        calendarEntity.setColor("color");
        Mockito.when((Object)((CalendarEntity)this.calendarDAO.find((Serializable)Long.valueOf(Mockito.eq((long)calendarId))))).thenReturn((Object)calendarEntity);
        Calendar calendar = this.agendaCalendarStorage.getCalendarById(calendarId);
        Assert.assertNotNull((Object)calendar);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Mockito.anyLong()));
        this.agendaCalendarStorage.getCalendarById(calendarId);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Mockito.anyLong()));
        this.agendaCalendarStorage.updateCalendar(calendar);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)1))).update((CalendarEntity)Mockito.anyObject());
        this.agendaCalendarStorage.getCalendarById(calendarId);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)2))).find((Serializable)Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void testDeleteCalendarById() throws Exception {
        long calendarId = 1L;
        CalendarEntity calendarEntity = new CalendarEntity();
        calendarEntity.setId(Long.valueOf(calendarId));
        calendarEntity.setOwnerId(Long.valueOf(2L));
        calendarEntity.setDescription("description");
        calendarEntity.setCreatedDate(new Date());
        calendarEntity.setSystem(true);
        calendarEntity.setColor("color");
        Mockito.when((Object)((CalendarEntity)this.calendarDAO.find((Serializable)Long.valueOf(Mockito.eq((long)calendarId))))).thenReturn((Object)calendarEntity);
        Calendar calendar = this.agendaCalendarStorage.getCalendarById(calendarId);
        Assert.assertNotNull((Object)calendar);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Mockito.anyLong()));
        this.agendaCalendarStorage.getCalendarById(calendarId);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Mockito.anyLong()));
        this.agendaCalendarStorage.deleteCalendarById(calendarId);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)1))).delete((CalendarEntity)Mockito.anyObject());
        Mockito.when((Object)((CalendarEntity)this.calendarDAO.find((Serializable)Long.valueOf(Mockito.eq((long)calendarId))))).thenReturn(null);
        this.agendaCalendarStorage.getCalendarById(calendarId);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)3))).find((Serializable)Long.valueOf(Mockito.anyLong()));
        this.agendaCalendarStorage.getCalendarById(calendarId);
        ((CalendarDAO)Mockito.verify((Object)this.calendarDAO, (VerificationMode)Mockito.times((int)4))).find((Serializable)Long.valueOf(Mockito.anyLong()));
    }
}

