/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service.notification.plugin;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.notification.plugin.EventVoteNotificationPlugin;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.core.identity.model.Identity;
import org.junit.Assert;
import org.junit.Test;

public class VoteNotificationPluginTest
extends BaseAgendaEventTest {
    @Test
    public void testSendNotificationWhenVoteToDatePoll() throws Exception {
        ZonedDateTime start = ZonedDateTime.now();
        boolean allDay = false;
        Event event = this.newEventInstance(start, start, allDay);
        long modifierId = Long.parseLong(this.testuser1Identity.getId());
        event = this.createEvent(event, modifierId, this.testuser2Identity, this.testuser5Identity);
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(event.getId()).getEventAttendees();
        eventAttendees.add(new EventAttendee(0L, event.getId(), Long.parseLong(this.testuser2Identity.getId()), EventAttendeeResponse.ACCEPTED));
        this.agendaEventAttendeeService.saveEventAttendees(event, eventAttendees, modifierId, false, true, new AgendaEventModification(event.getId(), event.getCalendarId(), modifierId, Collections.singleton(AgendaEventModificationType.ADDED)));
        this.agendaEventAttendeeService.sendEventResponse(event.getId(), Long.parseLong(this.testuser2Identity.getId()), EventAttendeeResponse.ACCEPTED);
        InitParams initParams = new InitParams();
        ValueParam value = new ValueParam();
        value.setName("VoteNotificationPlugin");
        value.setValue("#111111");
        initParams.addParam((Object)value);
        value.setName("agenda.notification.plugin.key");
        value.setValue("111");
        initParams.addParam((Object)value);
        EventVoteNotificationPlugin voteNotificationPlugin = new EventVoteNotificationPlugin(initParams, this.identityManager, this.agendaCalendarService, this.agendaEventAttendeeService, this.spaceService);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.EVENT_AGENDA, (Object)event).append(NotificationUtils.EVENT_PARTICIPANT_ID, (Object)((EventAttendee)eventAttendees.get(2)).getIdentityId()).append(NotificationUtils.EVENT_RESPONSE, (Object)((EventAttendee)eventAttendees.get(2)).getResponse());
        String eventUrl = System.getProperty("gatein.email.domain.url").concat("portal/classic/agenda?eventId=").concat(String.valueOf(event.getId()));
        Identity identity = this.identityManager.getIdentity(String.valueOf(this.testuser2Identity.getId()));
        String avatarUrl = "/portal/rest/v1/social/users/" + identity.getId() + "/avatar";
        NotificationInfo notificationInfo = voteNotificationPlugin.makeNotification(ctx);
        Assert.assertNotNull((Object)notificationInfo);
        Assert.assertEquals((Object)String.valueOf(event.getId()), (Object)notificationInfo.getValueOwnerParameter("eventId"));
        Assert.assertEquals((Object)event.getSummary(), (Object)notificationInfo.getValueOwnerParameter("eventTitle"));
        Assert.assertTrue((boolean)notificationInfo.getValueOwnerParameter("participantAvatarUrl").startsWith(avatarUrl));
        Assert.assertTrue((boolean)notificationInfo.getValueOwnerParameter("Url").startsWith(eventUrl));
        Assert.assertEquals((Object)identity.getProfile().getFullName(), (Object)notificationInfo.getValueOwnerParameter("participantName"));
    }
}

