/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.util.HashMap;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Asynchronous
public class AgendaEventAttendeeGamificationIntegrationListener
extends Listener<EventAttendee, EventAttendee> {
    private static final Log LOG = ExoLogger.getLogger(AgendaEventAttendeeGamificationIntegrationListener.class);
    public static final String GAMIFICATION_GENERIC_EVENT = "exo.gamification.generic.action";
    public static final String GAMIFICATION_REPLY_TO_EVENT_RULE_TITLE = "ReplyToEvent";
    private PortalContainer container;
    private ListenerService listenerService;
    private AgendaEventService agendaEventService;

    public AgendaEventAttendeeGamificationIntegrationListener(PortalContainer container, ListenerService listenerService) {
        this.container = container;
        this.listenerService = listenerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<EventAttendee, EventAttendee> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            EventAttendee oldAttendee = (EventAttendee)event.getSource();
            EventAttendee newAttendee = (EventAttendee)event.getData();
            org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(newAttendee.getEventId());
            EventAttendeeResponse oldResponse = oldAttendee == null ? null : oldAttendee.getResponse();
            EventAttendeeResponse newResponse = newAttendee.getResponse();
            if (oldResponse != newResponse) {
                String eventURL = NotificationUtils.getEventURL(agendaEvent);
                Long earnerId = newAttendee.getIdentityId();
                try {
                    HashMap<String, String> gam = new HashMap<String, String>();
                    gam.put("ruleTitle", GAMIFICATION_REPLY_TO_EVENT_RULE_TITLE);
                    gam.put("objectId", eventURL);
                    gam.put("senderId", String.valueOf(earnerId));
                    gam.put("receiverId", String.valueOf(earnerId));
                    this.listenerService.broadcast(GAMIFICATION_GENERIC_EVENT, gam, (Object)String.valueOf(agendaEvent.getId()));
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot broadcast gamification event", (Throwable)e);
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }
}

