/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventAttendeeList;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.storage.AgendaEventAttendeeStorage;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class AgendaEventAttendeeServiceImpl
implements AgendaEventAttendeeService {
    private static final Log LOG = ExoLogger.getLogger(AgendaEventAttendeeServiceImpl.class);
    private static final String SEPARATOR = "@@@";
    private AgendaEventAttendeeStorage attendeeStorage;
    private AgendaEventStorage eventStorage;
    private ListenerService listenerService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private CodecInitializer codecInitializer;

    public AgendaEventAttendeeServiceImpl(AgendaEventAttendeeStorage attendeeStorage, AgendaEventStorage eventStorage, ListenerService listenerService, IdentityManager identityManager, SpaceService spaceService, CodecInitializer codecInitializer) {
        this.attendeeStorage = attendeeStorage;
        this.eventStorage = eventStorage;
        this.codecInitializer = codecInitializer;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
    }

    public Set<AgendaEventModificationType> saveEventAttendees(Event event, List<EventAttendee> attendees, long creatorUserId, boolean sendInvitations, boolean resetResponses, AgendaEventModification eventModifications) {
        long eventId = event.getId();
        EventStatus eventStatus = event.getStatus();
        List oldAttendees = this.getEventAttendees(event.getId()).getEventAttendees();
        List<EventAttendee> newAttendees = attendees == null ? Collections.emptyList() : attendees;
        HashSet<AgendaEventModificationType> eventModificationTypes = new HashSet<AgendaEventModificationType>();
        this.processAttendeesToDelete(oldAttendees, newAttendees, eventModificationTypes);
        this.processAttendeesToCreate(eventId, eventStatus, oldAttendees, newAttendees, resetResponses, eventModificationTypes);
        this.processAttendeesToUpdate(eventId, oldAttendees, newAttendees, resetResponses);
        this.processSendingInvitation(event, attendees, sendInvitations, eventModifications);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.attendees.saved", eventId, 0);
        return eventModificationTypes;
    }

    public EventAttendeeList getEventAttendees(long eventId) {
        return this.attendeeStorage.getEventAttendees(eventId);
    }

    public EventAttendeeList getEventAttendees(long eventId, EventAttendeeResponse ... responses) {
        return this.attendeeStorage.getEventAttendees(eventId, responses);
    }

    public List<EventAttendee> getEventAttendees(long eventId, ZonedDateTime occurrenceId, EventAttendeeResponse ... responses) {
        EventAttendeeList eventAttendeeList = this.attendeeStorage.getEventAttendees(eventId, responses);
        return eventAttendeeList.getEventAttendees(occurrenceId);
    }

    public EventAttendeeResponse getEventResponse(long eventId, ZonedDateTime occurrenceId, long identityId) throws ObjectNotFoundException, IllegalAccessException {
        Event event = this.eventStorage.getEventById(eventId);
        if (event == null) {
            throw new ObjectNotFoundException("Event with id " + eventId + " wasn't found");
        }
        if (!this.isEventAttendee(eventId, identityId)) {
            throw new IllegalAccessException("User " + identityId + " is not attendee of event " + eventId);
        }
        EventAttendeeList eventAttendeeList = this.attendeeStorage.getEventAttendees(eventId, identityId);
        if (eventAttendeeList.isEmpty()) {
            return EventAttendeeResponse.NEEDS_ACTION;
        }
        EventAttendee eventAttendee = eventAttendeeList.getEventAttendee(identityId, occurrenceId);
        return eventAttendee == null ? EventAttendeeResponse.NEEDS_ACTION : eventAttendee.getResponse();
    }

    public void sendEventResponse(long eventId, long identityId, EventAttendeeResponse response) throws ObjectNotFoundException, IllegalAccessException {
        this.sendEventResponse(eventId, identityId, response, true);
    }

    public void sendUpcomingEventResponse(long eventId, ZonedDateTime occurrenceId, long identityId, EventAttendeeResponse response) throws ObjectNotFoundException, IllegalAccessException {
        if (response == null) {
            throw new IllegalArgumentException("Attendee response is mandatory");
        }
        if (occurrenceId == null) {
            throw new IllegalArgumentException("occurrenceId is mandatory");
        }
        if (eventId <= 0L) {
            throw new IllegalArgumentException("eventId is mandatory");
        }
        if (identityId <= 0L) {
            throw new IllegalArgumentException("identityId is mandatory");
        }
        Event event = this.eventStorage.getEventById(eventId);
        if (event == null) {
            throw new ObjectNotFoundException("Parent event with id " + eventId + " wasn't found");
        }
        if (event.getRecurrence() == null) {
            throw new IllegalStateException("Event with id " + eventId + " isn't recurrent");
        }
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (userIdentity == null) {
            throw new ObjectNotFoundException("Identity with id " + identityId + " wasn't found");
        }
        if (!this.isEventAttendee(eventId, identityId)) {
            throw new IllegalAccessException("User with identity id " + identityId + " isn't attendee of event with id " + eventId);
        }
        this.saveEventAttendee(eventId, occurrenceId, identityId, response, true);
        List<Long> exceptionalOccurenceEventIds = this.eventStorage.getExceptionalOccurenceIds(eventId, occurrenceId);
        for (long exceptionalOccurenceEventId : exceptionalOccurenceEventIds) {
            if (!this.isEventAttendee(exceptionalOccurenceEventId, identityId)) continue;
            this.saveEventAttendee(exceptionalOccurenceEventId, identityId, response, false);
        }
    }

    public void sendEventResponse(long eventId, long identityId, EventAttendeeResponse response, boolean broadcast) throws ObjectNotFoundException, IllegalAccessException {
        if (response == null) {
            throw new IllegalArgumentException("Attendee response is mandatory");
        }
        if (eventId <= 0L) {
            throw new IllegalArgumentException("eventId is mandatory");
        }
        Event event = this.eventStorage.getEventById(eventId);
        if (event == null) {
            throw new ObjectNotFoundException("Parent event with id " + eventId + " wasn't found");
        }
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (userIdentity == null) {
            throw new ObjectNotFoundException("Identity with id " + identityId + " wasn't found");
        }
        if (!this.isEventAttendee(eventId, identityId)) {
            throw new IllegalAccessException("User with identity id " + identityId + " isn't attendee of event with id " + eventId);
        }
        boolean isRecurrentEvent = this.eventStorage.isRecurrentEvent(eventId);
        if (isRecurrentEvent) {
            // empty if block
        }
        this.saveEventAttendee(eventId, identityId, response, broadcast);
        if (isRecurrentEvent) {
            List<Long> exceptionalOccurenceEventIds = this.eventStorage.getExceptionalOccurenceIds(eventId);
            for (long exceptionalOccurenceEventId : exceptionalOccurenceEventIds) {
                if (!this.isEventAttendee(exceptionalOccurenceEventId, identityId)) continue;
                this.saveEventAttendee(exceptionalOccurenceEventId, identityId, response, false);
            }
        }
    }

    public String generateEncryptedToken(long eventId, String email) {
        return this.generateEncryptedToken(eventId, email, null);
    }

    public String generateEncryptedToken(long eventId, String emailOrUsername, EventAttendeeResponse response) {
        if (eventId <= 0L) {
            throw new IllegalArgumentException("eventId is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)emailOrUsername)) {
            throw new IllegalArgumentException("email is mandatory");
        }
        StringBuilder tokenFlatStringBuilder = new StringBuilder().append(String.valueOf(eventId)).append(SEPARATOR).append(emailOrUsername);
        if (response != null) {
            tokenFlatStringBuilder.append(SEPARATOR).append(response.getValue());
        }
        String tokenFlat = tokenFlatStringBuilder.toString();
        try {
            return this.codecInitializer.getCodec().encode(tokenFlat);
        }
        catch (TokenServiceInitializationException e) {
            LOG.warn((Object)"Error generating Token", (Throwable)e);
            return null;
        }
    }

    public Identity decryptUserIdentity(long eventId, String token, EventAttendeeResponse response) throws IllegalAccessException {
        String tokenFlat;
        try {
            tokenFlat = this.codecInitializer.getCodec().decode(token);
        }
        catch (TokenServiceInitializationException e) {
            LOG.warn((Object)"Error decrypting Token", (Throwable)e);
            return null;
        }
        String[] tokenParts = tokenFlat.split("\\@@@");
        if (tokenParts.length < 2) {
            throw new IllegalAccessException("Wrong token format");
        }
        String eventIdString = tokenParts[0];
        if (!eventIdString.equals(String.valueOf(eventId))) {
            throw new IllegalAccessException("Wrong eventId from token");
        }
        if (response != null) {
            String responseString;
            String string = responseString = tokenParts.length > 2 ? tokenParts[2] : null;
            if (!StringUtils.equals((CharSequence)responseString, (CharSequence)response.getValue())) {
                throw new IllegalAccessException("Wrong response from token");
            }
        }
        String emailOrUsername = tokenParts[1];
        return this.identityManager.getOrCreateIdentity("organization", emailOrUsername);
    }

    public boolean isEventAttendee(long eventId, long identityId) {
        EventAttendeeList eventAttendees = this.getEventAttendees(eventId);
        return Utils.isEventAttendee(this.identityManager, this.spaceService, identityId, eventAttendees);
    }

    public void sendInvitations(Event event, List<EventAttendee> eventAttendees, AgendaEventModification eventModifications) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.EVENT_AGENDA, (Object)event);
        ctx.append(NotificationUtils.EVENT_ATTENDEE, eventAttendees);
        ctx.append(NotificationUtils.EVENT_MODIFIER, (Object)eventModifications.getModifierId());
        if (eventModifications.hasModification(AgendaEventModificationType.DELETED)) {
            ctx.append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.DELETED.name());
        } else if (eventModifications.hasModification(AgendaEventModificationType.ADDED)) {
            ctx.append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.ADDED.name());
        } else if (eventModifications.hasModification(AgendaEventModificationType.SWITCHED_EVENT_TO_DATE_POLL)) {
            ctx.append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.SWITCHED_EVENT_TO_DATE_POLL.name());
        } else if (eventModifications.hasModification(AgendaEventModificationType.SWITCHED_DATE_POLL_TO_EVENT)) {
            ctx.append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.SWITCHED_DATE_POLL_TO_EVENT.name());
        } else if (eventModifications.hasModification(AgendaEventModificationType.START_DATE_UPDATED) || eventModifications.hasModification(AgendaEventModificationType.END_DATE_UPDATED)) {
            ctx.append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.DATES_UPDATED.name());
        } else if (eventModifications.hasModification(AgendaEventModificationType.UPDATED)) {
            ctx.append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.UPDATED.name());
        }
        if (eventModifications.hasModification(AgendaEventModificationType.DELETED)) {
            this.dispatch(ctx, "EventCanceledNotificationPlugin");
        } else if (eventModifications.hasModification(AgendaEventModificationType.UPDATED)) {
            this.dispatch(ctx, "EventModifiedNotificationPlugin");
        } else if (eventModifications.hasModification(AgendaEventModificationType.ADDED) && event.getStatus() == EventStatus.TENTATIVE) {
            this.dispatch(ctx, "DatePollNotificationPlugin");
        } else if (eventModifications.hasModification(AgendaEventModificationType.ADDED) && event.getStatus() == EventStatus.CONFIRMED) {
            this.dispatch(ctx, "EventAddedNotificationPlugin");
        }
    }

    private void saveEventAttendee(long eventId, long identityId, EventAttendeeResponse response, boolean userResponseSent) {
        this.saveEventAttendee(eventId, null, identityId, response, userResponseSent);
    }

    private void saveEventAttendee(long eventId, ZonedDateTime occurrenceId, long identityId, EventAttendeeResponse response, boolean userResponseSent) {
        EventAttendee oldAttendee;
        EventAttendeeList eventAttendees = this.attendeeStorage.getEventAttendees(eventId, identityId);
        EventAttendee attendee = eventAttendees.getEventAttendee(identityId, occurrenceId);
        EventAttendee eventAttendee = oldAttendee = attendee == null ? null : attendee.clone();
        if (occurrenceId == null) {
            List userEventAttendees = eventAttendees.getEventAttendees(identityId);
            if (userEventAttendees.size() > 1) {
                userEventAttendees.forEach(userEventAttendee -> this.attendeeStorage.removeEventAttendee(userEventAttendee.getId()));
                attendee = new EventAttendee(0L, eventId, identityId, response);
            } else if (attendee == null) {
                attendee = new EventAttendee(0L, eventId, identityId, response);
            } else {
                attendee.setResponse(response);
            }
            this.attendeeStorage.saveEventAttendee(attendee, eventId);
        } else {
            List userAttendees = eventAttendees.getEventAttendees();
            for (EventAttendee eventAttendee2 : userAttendees) {
                if (eventAttendee2.getFromOccurrenceId() != null && (eventAttendee2.getFromOccurrenceId().isAfter(occurrenceId) || eventAttendee2.getFromOccurrenceId().isEqual(occurrenceId))) {
                    this.attendeeStorage.removeEventAttendee(eventAttendee2.getId());
                    continue;
                }
                if (eventAttendee2.getFromOccurrenceId() != null && !eventAttendee2.getFromOccurrenceId().isBefore(occurrenceId) || eventAttendee2.getUntilOccurrenceId() != null && !eventAttendee2.getUntilOccurrenceId().isAfter(occurrenceId)) continue;
                eventAttendee2.setUntilOccurrenceId(occurrenceId);
                this.attendeeStorage.saveEventAttendee(eventAttendee2, eventId);
            }
            attendee = new EventAttendee(0L, eventId, identityId, occurrenceId, null, response);
            this.attendeeStorage.saveEventAttendee(attendee, eventId);
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.responseSaved", oldAttendee, attendee);
        if (userResponseSent) {
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.responseSent", oldAttendee, attendee);
        }
    }

    private void dispatch(NotificationContext ctx, String ... pluginId) {
        ArrayList<NotificationCommand> commands = new ArrayList<NotificationCommand>(pluginId.length);
        for (String p : pluginId) {
            NotificationCommand command = ctx.makeCommand(PluginKey.key((String)p));
            if (command == null) continue;
            commands.add(command);
        }
        try {
            if (!commands.isEmpty()) {
                ctx.getNotificationExecutor().with(commands).execute(ctx);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error sending invitation notifications", (Throwable)e);
        }
    }

    private void processSendingInvitation(Event event, List<EventAttendee> attendees, boolean sendInvitations, AgendaEventModification eventModifications) {
        if (sendInvitations) {
            if (event.getStatus() == EventStatus.CANCELLED) {
                eventModifications.setModificationTypes(Collections.singleton(AgendaEventModificationType.DELETED));
            }
            this.sendInvitations(event, attendees, eventModifications);
        }
    }

    private void processAttendeesToUpdate(long eventId, List<EventAttendee> oldAttendees, List<EventAttendee> newAttendees, boolean resetResponses) {
        if (resetResponses) {
            List attendeesToUpdate = oldAttendees.stream().filter(attendee -> newAttendees.stream().anyMatch(newAttendee -> newAttendee.getIdentityId() == attendee.getIdentityId())).collect(Collectors.toList());
            for (EventAttendee eventAttendee : attendeesToUpdate) {
                try {
                    this.sendEventResponse(eventId, eventAttendee.getIdentityId(), EventAttendeeResponse.NEEDS_ACTION);
                }
                catch (Exception e) {
                    LOG.warn("Error initializing default reminders of event {} for user with id {}", new Object[]{eventId, eventAttendee.getIdentityId(), e});
                }
            }
        }
    }

    private void processAttendeesToCreate(long eventId, EventStatus eventStatus, List<EventAttendee> oldAttendees, List<EventAttendee> newAttendees, boolean resetResponses, Set<AgendaEventModificationType> eventModificationTypes) {
        List attendeesToCreate = newAttendees.stream().filter(attendee -> oldAttendees.stream().noneMatch(newAttendee -> newAttendee.getIdentityId() == attendee.getIdentityId())).collect(Collectors.toList());
        for (EventAttendee eventAttendee : attendeesToCreate) {
            if (resetResponses || eventAttendee.getResponse() == null || eventStatus == EventStatus.TENTATIVE) {
                eventAttendee.setResponse(EventAttendeeResponse.NEEDS_ACTION);
            }
            this.attendeeStorage.saveEventAttendee(eventAttendee, eventId);
        }
        if (!attendeesToCreate.isEmpty()) {
            eventModificationTypes.add(AgendaEventModificationType.ATTENDEE_ADDED);
        }
    }

    private void processAttendeesToDelete(List<EventAttendee> oldAttendees, List<EventAttendee> newAttendees, Set<AgendaEventModificationType> eventModificationTypes) {
        List attendeesToDelete = oldAttendees.stream().filter(attendee -> newAttendees.stream().noneMatch(newAttendee -> newAttendee.getIdentityId() == attendee.getIdentityId())).collect(Collectors.toList());
        for (EventAttendee eventAttendee : attendeesToDelete) {
            this.attendeeStorage.removeEventAttendee(eventAttendee.getId());
        }
        if (!attendeesToDelete.isEmpty()) {
            eventModificationTypes.add(AgendaEventModificationType.ATTENDEE_DELETED);
        }
    }
}

