/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antibruteforce.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    private static final String CONFIGURED_DOMAIN_URL_KEY = "gatein.email.domain.url";
    private static final String ANTI_BRUTEFORCE_RESOURCE_BUNDLE_NAME = "locale.Antibruteforce";
    private static final String ACCOUNT_LOCKED_MAIL_SUBJECT_KEY = "antibruteforce.accountLocked.email.subject";
    private static final String ACCOUNT_LOCKED_MAIL_TEMPLATE_PATH = "template/account_locked_email_template.html";
    private static final Pattern PATTERN = Pattern.compile("&\\{([a-zA-Z\\d\\.]+)\\}");

    public static void sendAccountLockedEmail(User user, Locale defaultLocale, OrganizationService organizationService) throws Exception {
        if (user == null) {
            throw new IllegalArgumentException("User or Locale must not be null");
        }
        ResourceBundleService resourceBundleService = (ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class);
        WebAppController webAppController = (WebAppController)CommonsUtils.getService(WebAppController.class);
        MailService mailService = (MailService)CommonsUtils.getService(MailService.class);
        UserProfile profile = organizationService.getUserProfileHandler().findUserProfileByName(user.getUserName());
        String lang = profile == null ? null : (String)profile.getUserInfoMap().get("user.language");
        Locale locale = lang != null ? LocaleContextInfo.getLocale((String)lang) : defaultLocale;
        ResourceBundle bundle = resourceBundleService.getResourceBundle(ANTI_BRUTEFORCE_RESOURCE_BUNDLE_NAME, locale);
        Router router = webAppController.getRouter();
        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
        params.put(WebAppController.HANDLER_PARAM, "forgot-password");
        String url = System.getProperty(CONFIGURED_DOMAIN_URL_KEY) + "/portal" + router.render(params);
        String emailBody = Utils.buildAccountLockedEmailBody(user, bundle, url);
        String emailSubject = bundle.getString(ACCOUNT_LOCKED_MAIL_SUBJECT_KEY);
        String senderName = MailUtils.getSenderName();
        Object from = MailUtils.getSenderEmail();
        if (senderName != null && !senderName.trim().isEmpty()) {
            from = senderName + " <" + (String)from + ">";
        }
        Message message = new Message();
        message.setFrom((String)from);
        message.setTo(user.getEmail());
        message.setSubject(emailSubject);
        message.setBody(emailBody);
        message.setMimeType("text/html");
        try {
            mailService.sendMessage(message);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failure to send account locked email", (Throwable)ex);
        }
    }

    private static String buildAccountLockedEmailBody(User user, ResourceBundle bundle, String link) {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(ACCOUNT_LOCKED_MAIL_TEMPLATE_PATH);
        String content = input == null ? "" : Utils.resolveLanguage(input, bundle);
        content = content.replace("${FIRST_NAME}", user.getFirstName());
        content = content.replace("${USERNAME}", user.getUserName());
        content = content.replace("${FORGOT_PASSWORD_LINK}", link);
        return content;
    }

    private static String resolveLanguage(InputStream input, ResourceBundle bundle) {
        StringBuffer content = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                if (content.length() > 0) {
                    content.append("\n");
                }
                Utils.parseKeys(content, line, bundle);
            }
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
        }
        return content.toString();
    }

    private static void parseKeys(StringBuffer sb, String input, ResourceBundle bundle) {
        Matcher matcher = PATTERN.matcher(input);
        while (matcher.find()) {
            String resource;
            String key = matcher.group(1);
            try {
                resource = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                resource = key;
            }
            matcher.appendReplacement(sb, resource);
        }
        matcher.appendTail(sb);
    }
}

