/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.connector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.antimalware.connector.MalwareDetectionItemConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class MalwareDetectionJcrConnector
extends MalwareDetectionItemConnector {
    private static final Log LOGGER = ExoLogger.getExoLogger(MalwareDetectionJcrConnector.class);
    private static final String PORTAL_CONTAINER = "_portal";
    private RepositoryService repositoryService;
    private static final String JCR = "jcr";
    private static final String VALUES = "values";
    private static final String MALWARE_INFECTED_JCR_NODE_DETECTION = "malware-infected-jcr-node-detection";
    private static final String MALWARE_INFECTED_JCR_NODE_CLEAN = "malware-infected-jcr-node-clean";
    private static final String INFECTED_JCR_NODE_WORKSPACE = "infectedJcrNodeWorkspace";

    public MalwareDetectionJcrConnector(InitParams initParams, RepositoryService repositoryService) {
        super(initParams);
        this.repositoryService = repositoryService;
    }

    @Override
    public List<Map<String, String>> getInfectedItems(String infectedJcrNodePath) {
        String infectedJcrNodeIdentifier = this.getJcrNodeIdentifier(infectedJcrNodePath);
        String jcrNodeWorkspace = this.getJcrNodeWorkspace(infectedJcrNodePath);
        ArrayList<Map<String, String>> infectedNodes = new ArrayList<Map<String, String>>();
        long startTime = System.currentTimeMillis();
        try {
            ExtendedSession session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(jcrNodeWorkspace, this.repositoryService.getCurrentRepository());
            Property infectedJcrNodeProperty = session.getPropertyByIdentifier(infectedJcrNodeIdentifier);
            if (infectedJcrNodeProperty.getName().equals("jcr:data")) {
                Node infectedJcrContentNode = infectedJcrNodeProperty.getParent();
                Node infectedJcrNode = infectedJcrContentNode.getParent();
                HashMap<String, String> infectedNode = new HashMap<String, String>();
                infectedNode.put("infectedItemId", ((NodeImpl)infectedJcrNode).getIdentifier());
                infectedNode.put(INFECTED_JCR_NODE_WORKSPACE, jcrNodeWorkspace);
                infectedNode.put("infectedItemName", infectedJcrNode.getName());
                infectedNode.put("infectedItemLastModifier", infectedJcrNode.getProperty("exo:lastModifier").getString());
                infectedNodes.add(infectedNode);
                long endTime = System.currentTimeMillis();
                LOGGER.info("service={} operation={} parameters=\"jcrNodeIdentifier:{}\" \"jcrNodeName:{}\" \"jcrNodeLastModifier:{}\" status=ok duration_ms={}", new Object[]{"malware-detection", MALWARE_INFECTED_JCR_NODE_DETECTION, ((NodeImpl)infectedJcrNode).getIdentifier(), infectedJcrNode.getName(), infectedJcrNode.getProperty("exo:lastModifier").getString(), endTime - startTime});
            }
        }
        catch (ItemNotFoundException e) {
            long endTime = System.currentTimeMillis();
            LOGGER.warn("service={} operation={} parameters=\"infectedJcrNodePath:{}\" status=ko duration_ms={} error_msg=\"The jcr node may be already cleaned by a previous malware detection operation:{}\"", new Object[]{"malware-detection", MALWARE_INFECTED_JCR_NODE_DETECTION, infectedJcrNodePath, endTime - startTime});
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            LOGGER.error("service={} operation={} parameters=\"infectedJcrNodePath:{}\" status=ko duration_ms={} error_msg=\"Error when trying to get the infected jcr node information:{}\"", new Object[]{"malware-detection", MALWARE_INFECTED_JCR_NODE_DETECTION, infectedJcrNodePath, endTime - startTime, e});
        }
        return infectedNodes;
    }

    @Override
    public boolean canProcessInfectedItem(String infectedJcrNodePath) {
        String infectedJcrNodePathSeparator = MalwareDetectionJcrConnector.getPathSeparator(infectedJcrNodePath);
        return infectedJcrNodePath.contains(infectedJcrNodePathSeparator + JCR + infectedJcrNodePathSeparator + VALUES + infectedJcrNodePathSeparator);
    }

    @Override
    public void cleanInfectedItem(Map<String, String> infectedItem) {
        long startTime = System.currentTimeMillis();
        try {
            ExtendedSession session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession(infectedItem.get(INFECTED_JCR_NODE_WORKSPACE), this.repositoryService.getCurrentRepository());
            Node infectedJcrNode = session.getNodeByIdentifier(infectedItem.get("infectedItemId"));
            infectedJcrNode.remove();
            session.save();
            long endTime = System.currentTimeMillis();
            LOGGER.info("service={} operation={} parameters=\"jcrNodeIdentifier:{}\" \"jcrNodeName:{}\" status=ok duration_ms={}", new Object[]{"malware-detection", MALWARE_INFECTED_JCR_NODE_CLEAN, infectedItem.get("infectedItemId"), infectedItem.get("infectedItemName"), endTime - startTime});
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            LOGGER.error("service={} operation={} parameters=\"jcrNodeIdentifier:{}\" \"jcrNodeName:{}\" status=ko duration_ms={} error_msg\"Error when trying to clean the infected jcr node:{}\"", new Object[]{"malware-detection", MALWARE_INFECTED_JCR_NODE_CLEAN, infectedItem.get("infectedItemId"), infectedItem.get("infectedItemName"), endTime - startTime, e});
        }
    }

    private String getJcrNodeIdentifier(String infectedJcrNodePath) {
        String infectedJcrNodeIdentifier = StringUtils.substringAfter((String)infectedJcrNodePath, (String)PORTAL_CONTAINER);
        String infectedJcrNodePathSeparator = MalwareDetectionJcrConnector.getPathSeparator(infectedJcrNodePath);
        infectedJcrNodeIdentifier = StringUtils.substringBeforeLast((String)infectedJcrNodeIdentifier, (String)infectedJcrNodePathSeparator);
        return StringUtils.remove((String)infectedJcrNodeIdentifier, (String)infectedJcrNodePathSeparator);
    }

    private String getJcrNodeWorkspace(String infectedJcrNodePath) {
        return StringUtils.substringBetween((String)infectedJcrNodePath, (String)(VALUES + MalwareDetectionJcrConnector.getPathSeparator(infectedJcrNodePath)), (String)PORTAL_CONTAINER);
    }
}

