/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.connector;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;

public abstract class MalwareDetectionItemConnector
extends BaseComponentPlugin {
    public static final String INFECTED_ITEM_NAME = "infectedItemName";
    public static final ArgumentLiteral<String> INFECTED_ITEM_NAME_ARGUMENT = new ArgumentLiteral(String.class, "infectedItemName");
    public static final String INFECTED_ITEM_LAST_MODIFIER = "infectedItemLastModifier";
    public static final ArgumentLiteral<String> INFECTED_ITEM_LAST_MODIFIER_ARGUMENT = new ArgumentLiteral(String.class, "infectedItemLastModifier");
    public static final String INFECTED_ITEM_ID = "infectedItemId";
    public static final String INFECTED_ITEM_MODIFICATION_DATE = "infectedItemModificationDate";
    private String type;
    private boolean enable = true;
    protected static final String MALWARE_DETECTION_FEATURE = "malware-detection";
    private static final String MALWARE_DETECTION_PLUGIN_ID = "MalwareDetectionPlugin";
    private static final String SLASH_SEPARATOR = "/";
    private static final String BACK_SLASH_SEPARATOR = "\\";

    public MalwareDetectionItemConnector(InitParams initParams) {
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.type = param.getProperty("type");
        if (StringUtils.isNotBlank((CharSequence)param.getProperty("enable"))) {
            this.setEnable(Boolean.parseBoolean(param.getProperty("enable")));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void processInfectedItem(String infectedItemPath) {
        for (Map<String, String> infectedItem : this.getInfectedItems(infectedItemPath)) {
            this.sendInfectedItemNotification(infectedItem);
            this.cleanInfectedItem(infectedItem);
        }
    }

    public abstract boolean canProcessInfectedItem(String var1);

    public abstract List<Map<String, String>> getInfectedItems(String var1);

    public abstract void cleanInfectedItem(Map<String, String> var1);

    protected static String getPathSeparator(String infectedFilePath) {
        String separator = "";
        if (infectedFilePath.contains(SLASH_SEPARATOR)) {
            separator = SLASH_SEPARATOR;
        } else if (infectedFilePath.contains(BACK_SLASH_SEPARATOR)) {
            separator = BACK_SLASH_SEPARATOR;
        }
        return separator;
    }

    private void sendInfectedItemNotification(Map<String, String> infectedItem) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(INFECTED_ITEM_NAME_ARGUMENT, (Object)infectedItem.get(INFECTED_ITEM_NAME));
        ctx.append(INFECTED_ITEM_LAST_MODIFIER_ARGUMENT, (Object)infectedItem.get(INFECTED_ITEM_LAST_MODIFIER));
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)MALWARE_DETECTION_PLUGIN_ID))).execute(ctx);
    }
}

