/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.connector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.antimalware.connector.MalwareDetectionItemConnector;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MalwareDetectionFilesConnector
extends MalwareDetectionItemConnector {
    private static final Log LOGGER = ExoLogger.getExoLogger(MalwareDetectionFilesConnector.class);
    private FileService fileService;
    private static final String FILES = "files";
    private static final String MALWARE_INFECTED_FILE_DETECTION = "malware-infected-file-detection";
    private static final String MALWARE_INFECTED_FILE_CLEAN = "malware-infected-file-clean";

    public MalwareDetectionFilesConnector(InitParams initParams, FileService fileService) {
        super(initParams);
        this.fileService = fileService;
    }

    @Override
    public List<Map<String, String>> getInfectedItems(String infectedFilePath) {
        String fileChecksum = this.getInfectedFileChecksum(infectedFilePath);
        ArrayList<Map<String, String>> infectedFiles = new ArrayList<Map<String, String>>();
        long startTime = System.currentTimeMillis();
        try {
            List infectedFileItems = this.fileService.getFilesByChecksum(fileChecksum);
            for (FileItem infectedFileItem : infectedFileItems) {
                if (infectedFileItem == null || infectedFileItem.getFileInfo() == null || infectedFileItem.getFileInfo().isDeleted()) continue;
                HashMap<String, String> infectedFile = new HashMap<String, String>();
                infectedFile.put("infectedItemId", String.valueOf(infectedFileItem.getFileInfo().getId()));
                infectedFile.put("infectedItemName", infectedFileItem.getFileInfo().getName());
                infectedFile.put("infectedItemLastModifier", infectedFileItem.getFileInfo().getUpdater());
                infectedFile.put("infectedItemModificationDate", String.valueOf(infectedFileItem.getFileInfo().getUpdatedDate().getTime()));
                infectedFiles.add(infectedFile);
                long endTime = System.currentTimeMillis();
                LOGGER.info("service={} operation={} parameters=\"fileId:{}\" \"fileName:{}\" \"fileLastModifier:{}\" status=ok duration_ms={}", new Object[]{"malware-detection", MALWARE_INFECTED_FILE_DETECTION, infectedFileItem.getFileInfo().getId(), infectedFileItem.getFileInfo().getName(), infectedFileItem.getFileInfo().getUpdater(), endTime - startTime});
            }
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            LOGGER.error("service={} operation={} parameters=\"fileChecksum:{}\" status=ko duration_ms={} error_msg=\"Error when trying to get the infected items:{}\"", new Object[]{"malware-detection", MALWARE_INFECTED_FILE_DETECTION, fileChecksum, endTime - startTime, e});
        }
        return infectedFiles;
    }

    @Override
    public boolean canProcessInfectedItem(String infectedFilePath) {
        String infectedFilePathSeparator = MalwareDetectionFilesConnector.getPathSeparator(infectedFilePath);
        return infectedFilePath.contains(infectedFilePathSeparator + FILES + infectedFilePathSeparator);
    }

    @Override
    public void cleanInfectedItem(Map<String, String> infectedItem) {
        long startTime = System.currentTimeMillis();
        this.fileService.deleteFile(Long.parseLong(infectedItem.get("infectedItemId")));
        long endTime = System.currentTimeMillis();
        LOGGER.info("service={} operation={} parameters=\"fileId:{}\" \"fileName:{}\" status=ok duration_ms={}", new Object[]{"malware-detection", MALWARE_INFECTED_FILE_CLEAN, infectedItem.get("infectedItemId"), infectedItem.get("infectedItemName"), endTime - startTime});
    }

    private String getInfectedFileChecksum(String infectedFilePath) {
        String infectedItemPathSeparator = MalwareDetectionFilesConnector.getPathSeparator(infectedFilePath);
        return StringUtils.substringAfterLast((String)infectedFilePath, (String)infectedItemPathSeparator);
    }
}

