/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.service;

import java.util.List;
import org.exoplatform.antimalware.connector.MalwareDetectionConnector;
import org.exoplatform.antimalware.connector.MalwareDetectionItemConnector;
import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MalwareDetectionServiceTest {
    private MalwareDetectionService malwareDetectionService;
    @Mock
    private ListenerService listenerService;

    @Before
    public void setUp() throws Exception {
        this.malwareDetectionService = new MalwareDetectionService(this.listenerService);
    }

    @Test
    public void getDefaultMalwareDetectionConnector() {
        MalwareDetectionConnector malwareDetectionConnector1 = (MalwareDetectionConnector)Mockito.mock(MalwareDetectionConnector.class);
        MalwareDetectionConnector malwareDetectionConnector2 = (MalwareDetectionConnector)Mockito.mock(MalwareDetectionConnector.class);
        Mockito.lenient().when((Object)malwareDetectionConnector1.isDefault()).thenReturn((Object)true);
        this.malwareDetectionService.addMalwareDetectionConnector(malwareDetectionConnector1);
        this.malwareDetectionService.addMalwareDetectionConnector(malwareDetectionConnector2);
        Assert.assertEquals((long)1L, (long)this.malwareDetectionService.getMalwareDetectionConnectors().size());
    }

    @Test
    public void checkAndProcessNewInfectedItems() {
        List<String> infectedItemsPaths = List.of("path1", "path2");
        MalwareDetectionConnector malwareDetectionConnector = (MalwareDetectionConnector)Mockito.mock(MalwareDetectionConnector.class);
        MalwareDetectionItemConnector malwareDetectionItemConnector = (MalwareDetectionItemConnector)Mockito.mock(MalwareDetectionItemConnector.class);
        Mockito.when((Object)malwareDetectionConnector.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)malwareDetectionConnector.getInfectedItemsPaths()).thenReturn(infectedItemsPaths);
        Mockito.when((Object)malwareDetectionItemConnector.getType()).thenReturn((Object)"files");
        Mockito.when((Object)malwareDetectionItemConnector.canProcessInfectedItem(ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.malwareDetectionService.addMalwareDetectionConnector(malwareDetectionConnector);
        this.malwareDetectionService.addMalwareDetectionItemConnector(malwareDetectionItemConnector);
        this.malwareDetectionService.checkAndProcessNewInfectedItems();
        ((MalwareDetectionItemConnector)Mockito.verify((Object)malwareDetectionItemConnector, (VerificationMode)Mockito.times((int)1))).processInfectedItem("path1");
        ((MalwareDetectionItemConnector)Mockito.verify((Object)malwareDetectionItemConnector, (VerificationMode)Mockito.times((int)1))).processInfectedItem("path2");
    }

    @Test
    public void processInfectedItem() {
        String infectedItemPath = "/gatein/data/files/d/e/4/c/e/2/d/7/dedeezd65edrerde673r777";
        MalwareDetectionItemConnector malwareDetectionItemConnector = (MalwareDetectionItemConnector)Mockito.mock(MalwareDetectionItemConnector.class);
        Mockito.when((Object)malwareDetectionItemConnector.getType()).thenReturn((Object)"files");
        this.malwareDetectionService.addMalwareDetectionItemConnector(malwareDetectionItemConnector);
        Mockito.when((Object)malwareDetectionItemConnector.canProcessInfectedItem(ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.malwareDetectionService.processInfectedItem(infectedItemPath);
        ((MalwareDetectionItemConnector)Mockito.verify((Object)malwareDetectionItemConnector, (VerificationMode)Mockito.times((int)1))).processInfectedItem(infectedItemPath);
    }
}

