/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.lock;

import com.sun.japex.TestCase;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EditLockedCommonNodeTest
extends JCRTestBase {
    public static Log log = ExoLogger.getLogger((String)"jcr.benchmark");
    public static boolean rootNodeCreated = false;
    public static boolean rootNodeDeleted = false;
    public static String rootNodeName = "rootLockUnlockCommonNodeTest";

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        this.createRootNode(context);
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        Node rootNode = (Node)context.getSession().getItem("/" + rootNodeName);
        try {
            rootNode.addNode(context.generateUniqueName("node"), "nt:unstructured");
            context.getSession().save();
            throw new RuntimeException("LockException must be here");
        }
        catch (LockException e) {
            try {
                rootNode.setProperty(context.generateUniqueName("property"), context.generateUniqueName("value"));
                context.getSession().save();
                throw new RuntimeException("LockException must be here");
            }
            catch (LockException e2) {
                return;
            }
        }
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.deleteRootNodeForAllThreads(context);
    }

    private synchronized void createRootNode(JCRTestContext context) {
        try {
            if (!rootNodeCreated) {
                Session tmpSession = context.getSession().getRepository().login();
                Node rootNode = tmpSession.getRootNode().addNode(rootNodeName);
                tmpSession.save();
                rootNode.addMixin("mix:lockable");
                tmpSession.save();
                rootNode.lock(true, false);
                tmpSession.logout();
                rootNodeCreated = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private synchronized void deleteRootNodeForAllThreads(JCRTestContext context) {
        try {
            if (!rootNodeDeleted) {
                Session tmpSession = context.getSession().getRepository().login();
                Node rootNode = tmpSession.getRootNode().getNode(rootNodeName);
                rootNode.remove();
                tmpSession.save();
                tmpSession.logout();
                rootNodeDeleted = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

