/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.portal;

import java.util.Random;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.jcr.benchmark.usecases.portal.AbstractWriteAction;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;

public class WritePageAction
extends AbstractWriteAction {
    protected int removeProperties = 0;
    protected int setProperties = 0;
    protected int removeSubNodes = 0;
    protected int addSubNodes = 0;
    private Random random;

    public WritePageAction(RepositoryImpl repository, String workspace, String rootName, int depth, String stringValue, byte[] binaryValue, int multiValueSize, int removeProperties, int setProperties, int removeSubNodes, int addSubNodes) {
        super(repository, workspace, rootName, depth, stringValue, binaryValue, multiValueSize);
        this.removeProperties = removeProperties;
        this.setProperties = setProperties;
        this.removeSubNodes = removeSubNodes;
        this.addSubNodes = addSubNodes;
        this.random = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() throws RepositoryException {
        Session session = null;
        try {
            NodeIterator iterator;
            int i;
            int i2;
            session = this.getSession(false);
            Node testRoot = session.getRootNode().getNode(this.getRootNodeName());
            Node node = this.nextNode(testRoot);
            for (i2 = 0; i2 < this.removeProperties && node.getProperties().getSize() >= 2L; ++i2) {
                String propName = null;
                while (!node.hasProperty(propName = this.nextPropertyName())) {
                }
                node.getProperty(propName).remove();
            }
            for (i2 = 0; i2 < this.setProperties; ++i2) {
                int propType = this.random.nextInt(9) + 1;
                boolean isMultivalued = this.random.nextBoolean();
                String propName = PropertyType.nameFromValue((int)propType) + (isMultivalued ? "-m" : "-s");
                Value[] values = this.createValues(node, propType, isMultivalued, session.getValueFactory());
                if (isMultivalued) {
                    node.setProperty(propName, values, propType);
                    continue;
                }
                node.setProperty(propName, values[0], propType);
            }
            Node parentNode = this.nextParent(testRoot);
            for (i = 0; i < this.removeSubNodes && (iterator = parentNode.getNodes()).hasNext(); ++i) {
                iterator.skip((long)this.random.nextInt((int)iterator.getSize()));
                iterator.nextNode().remove();
            }
            for (i = 0; i < this.addSubNodes; ++i) {
                this.createGenericNode(parentNode, session.getValueFactory());
            }
            session.save();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

