/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.node.read;

import com.sun.japex.TestCase;
import java.util.Calendar;
import javax.jcr.Node;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public class NodeConcurrentReadTest
extends JCRTestBase {
    private Node root;
    private Node node;
    private int iterations = 100;
    private Writer writer;

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        super.doFinish(tc, context);
        this.writer.destroy();
        this.node.remove();
        context.getSession().save();
    }

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        super.doPrepare(tc, context);
        this.root = context.getSession().getRootNode().addNode(context.generateUniqueName("testRoot"));
        this.node = this.root.addNode(context.generateUniqueName("testConcurentNode"));
        this.writer = new Writer();
        this.writer.start();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        try {
            for (int i = 0; i < this.iterations; ++i) {
                this.node.getProperty("name");
                this.node.getProperty("date");
                this.node.getProperty("time");
                this.node.getProperties();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Writer
    extends Thread {
        Writer() {
        }

        public void run() {
            try {
                for (int i = 0; i < NodeConcurrentReadTest.this.iterations; ++i) {
                    NodeConcurrentReadTest.this.node.setProperty("name", this.getName());
                    NodeConcurrentReadTest.this.node.setProperty("date", Calendar.getInstance());
                    NodeConcurrentReadTest.this.node.setProperty("time", System.currentTimeMillis());
                    this.wait(100L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

