/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.organization;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.organization.AbstractOrganizationTest;
import org.exoplatform.services.organization.Group;

public abstract class AbstractGroupTest
extends AbstractOrganizationTest {
    private List<Group> groups;
    private int index = 0;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int warmUpIterations;
        super.doPrepare(tc, context);
        int runIterations = tc.getIntParam("japex.runIterations");
        if (tc.hasParam("japex.warmupIterations") && (warmUpIterations = tc.getIntParam("japex.warmupIterations")) > 0) {
            runIterations += warmUpIterations;
        }
        this.groups = new ArrayList<Group>();
        for (int i = 0; i < runIterations; ++i) {
            Group group = this.gHandler.createGroupInstance();
            group.setGroupName(context.generateUniqueName("group"));
            group.setLabel(context.generateUniqueName("label"));
            this.groups.add(group);
        }
    }

    protected void createContent() throws Exception {
        for (Group g : this.groups) {
            this.gHandler.createGroup(g, false);
        }
    }

    protected Group nextGroup() {
        return this.groups.get(this.index++);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        for (Group g : this.groups) {
            Group group = this.gHandler.findGroupById("/" + g.getGroupName());
            if (group == null) continue;
            this.gHandler.removeGroup(group, false);
        }
        this.groups.clear();
        this.groups = null;
        super.doFinish(tc, context);
    }
}

