/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractMoveUsecaseTest
extends JCRTestBase {
    protected static final int START_YEAR = 2005;
    protected static Log LOG = ExoLogger.getLogger((String)"AbstractMoveUsecaseTest");
    protected Node rootNode = null;
    private volatile int iteration = 0;

    protected Node nextNode() throws PathNotFoundException, RepositoryException {
        return this.rootNode.getNode("iter" + this.iteration++);
    }

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int nodesCount;
        int warmUpIterations;
        long start = System.currentTimeMillis();
        this.rootNode = context.getSession().getRootNode();
        context.getSession().save();
        int runIterations = tc.getIntParam("japex.runIterations");
        if (tc.hasParam("japex.warmupIterations") && (warmUpIterations = tc.getIntParam("japex.warmupIterations")) > 0) {
            runIterations += warmUpIterations;
        }
        if ((nodesCount = tc.getIntParam("usecase.nodesCount")) <= 0) {
            throw new Exception("usecase.nodesCount should be a positive number, but " + nodesCount);
        }
        boolean addMeatadata = tc.getBooleanParam("usecase.addMeatadata");
        Random rndYear = new Random();
        Random rndMonth = new Random();
        Random rndDay = new Random();
        for (int i = 0; i < runIterations; ++i) {
            Node iterRoot = this.rootNode.addNode("iter" + i);
            this.rootNode.save();
            long istart = System.currentTimeMillis();
            for (int n = 0; n < nodesCount; ++n) {
                Calendar fileDate = Calendar.getInstance();
                fileDate.set(1, 2005 + rndYear.nextInt(1));
                fileDate.set(2, rndMonth.nextInt(11));
                fileDate.set(5, 1 + rndDay.nextInt(29));
                Node file = iterRoot.addNode("file." + i + "-" + n, "nt:file");
                Node fres = file.addNode("jcr:content", "nt:resource");
                fres.setProperty("jcr:encoding", "UTF-8");
                fres.setProperty("jcr:mimeType", "text/pdf");
                fres.setProperty("jcr:lastModified", fileDate);
                fres.setProperty("jcr:data", (InputStream)new FileInputStream("../resources/benchmark-tiff.pdf"));
                if (addMeatadata) {
                    file.addMixin("dc:elementSet");
                    file.setProperty("dc:title", new String[]{"Document #" + i + "-" + n});
                    file.setProperty("dc:creator", new String[]{this.toString()});
                    file.setProperty("dc:contributor", new String[]{"Contributor #" + i});
                    file.setProperty("dc:date", new Value[]{this.rootNode.getSession().getValueFactory().createValue(fileDate)});
                    file.setProperty("dc:language", new String[]{"EN"});
                    file.setProperty("dc:rights", new String[]{"eXo Platform SAS, UA"});
                }
                iterRoot.save();
            }
            LOG.info((Object)("Prepare of iteration " + i + " done " + (System.currentTimeMillis() - istart) + "ms"));
        }
        this.rootNode.addNode("catalog");
        this.rootNode.save();
        LOG.info((Object)("Prepare done " + (System.currentTimeMillis() - start) + "ms"));
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        long start = System.currentTimeMillis();
        LOG.info((Object)("Finish done. Nodes in workspace. " + (System.currentTimeMillis() - start) + "ms"));
    }
}

