/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public class MultiWriteTest
extends JCRTestBase {
    private static final int SIZE = 10240;
    private static final int BLOCK_SIZE = 1024;
    static int threadnum = 0;
    private Node parent;
    private Property prop;
    private File file;
    int curnum;

    private InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        this.curnum = threadnum++;
        this.file = File.createTempFile("Thread", "_" + this.curnum);
        FileOutputStream out = new FileOutputStream(this.file);
        byte[] buf = this.createBuf(1024, String.valueOf(this.curnum));
        for (int j = 0; j < 10240; ++j) {
            ((OutputStream)out).write(buf);
        }
        ((OutputStream)out).close();
        System.out.println(this.file.getAbsolutePath() + "   added");
        Session session = context.getSession();
        Node rootNode = session.getRootNode();
        if (rootNode.hasNode("parentNode")) {
            this.parent = rootNode.getNode("parentNode");
            System.out.println(this.curnum + " get node");
        } else {
            this.parent = rootNode.addNode("parentNode");
            session.save();
            System.out.println(this.curnum + " ADD node");
        }
        if (this.parent.hasProperty("prop")) {
            this.prop = this.parent.getProperty("prop");
            System.out.println(this.curnum + " get prop");
        } else {
            File f = File.createTempFile("Thread", "_first");
            out = new FileOutputStream(f);
            buf = this.createBuf(1024, "a");
            for (int j = 0; j < 10240; ++j) {
                ((OutputStream)out).write(buf);
            }
            ((OutputStream)out).close();
            System.out.println(f.getAbsolutePath() + "   added");
            this.prop = this.parent.setProperty("prop", (InputStream)new FileInputStream(f));
            session.save();
            System.out.println(this.curnum + " ADD prop");
        }
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        try {
            System.out.println("doRun " + this.curnum);
            this.prop.setValue(this.getStream());
            this.parent.save();
            System.out.println(" save finished " + this.curnum);
        }
        catch (Exception e) {
            System.out.println("====================" + this.curnum + " thread : ");
            e.printStackTrace();
        }
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        Session ses = context.getSession();
        ses.refresh(false);
        InputStream in = ses.getRootNode().getNode("parentNode").getProperty("prop").getStream();
        byte[] buf = new byte[4];
        in.read(buf);
        in.close();
        System.out.println(this.curnum + " - " + new String(buf));
    }

    private byte[] createBuf(int size, String val) {
        byte[] s = val.getBytes();
        byte[] buf = new byte[s.length * size];
        for (int i = 0; i < buf.length; i += s.length) {
            System.arraycopy(s, 0, buf, i, s.length);
        }
        return buf;
    }
}

