/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public class NodeConcurrentReadTest
extends JCRTestBase {
    private static String testRootPath = null;
    private Repository repo;
    private Credentials credentials;
    private String workspace;
    private static volatile int nodes = 0;
    private static Map<Integer, String> nodeNames = new ConcurrentHashMap<Integer, String>();
    private static volatile boolean writersActive = true;
    private static List<Writer> writersList = new ArrayList<Writer>();
    private static volatile long counter = 0L;
    private static volatile long threads = 0L;
    private JCRTestContext context = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        super.doPrepare(tc, context);
        this.repo = context.getSession().getRepository();
        this.workspace = context.getSession().getWorkspace().getName();
        this.credentials = context.getCredentials();
        this.context = context;
        List<Writer> list = writersList;
        synchronized (list) {
            if (writersList.size() == 0) {
                System.out.println();
                System.out.println("========= prepare test =========");
                Node testRoot = context.getSession().getRootNode().addNode("testRoot");
                context.getSession().save();
                testRootPath = testRoot.getPath();
                nodes = tc.hasParam("exo.numberOfNodes") ? tc.getIntParam("exo.numberOfNodes") : 100;
                System.out.println("exo.numberOfNodes " + nodes);
                for (int i = 0; i < nodes; ++i) {
                    String parentName = context.generateUniqueName("parent");
                    Node parent = testRoot.addNode(parentName);
                    parent.setProperty("testProp", "testVal");
                    context.getSession().save();
                    nodeNames.put(i, parentName);
                }
                int writers = tc.hasParam("exo.numberOfWriters") ? tc.getIntParam("exo.numberOfWriters") : 1;
                long pause = tc.hasParam("exo.writerPause") ? (long)tc.getIntParam("exo.writerPause") : 50L;
                System.out.println("exo.numberOfWriters " + writers);
                System.out.println("exo.writerPause " + pause);
                for (int i = 0; i < writers; ++i) {
                    Writer w = new Writer(pause);
                    writersList.add(w);
                    w.start();
                }
                System.out.println("===================================");
            }
        }
        ++threads;
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        Session session = context.getSession();
        Node readNode = ((Node)session.getItem(testRootPath)).getNode(nodeNames.get(new Random().nextInt(nodes)));
        readNode.getProperty("testProp").getValue().getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        writersActive = false;
        List<Writer> list = writersList;
        synchronized (list) {
            if (writersList.size() > 0) {
                String msg = "Ran readers " + threads + " writers " + writersList.size();
                System.out.print("Finishing... ");
                System.out.print("stopping writers... ");
                for (Writer w : writersList) {
                    w.join(1000L);
                }
                writersList.clear();
                System.out.println("done.");
                System.out.println(msg);
            }
        }
        super.doFinish(tc, context);
    }

    private class Writer
    extends Thread {
        private final Session session;
        private final long pause;

        Writer(long pause) throws LoginException, RepositoryException {
            this.session = NodeConcurrentReadTest.this.repo.login(NodeConcurrentReadTest.this.credentials, NodeConcurrentReadTest.this.workspace);
            this.pause = pause;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            super.run();
            try {
                Node root = (Node)this.session.getItem(testRootPath);
                while (writersActive) {
                    String name = NodeConcurrentReadTest.this.context.generateUniqueName(this.getName());
                    Node writeNode = root.addNode(name);
                    writeNode.setProperty("testProp", this.getName());
                    this.session.save();
                    nodeNames.put(nodeNames.size(), name);
                    if (this.pause > 0L) {
                        Thread.sleep(this.pause);
                    }
                    Thread.yield();
                    nodes++;
                }
            }
            catch (Exception e) {
                log.error((Object)("Writer stopped: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.session.logout();
            }
        }
    }
}

