/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.versioning;

import com.sun.japex.TestCase;
import java.sql.Connection;
import java.util.ArrayList;
import javax.jcr.Node;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CheckinCheckoutOwnNodeCleanDBOracleTest
extends JCRTestBase {
    public static Log log = ExoLogger.getLogger((String)"jcr.benchmark");
    public static WorkspaceStorageConnection workspaceStorageConnection = null;
    public static boolean dataBaseDropped = false;
    private Node rootNode = null;
    private String name = "";

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        this.name = context.generateUniqueName("rootNode");
        this.rootNode = context.getSession().getRootNode().addNode(this.name);
        this.rootNode.addMixin("mix:versionable");
        context.getSession().save();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        this.rootNode.checkin();
        this.rootNode.checkout();
        this.rootNode.addNode(context.generateUniqueName("child"));
        context.getSession().save();
        this.rootNode.checkin();
        this.rootNode.checkout();
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.cleanDB(context);
    }

    private synchronized void cleanDB(JCRTestContext context) {
        try {
            if (!dataBaseDropped) {
                JDBCWorkspaceDataContainer workspaceDataContainer = (JDBCWorkspaceDataContainer)((SessionImpl)context.getSession()).getContainer().getComponentInstanceOfType(JDBCWorkspaceDataContainer.class);
                workspaceStorageConnection = workspaceStorageConnection == null ? workspaceDataContainer.openConnection() : workspaceDataContainer.reuseConnection(workspaceStorageConnection);
                JDBCStorageConnection storageConnection = (JDBCStorageConnection)workspaceStorageConnection;
                Connection dbConnection = storageConnection.getJdbcConnection();
                ArrayList<String> oracleQueryList = new ArrayList<String>();
                oracleQueryList.add("DROP TABLE jcr_config");
                oracleQueryList.add("DROP TABLE jcr_scontainer");
                oracleQueryList.add("DROP TABLE jcr_svalue");
                oracleQueryList.add("DROP TABLE jcr_sref");
                oracleQueryList.add("DROP TABLE jcr_sitem");
                oracleQueryList.add("DROP SEQUENCE JCR_SVALUE_SEQ");
                for (String query : oracleQueryList) {
                    try {
                        dbConnection.prepareStatement(query).execute();
                    }
                    catch (Exception e) {}
                }
                dbConnection.commit();
                dataBaseDropped = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

