/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.calendar;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.SyndFeedOutput;
import com.rometools.rome.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webservice.cs.bean.EventData;
import org.exoplatform.webservice.cs.bean.SingleEvent;

@Path(value="/cs/calendar")
public class CalendarWebservice
implements ResourceContainer {
    public static final String PRIVATE = "/private";
    public static final String BASE_URL = "/cs/calendar".intern();
    public static final String BASE_RSS_URL = BASE_URL + "/feed".intern();
    public static final String BASE_EVENT_URL = BASE_URL + "/event".intern();
    public static final String BASE_URL_PUBLIC = "/cs/calendar/subscribe/".intern();
    public static final String BASE_URL_PRIVATE = "/private" + BASE_URL + "/".intern();
    private Log log = ExoLogger.getExoLogger(CalendarWebservice.class);
    protected static final CacheControl cc = new CacheControl();
    private CalendarService calendarService = null;
    private ExtendedCalendarService xCalService;

    public CalendarWebservice(CalendarService calendarService, ExtendedCalendarService xCalService) {
        this.calendarService = calendarService;
        this.xCalService = xCalService;
    }

    private boolean validateEventType(String type) {
        return type != null && (CalendarEvent.TYPE_EVENT.equals(type) || CalendarEvent.TYPE_TASK.equals(type));
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/checkPermission/{username}/{calendarId}/{type}/")
    public Response checkPermission(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        EventData eventData = new EventData();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            Calendar cal = null;
            eventData.setPermission(false);
            if (0 == Integer.parseInt(type)) {
                if (this.calendarService.isRemoteCalendar(username, calendarId)) {
                    eventData.setPermission(false);
                } else {
                    eventData.setPermission(true);
                }
            } else if (2 == Integer.parseInt(type)) {
                OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                if (Utils.hasPermission((OrganizationService)oService, (String[])(cal = this.calendarService.getGroupCalendar(calendarId)).getEditPermission(), (String)username)) {
                    eventData.setPermission(true);
                }
            } else if (1 == Integer.parseInt(type) && this.calendarService.getSharedCalendars(username, true) != null && Utils.hasPermission(null, (String[])Utils.getEditPerUsers((Calendar)(cal = this.calendarService.getSharedCalendars(username, true).getCalendarById(calendarId))), (String)username)) {
                eventData.setPermission(true);
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Exception when check permission", (Throwable)e);
            }
            eventData.setPermission(false);
        }
        return Response.ok((Object)eventData, (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/event/{username}/{eventFeedName}/")
    public Response event(@PathParam(value="username") String username, @PathParam(value="eventFeedName") String eventFeedName) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            EventQuery eventQuery;
            CalendarImportExport icalEx = this.calendarService.getCalendarImportExports("ICalendar(.ics)");
            String eventId = eventFeedName.split("splitter")[0];
            String type = eventFeedName.split("splitter")[1].replace(".ics", "");
            CalendarEvent event = null;
            if (type.equals("0")) {
                event = this.calendarService.getEvent(username, eventId);
            } else if (type.equals("1")) {
                eventQuery = new EventQuery();
                eventQuery.setText(eventId);
                event = (CalendarEvent)this.calendarService.getEvents(username, eventQuery, null).get(0);
            } else {
                eventQuery = new EventQuery();
                eventQuery.setText(eventId);
                event = (CalendarEvent)this.calendarService.getPublicEvents(eventQuery).get(0);
            }
            if (event == null) {
                return Response.status((int)404).entity((Object)("Event " + eventId + "is removed")).cacheControl(cacheControl).build();
            }
            ByteArrayOutputStream out = icalEx.exportEventCalendar(event);
            ByteArrayInputStream in = new ByteArrayInputStream(((Object)out).toString().getBytes());
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + eventId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/feed/{username}/{feedname}/{filename}/")
    public Response feed(@PathParam(value="username") String username, @PathParam(value="feedname") String feedname, @PathParam(value="filename") String filename, @Context UriInfo uri) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            FeedData feed = null;
            for (FeedData feedData : this.calendarService.getFeeds(username)) {
                if (!feedData.getTitle().equals(feedname)) continue;
                feed = feedData;
                break;
            }
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream(feed.getContent())));
            ArrayList entries = new ArrayList(syndFeed.getEntries());
            ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
            for (SyndEntry entry : entries) {
                String calendarId = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                ArrayList<String> calendarIds = new ArrayList<String>();
                calendarIds.add(calendarId);
                Calendar calendar = this.calendarService.getUserCalendar(username, calendarId);
                if (calendar != null) {
                    events.addAll(this.calendarService.getUserEventByCalendar(username, calendarIds));
                    continue;
                }
                GroupCalendarData groupData = this.calendarService.getSharedCalendars(username, false);
                Calendar calendar2 = calendar = groupData != null ? groupData.getCalendarById(calendarId) : null;
                if (calendar != null) {
                    events.addAll(this.calendarService.getSharedEventByCalendars(username, calendarIds));
                    continue;
                }
                calendar = this.calendarService.getGroupCalendar(calendarId);
                if (calendar == null) continue;
                EventQuery eventQuery = new EventQuery();
                eventQuery.setCalendarId(calendarIds.toArray(new String[0]));
                events.addAll(this.calendarService.getPublicEvents(eventQuery));
            }
            if (events.size() == 0) {
                return Response.status((int)404).entity((Object)("Feed " + feedname + "is removed")).cacheControl(cacheControl).build();
            }
            return Response.ok((Object)this.makeFeed(username, events, feed, uri), (String)"application/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    protected String makeFeed(String author, List<CalendarEvent> events, FeedData feedData, UriInfo uri) throws Exception {
        URI baseUri = uri.getBaseUri();
        String baseURL = baseUri.getScheme() + "://" + baseUri.getHost() + ":" + Integer.toString(baseUri.getPort());
        String baseRestURL = baseUri.toString();
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(feedData.getTitle());
        feed.setLink(baseURL + feedData.getUrl());
        feed.setDescription(feedData.getTitle());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (CalendarEvent event : events) {
            if (Utils.EVENT_NUMBER > 0 && Utils.EVENT_NUMBER <= entries.size()) break;
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(event.getSummary());
            entry.setLink(baseRestURL + BASE_EVENT_URL + "/" + author + "/" + event.getId() + "splitter" + event.getCalType() + ".ics");
            entry.setAuthor(author);
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(event.getDescription());
            entry.setDescription((SyndContent)description);
            entries.add(entry);
            entry.getEnclosures();
        }
        feed.setEntries(entries);
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        String feedXML = output.outputString((SyndFeed)feed);
        feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
        return feedXML;
    }

    @GET
    @Path(value="/subscribe/{username}/{calendarId}/{type}")
    public Response publicProcess(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            Calendar calendar = null;
            calendar = type.equals("0") ? this.calendarService.getUserCalendar(username, calendarId) : (type.equals("1") ? this.calendarService.getSharedCalendars(username, false).getCalendarById(calendarId) : this.calendarService.getGroupCalendar(calendarId));
            if (calendar == null || Utils.isEmpty((String)calendar.getPublicUrl())) {
                return Response.status((int)423).entity((Object)("Calendar " + calendarId + " is not public access")).cacheControl(cacheControl).build();
            }
            CalendarImportExport icalEx = this.calendarService.getCalendarImportExports("ICalendar(.ics)");
            OutputStream out = icalEx.exportCalendar(username, Arrays.asList(calendarId), type, -1);
            ByteArrayInputStream in = out != null ? new ByteArrayInputStream(out.toString().getBytes()) : null;
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/{username}/{calendarId}/{type}")
    public Response privateProcess(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarImportExport icalEx = this.calendarService.getCalendarImportExports("ICalendar(.ics)");
            OutputStream out = icalEx.exportCalendar(username, Arrays.asList(calendarId), type, -1);
            ByteArrayInputStream in = out != null ? new ByteArrayInputStream(out.toString().getBytes()) : null;
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/events/personal/{type}/{calids}/{from}/{to}/{limit}")
    @Produces(value={"application/json"})
    public Response getEvents(@PathParam(value="type") String type, @PathParam(value="calids") String calids, @PathParam(value="from") long from, @PathParam(value="to") long to, @PathParam(value="limit") long limit) {
        if (!this.validateEventType(type)) {
            return Response.status((int)400).cacheControl(cc).build();
        }
        CalendarService calendarService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (calendarService == null) {
            return Response.status((int)503).cacheControl(cc).build();
        }
        LinkedList<String> calList = new LinkedList<String>();
        for (String s : calids.split(",")) {
            if (s.trim().length() <= 0) continue;
            calList.add(s);
        }
        String username = ConversationState.getCurrent().getIdentity().getUserId();
        EventQuery eventQuery = new EventQuery();
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTimeInMillis(from);
        eventQuery.setFromDate(calendar);
        calendar = java.util.Calendar.getInstance();
        calendar.setTimeInMillis(to);
        eventQuery.setToDate(calendar);
        eventQuery.setEventType(type);
        eventQuery.setLimitedItems(limit);
        eventQuery.setOrderBy(new String[]{"exo:fromDateTime"});
        if (calList.size() > 0) {
            eventQuery.setCalendarId(calList.toArray(new String[calList.size()]));
        }
        try {
            List events = calendarService.getUserEvents(username, eventQuery);
            EventData data = new EventData();
            data.setInfo(events);
            return Response.ok((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE).cacheControl(cc).build();
        }
        catch (Exception e) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)String.format("Getting events for user %s from %s to %s failed", username, from, to), (Throwable)e);
            }
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/getissues/{currentdatetime}/{type}/{limit}")
    public Response upcomingEvent(@PathParam(value="currentdatetime") String currentdatetime, @PathParam(value="type") String type, @PathParam(value="limit") int limit) throws Exception {
        try {
            if (!this.validateEventType(type)) {
                return Response.status((int)400).cacheControl(cc).build();
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            CalendarSetting calSetting = this.calendarService.getCalendarSetting(username);
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
            sf.setTimeZone(DateUtils.getTimeZone((String)calSetting.getTimeZone()));
            Date currentDate = sf.parse(currentdatetime);
            java.util.Calendar fromCal = calSetting.createCalendar(currentDate);
            java.util.Calendar toCal = calSetting.createCalendar(currentDate);
            toCal.add(6, 1);
            toCal.add(13, -1);
            EventQuery eventQuery = new EventQuery();
            eventQuery.setFromDate(fromCal);
            eventQuery.setToDate(toCal);
            eventQuery.setLimitedItems(limit);
            eventQuery.setOrderBy(new String[]{"exo:fromDateTime"});
            eventQuery.setEventType(type);
            EventPageList data = this.calendarService.searchEvent(username, eventQuery, null);
            String timezoneId = calSetting.getTimeZone();
            TimeZone userTimezone = DateUtils.getTimeZone((String)timezoneId);
            int timezoneOffset = userTimezone.getRawOffset() + userTimezone.getDSTSavings();
            if (data == null || data.getAll().isEmpty()) {
                return Response.status((int)204).cacheControl(cc).build();
            }
            EventData eventData = new EventData();
            eventData.setInfo(data.getAll());
            eventData.setUserTimezoneOffset(Integer.toString(timezoneOffset));
            return Response.ok((Object)eventData, (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/updatestatus/{taskid}/{statusid}")
    public Response updateStatus(@PathParam(value="taskid") String taskid, @QueryParam(value="statusid") int statusId) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Update status [%1$s] for task [%2$s] ..............", statusId, taskid));
        }
        try {
            statusId = statusId != 0 ? statusId : 3;
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            String status = CalendarEvent.TASK_STATUS[(statusId - 1) % 4];
            CalendarEvent task = this.calendarService.getEvent(username, taskid);
            if (status.equals(task.getEventState())) {
                return Response.ok((Object)String.format("[%1$s] has been set for task %2$s before!", status, taskid), (String)"application/json").cacheControl(cc).build();
            }
            String calendarId = task.getCalendarId();
            task.setEventState(status);
            this.calendarService.saveUserEvent(username, calendarId, task, false);
            return Response.ok((Object)"true", (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Updating task status failed!", (Throwable)e);
            }
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/getcalendars")
    public Response getCalendars() throws Exception {
        try {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            List calList = this.calendarService.getUserCalendars(username, true);
            EventData data = new EventData();
            data.setCalendars(calList);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    private SingleEvent makeSingleEvent(CalendarSetting calSetting, CalendarEvent cEvent) {
        SingleEvent event;
        block3: {
            if (calSetting == null || cEvent == null) {
                throw new IllegalArgumentException("parameters must be not null");
            }
            event = new SingleEvent();
            event.setDescription(cEvent.getDescription());
            event.setEventState(cEvent.getEventState());
            event.setLocation(cEvent.getLocation());
            event.setPriority(cEvent.getPriority());
            event.setSummary(cEvent.getSummary());
            TimeZone timeZone = DateUtils.getTimeZone((String)calSetting.getTimeZone());
            event.setStartDateTime(cEvent.getFromDateTime().getTime());
            event.setStartTimeOffset(timeZone.getOffset(cEvent.getFromDateTime().getTime()));
            event.setEndDateTime(cEvent.getToDateTime().getTime());
            event.setEndTimeOffset(timeZone.getOffset(cEvent.getToDateTime().getTime()));
            event.setDateFormat(calSetting.getDateFormat());
            event.setOccurrence(cEvent.getIsExceptionOccurrence() != null);
            try {
                event.setVirtual(Utils.isExceptionOccurrence((CalendarEvent)cEvent));
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.info((Object)e);
            }
        }
        event.setEvent(CalendarEvent.TYPE_EVENT.equals(cEvent.getEventType()));
        return event;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/getevent/{eventid}")
    public Response getEvent(@PathParam(value="eventid") String eventid) throws Exception {
        try {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            CalendarEvent calEvent = this.calendarService.getEvent(username, eventid);
            CalendarSetting calSetting = this.calendarService.getCalendarSetting(username);
            if (calEvent.getAttachment() != null && !calEvent.getAttachment().isEmpty()) {
                calEvent.setAttachment(null);
            }
            SingleEvent data = this.makeSingleEvent(calSetting, calEvent);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/geteventbyid/{eventid}")
    public Response getEventById(@PathParam(value="eventid") String eventid) throws Exception {
        try {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            CalendarEvent calEvent = CalendarEvent.build((Event)this.xCalService.getEventHandler().getEventById(eventid));
            CalendarSetting calSetting = this.calendarService.getCalendarSetting(username);
            if (calEvent.getAttachment() != null && !calEvent.getAttachment().isEmpty()) {
                calEvent.setAttachment(null);
            }
            SingleEvent data = this.makeSingleEvent(calSetting, calEvent);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="getoccurrence/{eventid}/{recurid}")
    public Response getOccurrenceEvent(@PathParam(value="eventid") String eventId, @PathParam(value="recurid") String recurId) throws Exception {
        try {
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            CalendarSetting calSetting = this.calendarService.getCalendarSetting(username);
            String timezoneId = calSetting.getTimeZone();
            TimeZone timezone = DateUtils.getTimeZone((String)timezoneId);
            CalendarEvent orgEvent = this.calendarService.getEventById(eventId);
            SimpleDateFormat sdf = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
            sdf.setTimeZone(timezone);
            Date occurDate = sdf.parse(recurId);
            java.util.Calendar cal = java.util.Calendar.getInstance(timezone);
            cal.setTime(occurDate);
            java.util.Calendar from = Utils.getBeginDay((java.util.Calendar)cal);
            java.util.Calendar to = Utils.getEndDay((java.util.Calendar)cal);
            Map occMap = this.calendarService.getOccurrenceEvents(orgEvent, from, to, timezoneId);
            CalendarEvent occEvent = (CalendarEvent)occMap.get(recurId);
            occEvent.setIsExceptionOccurrence(Boolean.valueOf(false));
            SingleEvent data = this.makeSingleEvent(calSetting, occEvent);
            data.setOccurrence(true);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    @GET
    @Path(value="/invitation/{calendarId}/{calType}/{eventId}/{inviter}/{invitee}/{eXoId}/{answer}")
    public Response processInvitationReply(@PathParam(value="calendarId") String calendarId, @PathParam(value="calType") String calType, @PathParam(value="eventId") String eventId, @PathParam(value="inviter") String inviter, @PathParam(value="invitee") String invitee, @PathParam(value="eXoId") String eXoId, @PathParam(value="answer") String answer, @Context HttpHeaders headers, @QueryParam(value="lang") String language) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            String userId = eXoId.equals("null") ? null : eXoId;
            int ans = Integer.parseInt(answer);
            Locale locale = Locale.ENGLISH;
            List acceptableLanguages = headers.getAcceptableLanguages();
            if (!acceptableLanguages.isEmpty()) {
                locale = (Locale)acceptableLanguages.get(0);
            }
            if (language != null && !language.isEmpty()) {
                locale = LocaleContextInfo.getLocale((String)language);
            } else if (userId != null) {
                OrganizationService organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
                UserProfile profile = organizationService.getUserProfileHandler().findUserProfileByName(userId);
                String string = language = profile == null ? null : profile.getAttribute("user.language");
                if (language != null && !language.isEmpty()) {
                    locale = LocaleContextInfo.getLocale((String)language);
                }
            }
            ResourceBundleService resourceBundleService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
            ResourceBundle resource = resourceBundleService.getResourceBundle("locale.rest.calendar.CalendarRest", locale);
            this.calendarService.confirmInvitation(inviter, invitee, userId, Integer.parseInt(calType), calendarId, eventId, ans);
            String title = null;
            String message = null;
            String messageKey = "";
            String defaultMessage = "";
            switch (ans) {
                case 1: {
                    messageKey = "rest.invitation.answer.accept";
                    defaultMessage = "You have accepted invitation from {0}";
                    break;
                }
                case 0: {
                    messageKey = "rest.invitation.answer.deny";
                    defaultMessage = "You have refused invitation from {0}";
                    break;
                }
                case 2: {
                    messageKey = "rest.invitation.answer.notsure";
                    defaultMessage = "You have answered invitation from {0}: Not sure!";
                }
            }
            try {
                title = resource.getString("rest.invitation.answer.title");
            }
            catch (Exception ex) {
                title = "Invitation Answer";
            }
            try {
                message = resource.getString(messageKey);
            }
            catch (Exception ex) {
                message = defaultMessage;
            }
            message = message.replace("{0}", inviter);
            StringBuffer response = new StringBuffer();
            response.append("<html><head><title>");
            response.append(title);
            response.append("</title></head>");
            response.append("<body>");
            response.append(message);
            response.append("</body></html>");
            return Response.ok((Object)response.toString(), (String)"text/html").header("Content-Type", (Object)"text/html; charset=UTF-8").cacheControl(cc).build();
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage());
            }
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    static {
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

