/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.List;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(NewUserListener.class);
    public static final String CALENDAR_CATEGORY = "defaultCalendarCategory".intern();
    public static final String CALENDAR_NAME = "defaultCalendar".intern();
    public static final String EVENT_CATEGORIES = "defaultEventCategories".intern();
    public static final String COMA = ",".intern();
    public static String DEFAULTGROUP = "default".intern();
    public static String ADDRESSESGROUP = "addresses".intern();
    public static String ADDRESSESGROUPNAME = "collected-email-adresses".intern();
    public static String DEFAULTGROUPNAME = "My contacts".intern();
    public static String DEFAULTGROUPDES = "Default address book".intern();
    public static final String ST_VIEW_TYPE = "viewType".intern();
    public static final String ST_TIME_INTEVAL = "timeInterval".intern();
    public static final String ST_WEEK_START = "weekStartOn".intern();
    public static final String ST_DATE_FORMAT = "dateFormat".intern();
    public static final String ST_TIME_FORMAT = "timeFormat".intern();
    public static final String ST_LOCALE = "localeId".intern();
    public static final String ST_TIMEZONE = "timezoneId".intern();
    public static final String ST_BASE_URL = "baseUrlForRss".intern();
    public static final String ST_WORKINGTIME = "isShowWorkingTime".intern();
    public static final String ST_TIME_BEGIN = "workingTimeBegin".intern();
    public static final String ST_TIME_END = "workingTimeEnd".intern();
    public static final String ST_USER_IGNORE = "ignoredUsers".intern();
    public static final String DEFAULT_CALENDAR_CATEGORYID = "defaultCalendarCategoryId";
    public static final String DEFAULT_CALENDAR_ID = "defaultCalendarId";
    public static final String DEFAULT_CALENDAR_CATEGORYNAME = "defaultCalendarCategoryName";
    public static final String DEFAULT_CALENDAR_NAME = "defaultCalendarName";
    public static final String DEFAULT_EVENTCATEGORY_ID_ALL = "defaultEventCategoryIdAll";
    public static final String DEFAULT_EVENTCATEGORY_ID_MEETING = "defaultEventCategoryIdMeeting";
    public static final String DEFAULT_EVENTCATEGORY_ID_CALLS = "defaultEventCategoryIdCalls";
    public static final String DEFAULT_EVENTCATEGORY_ID_CLIENTS = "defaultEventCategoryIdClients";
    public static final String DEFAULT_EVENTCATEGORY_ID_HOLIDAY = "defaultEventCategoryIdHoliday";
    public static final String DEFAULT_EVENTCATEGORY_ID_ANNIVERSARY = "defaultEventCategoryIdAnniversary";
    private static final String[] DEFAULT_EVENT_CATEGORY_IDS = new String[]{"defaultEventCategoryIdAll", "defaultEventCategoryIdMeeting", "defaultEventCategoryIdCalls", "defaultEventCategoryIdClients", "defaultEventCategoryIdHoliday", "defaultEventCategoryIdAnniversary"};
    public static String[] defaultEventCategoryIds = DEFAULT_EVENT_CATEGORY_IDS;
    public static final String DEFAULT_EVENTCATEGORY_NAME_ALL = "defaultEventCategoryNameAll";
    public static final String DEFAULT_EVENTCATEGORY_NAME_MEETING = "defaultEventCategoryNameMeeting";
    public static final String DEFAULT_EVENTCATEGORY_NAME_CALLS = "defaultEventCategoryNameCalls";
    public static final String DEFAULT_EVENTCATEGORY_NAME_CLIENTS = "defaultEventCategoryNameClients";
    public static final String DEFAULT_EVENTCATEGORY_NAME_HOLIDAY = "defaultEventCategoryNameHoliday";
    public static final String DEFAULT_EVENTCATEGORY_NAME_ANNIVERSARY = "defaultEventCategoryNameAnniversary";
    private static final String[] DEFAULT_EVENT_CATEGORY_NAMES = new String[]{"defaultEventCategoryNameAll", "defaultEventCategoryNameMeeting", "defaultEventCategoryNameCalls", "defaultEventCategoryNameClients", "defaultEventCategoryNameHoliday", "defaultEventCategoryNameAnniversary"};
    public static String[] defaultEventCategoryNames = DEFAULT_EVENT_CATEGORY_NAMES;
    private CalendarService cservice_;
    public static String defaultCalendarCategoryId = "defaultCalendarCategoryId";
    public static String defaultCalendarCategoryName = "defaultCalendarCategoryName";
    public static String defaultCalendarId = "defaultCalendarId";
    public static String defaultCalendarName = "defaultCalendarName";
    private List<String> ignore_users_;
    private CalendarSetting defaultCalendarSetting_;

    public NewUserListener() {
    }

    public NewUserListener(CalendarService cservice, InitParams params) throws Exception {
        ValuesParam ignoredUsers;
        this.cservice_ = cservice;
        if (params.getValueParam(CALENDAR_CATEGORY) != null) {
            defaultCalendarCategoryId = params.getValueParam(CALENDAR_CATEGORY).getValue().trim();
            defaultCalendarCategoryName = defaultCalendarCategoryId.equals(DEFAULT_CALENDAR_CATEGORYID) ? DEFAULT_CALENDAR_CATEGORYNAME : defaultCalendarCategoryId;
        } else {
            LOG.warn((Object)"Config for Default calendar category does not exist!");
        }
        if (params.getValueParam(CALENDAR_NAME) != null) {
            defaultCalendarId = params.getValueParam(CALENDAR_NAME).getValue().trim();
            defaultCalendarName = defaultCalendarId.equals(DEFAULT_CALENDAR_ID) ? DEFAULT_CALENDAR_NAME : defaultCalendarId;
        } else {
            LOG.warn((Object)"Config for Default calendar does not exist!");
        }
        if (params.getValueParam(EVENT_CATEGORIES) != null) {
            String eventCategoryConfig = params.getValueParam(EVENT_CATEGORIES).getValue();
            String[] configValue = eventCategoryConfig.split(COMA);
            defaultEventCategoryIds = new String[configValue.length + 1];
            defaultEventCategoryNames = new String[defaultEventCategoryIds.length];
            NewUserListener.defaultEventCategoryIds[0] = DEFAULT_EVENTCATEGORY_ID_ALL;
            NewUserListener.defaultEventCategoryNames[0] = DEFAULT_EVENTCATEGORY_NAME_ALL;
            for (int i = 0; i < configValue.length; ++i) {
                NewUserListener.defaultEventCategoryIds[i + 1] = configValue[i].trim();
                int defaultEventCategoryIndex = -1;
                for (int j = 0; j < DEFAULT_EVENT_CATEGORY_IDS.length; ++j) {
                    if (!DEFAULT_EVENT_CATEGORY_IDS[j].equals(defaultEventCategoryIds[i + 1])) continue;
                    defaultEventCategoryIndex = j;
                    break;
                }
                NewUserListener.defaultEventCategoryNames[i + 1] = defaultEventCategoryIndex > -1 ? DEFAULT_EVENT_CATEGORY_NAMES[defaultEventCategoryIndex] : configValue[i].trim();
            }
        } else {
            LOG.warn((Object)"Config for Default event categories does not exist!");
        }
        this.defaultCalendarSetting_ = new CalendarSetting();
        if (params.getValueParam(ST_VIEW_TYPE) != null) {
            this.defaultCalendarSetting_.setViewType(params.getValueParam(ST_VIEW_TYPE).getValue());
        } else {
            this.defaultCalendarSetting_.setViewType(CalendarSetting.WORKING_VIEW);
        }
        if (params.getValueParam(ST_WEEK_START) != null) {
            this.defaultCalendarSetting_.setWeekStartOn(params.getValueParam(ST_WEEK_START).getValue());
        }
        if (params.getValueParam(ST_DATE_FORMAT) != null) {
            this.defaultCalendarSetting_.setDateFormat(params.getValueParam(ST_DATE_FORMAT).getValue());
        }
        if (params.getValueParam(ST_TIME_FORMAT) != null) {
            this.defaultCalendarSetting_.setTimeFormat(params.getValueParam(ST_TIME_FORMAT).getValue());
        }
        if (params.getValueParam(ST_LOCALE) != null) {
            this.defaultCalendarSetting_.setLocation(params.getValueParam(ST_LOCALE).getValue());
        }
        if (params.getValueParam(ST_TIMEZONE) != null) {
            this.defaultCalendarSetting_.setTimeZone(params.getValueParam(ST_TIMEZONE).getValue());
        }
        if (params.getValueParam(ST_BASE_URL) != null) {
            this.defaultCalendarSetting_.setBaseURL(params.getValueParam(ST_BASE_URL).getValue());
        }
        if (params.getValueParam(ST_WORKINGTIME) != null) {
            this.defaultCalendarSetting_.setShowWorkingTime(Boolean.parseBoolean(params.getValueParam(ST_WORKINGTIME).getValue()));
            if (this.defaultCalendarSetting_.isShowWorkingTime()) {
                if (params.getValueParam(ST_TIME_BEGIN) != null) {
                    this.defaultCalendarSetting_.setWorkingTimeBegin(params.getValueParam(ST_TIME_BEGIN).getValue());
                } else {
                    this.defaultCalendarSetting_.setWorkingTimeBegin("09:00");
                }
                if (params.getValueParam(ST_TIME_END) != null) {
                    this.defaultCalendarSetting_.setWorkingTimeEnd(params.getValueParam(ST_TIME_END).getValue());
                } else {
                    this.defaultCalendarSetting_.setWorkingTimeEnd("18:00");
                }
            }
        } else {
            this.defaultCalendarSetting_.setShowWorkingTime(true);
            if (params.getValueParam(ST_TIME_BEGIN) != null) {
                this.defaultCalendarSetting_.setWorkingTimeBegin(params.getValueParam(ST_TIME_BEGIN).getValue());
            } else {
                this.defaultCalendarSetting_.setWorkingTimeBegin("09:00");
            }
            if (params.getValueParam(ST_TIME_END) != null) {
                this.defaultCalendarSetting_.setWorkingTimeEnd(params.getValueParam(ST_TIME_END).getValue());
            } else {
                this.defaultCalendarSetting_.setWorkingTimeEnd("18:00");
            }
        }
        if ((ignoredUsers = params.getValuesParam(ST_USER_IGNORE)) != null && !ignoredUsers.getValues().isEmpty()) {
            this.ignore_users_ = ignoredUsers.getValues();
        }
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        if (this.ignore_users_ != null && !this.ignore_users_.isEmpty()) {
            for (String u : this.ignore_users_) {
                if (!user.getUserName().equalsIgnoreCase(u)) continue;
                return;
            }
        }
        try {
            this.cservice_.initNewUser(user.getUserName(), this.defaultCalendarSetting_);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to initialize calendar account for " + user.getUserName()));
        }
    }

    public void preDelete(User user) throws Exception {
        block2: {
            try {
                this.cservice_.removeSharedCalendarFolder(user.getUserName());
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)("Exception occurs when trying to remove shared calendar folder of this user: " + user.getUserName()), (Throwable)e);
            }
        }
    }
}

