/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.model;

import java.util.Objects;

public class CompositeID {
    private String id;
    private String ds;

    public CompositeID(String id) {
        this(id, null);
    }

    public CompositeID(String id, String ds) {
        this.id = id;
        this.ds = ds;
    }

    public String getId() {
        return this.id;
    }

    public String getDS() {
        return this.ds;
    }

    public boolean equals(Object obj) {
        CompositeID comId;
        if (obj instanceof CompositeID && this.id.equals((comId = (CompositeID)obj).getId())) {
            if (this.ds == null) {
                if (comId.getDS() == null) {
                    return true;
                }
            } else {
                return this.ds.equals(comId.getDS());
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ds);
    }

    public String toString() {
        return this.ds + "::" + this.id;
    }

    public static CompositeID parse(String compositeId) {
        if (compositeId == null) {
            throw new IllegalArgumentException();
        }
        String[] split = compositeId.split("::");
        if (split.length > 1) {
            return new CompositeID(split[1], split[0]);
        }
        return new CompositeID(split[0]);
    }
}

