/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import javax.jcr.query.InvalidQueryException;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.impl.EventDAOImpl;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractEventListAccess<T>
implements ListAccess<T> {
    private static Log log = ExoLogger.getLogger(AbstractEventListAccess.class);
    private EventDAOImpl evtDAO;
    private EventQuery query;
    private Integer size;

    public AbstractEventListAccess(EventDAOImpl evtDAO, EventQuery eventQuery) {
        this.query = eventQuery;
        this.evtDAO = evtDAO;
    }

    protected QueryResultImpl loadData(SessionProvider provider, int offset, int limit) {
        try {
            QueryImpl jcrQuery = this.evtDAO.createJCRQuery(provider, this.query.getQueryStatement(), this.query.getQueryType());
            if (limit > 0) {
                jcrQuery.setOffset((long)offset);
                jcrQuery.setLimit((long)limit);
            }
            QueryResultImpl queryResult = (QueryResultImpl)jcrQuery.execute();
            this.size = queryResult.getTotalSize();
            return queryResult;
        }
        catch (InvalidQueryException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"JCRQuery is invalid", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public abstract T[] load(int var1, int var2) throws Exception;

    public int getSize() throws Exception {
        if (this.size == null) {
            log.debug((Object)"Querying to get Size");
            this.load(0, 0);
        }
        return this.size;
    }
}

