/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import net.fortuna.ical4j.data.ParserException;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCollection;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.RemoteCalendar;
import org.exoplatform.calendar.service.RemoteCalendarService;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarSearchServiceConnector;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.EventSearchConnector;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.calendar.service.impl.UnifiedQuery;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;
import org.exoplatform.calendar.util.CalendarUtils;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;

public class CalendarTestCase
extends BaseCalendarServiceTestCase {
    private RepositoryService repositoryService_;
    private JCRDataStorage storage_;
    private CalendarSearchServiceConnector eventSearchConnector_;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.repositoryService_ = this.getService(RepositoryService.class);
        this.storage_ = ((CalendarServiceImpl)this.calendarService_).getDataStorage();
        this.eventSearchConnector_ = (CalendarSearchServiceConnector)this.getService(EventSearchConnector.class);
    }

    public void testInitServices() throws Exception {
        CalendarTestCase.assertNotNull((Object)this.repositoryService_);
        CalendarTestCase.assertNotNull((Object)this.organizationService_);
        CalendarTestCase.assertTrue((this.organizationService_.getUserHandler().findAllUsers(UserStatus.ANY).getSize() > 5 ? 1 : 0) != 0);
        CalendarTestCase.assertNotNull((Object)this.storage_);
        CalendarTestCase.assertNotNull((Object)this.storage_.getUserCalendarHome(this.username));
        CalendarTestCase.assertNotNull((Object)this.storage_.getPublicCalendarHome());
        CalendarTestCase.assertNotNull((Object)this.storage_.getPublicCalendarServiceHome());
        CalendarTestCase.assertNotNull((Object)this.calendarService_);
    }

    public void testGetCalendarById() throws Exception {
        Calendar cal = this.createPrivateCalendar(this.username, "myCalendar", "Desscription");
        Calendar calSave = this.calendarService_.getCalendarById(cal.getId());
        CalendarTestCase.assertNotNull((Object)calSave);
        CalendarTestCase.assertEquals((int)0, (int)this.calendarService_.getTypeOfCalendar(this.username, calSave.getId()));
        CalendarTestCase.assertEquals((String)"myCalendar", (String)calSave.getName());
        CalendarTestCase.assertEquals((String)"Desscription", (String)calSave.getDescription());
    }

    public void testGetCalendarOfDisabledUser() throws Exception {
        Calendar cal = new Calendar();
        cal.setName("myCalendar");
        cal.setPublic(true);
        cal.setViewPermission(new String[]{"*.*"});
        cal.setEditPermission(new String[]{"*.*", "john"});
        this.calendarService_.saveUserCalendar(this.username, cal, true);
        ArrayList<String> receiverUser = new ArrayList<String>();
        receiverUser.add("john");
        this.calendarService_.shareCalendar(this.username, cal.getId(), receiverUser);
        Calendar sharedCalendar = this.calendarService_.getSharedCalendars("john", true).getCalendarById(cal.getId());
        CalendarTestCase.assertEquals((String)"myCalendar", (String)sharedCalendar.getName());
        sharedCalendar.setDescription("shared description");
        this.calendarService_.saveSharedCalendar("john", sharedCalendar);
        Calendar editedCalendar = this.calendarService_.getSharedCalendars("john", true).getCalendarById(cal.getId());
        CalendarTestCase.assertEquals((String)"shared description", (String)editedCalendar.getDescription());
        CalendarEvent calendarEvent = new CalendarEvent();
        calendarEvent.setCalendarId(cal.getId());
        calendarEvent.setSummary("calendarEvent");
        calendarEvent.setEventType(CalendarEvent.TYPE_EVENT);
        java.util.Calendar current = java.util.Calendar.getInstance();
        current.add(12, 10);
        calendarEvent.setFromDateTime(current.getTime());
        current.add(12, 30);
        calendarEvent.setToDateTime(current.getTime());
        this.calendarService_.saveEventToSharedCalendar("john", cal.getId(), calendarEvent, true);
        ArrayList<String> calendarIds = new ArrayList<String>();
        calendarIds.add(cal.getId());
        CalendarTestCase.assertEquals((int)1, (int)this.calendarService_.getSharedEventByCalendars("john", calendarIds).size());
        CalendarTestCase.assertNotNull((Object)this.calendarService_.getSharedEvent("john", cal.getId(), calendarEvent.getId()));
        CalendarEvent event = (CalendarEvent)this.calendarService_.getUserEventByCalendar(this.username, calendarIds).get(0);
        CalendarTestCase.assertEquals((String)"calendarEvent", (String)event.getSummary());
        this.login("john");
        UnifiedQuery query = new UnifiedQuery();
        query.setText("calendarEvent");
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        Collection rs = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        CalendarTestCase.assertEquals((int)1, (int)rs.size());
        this.login(this.username);
        rs = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        CalendarTestCase.assertEquals((int)1, (int)rs.size());
        receiverUser.add("mary");
        this.calendarService_.shareCalendar(this.username, cal.getId(), receiverUser);
        this.login("mary");
        CalendarTestCase.assertEquals((int)1, (int)this.calendarService_.getSharedCalendars("mary", true).getCalendars().size());
        CalendarTestCase.assertEquals((int)1, (int)this.calendarService_.getSharedEventByCalendars("mary", calendarIds).size());
        EventQuery eq = new EventQuery();
        eq.setText("calendarEvent");
        CalendarTestCase.assertEquals((int)1, (int)this.calendarService_.getEvents("john", eq, null).size());
        CalendarTestCase.assertEquals((int)1, (int)this.calendarService_.getEvents("mary", eq, null).size());
        this.organizationService_.getUserHandler().setEnabled("john", false, false);
        CalendarTestCase.assertNull((Object)this.calendarService_.getSharedCalendars("john", true));
        CalendarTestCase.assertEquals((int)0, (int)this.calendarService_.getSharedEventByCalendars("john", calendarIds).size());
        CalendarTestCase.assertEquals((int)0, (int)this.calendarService_.getEvents("john", eq, null).size());
        this.calendarService_.removeSharedEvent("john", cal.getId(), calendarEvent.getId());
        List events = this.calendarService_.getUserEventByCalendar(this.username, calendarIds);
        CalendarTestCase.assertEquals((int)0, (int)events.size());
        this.calendarService_.removeSharedCalendar("john", cal.getId());
        CalendarTestCase.assertNull((Object)this.calendarService_.getSharedCalendars("john", true));
    }

    public void testDefaultData() throws Exception {
        String defaultEventCategoriesConfig = "Birthday,Memo,Wedding,DayOff";
        ValueParam defaultEventCategoriesConfigParam = new ValueParam();
        defaultEventCategoriesConfigParam.setValue(defaultEventCategoriesConfig);
        String newUserName = "testUser";
        User newUser = this.organizationService_.getUserHandler().createUserInstance(newUserName);
        this.organizationService_.getUserHandler().createUser(newUser, true);
        String[] configValues = defaultEventCategoriesConfig.split(",");
        ArrayList<String> defaultEventCategories = new ArrayList<String>();
        defaultEventCategories.add("defaultEventCategoryIdAll");
        for (int i = 0; i < configValues.length; ++i) {
            defaultEventCategories.add(configValues[i].trim());
        }
        List calendars = this.calendarService_.getUserCalendars(newUserName, true);
        CalendarTestCase.assertEquals((int)calendars.size(), (int)1);
        CalendarTestCase.assertEquals((String)((Calendar)calendars.get(0)).getName(), (String)newUserName);
        List eventCategories = this.calendarService_.getEventCategories(newUserName);
        LinkedList<String> results = new LinkedList<String>();
        for (EventCategory eventCategory : eventCategories) {
            results.add(eventCategory.getId());
        }
        CalendarTestCase.assertEquals((int)defaultEventCategories.size(), (int)results.size());
        CalendarTestCase.assertTrue((boolean)results.containsAll(defaultEventCategories));
    }

    public void testCalendar() throws Exception {
        Calendar uCal = this.createPrivateCalendar(this.username, "myCalendar", "Description");
        uCal = this.calendarService_.getUserCalendar(this.username, uCal.getId());
        CalendarTestCase.assertNotNull((Object)uCal);
        CalendarTestCase.assertEquals((String)uCal.getName(), (String)"myCalendar");
        Calendar gCal = this.createGroupCalendar(new String[]{"users", "admin"}, "groupCalendar", "groupDes");
        gCal = this.calendarService_.getGroupCalendar(gCal.getId());
        CalendarTestCase.assertNotNull((Object)gCal);
        CalendarTestCase.assertEquals((String)gCal.getName(), (String)"groupCalendar");
        List groupCalendarList = this.calendarService_.getGroupCalendars(new String[]{"users"}, true, this.username);
        CalendarTestCase.assertNotNull((Object)groupCalendarList);
        CalendarTestCase.assertEquals((int)groupCalendarList.size(), (int)1);
        groupCalendarList = this.calendarService_.getGroupCalendars(new String[]{"admin"}, true, this.username);
        CalendarTestCase.assertNotNull((Object)groupCalendarList);
        CalendarTestCase.assertEquals((int)groupCalendarList.size(), (int)1);
        groupCalendarList = this.calendarService_.getGroupCalendars(new String[]{"admin1"}, true, this.username);
        CalendarTestCase.assertNotNull((Object)groupCalendarList);
        CalendarTestCase.assertEquals((int)groupCalendarList.size(), (int)0);
        gCal.setName("myCalendarUpdated");
        this.calendarService_.savePublicCalendar(gCal, false);
        gCal = this.calendarService_.getGroupCalendar(gCal.getId());
        CalendarTestCase.assertEquals((String)gCal.getName(), (String)"myCalendarUpdated");
        Calendar removeCal = this.calendarService_.removePublicCalendar(gCal.getId());
        CalendarTestCase.assertEquals((String)removeCal.getName(), (String)"myCalendarUpdated");
        removeCal = this.calendarService_.removeUserCalendar(this.username, uCal.getId());
        CalendarTestCase.assertEquals((String)removeCal.getName(), (String)"myCalendar");
        CalendarSetting setting = new CalendarSetting();
        setting.setBaseURL("url");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        CalendarTestCase.assertEquals((String)"url", (String)this.calendarService_.getCalendarSetting(this.username).getBaseURL());
    }

    public void testEventCategory() throws Exception {
        int initialSize = this.calendarService_.getEventCategories(this.username).size();
        EventCategory eventCategory = new EventCategory();
        String name = "eventCategoryName";
        eventCategory.setName(name);
        this.calendarService_.saveEventCategory(this.username, eventCategory, true);
        CalendarTestCase.assertEquals((int)(initialSize + 1), (int)this.calendarService_.getEventCategories(this.username).size());
        CalendarTestCase.assertNotNull((Object)this.calendarService_.getEventCategory(this.username, eventCategory.getId()));
    }

    public void testFeed() throws Exception {
        CalendarEvent event = this.createUserEvent("Have a meeting");
        String calId = event.getCalendarId();
        LinkedHashMap<String, Calendar> calendars = new LinkedHashMap<String, Calendar>();
        calendars.put("0:" + calId, this.calendarService_.getCalendarById(calId));
        RssData rssData = new RssData();
        String name = "RSS";
        rssData.setName(name + ".rss");
        String url = "http://localhost:8080/csdemo/rest-csdemo/cs/calendar/feed/" + this.username + "/" + name + "/" + IdGenerator.generate() + ".rss";
        rssData.setUrl(url);
        rssData.setTitle(name);
        rssData.setDescription("Description");
        rssData.setLink(url);
        rssData.setVersion("rss_2.0");
        this.calendarService_.generateRss(this.username, calendars, rssData);
        CalendarTestCase.assertEquals((int)1, (int)this.calendarService_.getFeeds(this.username).size());
        this.calendarService_.removeFeedData(this.username, name);
        CalendarTestCase.assertEquals((int)0, (int)this.calendarService_.getFeeds(this.username).size());
    }

    public void testFeedWithDefaultHostname() throws Exception {
        CalendarEvent event = this.createUserEvent("Have a meeting");
        String calId = event.getCalendarId();
        LinkedHashMap<String, Calendar> calendars = new LinkedHashMap<String, Calendar>();
        calendars.put("0:" + calId, this.calendarService_.getCalendarById(calId));
        RssData rssData = new RssData();
        String name = "RSS";
        rssData.setName(name + ".rss");
        String url = "http://" + CalendarUtils.getServerBaseUrl() + "/csdemo/rest-csdemo/cs/calendar/feed/" + this.username + "/" + name + "/" + IdGenerator.generate() + ".rss";
        rssData.setUrl(url);
        rssData.setTitle(name);
        rssData.setDescription("Description");
        rssData.setLink(url);
        rssData.setVersion("rss_2.0");
        CalendarTestCase.assertNotNull((Object)CalendarUtils.getServerBaseUrl());
        this.calendarService_.generateRss(this.username, calendars, rssData);
        CalendarTestCase.assertEquals((int)1, (int)this.calendarService_.getFeeds(this.username).size());
        CalendarTestCase.assertTrue((boolean)((FeedData)this.calendarService_.getFeeds(this.username).get(0)).getUrl().startsWith("http://localhost:8080"));
        this.calendarService_.removeFeedData(this.username, name);
        CalendarTestCase.assertEquals((int)0, (int)this.calendarService_.getFeeds(this.username).size());
    }

    public void testRemoteCalendar() throws Exception {
        Calendar cal;
        String remoteUrl = "http://www.google.com/calendar/ical/exomailtest@gmail.com/private-462ee65e38f964b0aa64a37b427ed673/basic.ics";
        RemoteCalendarService remoteCalendarService = this.calendarService_.getRemoteCalendarService();
        RemoteCalendar remoteCal = new RemoteCalendar();
        remoteCal.setType("ICalendar(.ics)");
        remoteCal.setUsername(this.username);
        remoteCal.setRemoteUrl(remoteUrl);
        remoteCal.setCalendarName("CalendarName");
        remoteCal.setDescription("Description");
        remoteCal.setSyncPeriod("Auto");
        remoteCal.setBeforeDate(0L);
        remoteCal.setAfterDate(0L);
        try {
            cal = remoteCalendarService.importRemoteCalendar(remoteCal);
        }
        catch (IOException e) {
            log.info((Object)"Exception occurs when connect to remote calendar. Skip this test.");
            return;
        }
        catch (ParserException e) {
            log.info((Object)"Exception occurs when parse remote calendar. Skip this test.");
            return;
        }
        this.calendarService_.saveUserCalendar(this.username, cal, true);
        Calendar newCal = this.calendarService_.getCalendarById(cal.getId());
        CalendarTestCase.assertNotNull((Object)newCal);
        CalendarTestCase.assertEquals((String)newCal.getId(), (String)cal.getId());
        boolean isRemoteCalendar = this.calendarService_.isRemoteCalendar(this.username, cal.getId());
        CalendarTestCase.assertTrue((boolean)isRemoteCalendar);
        RemoteCalendar remoteCalendar = this.calendarService_.getRemoteCalendar(this.username, cal.getId());
        CalendarTestCase.assertEquals((String)remoteUrl, (String)remoteCalendar.getRemoteUrl());
        Calendar calendar1 = this.calendarService_.getRemoteCalendar(this.username, remoteUrl, "ICalendar(.ics)");
        CalendarTestCase.assertEquals((String)cal.getId(), (String)calendar1.getId());
        int remoteCalendarCount = this.calendarService_.getRemoteCalendarCount(this.username);
        CalendarTestCase.assertEquals((int)1, (int)remoteCalendarCount);
        String newRemoteUrl = "https://www.google.com/calendar/dav/exomailtest@gmail.com/events/";
        remoteCalendar.setRemoteUrl(newRemoteUrl);
        this.calendarService_.updateRemoteCalendarInfo(remoteCalendar);
        remoteCalendar = this.calendarService_.getRemoteCalendar(this.username, cal.getId());
        CalendarTestCase.assertEquals((String)newRemoteUrl, (String)remoteCalendar.getRemoteUrl());
        this.calendarService_.removeUserCalendar(this.username, cal.getId());
        remoteCal.setType("CalDAV");
        remoteCal.setRemoteUser("exomailtest@gmail.com");
        remoteCal.setRemotePassword("testexomail");
        remoteCal.setRemoteUrl("https://www.google.com/calendar/dav/exomailtest@gmail.com/events/");
        try {
            cal = remoteCalendarService.importRemoteCalendar(remoteCal);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.info((Object)"Exception occurs when connect to remote calendar. Skip this test.");
            }
            return;
        }
        List events1 = this.calendarService_.getUserEventByCalendar(this.username, Arrays.asList(cal.getId()));
        CalendarTestCase.assertTrue((events1.size() > 0 ? 1 : 0) != 0);
        this.calendarService_.removeUserCalendar(this.username, cal.getId());
    }

    public void testGetNonExistCalendar() {
        try {
            Calendar calendar = this.calendarService_.getUserCalendar(this.username, "Not exist calendar");
            CalendarTestCase.assertNull((Object)calendar);
        }
        catch (Exception e) {
            CalendarTestCase.fail();
        }
    }

    public void testSaveUserCalendar() throws Exception {
        Calendar calendar = this.createPrivateCalendar(this.username, "CalendarName", "CalendarDesscription");
        String newCalendarName = "CalendarName edited";
        calendar.setName(newCalendarName);
        this.calendarService_.saveUserCalendar(this.username, calendar, false);
        Calendar edidedCalendar = this.calendarService_.getUserCalendar(this.username, calendar.getId());
        CalendarTestCase.assertEquals((String)newCalendarName, (String)edidedCalendar.getName());
    }

    public void testSaveGroupCalendar() throws Exception {
        Calendar calendar = this.createGroupCalendar(new String[]{"/platform/users", "/organization/management/executive-board"}, "CalendarName", "CalendarDesscription");
        CalendarTestCase.assertNotNull((Object)this.calendarService_.getGroupCalendar(calendar.getId()));
        CalendarTestCase.assertEquals((String)calendar.getId(), (String)this.calendarService_.getCalendarById(calendar.getId()).getId());
    }

    public void testSaveSharedCalendar() throws Exception {
        Calendar shCal = this.createSharedCalendar(this.username + "-calendar-share", "shared to john", new String[]{"john"});
        shCal.setName(shCal.getName() + "-updated");
        Calendar shReturn = this.calendarService_.saveCalendar(this.username, shCal, 1, false);
        CalendarTestCase.assertEquals((Object)shReturn, (Object)this.calendarService_.getCalendarById(shCal.getId()));
    }

    public void testGetCalendars() throws Exception {
        int offset = 0;
        int limit = 5;
        int counter = 0;
        for (int i = 0; i < 100; ++i) {
            this.createPrivateCalendar(this.username, this.username + "-calendar-" + i, "description-" + i);
            ++counter;
        }
        CalendarCollection pCals = this.calendarService_.getAllCalendars(this.username, 0, offset, limit);
        CalendarTestCase.assertEquals((int)limit, (int)pCals.size());
        offset = 5;
        limit = 10;
        pCals = this.calendarService_.getAllCalendars(this.username, 0, offset, limit);
        CalendarTestCase.assertEquals((int)limit, (int)pCals.size());
        offset = 0;
        String[] groups = new String[]{"/platform/users", "/organization/management/executive-board"};
        for (int i = 0; i < 100; ++i) {
            this.createGroupCalendar(groups, "group cal-" + i, "group calendar");
            ++counter;
        }
        CalendarCollection gCals = this.calendarService_.getAllCalendars(this.username, 2, offset, limit);
        CalendarTestCase.assertEquals((int)limit, (int)gCals.size());
        ArrayList<String> shareTo = new ArrayList<String>();
        shareTo.add("john");
        for (Calendar cal : pCals) {
            this.calendarService_.shareCalendar(this.username, cal.getId(), shareTo);
        }
        this.login("john");
        CalendarCollection shCals = this.calendarService_.getAllCalendars("john", 1, offset, limit);
        CalendarTestCase.assertEquals((int)limit, (int)shCals.size());
        ArrayList<Calendar> jPcals = new ArrayList<Calendar>();
        for (int i = 0; i < 50; ++i) {
            jPcals.add(this.createPrivateCalendar("john", "john-" + i, "john calendar " + i));
        }
        shareTo = new ArrayList();
        shareTo.add("root");
        for (Calendar cal : jPcals) {
            this.calendarService_.shareCalendar("john", cal.getId(), shareTo);
            ++counter;
        }
        limit = 120;
        this.login(this.username);
        CalendarCollection cals = this.calendarService_.getAllCalendars(this.username, -1, offset, limit);
        CalendarTestCase.assertEquals((int)limit, (int)cals.size());
        CalendarTestCase.assertEquals((long)counter, (long)cals.getFullSize());
    }

    public void testGetAllCalendarsInGroup() throws Exception {
        int i;
        int offset = 0;
        int limit = 100;
        for (i = 0; i < 2; ++i) {
            this.createGroupCalendar(new String[]{"/platform/administrators"}, "group cal-" + System.currentTimeMillis(), "group calendar");
        }
        for (i = 0; i < 2; ++i) {
            this.createGroupCalendar(new String[]{"/platform/administrators, /platform/users"}, "group cal-" + System.currentTimeMillis(), "group calendar");
        }
        for (i = 0; i < 2; ++i) {
            this.createGroupCalendar(new String[]{"/platform/users"}, "group cal-" + System.currentTimeMillis(), "group calendar");
        }
        for (i = 0; i < 2; ++i) {
            this.createGroupCalendar(new String[]{"/platform/guests"}, "group cal-" + System.currentTimeMillis(), "group calendar");
        }
        for (i = 0; i < 2; ++i) {
            this.createGroupCalendar(new String[]{"/organization/management/executive-board"}, "group cal-" + System.currentTimeMillis(), "group calendar");
        }
        CalendarTestCase.assertEquals((long)8L, (long)this.calendarService_.getAllCalendars("root", 2, offset, limit).getFullSize());
        CalendarTestCase.assertEquals((long)8L, (long)this.calendarService_.getAllCalendars("john", 2, offset, limit).getFullSize());
        CalendarTestCase.assertEquals((long)4L, (long)this.calendarService_.getAllCalendars("mary", 2, offset, limit).getFullSize());
        CalendarTestCase.assertEquals((long)6L, (long)this.calendarService_.getAllCalendars("demo", 2, offset, limit).getFullSize());
    }

    public void testSaveEventCategory() throws Exception {
        String eventCategoryName = "eventCategoryName1";
        EventCategory eventCategory = this.createUserEventCategory(this.username, eventCategoryName);
        String newEventCategoryName = "newEventCategoryName";
        eventCategory.setName(newEventCategoryName);
        this.calendarService_.saveEventCategory(this.username, eventCategory, false);
        EventCategory edidedEventCategory = this.calendarService_.getEventCategory(this.username, eventCategory.getId());
        CalendarTestCase.assertNotNull((Object)edidedEventCategory);
        CalendarTestCase.assertEquals((String)newEventCategoryName, (String)edidedEventCategory.getName());
    }

    public void testRemoveEventCategory() throws Exception {
        Calendar calendar = this.createPrivateCalendar(this.username, "myCalendar", "Description");
        Calendar groupCalendar = this.createGroupCalendar(this.userGroups, "groupCalendar", "groupDescription");
        EventCategory eventCategory = this.createUserEventCategory(this.username, "eventCategoryName2");
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(10, 1);
        CalendarEvent userEvent = this.createUserEvent(calendar.getId(), eventCategory, "Have a meeting", true, fromCal, toCal);
        CalendarEvent publicEvent = this.createGroupEvent(groupCalendar.getId(), eventCategory, "Have a meeting", true, fromCal, toCal);
        this.calendarService_.removeEventCategory(this.username, eventCategory.getId());
        try {
            this.calendarService_.getEventCategory(this.username, eventCategory.getId());
            CalendarTestCase.fail();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        CalendarEvent calendarEvent3 = this.calendarService_.getEvent(this.username, userEvent.getId());
        CalendarTestCase.assertNotNull((Object)calendarEvent3);
        CalendarTestCase.assertEquals((String)"defaultEventCategoryIdAll", (String)calendarEvent3.getEventCategoryId());
        CalendarTestCase.assertEquals((String)"defaultEventCategoryNameAll", (String)calendarEvent3.getEventCategoryName());
        CalendarEvent calendarEvent4 = this.calendarService_.getGroupEvent(groupCalendar.getId(), publicEvent.getId());
        CalendarTestCase.assertNotNull((Object)calendarEvent4);
        CalendarTestCase.assertEquals((String)"defaultEventCategoryIdAll", (String)calendarEvent4.getEventCategoryId());
        CalendarTestCase.assertEquals((String)"defaultEventCategoryNameAll", (String)calendarEvent4.getEventCategoryName());
    }

    public void testCheckFreeBusy() throws Exception {
        Calendar publicCalendar = this.createGroupCalendar(this.userGroups, "publicCalendar", "publicDescription");
        EventCategory eventCategory = this.createUserEventCategory(this.username, "CheckFreeBusyCategory");
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(5, 1);
        this.createGroupEvent(publicCalendar.getId(), eventCategory, "Have a meeting", true, fromCal, toCal);
        toCal.add(5, 1);
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(fromCal);
        eventQuery.setToDate(toCal);
        eventQuery.setParticipants(new String[]{"root"});
        eventQuery.setNodeType("exo:calendarPublicEvent");
        this.calendarService_.checkFreeBusy(eventQuery);
    }
}

