/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.model.query.CalendarQuery;
import org.exoplatform.calendar.model.query.EventQuery;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarException;
import org.exoplatform.calendar.service.MockCalendar;
import org.exoplatform.calendar.storage.CalendarDAO;
import org.exoplatform.calendar.storage.EventDAO;
import org.exoplatform.calendar.storage.Storage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.component.BaseComponentPlugin;

public class MockStorage
extends BaseComponentPlugin
implements Storage {
    public static final String ID = "MOCK_STORAGE";
    CalendarDAO calDAO;
    EventDAO eventDAO;

    public String getId() {
        return ID;
    }

    public CalendarDAO getCalendarDAO() {
        if (this.calDAO == null) {
            this.calDAO = new MockCalendarDAO();
        }
        return this.calDAO;
    }

    public EventDAO getEventDAO() {
        if (this.eventDAO == null) {
            this.eventDAO = new MockEventDAO();
        }
        return this.eventDAO;
    }

    class MockEventDAO
    implements EventDAO {
        MockEventDAO() {
        }

        public Event getById(String id) {
            return null;
        }

        public Event save(Event object) {
            return null;
        }

        public Event remove(String id) {
            return null;
        }

        public Event newInstance() {
            return null;
        }

        public ListAccess<Event> findEventsByQuery(EventQuery eventQuery) throws CalendarException {
            return null;
        }

        public Event update(Event entity) {
            return null;
        }
    }

    class MockCalendarDAO
    implements CalendarDAO {
        private HashMap<String, org.exoplatform.calendar.model.Calendar> cals = new HashMap();

        MockCalendarDAO() {
        }

        public org.exoplatform.calendar.model.Calendar getById(String id) {
            return this.cals.get(id);
        }

        public org.exoplatform.calendar.model.Calendar save(org.exoplatform.calendar.model.Calendar cal) {
            this.cals.put(cal.getId(), cal);
            return cal;
        }

        public org.exoplatform.calendar.model.Calendar remove(String id) {
            return this.cals.remove(id);
        }

        public Calendar newInstance() {
            return new MockCalendar();
        }

        public List<org.exoplatform.calendar.model.Calendar> findCalendars(CalendarQuery query) {
            return null;
        }

        public org.exoplatform.calendar.model.Calendar update(org.exoplatform.calendar.model.Calendar entity) {
            return null;
        }
    }
}

