/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.List;
import org.exoplatform.calendar.model.CompositeID;
import org.exoplatform.calendar.model.query.CalendarQuery;
import org.exoplatform.calendar.service.AssertUtil;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarHandler;
import org.exoplatform.calendar.service.MockCalendar;
import org.exoplatform.calendar.service.TestUtil;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class TestCalendarHandler
extends BaseCalendarServiceTestCase {
    protected CalendarHandler calHandler;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.calHandler = this.xCalService.getCalendarHandler();
    }

    public void testCreateCalendar() {
        MockCalendar cal = new MockCalendar();
        cal.setName("newCalendar");
        cal = this.calHandler.saveCalendar((org.exoplatform.calendar.model.Calendar)cal);
        TestCalendarHandler.assertEquals((String)"MOCK_STORAGE", (String)CompositeID.parse((String)cal.getCompositeId()).getDS());
        cal = this.calHandler.getCalendarById(cal.getCompositeId());
        TestCalendarHandler.assertNotNull((Object)((Object)cal));
        TestCalendarHandler.assertEquals((String)"newCalendar", (String)cal.getName());
    }

    public void testCreatePersonalCalendar() {
        Calendar cal = new Calendar();
        cal.setName("testCreatePersonalCalendar");
        cal.setCalType(Calendar.Type.PERSONAL.type());
        cal.setCalendarOwner(this.username);
        this.calHandler.saveCalendar((org.exoplatform.calendar.model.Calendar)cal);
        org.exoplatform.calendar.model.Calendar calSaved = this.calHandler.getCalendarById(cal.getId());
        TestCalendarHandler.assertNotNull((Object)calSaved);
        TestCalendarHandler.assertEquals((String)"testCreatePersonalCalendar", (String)calSaved.getName());
    }

    public void testCreateGroupCalendar() {
        Calendar cal = new Calendar();
        cal.setName("testCreateGroupCalendar");
        cal.setCalType(Calendar.Type.GROUP.type());
        cal.setGroups(this.userGroups);
        this.calHandler.saveCalendar((org.exoplatform.calendar.model.Calendar)cal);
        org.exoplatform.calendar.model.Calendar calSaved = this.calHandler.getCalendarById(cal.getId());
        TestCalendarHandler.assertNotNull((Object)calSaved);
        TestCalendarHandler.assertEquals((String)"testCreateGroupCalendar", (String)calSaved.getName());
    }

    public void testRemoveGroupCalendar() throws Exception {
        Identity identity = ConversationState.getCurrent().getIdentity();
        org.exoplatform.calendar.model.Calendar cal1 = TestUtil.createGroupCalendar(this.calHandler, "testRemoveGroupCalendar_1", this.userGroups);
        org.exoplatform.calendar.model.Calendar cal2 = TestUtil.createGroupCalendar(this.calHandler, "testRemoveGroupCalendar_2", this.userGroups);
        CalendarQuery query = new CalendarQuery();
        query.setIdentity(identity);
        List calendars = this.calHandler.findCalendars(query);
        int size = calendars.size();
        TestCalendarHandler.assertTrue((String)"User must have at least 2 group calendars", (size >= 2 ? 1 : 0) != 0);
        AssertUtil.assertContainCalendarName(calendars, "testRemoveGroupCalendar_1");
        AssertUtil.assertContainCalendarName(calendars, "testRemoveGroupCalendar_2");
        this.calHandler.removeCalendar(cal1.getId());
        calendars = this.calHandler.findCalendars(query);
        size = calendars.size();
        TestCalendarHandler.assertTrue((String)"User must have at least 1 personal calendars", (size >= 1 ? 1 : 0) != 0);
        AssertUtil.assertNotContainCalendarName(calendars, "testRemoveGroupCalendar_1");
        AssertUtil.assertContainCalendarName(calendars, "testRemoveGroupCalendar_2");
    }

    public void testUpdatePersonalCalendar() {
        String calId = TestUtil.createPersonalCalendar(this.calHandler, "testUpdatePersonalCalendar", this.username).getId();
        org.exoplatform.calendar.model.Calendar cal = this.calHandler.getCalendarById(calId);
        TestCalendarHandler.assertNotNull((Object)cal);
        TestCalendarHandler.assertEquals((String)"testUpdatePersonalCalendar", (String)cal.getName());
        cal.setName("testUpdatePersonalCalendar_updated");
        cal.setDescription("testUpdatePersonalCalendar description");
        this.calHandler.updateCalendar(cal);
        cal = this.calHandler.getCalendarById(calId);
        TestCalendarHandler.assertNotNull((Object)cal);
        TestCalendarHandler.assertEquals((String)"testUpdatePersonalCalendar_updated", (String)cal.getName());
        TestCalendarHandler.assertEquals((String)"testUpdatePersonalCalendar description", (String)cal.getDescription());
    }

    public void testUpdateGroupCalendar() {
        String calId = TestUtil.createGroupCalendar(this.calHandler, "testUpdateGroupCalendar", this.userGroups).getId();
        org.exoplatform.calendar.model.Calendar cal = this.calHandler.getCalendarById(calId);
        TestCalendarHandler.assertNotNull((Object)cal);
        TestCalendarHandler.assertEquals((String)"testUpdateGroupCalendar", (String)cal.getName());
        cal.setName("testUpdateGroupCalendar_updated");
        cal.setDescription("testUpdateGroupCalendar description");
        this.calHandler.updateCalendar(cal);
        cal = this.calHandler.getCalendarById(calId);
        TestCalendarHandler.assertNotNull((Object)cal);
        TestCalendarHandler.assertEquals((String)"testUpdateGroupCalendar_updated", (String)cal.getName());
        TestCalendarHandler.assertEquals((String)"testUpdateGroupCalendar description", (String)cal.getDescription());
    }
}

