/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.model.query.EventQuery;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventHandler;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;
import org.exoplatform.calendar.storage.jcr.JCREventQuery;
import org.exoplatform.commons.utils.ListAccess;

public class TestEventHandler
extends BaseCalendarServiceTestCase {
    protected EventHandler evtHandler;
    private Calendar userCal;
    private Calendar grpCal;
    private CalendarEvent userEvent;
    private CalendarEvent grpEvent;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.evtHandler = this.xCalService.getEventHandler();
        this.userCal = this.createPrivateCalendar(this.username, "CalendarName", "CalendarDescription");
        EventCategory eventCategory = this.createUserEventCategory(this.username, "EventCategoryName2");
        this.userEvent = this.createUserEvent(this.userCal.getId(), eventCategory, "Have a meeting");
        this.grpCal = this.createGroupCalendar(this.userGroups, "user calendar", "user cal des");
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.setTimeInMillis(this.userEvent.getFromDateTime().getTime() + 3600000L);
        java.util.Calendar to = java.util.Calendar.getInstance();
        to.setTimeInMillis(from.getTimeInMillis() + 3600000L);
        this.grpEvent = this.createGroupEvent(this.grpCal.getId(), eventCategory, "group evt des", false, from, to);
    }

    public void testFindEventByDate() throws Exception {
        JCREventQuery condition = new JCREventQuery();
        condition.setCalType(Calendar.Type.PERSONAL.type());
        condition.setOwner(this.username);
        condition.setFromDate(Long.valueOf(this.userEvent.getFromDateTime().getTime()));
        condition.setToDate(Long.valueOf(this.userEvent.getToDateTime().getTime() + 3600000L));
        ListAccess events = this.evtHandler.findEventsByQuery((EventQuery)condition);
        TestEventHandler.assertEquals((int)1, (int)events.getSize());
        TestEventHandler.assertEquals((String)this.userEvent.getId(), (String)((Event[])events.load(0, 1))[0].getId());
        condition.setFromDate(Long.valueOf(condition.getFromDate() + 3600000L + 100L));
        events = this.evtHandler.findEventsByQuery((EventQuery)condition);
        TestEventHandler.assertEquals((int)0, (int)events.getSize());
        condition.setCalType(Calendar.Type.GROUP.type());
        events = this.evtHandler.findEventsByQuery((EventQuery)condition);
        TestEventHandler.assertEquals((int)1, (int)events.getSize());
    }

    public void testFindEventByCalendarID() throws Exception {
        JCREventQuery condition = new JCREventQuery();
        condition.setCalType(Calendar.Type.PERSONAL.type());
        condition.setOwner(this.username);
        condition.setCalendarIds(new String[]{this.userCal.getId()});
        ListAccess events = this.evtHandler.findEventsByQuery((EventQuery)condition);
        TestEventHandler.assertEquals((int)1, (int)events.getSize());
        TestEventHandler.assertEquals((String)this.userEvent.getId(), (String)((Event[])events.load(0, 1))[0].getId());
        condition.setCalType(Calendar.Type.GROUP.type());
        condition.setCalendarIds(new String[]{this.grpCal.getId()});
        events = this.evtHandler.findEventsByQuery((EventQuery)condition);
        TestEventHandler.assertEquals((int)1, (int)events.getSize());
        TestEventHandler.assertEquals((String)this.grpEvent.getId(), (String)((Event[])events.load(0, 1))[0].getId());
    }

    public void testFindNonRepeatEvent() throws Exception {
        CalendarEvent repeatEvent = this.createUserEvent(this.userCal.getId(), null, "this is repeated event");
        repeatEvent.setRepeatType(CalendarEvent.RP_DAILY);
        this.calendarService_.saveUserEvent(this.username, this.userCal.getId(), repeatEvent, false);
        JCREventQuery condition = new JCREventQuery();
        condition.setCalType(Calendar.Type.PERSONAL.type());
        condition.setOwner(this.username);
        ListAccess events = this.evtHandler.findEventsByQuery((EventQuery)condition);
        TestEventHandler.assertEquals((int)2, (int)events.getSize());
        condition.setExcludeRepeatEvent(Boolean.valueOf(true));
        events = this.evtHandler.findEventsByQuery((EventQuery)condition);
        TestEventHandler.assertEquals((int)1, (int)events.getSize());
    }

    public void testFindEventWithFilter() throws Exception {
        Calendar cal = this.createPrivateCalendar(this.username, "cal", "des");
        this.createUserEvent(cal.getId(), null, "Have a meeting");
        JCREventQuery condition = new JCREventQuery();
        condition.setCalType(Calendar.Type.PERSONAL.type());
        condition.setOwner(this.username);
        ListAccess events = this.evtHandler.findEventsByQuery((EventQuery)condition);
        TestEventHandler.assertEquals((int)2, (int)events.getSize());
        condition.setFilterCalendarIds(new String[]{cal.getId()});
        events = this.evtHandler.findEventsByQuery((EventQuery)condition);
        TestEventHandler.assertEquals((int)1, (int)events.getSize());
    }
}

