/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.calendar.component.service-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.calendar.component.service-dependencies-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.calendar.component.service-local-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.calendar.component.service-organization-configuration.xml")})
public abstract class BaseCalendarServiceTestCase
extends AbstractKernelTest {
    protected static Log log = ExoLogger.getLogger((String)"cs.calendar.services.test");
    protected TimeZone tz = java.util.Calendar.getInstance().getTimeZone();
    protected String timeZone = this.tz.getID();
    protected String username = "root";
    protected String[] userGroups = new String[]{"/platform/users", "/organization/management/executive-board"};
    protected SimpleDateFormat df = new SimpleDateFormat(Utils.DATE_TIME_FORMAT, Locale.ENGLISH);
    protected OrganizationService organizationService_;
    protected CalendarService calendarService_;
    protected ExtendedCalendarService xCalService;

    public void setUp() throws Exception {
        this.begin();
        Locale.setDefault(Locale.ENGLISH);
        this.organizationService_ = this.getService(OrganizationService.class);
        this.calendarService_ = this.getService(CalendarService.class);
        this.xCalService = this.getService(ExtendedCalendarService.class);
        JCRDataStorage storage = ((CalendarServiceImpl)this.calendarService_).getDataStorage();
        storage.getPublicCalendarHome();
        storage.getPublicCalendarServiceHome();
        storage.getUserCalendarHome(this.username);
        storage.getSharedCalendarHome();
        this.login(this.username);
        ListAccess users = this.organizationService_.getUserHandler().findAllUsers(UserStatus.DISABLED);
        if (users != null) {
            for (User user : (User[])users.load(0, users.getSize())) {
                this.organizationService_.getUserHandler().setEnabled(user.getUserName(), true, false);
            }
        }
        System.setProperty("gatein.email.domain.url", "localhost:8080");
    }

    public void tearDown() throws Exception {
        ListAccess users = this.organizationService_.getUserHandler().findAllUsers();
        int size = users.getSize();
        for (User u : (User[])users.load(0, size)) {
            this.cleanData(u);
        }
        this.end();
    }

    protected void cleanData(User user) throws Exception {
        List cals = this.calendarService_.getUserCalendars(user.getUserName(), true);
        ArrayList groups = new ArrayList();
        groups.addAll(this.organizationService_.getGroupHandler().findGroupsOfUser(user.getUserName()));
        String[] groupIds = new String[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            groupIds[i] = ((Group)groups.get(i)).getId();
        }
        for (GroupCalendarData g : this.calendarService_.getGroupCalendars(groupIds, true, user.getUserName())) {
            cals.addAll(g.getCalendars());
        }
        GroupCalendarData gData = this.calendarService_.getSharedCalendars(user.getUserName(), true);
        if (gData != null) {
            cals.addAll(gData.getCalendars());
        }
        for (int i = 0; i < cals.size(); ++i) {
            String id = ((Calendar)cals.get(i)).getId();
            this.calendarService_.removeUserCalendar(user.getUserName(), id);
            this.calendarService_.removePublicCalendar(id);
            this.calendarService_.removeSharedCalendar(user.getUserName(), id);
        }
        List categories = this.calendarService_.getEventCategories(user.getUserName());
        for (EventCategory category : categories) {
            this.calendarService_.removeEventCategory(user.getUserName(), category.getId());
        }
    }

    protected Calendar createPrivateCalendar(String username, String name, String description) throws Exception {
        Calendar calendar = new Calendar();
        calendar.setName(name);
        calendar.setDescription(description);
        calendar.setPublic(false);
        this.calendarService_.saveUserCalendar(username, calendar, true);
        return calendar;
    }

    protected Calendar createGroupCalendar(String[] groups, String calName, String description) throws Exception {
        Calendar calendar = new Calendar();
        calendar.setName(calName);
        calendar.setDescription(description);
        calendar.setPublic(true);
        calendar.setGroups(groups);
        this.calendarService_.savePublicCalendar(calendar, true);
        return calendar;
    }

    protected Calendar createSharedCalendar(String name, String description, String[] shared) {
        try {
            Calendar sharedCalendar = new Calendar();
            sharedCalendar.setName(name);
            sharedCalendar.setDescription(description);
            sharedCalendar.setPublic(true);
            sharedCalendar.setViewPermission(shared);
            sharedCalendar.setEditPermission(shared);
            this.calendarService_.saveUserCalendar(this.username, sharedCalendar, true);
            this.calendarService_.shareCalendar(this.username, sharedCalendar.getId(), Arrays.asList(shared));
            return sharedCalendar;
        }
        catch (Exception e) {
            BaseCalendarServiceTestCase.fail();
            return null;
        }
    }

    protected EventCategory createUserEventCategory(String username, String name) throws Exception {
        EventCategory eventCategory = new EventCategory();
        eventCategory.setName(name);
        this.calendarService_.saveEventCategory(username, eventCategory, true);
        return eventCategory;
    }

    protected CalendarEvent createCalendarEventInstance(String summary) {
        CalendarEvent event = new CalendarEvent();
        event.setSummary(summary);
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.add(12, 5);
        event.setFromDateTime(from.getTime());
        from.add(10, 1);
        event.setToDateTime(from.getTime());
        return event;
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContainer().getComponentInstanceOfType(clazz);
    }

    protected CalendarEvent createUserEvent(String calendarId, EventCategory eventCategory, String summary) {
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(10, 1);
        return this.createUserEvent(calendarId, eventCategory, summary, true, fromCal, toCal);
    }

    protected CalendarEvent createUserEvent(String calendarId, EventCategory eventCategory, String summary, boolean isPrivate, java.util.Calendar fromCal, java.util.Calendar toCal) {
        try {
            CalendarEvent calendarEvent = new CalendarEvent();
            if (eventCategory != null) {
                calendarEvent.setEventCategoryId(eventCategory.getId());
                calendarEvent.setEventCategoryName(eventCategory.getName());
            }
            calendarEvent.setSummary(summary);
            calendarEvent.setFromDateTime(fromCal.getTime());
            calendarEvent.setToDateTime(toCal.getTime());
            calendarEvent.setPrivate(isPrivate);
            this.calendarService_.saveUserEvent(this.username, calendarId, calendarEvent, true);
            return calendarEvent;
        }
        catch (Exception e) {
            BaseCalendarServiceTestCase.fail((String)"Exception while create user event", (Throwable)e);
            return null;
        }
    }

    protected CalendarEvent createUserEvent(String username, String calendarId, EventCategory eventCategory, String summary, boolean isPrivate, java.util.Calendar fromCal, java.util.Calendar toCal) {
        try {
            CalendarEvent calendarEvent = new CalendarEvent();
            if (eventCategory != null) {
                calendarEvent.setEventCategoryId(eventCategory.getId());
                calendarEvent.setEventCategoryName(eventCategory.getName());
            }
            calendarEvent.setSummary(summary);
            calendarEvent.setFromDateTime(fromCal.getTime());
            calendarEvent.setToDateTime(toCal.getTime());
            calendarEvent.setPrivate(isPrivate);
            this.calendarService_.saveUserEvent(username, calendarId, calendarEvent, true);
            return calendarEvent;
        }
        catch (Exception e) {
            BaseCalendarServiceTestCase.fail((String)"Exception while create user event", (Throwable)e);
            return null;
        }
    }

    protected CalendarEvent createUserEvent(String summary) throws Exception {
        Calendar calendar = this.createPrivateCalendar(this.username, "CalendarTest", "CalendarTest");
        EventCategory category = this.createUserEventCategory(this.username, "CalendarCategoryTest");
        java.util.Calendar from = java.util.Calendar.getInstance();
        java.util.Calendar to = java.util.Calendar.getInstance();
        to.add(10, 1);
        return this.createUserEvent(calendar.getId(), category, summary, true, from, to);
    }

    protected CalendarEvent createGroupEvent(String publicCalendarId, EventCategory eventCategory, String summary, boolean isPrivate, java.util.Calendar fromCal, java.util.Calendar toCal) {
        try {
            CalendarEvent publicEvent = new CalendarEvent();
            if (eventCategory != null) {
                publicEvent.setEventCategoryId(eventCategory.getId());
                publicEvent.setEventCategoryName(eventCategory.getName());
            }
            publicEvent.setSummary(summary);
            publicEvent.setFromDateTime(fromCal.getTime());
            publicEvent.setToDateTime(toCal.getTime());
            publicEvent.setPrivate(isPrivate);
            this.calendarService_.savePublicEvent(publicCalendarId, publicEvent, true);
            return publicEvent;
        }
        catch (Exception e) {
            BaseCalendarServiceTestCase.fail();
            return null;
        }
    }

    protected void login(String username) {
        LinkedList<MembershipEntry> entries = new LinkedList<MembershipEntry>();
        MembershipHandler mHandler = this.organizationService_.getMembershipHandler();
        try {
            Collection memberships = mHandler.findMembershipsByUser(username);
            for (Membership m : memberships) {
                entries.add(new MembershipEntry(m.getGroupId(), m.getMembershipType()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.login(username, entries);
    }

    private void login(String username, Collection<MembershipEntry> entries) {
        Identity identity = new Identity(username, entries);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }
}

