/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;

public class EventSearchTestCase
extends BaseCalendarServiceTestCase {
    public void testSearchUserEventWithCategory() throws Exception {
        EventCategory category1 = this.createUserEventCategory(this.username, "event category 1");
        EventCategory category2 = this.createUserEventCategory(this.username, "event category 2");
        Calendar calendar = this.createPrivateCalendar(this.username, "testSearchEventWithCategory", "testSearchEventWithCategory");
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.add(12, 30);
        java.util.Calendar to = java.util.Calendar.getInstance();
        from.add(12, 60);
        CalendarEvent event = this.createUserEvent(calendar.getId(), category1, "My testSearchEventWithCategory event", false, from, to);
        EventQuery query = new EventQuery();
        query.setText("testSearchEventWithCategory");
        query.setCategoryId(new String[]{category2.getId()});
        List list = this.calendarService_.searchEvent(this.username, query, new String[0]).getAll();
        this.assertNotContain(event.getId(), list);
        list = this.calendarService_.getEvents(this.username, query, new String[0]);
        this.assertNotContain(event.getId(), list);
        query.setCategoryId(new String[]{category1.getId()});
        list = this.calendarService_.searchEvent(this.username, query, new String[0]).getAll();
        this.assertContain(event.getId(), list);
        list = this.calendarService_.getEvents(this.username, query, new String[0]);
        this.assertContain(event.getId(), list);
        query.setCategoryId(new String[]{category2.getId(), category1.getId()});
        list = this.calendarService_.searchEvent(this.username, query, new String[0]).getAll();
        this.assertContain(event.getId(), list);
        list = this.calendarService_.getEvents(this.username, query, new String[0]);
        this.assertContain(event.getId(), list);
        query.setCategoryId(new String[]{"defaultEventCategoryIdAll"});
        list = this.calendarService_.searchEvent(this.username, query, new String[0]).getAll();
        this.assertContain(event.getId(), list);
        list = this.calendarService_.getEvents(this.username, query, new String[0]);
        this.assertContain(event.getId(), list);
        query.setCategoryId(new String[]{category2.getId(), "defaultEventCategoryIdAll"});
        list = this.calendarService_.searchEvent(this.username, query, new String[0]).getAll();
        this.assertContain(event.getId(), list);
        list = this.calendarService_.getEvents(this.username, query, new String[0]);
        this.assertContain(event.getId(), list);
    }

    public void testSearchSharedEventWithCategory() throws Exception {
        String user = "john";
        Calendar calendar = this.createPrivateCalendar(this.username, "testSearchSharedEventWithCategory", "testSearchSharedEventWithCategory");
        this.calendarService_.shareCalendar(this.username, calendar.getId(), Arrays.asList("john"));
        calendar.setViewPermission(new String[]{"john"});
        calendar.setEditPermission(new String[]{"john"});
        this.calendarService_.saveUserCalendar(this.username, calendar, false);
        this.login("john");
        EventCategory category1 = this.createUserEventCategory("john", "event category 1");
        EventCategory category2 = this.createUserEventCategory("john", "event category 2");
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.add(12, 30);
        java.util.Calendar to = java.util.Calendar.getInstance();
        from.add(12, 60);
        CalendarEvent event = this.createUserEvent(calendar.getId(), category1, "My testSearchSharedEventWithCategory event", false, from, to);
        EventQuery query = new EventQuery();
        query.setText("testSearchSharedEventWithCategory");
        query.setCategoryId(new String[]{category2.getId()});
        List list = this.calendarService_.searchEvent("john", query, new String[0]).getAll();
        this.assertNotContain(event.getId(), list);
        list = this.calendarService_.getEvents("john", query, new String[0]);
        this.assertNotContain(event.getId(), list);
        query.setCategoryId(new String[]{category1.getId()});
        list = this.calendarService_.searchEvent("john", query, new String[0]).getAll();
        this.assertContain(event.getId(), list);
        list = this.calendarService_.getEvents("john", query, new String[0]);
        this.assertContain(event.getId(), list);
        query.setCategoryId(new String[]{category2.getId(), category1.getId()});
        list = this.calendarService_.searchEvent("john", query, new String[0]).getAll();
        this.assertContain(event.getId(), list);
        list = this.calendarService_.getEvents("john", query, new String[0]);
        this.assertContain(event.getId(), list);
        query.setCategoryId(new String[]{"defaultEventCategoryIdAll"});
        list = this.calendarService_.searchEvent("john", query, new String[0]).getAll();
        this.assertContain(event.getId(), list);
        list = this.calendarService_.getEvents("john", query, new String[0]);
        this.assertContain(event.getId(), list);
        query.setCategoryId(new String[]{category2.getId(), "defaultEventCategoryIdAll"});
        list = this.calendarService_.searchEvent("john", query, new String[0]).getAll();
        this.assertContain(event.getId(), list);
        list = this.calendarService_.getEvents("john", query, new String[0]);
        this.assertContain(event.getId(), list);
    }

    public void testSearchPublicEventWithCategory() throws Exception {
        String group = "/platform/user";
        Calendar calendar = this.createGroupCalendar(new String[]{"/platform/user"}, "testSearchPublicEventWithCategory", "testSearchPublicEventWithCategory");
        EventCategory category1 = this.createUserEventCategory(this.username, "event category 1");
        EventCategory category2 = this.createUserEventCategory(this.username, "event category 2");
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.add(12, 30);
        java.util.Calendar to = java.util.Calendar.getInstance();
        from.add(12, 60);
        CalendarEvent event = this.createGroupEvent(calendar.getId(), category1, "My testSearchPublicEventWithCategory event", false, from, to);
        EventQuery query = new EventQuery();
        query.setText("testSearchPublicEventWithCategory");
        query.setCategoryId(new String[]{category2.getId()});
        List list = this.calendarService_.searchEvent(this.username, query, new String[]{calendar.getId()}).getAll();
        this.assertNotContain(event.getId(), list);
        list = this.calendarService_.getEvents(this.username, query, new String[]{calendar.getId()});
        this.assertNotContain(event.getId(), list);
        query.setCalendarId(null);
        query.setCategoryId(new String[]{category1.getId()});
        list = this.calendarService_.searchEvent(this.username, query, new String[]{calendar.getId()}).getAll();
        this.assertContain(event.getId(), list);
        query.setCalendarId(null);
        list = this.calendarService_.getEvents(this.username, query, new String[]{calendar.getId()});
        this.assertContain(event.getId(), list);
        query.setCalendarId(null);
        query.setCategoryId(new String[]{category2.getId(), category1.getId()});
        list = this.calendarService_.searchEvent(this.username, query, new String[]{calendar.getId()}).getAll();
        this.assertContain(event.getId(), list);
        query.setCalendarId(null);
        list = this.calendarService_.getEvents(this.username, query, new String[]{calendar.getId()});
        this.assertContain(event.getId(), list);
        query.setCalendarId(null);
        query.setCategoryId(new String[]{"defaultEventCategoryIdAll"});
        list = this.calendarService_.searchEvent(this.username, query, new String[]{calendar.getId()}).getAll();
        this.assertContain(event.getId(), list);
        query.setCalendarId(null);
        list = this.calendarService_.getEvents(this.username, query, new String[]{calendar.getId()});
        this.assertContain(event.getId(), list);
        query.setCalendarId(null);
        query.setCategoryId(new String[]{category2.getId(), "defaultEventCategoryIdAll"});
        list = this.calendarService_.searchEvent(this.username, query, new String[]{calendar.getId()}).getAll();
        this.assertContain(event.getId(), list);
        query.setCalendarId(null);
        list = this.calendarService_.getEvents(this.username, query, new String[]{calendar.getId()});
        this.assertContain(event.getId(), list);
    }

    public void testGetAllNoRepeatEventWithCategory() throws Exception {
        String user = "john";
        Calendar sharedCalendar = this.createPrivateCalendar(this.username, "testAllNoRepeatEventWithCategory", "testAllNoRepeatEventWithCategory");
        this.calendarService_.shareCalendar(this.username, sharedCalendar.getId(), Arrays.asList("john"));
        sharedCalendar.setViewPermission(new String[]{"john"});
        sharedCalendar.setEditPermission(new String[]{"john"});
        this.calendarService_.saveUserCalendar(this.username, sharedCalendar, false);
        this.login("john");
        EventCategory category1 = this.createUserEventCategory("john", "event category 1");
        EventCategory category2 = this.createUserEventCategory("john", "event category 2");
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.add(12, 30);
        java.util.Calendar to = java.util.Calendar.getInstance();
        from.add(12, 60);
        Calendar calendar = this.createPrivateCalendar("john", "testAllNoRepeatEventWithCategory", "testAllNoRepeatEventWithCategory");
        Calendar groupCalendar = this.createGroupCalendar(new String[]{"/platform/user"}, "group calendar", "group calendar");
        CalendarEvent event = this.createUserEvent("john", calendar.getId(), category1, "My testAllNoRepeatEventWithCategory event", false, from, to);
        CalendarEvent sharedEvent = this.createUserEvent(sharedCalendar.getId(), category1, "My testAllNoRepeatEventWithCategory shared event", false, from, to);
        CalendarEvent groupEvent = this.createGroupEvent(groupCalendar.getId(), category1, "My testAllNoRepeatEventWithCategory group event", false, from, to);
        EventQuery query = new EventQuery();
        query.setText("testAllNoRepeatEventWithCategory");
        from.add(5, -2);
        to.add(5, 2);
        query.setFromDate(from);
        query.setToDate(to);
        query.setCalendarId(null);
        query.setCategoryId(new String[]{category2.getId()});
        List list = this.calendarService_.getAllNoRepeatEventsSQL("john", query, new String[]{calendar.getId()}, new String[]{groupCalendar.getId()}, Collections.emptyList());
        this.assertNotContain(event.getId(), list);
        this.assertNotContain(sharedEvent.getId(), list);
        this.assertNotContain(groupEvent.getId(), list);
        query.setCalendarId(null);
        query.setCategoryId(new String[]{category1.getId()});
        list = this.calendarService_.getAllNoRepeatEventsSQL("john", query, new String[]{calendar.getId()}, new String[]{groupCalendar.getId()}, Collections.emptyList());
        this.assertContain(event.getId(), list);
        this.assertContain(sharedEvent.getId(), list);
        this.assertContain(groupEvent.getId(), list);
        query.setCalendarId(null);
        query.setCategoryId(new String[]{category2.getId(), category1.getId()});
        list = this.calendarService_.getAllNoRepeatEventsSQL("john", query, new String[]{calendar.getId()}, new String[]{groupCalendar.getId()}, Collections.emptyList());
        this.assertContain(event.getId(), list);
        this.assertContain(sharedEvent.getId(), list);
        this.assertContain(groupEvent.getId(), list);
        query.setCalendarId(null);
        query.setCategoryId(new String[]{"defaultEventCategoryIdAll"});
        list = this.calendarService_.getAllNoRepeatEventsSQL("john", query, new String[]{calendar.getId()}, new String[]{groupCalendar.getId()}, Collections.emptyList());
        this.assertContain(event.getId(), list);
        this.assertContain(sharedEvent.getId(), list);
        this.assertContain(groupEvent.getId(), list);
        query.setCalendarId(null);
        query.setCategoryId(new String[]{category2.getId(), "defaultEventCategoryIdAll"});
        list = this.calendarService_.getAllNoRepeatEventsSQL("john", query, new String[]{calendar.getId()}, new String[]{groupCalendar.getId()}, Collections.emptyList());
        this.assertContain(event.getId(), list);
        this.assertContain(sharedEvent.getId(), list);
        this.assertContain(groupEvent.getId(), list);
    }

    private void assertContain(String eventId, Collection<CalendarEvent> events) {
        for (CalendarEvent e : events) {
            if (!e.getId().equals(eventId)) continue;
            return;
        }
        EventSearchTestCase.fail((String)("Event id [" + eventId + "] should be found in search result"));
    }

    private void assertNotContain(String eventId, Collection<CalendarEvent> events) {
        for (CalendarEvent e : events) {
            if (!e.getId().equals(eventId)) continue;
            EventSearchTestCase.fail((String)("Event id [" + eventId + "] should be found in search result"));
        }
    }
}

