/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.impl.MailNotification;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.junit.Assert;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MailNotificationTest
extends BaseCalendarServiceTestCase {
    private OrganizationService organizationService;
    private MailService mailService;
    private CalendarService calendarService;
    private static final String USERNAMEROOT = "root";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.mailService = (MailService)Mockito.mock(MailService.class);
        this.getContainer().unregisterComponent(MailService.class);
        this.getContainer().registerComponentInstance(MailService.class, (Object)this.mailService);
        this.calendarService = (CalendarService)this.getContainer().getComponentInstanceOfType(CalendarService.class);
        this.begin();
        UserHandler userHandler = this.organizationService.getUserHandler();
        User userLionel = userHandler.createUserInstance("lionel");
        userHandler.createUser(userLionel, true);
        userLionel.setFirstName("Lionel");
        userLionel.setLastName("Messi");
        userLionel.setEmail("lionel@gmail.com");
        userHandler.saveUser(userLionel, true);
        User userRonaldo = userHandler.createUserInstance("cristiano");
        userHandler.createUser(userRonaldo, true);
        userRonaldo.setFirstName("Cristiano");
        userRonaldo.setLastName("Ronaldo");
        userRonaldo.setEmail("cristiano@gmail.com");
        userHandler.saveUser(userRonaldo, true);
        ConversationState.getCurrent().setAttribute("UserProfile", (Object)this.organizationService.getUserHandler().findUserByName(USERNAMEROOT));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.organizationService.getUserProfileHandler().removeUserProfile("lionel", true);
        this.organizationService.getUserHandler().removeUser("lionel", true);
        this.organizationService.getUserProfileHandler().removeUserProfile("cristiano", true);
        this.organizationService.getUserHandler().removeUser("cristiano", true);
        this.end();
    }

    public void testShouldSendMailToParticipantAfterCreateEventInPublicCalendar() throws Exception {
        MailNotificationTest.assertNotNull((Object)MailNotification.EXO_EMAIL_SMTP_FROM);
        if (System.getProperty("exo.email.smtp.from") == null) {
            MailNotificationTest.assertEquals((String)"noreply@exoplatform.com", (String)MailNotification.EXO_EMAIL_SMTP_FROM);
        }
        Calendar calendar = this.createGroupCalendar(new String[]{"/platform/users", "/organization/management/executive-board"}, "CalendarName", "CalendarDesscription");
        CalendarEvent newEvent = new CalendarEvent();
        newEvent.setCalendarId(calendar.getId());
        newEvent.setCalType(String.valueOf(2));
        newEvent.setSummary("Meeting");
        String[] participants = new String[]{"lionel", "cristiano"};
        newEvent.setParticipant(participants);
        LocalDateTime fromDateTime = LocalDateTime.now();
        newEvent.setFromDateTime(Date.from(fromDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        newEvent.setToDateTime(Date.from(fromDateTime.plusHours(2L).atZone(ZoneId.systemDefault()).toInstant()));
        java.util.Calendar calFrom = java.util.Calendar.getInstance();
        calFrom.setTime(newEvent.getFromDateTime());
        java.util.Calendar calTo = java.util.Calendar.getInstance();
        calTo.setTime(newEvent.getToDateTime());
        Attachment attachment = new Attachment();
        attachment.setName("attachment1.txt");
        attachment.setMimeType("plain/text");
        attachment.setInputStream((InputStream)new ByteArrayInputStream("text".getBytes()));
        newEvent.setAttachment(Arrays.asList(attachment));
        this.calendarService.savePublicEvent(USERNAMEROOT, calendar.getId(), newEvent, true);
        MailNotification.sendEmail((CalendarEvent)newEvent, (String)USERNAMEROOT);
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((MailService)Mockito.verify((Object)this.mailService, (VerificationMode)Mockito.times((int)4))).sendMessage((Message)messageCaptor.capture());
        List messages = messageCaptor.getAllValues();
        Message messageLionel = (Message)messages.get(0);
        Assert.assertTrue((boolean)messageLionel.getSubject().startsWith("[invitation] Meeting"));
        Assert.assertEquals((Object)("Root Root<" + MailNotification.EXO_EMAIL_SMTP_FROM + ">"), (Object)messageLionel.getFrom());
        Assert.assertEquals((Object)"lionel@gmail.com", (Object)messageLionel.getTo());
        Assert.assertNotNull((Object)messageLionel.getAttachment());
        Assert.assertEquals((long)2L, (long)messageLionel.getAttachment().size());
        Message messageCristiano = (Message)messages.get(1);
        Assert.assertTrue((boolean)messageCristiano.getSubject().startsWith("[invitation] Meeting"));
        Assert.assertEquals((Object)("Root Root<" + MailNotification.EXO_EMAIL_SMTP_FROM + ">"), (Object)messageCristiano.getFrom());
        Assert.assertEquals((Object)"cristiano@gmail.com", (Object)messageCristiano.getTo());
        Assert.assertNotNull((Object)messageCristiano.getAttachment());
        Assert.assertEquals((long)2L, (long)messageCristiano.getAttachment().size());
        MailNotificationTest.assertNotNull((Object)MailNotification.getParticiapntsDisplayName((CalendarEvent)newEvent));
        MailNotificationTest.assertEquals((String)"Lionel Messi,Cristiano Ronaldo", (String)MailNotification.getParticiapntsDisplayName((CalendarEvent)newEvent));
        MailNotificationTest.assertNotNull((Object)MailNotification.getEmailsInivtationList((CalendarEvent)newEvent, (String)USERNAMEROOT));
        MailNotificationTest.assertEquals((String)"lionel@gmail.com,cristiano@gmail.com", (String)MailNotification.getEmailsInivtationList((CalendarEvent)newEvent, (String)USERNAMEROOT));
        MailNotificationTest.assertNotNull((Object)newEvent.getAttachment());
    }

    public void testShouldSendMailToParticipantAfterEditEventInPublicCalendar() throws Exception {
        MailNotificationTest.assertNotNull((Object)MailNotification.EXO_EMAIL_SMTP_FROM);
        if (System.getProperty("exo.email.smtp.from") == null) {
            MailNotificationTest.assertEquals((String)"noreply@exoplatform.com", (String)MailNotification.EXO_EMAIL_SMTP_FROM);
        }
        Calendar calendar = this.createGroupCalendar(new String[]{"/platform/users", "/organization/management/executive-board"}, "CalendarName", "CalendarDesscription");
        CalendarEvent newEvent = new CalendarEvent();
        newEvent.setCalendarId(calendar.getId());
        newEvent.setCalType(String.valueOf(2));
        newEvent.setSummary("Meeting");
        String[] participants = new String[]{"lionel", "cristiano"};
        newEvent.setParticipant(participants);
        LocalDateTime fromDateTime = LocalDateTime.now();
        newEvent.setFromDateTime(Date.from(fromDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        newEvent.setToDateTime(Date.from(fromDateTime.plusHours(2L).atZone(ZoneId.systemDefault()).toInstant()));
        java.util.Calendar calFrom = java.util.Calendar.getInstance();
        calFrom.setTime(newEvent.getFromDateTime());
        java.util.Calendar calTo = java.util.Calendar.getInstance();
        calTo.setTime(newEvent.getToDateTime());
        Attachment attachment = new Attachment();
        attachment.setName("attachment1.txt");
        attachment.setMimeType("plain/text");
        attachment.setInputStream((InputStream)new ByteArrayInputStream("text".getBytes()));
        newEvent.setAttachment(Arrays.asList(attachment));
        this.calendarService.savePublicEvent(calendar.getId(), newEvent, true);
        newEvent.setSummary("Concert");
        this.calendarService.savePublicEvent(USERNAMEROOT, calendar.getId(), newEvent, false);
        MailNotification.sendEmail((CalendarEvent)newEvent, (String)USERNAMEROOT);
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((MailService)Mockito.verify((Object)this.mailService, (VerificationMode)Mockito.times((int)4))).sendMessage((Message)messageCaptor.capture());
        List messages = messageCaptor.getAllValues();
        Message messageLionel = (Message)messages.get(2);
        Assert.assertTrue((boolean)messageLionel.getSubject().startsWith("[invitation] Concert"));
    }

    public void testShouldSendMailToParticipantAfterCreateEventInPrivateCalendar() throws Exception {
        MailNotificationTest.assertNotNull((Object)MailNotification.EXO_EMAIL_SMTP_FROM);
        if (System.getProperty("exo.email.smtp.from") == null) {
            MailNotificationTest.assertEquals((String)"noreply@exoplatform.com", (String)MailNotification.EXO_EMAIL_SMTP_FROM);
        }
        Calendar calendar = this.createPrivateCalendar(USERNAMEROOT, "personalCalendar", "it is a personal calendar");
        CalendarEvent newEvent = new CalendarEvent();
        newEvent.setCalendarId(calendar.getId());
        newEvent.setCalType(String.valueOf(0));
        newEvent.setSummary("Meeting");
        String[] participants = new String[]{"lionel", "cristiano"};
        newEvent.setParticipant(participants);
        LocalDateTime fromDateTime = LocalDateTime.now();
        newEvent.setFromDateTime(Date.from(fromDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        newEvent.setToDateTime(Date.from(fromDateTime.plusHours(2L).atZone(ZoneId.systemDefault()).toInstant()));
        java.util.Calendar calFrom = java.util.Calendar.getInstance();
        calFrom.setTime(newEvent.getFromDateTime());
        java.util.Calendar calTo = java.util.Calendar.getInstance();
        calTo.setTime(newEvent.getToDateTime());
        Attachment attachment = new Attachment();
        attachment.setName("attachment1.txt");
        attachment.setMimeType("plain/text");
        attachment.setInputStream((InputStream)new ByteArrayInputStream("text".getBytes()));
        newEvent.setAttachment(Arrays.asList(attachment));
        this.calendarService.saveUserEvent(USERNAMEROOT, calendar.getId(), newEvent, true);
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((MailService)Mockito.verify((Object)this.mailService, (VerificationMode)Mockito.times((int)2))).sendMessage((Message)messageCaptor.capture());
        List messages = messageCaptor.getAllValues();
        Message messageLionel = (Message)messages.get(0);
        Assert.assertTrue((boolean)messageLionel.getSubject().startsWith("[invitation] Meeting"));
        Assert.assertEquals((Object)("Root Root<" + MailNotification.EXO_EMAIL_SMTP_FROM + ">"), (Object)messageLionel.getFrom());
        Assert.assertEquals((Object)"lionel@gmail.com", (Object)messageLionel.getTo());
        Assert.assertNotNull((Object)messageLionel.getAttachment());
        Assert.assertEquals((long)2L, (long)messageLionel.getAttachment().size());
        Message messageCristiano = (Message)messages.get(1);
        Assert.assertTrue((boolean)messageCristiano.getSubject().startsWith("[invitation] Meeting"));
        Assert.assertEquals((Object)("Root Root<" + MailNotification.EXO_EMAIL_SMTP_FROM + ">"), (Object)messageCristiano.getFrom());
        Assert.assertEquals((Object)"cristiano@gmail.com", (Object)messageCristiano.getTo());
        Assert.assertNotNull((Object)messageCristiano.getAttachment());
        Assert.assertEquals((long)2L, (long)messageCristiano.getAttachment().size());
        MailNotificationTest.assertNotNull((Object)MailNotification.getParticiapntsDisplayName((CalendarEvent)newEvent));
        MailNotificationTest.assertEquals((String)"Lionel Messi,Cristiano Ronaldo", (String)MailNotification.getParticiapntsDisplayName((CalendarEvent)newEvent));
        MailNotificationTest.assertNotNull((Object)MailNotification.getEmailsInivtationList((CalendarEvent)newEvent, (String)USERNAMEROOT));
        MailNotificationTest.assertEquals((String)"lionel@gmail.com,cristiano@gmail.com", (String)MailNotification.getEmailsInivtationList((CalendarEvent)newEvent, (String)USERNAMEROOT));
        MailNotificationTest.assertNotNull((Object)newEvent.getAttachment());
    }

    public void testShouldSendMailToParticipantAfterEditEventInPrivateCalendar() throws Exception {
        MailNotificationTest.assertNotNull((Object)MailNotification.EXO_EMAIL_SMTP_FROM);
        if (System.getProperty("exo.email.smtp.from") == null) {
            MailNotificationTest.assertEquals((String)"noreply@exoplatform.com", (String)MailNotification.EXO_EMAIL_SMTP_FROM);
        }
        Calendar calendar = this.createPrivateCalendar(USERNAMEROOT, "personalCalendar", "it is a personal calendar");
        CalendarEvent newEvent = new CalendarEvent();
        newEvent.setCalendarId(calendar.getId());
        newEvent.setCalType(String.valueOf(0));
        newEvent.setSummary("Meeting");
        String[] participants = new String[]{"lionel", "cristiano"};
        newEvent.setParticipant(participants);
        LocalDateTime fromDateTime = LocalDateTime.now();
        newEvent.setFromDateTime(Date.from(fromDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        newEvent.setToDateTime(Date.from(fromDateTime.plusHours(2L).atZone(ZoneId.systemDefault()).toInstant()));
        java.util.Calendar calFrom = java.util.Calendar.getInstance();
        calFrom.setTime(newEvent.getFromDateTime());
        java.util.Calendar calTo = java.util.Calendar.getInstance();
        calTo.setTime(newEvent.getToDateTime());
        Attachment attachment = new Attachment();
        attachment.setName("attachment1.txt");
        attachment.setMimeType("plain/text");
        attachment.setInputStream((InputStream)new ByteArrayInputStream("text".getBytes()));
        newEvent.setAttachment(Arrays.asList(attachment));
        this.calendarService.saveUserEvent(USERNAMEROOT, calendar.getId(), newEvent, true);
        newEvent.setSummary("Seminar");
        this.calendarService.saveUserEvent(USERNAMEROOT, calendar.getId(), newEvent, false);
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((MailService)Mockito.verify((Object)this.mailService, (VerificationMode)Mockito.times((int)4))).sendMessage((Message)messageCaptor.capture());
        List messages = messageCaptor.getAllValues();
        Message messageLionel = (Message)messages.get(2);
        Assert.assertTrue((boolean)messageLionel.getSubject().startsWith("[invitation] Seminar"));
        Assert.assertEquals((Object)("Root Root<" + MailNotification.EXO_EMAIL_SMTP_FROM + ">"), (Object)messageLionel.getFrom());
        Assert.assertEquals((Object)"lionel@gmail.com", (Object)messageLionel.getTo());
        Assert.assertNotNull((Object)messageLionel.getAttachment());
        Assert.assertEquals((long)2L, (long)messageLionel.getAttachment().size());
        Message messageCristiano = (Message)messages.get(3);
        Assert.assertTrue((boolean)messageCristiano.getSubject().startsWith("[invitation] Seminar"));
    }
}

