/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.util.List;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.calendar.component.service-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.calendar.component.service-dependencies-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.calendar.component.service-local-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/exo.calendar.test.newgrouplistener_ignoreall_configuration.xml")})
public class TestNewGroupListenerWithIgnoreAll
extends BaseCalendarServiceTestCase {
    private CalendarService calendarService;
    private OrganizationService organizationService;
    private String username = "root";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.calendarService = this.getService(CalendarService.class);
        this.organizationService = this.getService(OrganizationService.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIgnoredGroup() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.createGroupInstance();
        group.setGroupName("groupA");
        group.setLabel("label for group groupA");
        groupHandler.addChild(null, group, true);
        TestNewGroupListenerWithIgnoreAll.assertNotNull((Object)groupHandler.findGroupById("/groupA"));
        List calendars = this.calendarService.getGroupCalendars(new String[]{"/groupA"}, true, this.username);
        TestNewGroupListenerWithIgnoreAll.assertEquals((int)0, (int)calendars.size());
        Group plf = groupHandler.findGroupById("/platform");
        group = groupHandler.createGroupInstance();
        group.setGroupName("groupB");
        group.setLabel("label for group groupB");
        groupHandler.addChild(plf, group, true);
        TestNewGroupListenerWithIgnoreAll.assertNotNull((Object)groupHandler.findGroupById("/groupB"));
        calendars = this.calendarService.getGroupCalendars(new String[]{"/platform/groupB"}, true, this.username);
        TestNewGroupListenerWithIgnoreAll.assertEquals((int)0, (int)calendars.size());
    }
}

