/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarSearchResult;
import org.exoplatform.calendar.service.impl.CalendarSearchServiceConnector;
import org.exoplatform.calendar.service.impl.EventSearchConnector;
import org.exoplatform.calendar.service.impl.UnifiedQuery;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.router.Router;

public class UnifiedSearchTestCase
extends BaseCalendarServiceTestCase {
    private CalendarSearchServiceConnector unifiedSearchService_;
    private CalendarSearchServiceConnector eventSearchConnector_;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.unifiedSearchService_ = this.getService(CalendarSearchServiceConnector.class);
        this.eventSearchConnector_ = (CalendarSearchServiceConnector)this.getService(EventSearchConnector.class);
    }

    public void testParseKeyword() {
        String keyword = "hello \" i am  a \" new guy";
        List formated = UnifiedQuery.parse((String)keyword);
        UnifiedSearchTestCase.assertEquals((int)4, (int)formated.size());
        keyword = keyword + " \" why don't \"we talk \" ";
        formated = UnifiedQuery.parse((String)keyword);
        UnifiedSearchTestCase.assertEquals((int)8, (int)formated.size());
    }

    public void testUnifiedSeach() throws Exception {
        this.login(this.username);
        String keyword = "hello \"how are\" you ";
        UnifiedQuery query = new UnifiedQuery();
        query.setQueryType("sql");
        query.setText(keyword);
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        Collection result = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertNotNull((Object)result);
        UnifiedSearchTestCase.assertEquals((int)0, (int)result.size());
        Calendar cal = this.createPrivateCalendar(this.username, "myCalendar", "Description");
        CalendarEvent calEvent = this.createUserEvent(this.username, cal.getId(), "do you getting Have some busy day?", "", true);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(cal.getId());
        List data = this.calendarService_.getUserEventByCalendar(this.username, ids);
        UnifiedSearchTestCase.assertEquals((int)1, (int)data.size());
        keyword = "Have \"you getting\" busy";
        query.setText(keyword);
        result = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)1, (int)result.size());
        for (SearchResult item : result) {
            this.checkFieldsValueWithType(cal.getName(), calEvent, item);
        }
        calEvent.setDescription("we have meeting with CEO");
        this.calendarService_.saveUserEvent(this.username, cal.getId(), calEvent, false);
        keyword = "do \"you getting\" CEO";
        query.setText(keyword);
        result = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)1, (int)result.size());
        for (SearchResult item : result) {
            this.checkFieldsValueWithType(cal.getName(), calEvent, item);
        }
        calEvent.setLocation("in Hanoi");
        this.calendarService_.saveUserEvent(this.username, cal.getId(), calEvent, false);
        keyword = "hanoi CEO";
        query.setText(keyword);
        query.setOrderBy(new String[]{Utils.ORDERBY_DATE});
        result = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)1, (int)result.size());
        for (SearchResult item : result) {
            this.checkFieldsValueWithType(cal.getName(), calEvent, item);
        }
        calEvent.setEventType(CalendarEvent.TYPE_EVENT);
        this.calendarService_.saveUserEvent(this.username, cal.getId(), calEvent, false);
        query.setOrderBy(new String[]{Utils.ORDERBY_RELEVANCY});
        result = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)1, (int)result.size());
        for (SearchResult item : result) {
            this.checkFieldsValueWithType(cal.getName(), calEvent, item);
        }
    }

    public void testSearchResultURL() throws Exception {
        Calendar cal = this.createPrivateCalendar(this.username, "myCalendar", "Description");
        this.createUserEvent(this.username, cal.getId(), "do you getting", "", true);
        String siteName = "classic";
        SearchContext sc = new SearchContext(this.loadConfiguration("conf/portal/controller.xml"), siteName);
        UnifiedSearchTestCase.assertNotNull((Object)sc);
        sc.lang("en");
        Router rt = sc.getRouter();
        UnifiedSearchTestCase.assertNotNull((Object)rt);
        ExoContainerContext context = (ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class);
        String portalName = context.getPortalContainerName();
        String spaceGroupId = null;
        String url = this.unifiedSearchService_.getUrl(rt, portalName, siteName, spaceGroupId, "calendar");
        UnifiedSearchTestCase.assertEquals((String)("/" + portalName + "/" + siteName + "/" + "calendar"), (String)url);
        spaceGroupId = "/spaces/space1";
        url = this.unifiedSearchService_.getUrl(rt, portalName, siteName, spaceGroupId, "calendar");
        UnifiedSearchTestCase.assertEquals((String)("/" + portalName + "/g/" + spaceGroupId.replaceAll("/", ":") + "/space1/" + "calendar"), (String)url);
        UnifiedQuery query = new UnifiedQuery();
        query.setQueryType("sql");
        query.setText("do you getting");
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        Collection result = this.eventSearchConnector_.search(sc, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)1, (int)result.size());
        url = this.unifiedSearchService_.getUrl(rt, portalName, siteName, null, "calendar");
        for (SearchResult sr : result) {
            this.checkFields(sr);
            UnifiedSearchTestCase.assertEquals((String)(url + "/" + "details" + "/" + sr.getUrl().split("/")[sr.getUrl().split("/").length - 1]), (String)sr.getUrl());
        }
        sc = new SearchContext(this.loadConfiguration("conf/portal/controller.xml"), null);
        sc.lang("en");
        siteName = "intranet";
        spaceGroupId = null;
        url = this.unifiedSearchService_.getUrl(rt, portalName, siteName, spaceGroupId, "calendar");
        UnifiedSearchTestCase.assertEquals((String)("/" + portalName + "/" + siteName + "/" + "calendar"), (String)url);
        spaceGroupId = "/spaces/space1";
        url = this.unifiedSearchService_.getUrl(rt, portalName, siteName, spaceGroupId, "calendar");
        UnifiedSearchTestCase.assertEquals((String)("/" + portalName + "/g/" + spaceGroupId.replaceAll("/", ":") + "/space1/" + "calendar"), (String)url);
        result = this.eventSearchConnector_.search(sc, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)1, (int)result.size());
        url = this.unifiedSearchService_.getUrl(rt, portalName, siteName, null, "");
        for (SearchResult sr : result) {
            this.checkFields(sr);
            UnifiedSearchTestCase.assertEquals((String)(url + "/" + "details" + "/" + sr.getUrl().split("/")[sr.getUrl().split("/").length - 1]), (String)sr.getUrl());
        }
    }

    public void testSearchWithDate() throws Exception {
        Calendar cal = this.createPrivateCalendar(this.username, "root calendar", "");
        CalendarEvent inPassEvent = this.createUserEvent(this.username, cal.getId(), "Summary CEO", "Hanoi", true);
        java.util.Calendar current = java.util.Calendar.getInstance();
        current.add(11, -1);
        inPassEvent.setFromDateTime(current.getTime());
        current.add(12, 30);
        inPassEvent.setToDateTime(current.getTime());
        this.calendarService_.saveUserEvent(this.username, cal.getId(), inPassEvent, false);
        List events = this.calendarService_.getUserEventByCalendar(this.username, Arrays.asList(cal.getId()));
        UnifiedSearchTestCase.assertEquals((int)1, (int)events.size());
        UnifiedQuery query = new UnifiedQuery();
        query.setQueryType("sql");
        query.setText("Hanoi CEO");
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        Collection result = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)0, (int)result.size());
        current = java.util.Calendar.getInstance();
        current.add(12, 1);
        inPassEvent.setFromDateTime(current.getTime());
        current.add(12, 30);
        inPassEvent.setToDateTime(current.getTime());
        this.calendarService_.saveUserEvent(this.username, cal.getId(), inPassEvent, false);
        result = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)1, (int)result.size());
    }

    public void testSearchPermission() throws Exception {
        String john = "john";
        Calendar johnCalendar = this.createPrivateCalendar(john, "johnCalendar", "");
        this.createUserEvent(john, johnCalendar.getId(), "Summary CEO come we will have some dayoff", "Hanoi", true);
        UnifiedQuery query = new UnifiedQuery();
        query.setQueryType("sql");
        query.setText("Hanoi CEO");
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        this.login(john);
        ArrayList params = new ArrayList();
        Collection result = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)1, (int)result.size());
        this.login(this.username);
        result = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)0, (int)result.size());
    }

    public void testSearchOrder() throws Exception {
        Calendar cal = this.createPrivateCalendar(this.username, "myCalendar", "Description");
        CalendarEvent calEvent = this.createUserEvent(this.username, cal.getId(), "today is friday, we will have a weekend", "", true);
        CalendarEvent calEvent2 = this.createUserEvent(this.username, cal.getId(), "Summary CEO come we will have some dayoff", "friday", true);
        String keyword = "\"we will have\" friday";
        UnifiedQuery query = new UnifiedQuery();
        query.setText(keyword);
        query.setOrderType("DESC");
        query.setOrderBy(new String[]{Utils.ORDERBY_RELEVANCY});
        ArrayList params = new ArrayList();
        Collection result = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)2, (int)result.size());
        SearchResult item = (SearchResult)result.toArray()[0];
        this.checkFields(item);
        SearchResult item2 = (SearchResult)result.toArray()[1];
        this.checkFields(item2);
        UnifiedSearchTestCase.assertEquals((boolean)false, (item2.getRelevancy() > item.getRelevancy() ? 1 : 0) != 0);
        query.setOrderBy(new String[]{Utils.ORDERBY_DATE});
        query.setOrderType("ASC");
        result = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)2, (int)result.size());
        CalendarSearchResult calSerResult = (CalendarSearchResult)result.toArray()[0];
        this.checkFields(calSerResult);
        this.checkFieldsValueWithType(cal.getName(), calEvent, calSerResult);
        CalendarSearchResult calSerResult2 = (CalendarSearchResult)result.toArray()[1];
        this.checkFields(calSerResult2);
        this.checkFieldsValueWithType(cal.getName(), calEvent2, calSerResult2);
        UnifiedSearchTestCase.assertEquals((boolean)true, (item.getDate() < item2.getDate() ? 1 : 0) != 0);
    }

    public void testUnifiedSeachEx() throws Exception {
        this.login(this.username);
        String calId = this.createPrivateCalendar(this.username, "root calendar", "").getId();
        this.createUserEvent(this.username, calId, "how do you do root", "you are a search able event", false);
        this.createUserEvent(this.username, calId, "are you here?", "I am not search able event with john", false);
        String john = "john";
        this.calendarService_.shareCalendar(this.username, calId, Arrays.asList(john));
        String keyword = "you are search able";
        UnifiedQuery query = new UnifiedQuery();
        query.setText(keyword);
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        Collection result = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertNotNull((Object)result);
        UnifiedSearchTestCase.assertEquals((int)2, (int)result.size());
        this.login(john);
        result = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)2, (int)result.size());
    }

    public void testUnifiedSeachAllWord() throws Exception {
        String keyword = "abcde fghik";
        Calendar cal = this.createPrivateCalendar(this.username, "root calendar", "");
        this.createUserEvent(cal.getId(), null, keyword);
        this.createUserEvent(cal.getId(), null, "abcde");
        this.createUserEvent(cal.getId(), null, "fghik");
        UnifiedQuery query = new UnifiedQuery();
        query.setText(keyword);
        ArrayList params = new ArrayList();
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        Collection result = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertNotNull((Object)result);
        UnifiedSearchTestCase.assertEquals((int)result.size(), (int)1);
        UnifiedSearchTestCase.assertEquals((String)keyword, (String)((SearchResult)result.iterator().next()).getTitle());
    }

    public void testSearchSpecialCharacter() throws Exception {
        String keyword = "Have a%'\\_-\". meeting";
        this.createUserEvent(keyword);
        EventQuery query = new EventQuery();
        query.setText(keyword);
        query.setQueryType("xpath");
        UnifiedSearchTestCase.assertEquals((int)1, (int)this.calendarService_.searchEvent(this.username, query, new String[0]).getAll().size());
        UnifiedSearchTestCase.assertEquals((int)1, (int)this.calendarService_.getEvents(this.username, query, new String[0]).size());
        query.setQueryType("sql");
        UnifiedSearchTestCase.assertEquals((int)1, (int)this.calendarService_.searchEvent(this.username, query, new String[0]).getAll().size());
        UnifiedSearchTestCase.assertEquals((int)1, (int)this.calendarService_.getEvents(this.username, query, new String[0]).size());
        UnifiedQuery uQuery = new UnifiedQuery();
        uQuery.setText(keyword);
        ArrayList params = new ArrayList();
        uQuery.setOrderType("ASC");
        uQuery.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        Collection result = this.unifiedSearchService_.search(null, uQuery.getText(), params, 0, 10, uQuery.getOrderBy()[0], uQuery.getOrderType());
        UnifiedSearchTestCase.assertNotNull((Object)result);
        UnifiedSearchTestCase.assertEquals((int)1, (int)result.size());
    }

    public void testMultiThreadSearch() throws Exception {
        String keyword = "Have a meeting";
        LinkedList<Calendar> calendars = new LinkedList<Calendar>();
        for (int i = 0; i < 100; ++i) {
            Calendar cal = new Calendar();
            cal.setName("CalendarName" + i);
            this.calendarService_.saveUserCalendar(this.username, cal, true);
            calendars.add(cal);
            CalendarEvent calEvent = this.createCalendarEventInstance(keyword);
            this.calendarService_.saveUserEvent(this.username, cal.getId(), calEvent, true);
        }
        UnifiedQuery uQuery = new UnifiedQuery();
        uQuery.setText(keyword);
        ArrayList params = new ArrayList();
        uQuery.setOrderType("ASC");
        uQuery.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        AtomicBoolean fail = new AtomicBoolean(false);
        final CountDownLatch wait = new CountDownLatch(1);
        final PortalContainer container = this.getContainer();
        Runnable runner = new Runnable((EventQuery)uQuery, params, fail){
            final /* synthetic */ EventQuery val$uQuery;
            final /* synthetic */ Collection val$params;
            final /* synthetic */ AtomicBoolean val$fail;
            {
                this.val$uQuery = eventQuery;
                this.val$params = collection;
                this.val$fail = atomicBoolean;
            }

            @Override
            public void run() {
                ExoContainerContext.setCurrentContainer((ExoContainer)container);
                try {
                    wait.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                UnifiedSearchTestCase.this.begin();
                UnifiedSearchTestCase.this.login(UnifiedSearchTestCase.this.username);
                Collection result = UnifiedSearchTestCase.this.unifiedSearchService_.search(null, this.val$uQuery.getText(), this.val$params, 0, -1, this.val$uQuery.getOrderBy()[0], this.val$uQuery.getOrderType());
                if (result == null || result.size() < 100) {
                    this.val$fail.set(true);
                }
                UnifiedSearchTestCase.this.end();
                ExoContainerContext.setCurrentContainer(null);
            }
        };
        LinkedList<Thread> threads = new LinkedList<Thread>();
        for (int i = 0; i < 20; ++i) {
            Thread t = new Thread(runner);
            t.start();
            threads.add(t);
        }
        wait.countDown();
        for (Thread t : threads) {
            t.join();
        }
        UnifiedSearchTestCase.assertFalse((boolean)fail.get());
    }

    public void testUnifiedSeachDetail() throws Exception {
        this.login(this.username);
        Calendar cal = new Calendar();
        cal.setName("root calendar");
        cal.setTimeZone(TimeZone.getAvailableIDs(0)[0]);
        this.calendarService_.saveUserCalendar(this.username, cal, true);
        CalendarSetting calSetting = this.calendarService_.getCalendarSetting(this.username);
        String keyword = "test";
        CalendarEvent calEvent = this.createUserEvent(this.username, cal.getId(), keyword, "", true);
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        fromCal.setTime(calEvent.getFromDateTime());
        UnifiedQuery query = new UnifiedQuery();
        query.setText(keyword);
        ArrayList params = new ArrayList();
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        Collection result = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertNotNull((Object)result);
        UnifiedSearchTestCase.assertEquals((int)result.size(), (int)1);
        SearchResult r = (SearchResult)result.iterator().next();
        UnifiedSearchTestCase.assertEquals((String)keyword, (String)r.getTitle());
        SimpleDateFormat df = new SimpleDateFormat(Utils.DATE_TIME_FORMAT);
        df.setTimeZone(DateUtils.getTimeZone((String)calSetting.getTimeZone()));
        String detail = "root calendar - " + df.format(fromCal.getTime());
        UnifiedSearchTestCase.assertEquals((String)detail, (String)r.getDetail());
    }

    public void testUnifiedSearchInReadOnlySharedCalendar() throws Exception {
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        fromCal.add(12, 5);
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(12, 65);
        String keyword = "search this event";
        String publicEventTitle = "UnifiedSearchWithPublicEventInReadonlySharedCalendar";
        String privateEventTitle = "UnifiedSearchWithPrivateEventInReadonlySharedCalendar";
        this.login(this.username);
        Calendar cal = new Calendar();
        cal.setName("root shared calendar as readonly");
        this.calendarService_.saveUserCalendar(this.username, cal, true);
        this.calendarService_.shareCalendar(this.username, cal.getId(), Arrays.asList("john"));
        CalendarEvent pubEvent = new CalendarEvent();
        pubEvent.setFromDateTime(fromCal.getTime());
        pubEvent.setToDateTime(toCal.getTime());
        pubEvent.setSummary(publicEventTitle);
        pubEvent.setDescription("you can search this event");
        pubEvent.setCalendarId(cal.getId());
        pubEvent.setPrivate(false);
        this.calendarService_.saveUserEvent(this.username, cal.getId(), pubEvent, true);
        CalendarEvent priEvent = new CalendarEvent();
        priEvent.setFromDateTime(fromCal.getTime());
        priEvent.setToDateTime(toCal.getTime());
        priEvent.setSummary(privateEventTitle);
        priEvent.setDescription("you can not search this event");
        priEvent.setCalendarId(cal.getId());
        priEvent.setPrivate(true);
        this.calendarService_.saveUserEvent(this.username, cal.getId(), priEvent, true);
        this.login("john");
        Collection result = this.unifiedSearchService_.search(null, keyword, Arrays.asList(new String[0]), 0, 10, Utils.ORDERBY_TITLE, "ASC");
        this.assertNotFoundInSearchResults(privateEventTitle, result);
        this.assertFoundInSearchResults(publicEventTitle, result);
    }

    public void testUnifiedSearchInEditableSharedCalendar() throws Exception {
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        fromCal.add(12, 5);
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(12, 65);
        String keyword = "search this event";
        String publicEventTitle = "UnifiedSearchWithPublicEventInEditableSharedCalendar";
        String privateEventTitle = "UnifiedSearchWithPrivateEventInEditableSharedCalendar";
        this.login(this.username);
        Calendar cal = new Calendar();
        cal.setName("root shared calendar as editable");
        this.calendarService_.saveUserCalendar(this.username, cal, true);
        this.calendarService_.shareCalendar(this.username, cal.getId(), Arrays.asList("john"));
        cal.setEditPermission(new String[]{"john"});
        this.calendarService_.saveUserCalendar(this.username, cal, false);
        CalendarEvent pubEvent = new CalendarEvent();
        pubEvent.setFromDateTime(fromCal.getTime());
        pubEvent.setToDateTime(toCal.getTime());
        pubEvent.setSummary(publicEventTitle);
        pubEvent.setDescription("you can search this event");
        pubEvent.setCalendarId(cal.getId());
        pubEvent.setPrivate(false);
        this.calendarService_.saveUserEvent(this.username, cal.getId(), pubEvent, true);
        CalendarEvent priEvent = new CalendarEvent();
        priEvent.setFromDateTime(fromCal.getTime());
        priEvent.setToDateTime(toCal.getTime());
        priEvent.setSummary(privateEventTitle);
        priEvent.setDescription("you can still search this event");
        priEvent.setCalendarId(cal.getId());
        priEvent.setPrivate(true);
        this.calendarService_.saveUserEvent(this.username, cal.getId(), priEvent, true);
        this.login("john");
        Collection results = this.unifiedSearchService_.search(null, keyword, Arrays.asList(new String[0]), 0, 10, Utils.ORDERBY_TITLE, "ASC");
        this.assertFoundInSearchResults(privateEventTitle, results);
        this.assertFoundInSearchResults(publicEventTitle, results);
    }

    public void testUnifiedSearchInReadOnlyGroupCalendar() throws Exception {
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        fromCal.add(12, 5);
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(12, 65);
        String keyword = "search this event";
        String publicEventTitle = "UnifiedSearchWithPublicEventInReadonlyGroupCalendar";
        String privateEventTitle = "UnifiedSearchWithPrivateEventInReadonlyGroupCalendar";
        this.login(this.username);
        Calendar cal = new Calendar();
        cal.setName("Group calendar");
        cal.setDescription("user group calendar");
        cal.setPublic(true);
        cal.setGroups(new String[]{"/platform/users"});
        this.calendarService_.savePublicCalendar(cal, true);
        CalendarEvent pubEvent = new CalendarEvent();
        pubEvent.setFromDateTime(fromCal.getTime());
        pubEvent.setToDateTime(toCal.getTime());
        pubEvent.setSummary(publicEventTitle);
        pubEvent.setDescription("you can search this event");
        pubEvent.setCalendarId(cal.getId());
        pubEvent.setPrivate(false);
        this.calendarService_.savePublicEvent(cal.getId(), pubEvent, true);
        CalendarEvent priEvent = new CalendarEvent();
        priEvent.setFromDateTime(fromCal.getTime());
        priEvent.setToDateTime(toCal.getTime());
        priEvent.setSummary(privateEventTitle);
        priEvent.setDescription("you can not search this event");
        priEvent.setCalendarId(cal.getId());
        priEvent.setPrivate(true);
        this.calendarService_.savePublicEvent(cal.getId(), priEvent, true);
        this.login("john");
        Collection result = this.unifiedSearchService_.search(null, keyword, Arrays.asList(new String[0]), 0, 10, Utils.ORDERBY_TITLE, "ASC");
        this.assertNotFoundInSearchResults(privateEventTitle, result);
        this.assertFoundInSearchResults(publicEventTitle, result);
    }

    public void testUnifiedSearchInEditableGroupCalendar() throws Exception {
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        fromCal.add(12, 5);
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(12, 65);
        String keyword = "search this event";
        String publicEventTitle = "UnifiedSearchWithPublicEventInEditableGroupCalendar";
        String privateEventTitle = "UnifiedSearchWithPrivateEventInEditableGroupCalendar";
        this.login(this.username);
        Calendar cal = new Calendar();
        cal.setName("Group calendar");
        cal.setDescription("user group calendar");
        cal.setPublic(true);
        cal.setGroups(new String[]{"/platform/users"});
        this.calendarService_.savePublicCalendar(cal, true);
        cal.setEditPermission(new String[]{"john"});
        this.calendarService_.savePublicCalendar(cal, false);
        CalendarEvent pubEvent = new CalendarEvent();
        pubEvent.setFromDateTime(fromCal.getTime());
        pubEvent.setToDateTime(toCal.getTime());
        pubEvent.setSummary(publicEventTitle);
        pubEvent.setDescription("you can search this event");
        pubEvent.setCalendarId(cal.getId());
        pubEvent.setPrivate(false);
        this.calendarService_.savePublicEvent(cal.getId(), pubEvent, true);
        CalendarEvent priEvent = new CalendarEvent();
        priEvent.setFromDateTime(fromCal.getTime());
        priEvent.setToDateTime(toCal.getTime());
        priEvent.setSummary(privateEventTitle);
        priEvent.setDescription("you can still search this event");
        priEvent.setCalendarId(cal.getId());
        priEvent.setPrivate(true);
        this.calendarService_.savePublicEvent(cal.getId(), priEvent, true);
        this.login("john");
        Collection result = this.unifiedSearchService_.search(null, keyword, Arrays.asList(new String[0]), 0, 10, Utils.ORDERBY_TITLE, "ASC");
        this.assertFoundInSearchResults(privateEventTitle, result);
        this.assertFoundInSearchResults(publicEventTitle, result);
    }

    public void assertNotFoundInSearchResults(String eventTitle, Collection<SearchResult> results) {
        for (SearchResult result : results) {
            if (!result.getTitle().equals(eventTitle)) continue;
            UnifiedSearchTestCase.fail((String)("The event with title " + eventTitle + " should not found in search"));
        }
    }

    public void assertFoundInSearchResults(String eventTitle, Collection<SearchResult> results) {
        for (SearchResult result : results) {
            if (!result.getTitle().equals(eventTitle)) continue;
            return;
        }
        UnifiedSearchTestCase.fail((String)("The event with title " + eventTitle + " should be returned in search"));
    }

    public void testUnifiedSearchWithSpecialCharacter() throws Exception {
        int i;
        String specialCharacter = "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\";
        this.login(this.username);
        Calendar calendar = new Calendar();
        calendar.setName("testUnifiedSeachWitchSpecialCharacter");
        calendar.setDescription("testUnifiedSeachWitchSpecialCharacter");
        calendar.setPublic(false);
        this.calendarService_.saveUserCalendar(this.username, calendar, true);
        EventCategory category = new EventCategory();
        category.setName("testUnifiedSeachWitchSpecialCharacter");
        this.calendarService_.saveEventCategory(this.username, category, true);
        CalendarEvent event = this.createUserEvent(this.username, calendar.getId(), "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\", "Event with !.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\", false);
        UnifiedQuery query = new UnifiedQuery();
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        String keyword = "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\~0.5";
        query.setText(keyword);
        Collection results = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)0, (int)results.size());
        for (i = 0; i < "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\".length(); ++i) {
            keyword = "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\".charAt(i) + "~0.5";
            query.setText(keyword);
            results = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        }
        for (i = 0; i < "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\".length(); ++i) {
            keyword = "gatein" + "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\".charAt(i) + "~0.5";
            query.setText(keyword);
            results = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
            UnifiedSearchTestCase.assertEquals((int)0, (int)results.size());
        }
        for (i = 0; i < "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\".length(); ++i) {
            keyword = "gatein3" + "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\".charAt(i) + "5~0.5";
            query.setText(keyword);
            results = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
            UnifiedSearchTestCase.assertEquals((int)0, (int)results.size());
        }
        for (i = 0; i < "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\".length(); ++i) {
            keyword = "3" + "!.,:;\"'()\"-@#$%^~*<>?/}{[]-=|\\".charAt(i) + "5~0.5";
            query.setText(keyword);
            results = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
            UnifiedSearchTestCase.assertEquals((int)0, (int)results.size());
        }
    }

    public void testUnifiedSearchWithEmptyKeyword() throws Exception {
        Calendar calendar = this.createPrivateCalendar(this.username, "testUnifiedSeachWithEmptyKeyword", "testUnifiedSeachWithEmptyKeyword");
        this.createUserEvent(this.username, calendar.getId(), "testUnifiedSeachWithEmptyKeyword", "testUnifiedSeachWithEmptyKeyword", false);
        UnifiedQuery query = new UnifiedQuery();
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        String keyword = "";
        query.setText(keyword);
        Collection results = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)0, (int)results.size());
        keyword = "  ";
        query.setText(keyword);
        results = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        UnifiedSearchTestCase.assertEquals((int)0, (int)results.size());
    }

    public void testSearchEventEndInFuture() throws Exception {
        Calendar calendar = this.createPrivateCalendar(this.username, "testSearchEventEndInFuture", "");
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        fromCal.add(11, -1);
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(11, 2);
        CalendarEvent event = this.createUserEvent(calendar.getId(), null, "testSearchEventEndInFuture", true, fromCal, toCal);
        UnifiedQuery query = new UnifiedQuery();
        query.setText("testSearchEventEndInFuture~0.5");
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        Collection results = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        this.assertFoundInSearchResults(event.getSummary(), results);
    }

    private CalendarEvent createUserEvent(String username, String calId, String summary, String desc, boolean isPrivate) throws Exception {
        CalendarEvent calEvent = this.createCalendarEventInstance(summary);
        calEvent.setDescription(desc);
        calEvent.setPrivate(isPrivate);
        this.calendarService_.saveUserEvent(username, calId, calEvent, true);
        return calEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Router loadConfiguration(String path) throws IOException {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            ControllerDescriptor routerDesc = new DescriptorBuilder().build(in);
            Router router = new Router(routerDesc);
            return router;
        }
        return null;
    }

    private void checkFieldsValueWithType(String calName, CalendarEvent calEvent, CalendarSearchResult item) {
        this.checkFieldsValueWithType(calName, calEvent, (SearchResult)item);
        if (CalendarEvent.TYPE_EVENT.equals(calEvent.getEventType())) {
            UnifiedSearchTestCase.assertEquals((long)item.getFromDateTime(), (long)calEvent.getFromDateTime().getTime());
            UnifiedSearchTestCase.assertNull((Object)item.getImageUrl());
            UnifiedSearchTestCase.assertEquals((String)Utils.EVENT_ICON_URL, (String)item.getImageUrl());
        }
        UnifiedSearchTestCase.assertNotNull((Object)item.getTimeZoneName());
    }

    private void checkFieldsValueWithType(String calName, CalendarEvent calEvent, SearchResult item) {
        UnifiedSearchTestCase.assertEquals((String)calEvent.getSummary(), (String)item.getTitle());
        if (CalendarEvent.TYPE_EVENT.equals(calEvent.getEventType())) {
            if (calEvent.getLocation() != null) {
                UnifiedSearchTestCase.assertEquals((String)(calName + " " + "-" + " " + this.df.format(calEvent.getFromDateTime()) + " " + "-" + " " + calEvent.getLocation()), (String)item.getDetail());
            }
        } else {
            UnifiedSearchTestCase.assertEquals((String)(calName + " " + "-" + " " + "Due for: " + this.df.format(calEvent.getToDateTime())), (String)item.getDetail());
        }
        UnifiedSearchTestCase.assertEquals((long)(new Date().getTime() / 3600000L), (long)(item.getDate() / 3600000L));
        UnifiedSearchTestCase.assertEquals((boolean)true, (item.getRelevancy() > 0L ? 1 : 0) != 0);
        UnifiedSearchTestCase.assertEquals((String)"#", (String)item.getUrl());
        StringBuffer sb = new StringBuffer("");
        if (calEvent.getDescription() != null) {
            sb.append(calEvent.getDescription());
        }
        UnifiedSearchTestCase.assertEquals((String)sb.toString(), (String)item.getExcerpt());
    }

    private void checkFields(SearchResult item) {
        UnifiedSearchTestCase.assertNotNull((Object)item.getTitle());
        UnifiedSearchTestCase.assertNotNull((Object)item.getExcerpt());
        UnifiedSearchTestCase.assertNotNull((Object)item.getDetail());
        UnifiedSearchTestCase.assertNull((Object)item.getImageUrl());
        UnifiedSearchTestCase.assertNotNull((Object)item.getUrl());
        UnifiedSearchTestCase.assertTrue((item.getDate() > 0L ? 1 : 0) != 0);
    }

    private void checkFields(CalendarSearchResult item) {
        this.checkFields((SearchResult)item);
        UnifiedSearchTestCase.assertEquals((String)item.getDataType(), (String)CalendarEvent.TYPE_EVENT);
        if (CalendarEvent.TYPE_EVENT.equals(item.getDataType())) {
            UnifiedSearchTestCase.assertNull((Object)item.getImageUrl());
            UnifiedSearchTestCase.assertNull((Object)item.getTaskStatus());
        }
    }
}

