/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.webui.UICalendarContainer;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarWorkingContainer;
import org.exoplatform.calendar.webui.UICalendars;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(template="app:/templates/calendar/webui/UIPopup/UICalendarSettingDisplayTab.gtmpl")
public class UICalendarSettingDisplayTab
extends UIFormInputWithActions {
    private Map<String, List<UIFormInputWithActions.ActionData>> actionField_ = new HashMap();
    private LinkedHashMap<String, String> colorMap_ = new LinkedHashMap();

    public UICalendarSettingDisplayTab(String compId) throws Exception {
        super(compId);
        this.setComponentConfig(this.getClass(), null);
    }

    protected UIForm getParentFrom() {
        return (UIForm)this.getParent();
    }

    public LinkedHashMap<String, String> getColorMap() {
        return this.colorMap_;
    }

    public List<Calendar> getAllPrivateCalendars() throws Exception {
        boolean showAllCalendar;
        String username;
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List calendars = calendarService.getUserCalendars(username = CalendarUtils.getCurrentUser(), showAllCalendar = true);
        if (calendars.size() == 0) {
            return new ArrayList<Calendar>(0);
        }
        if (calendars != null) {
            for (Calendar calendar : calendars) {
                this.colorMap_.put(0 + CalendarUtils.COLON + calendar.getId(), calendar.getCalendarColor());
                UICheckBoxInput checkbox = this.getUICheckBoxInput(calendar.getId());
                if (checkbox != null) continue;
                checkbox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
                checkbox.setChecked(this.isCalendarOfSpace(calendar.getGroups()));
                this.addUIFormInput((UIFormInput)checkbox);
            }
        }
        return calendars;
    }

    private UICalendars getUICalendars() {
        return (UICalendars)((UICalendarContainer)((UICalendarWorkingContainer)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).getChild(UICalendarWorkingContainer.class)).getChild(UICalendarContainer.class)).getChild(UICalendars.class);
    }

    public List<Calendar> getAllPublicCalendars() throws Exception {
        boolean showAllCalendar;
        String username = CalendarUtils.getCurrentUser();
        String[] groups = CalendarUtils.getUserGroups((String)username);
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List groupCalendars = calendarService.getGroupCalendars(groups, showAllCalendar = true, username);
        if (groupCalendars.size() == 0) {
            return new ArrayList<Calendar>(0);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList calendars = new ArrayList();
        for (GroupCalendarData group : groupCalendars) {
            calendars.addAll(group.getCalendars());
            for (Calendar calendar : calendars) {
                map.put(calendar.getId(), calendar.getId());
                this.colorMap_.put(2 + CalendarUtils.COLON + calendar.getId(), calendar.getCalendarColor());
                UICheckBoxInput checkbox = this.getUICheckBoxInput(calendar.getId());
                if (checkbox != null) continue;
                checkbox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
                checkbox.setChecked(this.isCalendarOfSpace(calendar.getGroups()));
                this.addUIFormInput((UIFormInput)checkbox);
            }
        }
        return new ArrayList<Calendar>(new HashSet(calendars));
    }

    public GroupCalendarData getSharedCalendars() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        boolean showAllCalendar = true;
        GroupCalendarData groupCalendars = calendarService.getSharedCalendars(CalendarUtils.getCurrentUser(), showAllCalendar);
        if (groupCalendars == null) {
            return new GroupCalendarData("", "", new ArrayList(0));
        }
        CalendarSetting setting = calendarService.getCalendarSetting(CalendarUtils.getCurrentUser());
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : setting.getSharedCalendarsColors()) {
            map.put(key.split(CalendarUtils.COLON)[0], key.split(CalendarUtils.COLON)[1]);
        }
        List calendars = groupCalendars.getCalendars();
        for (Calendar calendar : calendars) {
            String color = (String)map.get(calendar.getId());
            if (color == null) {
                color = calendar.getCalendarColor();
            }
            this.colorMap_.put(1 + CalendarUtils.COLON + calendar.getId(), color);
            UICheckBoxInput checkbox = this.getUICheckBoxInput(calendar.getId());
            if (checkbox != null) continue;
            checkbox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
            checkbox.setChecked(this.isCalendarOfSpace(calendar.getGroups()));
            this.addUIFormInput((UIFormInput)checkbox);
        }
        return groupCalendars;
    }

    private String truncateLongName(String longName) {
        if (longName.length() > 35) {
            return longName.substring(0, 30) + "..";
        }
        return longName;
    }

    protected boolean isCalendarOfSpace(String[] groupIds) {
        String spaceId = UICalendarPortlet.getSpaceId();
        if (spaceId == null) {
            return true;
        }
        if (groupIds != null && groupIds.length > 0) {
            for (String groupId : groupIds) {
                if (!groupId.contains(spaceId)) continue;
                return true;
            }
        }
        return false;
    }

    public void setActionField(String fieldName, List<UIFormInputWithActions.ActionData> actions) {
        this.actionField_.put(fieldName, actions);
    }

    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (List)this.actionField_.get(fieldName);
    }

    public void processRender(WebuiRequestContext arg0) throws Exception {
        super.processRender(arg0);
    }
}

