/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UICalendars;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIPreview;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}, confirm="UICalendarView.msg.confirm-delete"), @EventConfig(listeners={CloseSearchActionListener.class}), @EventConfig(listeners={ViewDetailActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={OnchangeActionListener.class}), @EventConfig(listeners={SortActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class}), @EventConfig(listeners={AdvancedSearchActionListener.class})})
public class UIListView
extends UICalendarView {
    private static final Log log = ExoLogger.getLogger((String)"org.exoplatform.calendar.webui.UIListView");
    private LinkedHashMap<String, CalendarEvent> eventMap_ = new LinkedHashMap();
    private EventPageList pageList_ = null;
    private String selectedEvent_ = null;
    private boolean isShowEventAndTask = true;
    private boolean isSearchResult = false;
    private String lastViewId_ = null;
    private String categoryId_ = null;
    private String keyWords_ = null;
    private int currentPage_ = 0;
    private EventQuery query = null;
    public static final String EVENT_SUMMARY = "exo:summary";
    public static final String EVENT_PRIORITY = "exo:priority";
    public static final String EVENT_DESCRIPTION = "exo:description";
    public static final String EVENT_START = "exo:fromDateTime";
    public static final String EVENT_END = "exo:toDateTime";
    private String sortedField_ = "exo:summary";
    private boolean isAscending_ = true;
    private boolean calClicked = true;

    public UIListView() throws Exception {
        if (this.getEvents().length > 0) {
            this.selectedEvent_ = this.getEvents()[0].getId();
        }
    }

    public String getTemplate() {
        if (this.getViewType().equals(TYPE_TASK)) {
            return "app:/templates/calendar/webui/UIListTask.gtmpl";
        }
        if (this.getViewType().equals(TYPE_EVENT)) {
            return "app:/templates/calendar/webui/UIListEvent.gtmpl";
        }
        return "app:/templates/calendar/webui/UIListView.gtmpl";
    }

    public void setSortedField(String field) {
        this.sortedField_ = field;
    }

    public String getSortedField() {
        return this.sortedField_;
    }

    public void setIsAscending(boolean b) {
        this.isAscending_ = b;
    }

    public boolean isAscending() {
        return this.isAscending_;
    }

    public void setEventQuery(EventQuery eventQuery) {
        this.query = eventQuery;
    }

    public EventQuery getEventQuery() {
        return this.query;
    }

    public void refresh() throws Exception {
        UIListContainer uiListContainer = (UIListContainer)this.getParent();
        this.setCalClicked(true);
        if (uiListContainer.isDisplaySearchResult()) {
            return;
        }
        this.query = new EventQuery();
        if (!(CalendarUtils.isEmpty((String)this.categoryId_) || this.categoryId_.toLowerCase().equals("null") || this.categoryId_.equals("calId") || this.categoryId_.equals("defaultEventCategoryIdAll"))) {
            this.query.setCategoryId(new String[]{this.categoryId_});
        }
        java.util.Calendar fromcalendar = this.getBeginDay((java.util.Calendar)new GregorianCalendar(this.getCurrentYear(), this.getCurrentMonth(), this.getCurrentDay()));
        this.query.setFromDate(fromcalendar);
        java.util.Calendar tocalendar = this.getEndDay((java.util.Calendar)new GregorianCalendar(this.getCurrentYear(), this.getCurrentMonth(), this.getCurrentDay()));
        if (tocalendar.get(14) == 0) {
            tocalendar.add(14, -1);
        }
        this.query.setToDate(tocalendar);
        if (!this.getViewType().equals(TYPE_BOTH)) {
            this.query.setEventType(this.getViewType());
        }
        this.query.setExcludeRepeatEvent(Boolean.valueOf(true));
        List calendarIds = this.findCalendarIds();
        if (calendarIds.size() > 0) {
            this.query.setCalendarId(calendarIds.toArray(new String[0]));
        } else {
            this.query.setCalendarId(new String[]{"null"});
        }
        this.query.setOrderBy(new String[]{EVENT_SUMMARY});
        List allEvents = this.getAllEvents(this.query);
        if (uiListContainer.isDisplaySearchResult()) {
            this.update(this.pageList_);
        } else {
            this.update(new EventPageList(allEvents, 10L));
        }
        if (this.currentPage_ > 0 && (long)this.currentPage_ <= this.pageList_.getAvailablePage()) {
            this.updateCurrentPage((long)this.currentPage_);
        }
        UIFormSelectBox uiCategory = this.getUIFormSelectBox(EVENT_CATEGORIES);
        uiCategory.setValue(this.categoryId_);
        uiCategory.setOnChange("Onchange");
        UIListContainer uiContainer = (UIListContainer)this.getParent();
        UIPreview view = (UIPreview)uiContainer.getChild(UIPreview.class);
        if (CalendarUtils.isEmpty((String)this.getSelectedEvent())) {
            if (this.getEvents().length > 0) {
                String eventId = this.getEvents()[0].getId();
                this.setSelectedEvent(eventId);
                this.setLastUpdatedEventId(eventId);
                view.setEvent(this.getEvents()[0]);
            } else {
                this.setSelectedEvent(null);
                view.setEvent(null);
                this.setLastUpdatedEventId(null);
            }
        } else if (this.getEvents().length > 0) {
            for (CalendarEvent cal : this.getEvents()) {
                if (!cal.getId().equals(this.getSelectedEvent())) continue;
                view.setEvent(cal);
                this.setLastUpdatedEventId(this.getSelectedEvent());
                break;
            }
        } else {
            this.setSelectedEvent(null);
            view.setEvent(null);
            this.setLastUpdatedEventId(null);
        }
    }

    private List<String> findCalendarIds() throws Exception {
        ArrayList<String> calendarIds = new ArrayList<String>();
        UICalendars uiCalendars = (UICalendars)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UICalendars.class);
        if (this.isInSpace()) {
            return Arrays.asList(this.getPublicCalendars());
        }
        List checkedCals = uiCalendars.getCheckedCalendars();
        List privateCalendar = uiCalendars.getAllPrivateCalendars();
        List publicCalendar = uiCalendars.getAllPublicCalendars();
        GroupCalendarData shareClas = uiCalendars.getSharedCalendars();
        for (Calendar cal : privateCalendar) {
            if (!checkedCals.contains(cal.getId())) continue;
            calendarIds.add(cal.getId());
        }
        for (Calendar calendar : publicCalendar) {
            if (!checkedCals.contains(calendar.getId())) continue;
            calendarIds.add(calendar.getId());
        }
        if (shareClas != null) {
            for (Calendar cal : shareClas.getCalendars()) {
                if (!checkedCals.contains(cal.getId())) continue;
                calendarIds.add(cal.getId());
            }
        }
        return calendarIds;
    }

    public List<CalendarEvent> getAllEvents(EventQuery eventQuery) throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        UICalendars uiCalendars = (UICalendars)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UICalendars.class);
        String[] checkedPublicCalendars = uiCalendars.getCheckedPublicCalendars();
        if (this.isDisplaySearchResult()) {
            eventQuery.setExcludeRepeatEvent(Boolean.valueOf(false));
            if (eventQuery.getCalendarId().length == 1) {
                if (Arrays.asList(checkedPublicCalendars).contains(eventQuery.getCalendarId()[0])) {
                    return calendarService.getEvents(username, eventQuery, eventQuery.getCalendarId());
                }
                return calendarService.getEvents(username, eventQuery, null);
            }
            return calendarService.getEvents(username, eventQuery, checkedPublicCalendars);
        }
        List allEvents = calendarService.getEvents(username, eventQuery, checkedPublicCalendars);
        List originalRecurEvents = calendarService.getOriginalRecurrenceEvents(username, eventQuery.getFromDate(), eventQuery.getToDate(), checkedPublicCalendars);
        String timezone = CalendarUtils.getCurrentUserCalendarSetting().getTimeZone();
        if (originalRecurEvents != null && originalRecurEvents.size() > 0) {
            for (CalendarEvent recurEvent : originalRecurEvents) {
                Map tempMap = calendarService.getOccurrenceEvents(recurEvent, eventQuery.getFromDate(), eventQuery.getToDate(), timezone);
                if (tempMap == null) continue;
                this.recurrenceEventsMap.put(recurEvent.getId(), tempMap);
                allEvents.addAll(tempMap.values());
            }
        }
        return allEvents;
    }

    public void update(EventPageList pageList) throws Exception {
        this.pageList_ = pageList;
        this.updateCurrentPage(this.pageList_.getCurrentPage());
    }

    protected void updateCurrentPage(long page) throws Exception {
        this.getChildren().clear();
        this.update();
        UIFormSelectBox uiCategory = this.getUIFormSelectBox(EVENT_CATEGORIES);
        uiCategory.setValue(this.categoryId_);
        uiCategory.setOnChange("Onchange");
        this.eventMap_.clear();
        if (this.pageList_ != null) {
            for (CalendarEvent calendarEvent : this.pageList_.getPage(page, CalendarUtils.getCurrentUser())) {
                UICheckBoxInput checkbox = new UICheckBoxInput(calendarEvent.getId(), calendarEvent.getId(), Boolean.valueOf(false));
                this.addUIFormInput((UIFormInput)checkbox);
                if (this.getViewType().equals(TYPE_BOTH)) {
                    this.eventMap_.put(calendarEvent.getId(), calendarEvent);
                    continue;
                }
                if (!this.getViewType().equals(calendarEvent.getEventType())) continue;
                this.eventMap_.put(calendarEvent.getId(), calendarEvent);
            }
        }
    }

    public CalendarEvent[] getEvents() throws Exception {
        if (this.eventMap_.size() == 0) {
            return new CalendarEvent[0];
        }
        return this.eventMap_.values().toArray(new CalendarEvent[0]);
    }

    protected void refreshBrowser() {
        block4: {
            UIListContainer uiListContainer = (UIListContainer)this.getParent();
            if (uiListContainer.isDisplaySearchResult()) {
                return;
            }
            if (!this.isCalClicked()) {
                try {
                    this.refresh();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Exception occurs in freshBrowserListMethod", (Throwable)e);
                }
            }
        }
    }

    public long getAvailablePage() {
        return this.pageList_.getAvailablePage();
    }

    public void setCurrentPage(int page) {
        this.currentPage_ = page;
    }

    public long getCurrentPage() {
        return this.pageList_.getCurrentPage();
    }

    protected boolean isShowEvent() {
        return this.isShowEvent_;
    }

    protected boolean isShowEventAndTask() {
        return this.isShowEventAndTask;
    }

    public void setShowEventAndTask(boolean show) {
        this.isShowEventAndTask = show;
    }

    public boolean isDisplaySearchResult() {
        return this.isSearchResult;
    }

    public void setDisplaySearchResult(boolean show) {
        this.isSearchResult = show;
    }

    public void setSelectedEvent(String selectedEvent) {
        this.selectedEvent_ = selectedEvent;
    }

    public String getSelectedEvent() {
        return this.selectedEvent_;
    }

    public boolean isCalClicked() {
        return this.calClicked;
    }

    public void setCalClicked(boolean clickChkCalendar) {
        this.calClicked = clickChkCalendar;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        return this.eventMap_;
    }

    public List<CalendarEvent> getSelectedEvents() {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (CalendarEvent ce : this.eventMap_.values()) {
            UICheckBoxInput checkbox = (UICheckBoxInput)this.getChildById(ce.getId());
            if (checkbox == null || !checkbox.isChecked()) continue;
            events.add(ce);
        }
        return events;
    }

    public void setLastViewId(String lastViewId_) {
        this.lastViewId_ = lastViewId_;
    }

    public String getLastViewId() {
        return this.lastViewId_;
    }

    public void setCategoryId(String catetoryId) {
        this.categoryId_ = catetoryId;
        this.setSelectedCategory(catetoryId);
    }

    public String getSelectedCategory() {
        return this.categoryId_;
    }

    public CalendarEvent getSelectedEventObj() {
        return (CalendarEvent)this.eventMap_.get(this.selectedEvent_);
    }

    public void setKeyWords(String keyWords) {
        this.keyWords_ = keyWords;
    }

    public String getKeyWords() {
        return this.keyWords_;
    }

    public String getDefaultStartTimeOfEvent() {
        return String.valueOf(this.calendar_.getTimeInMillis());
    }

    public void processAction(WebuiRequestContext context) throws Exception {
        this.setCalClicked(true);
        super.processAction(context);
    }

    static /* synthetic */ int access$002(UIListView x0, int x1) {
        x0.currentPage_ = x1;
        return x0.currentPage_;
    }

    static /* synthetic */ EventQuery access$100(UIListView x0) {
        return x0.query;
    }

    static /* synthetic */ List access$200(UIListView x0) throws Exception {
        return x0.findCalendarIds();
    }
}

