/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.io.Writer;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;

public class UICheckBoxInput
extends org.exoplatform.webui.form.input.UICheckBoxInput {
    public UICheckBoxInput(String fieldId, String fieldName, boolean b) {
        super(fieldId, fieldName, Boolean.valueOf(b));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        String label = this.getLabel();
        if (label == null) {
            label = this.getId() + ".label";
            try {
                ResourceBundle res = context.getApplicationResourceBundle();
                label = res.getString(label);
            }
            catch (MissingResourceException e) {
                label = null;
            }
        }
        Writer w = context.getWriter();
        if (label != null) {
            w.write("<label class=\"uiCheckbox\">");
        } else {
            w.write("<span class=\"uiCheckbox\">");
        }
        w.append("<input id=\"").append(this.getId()).append("\" type=\"checkbox\" class=\"checkbox\" name=\"");
        w.write(this.name);
        w.write("\"");
        if (this.isChecked()) {
            w.write(" checked");
        }
        if (this.isDisabled()) {
            w.write(" disabled");
        }
        this.renderHTMLAttributes(w);
        w.write("/><span>");
        if (label != null) {
            w.write(label);
            w.write("</span></label>");
        } else {
            w.write("</span></span>");
        }
        if (this.isMandatory()) {
            w.write(" *");
        }
    }
}

