/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.UIDayView;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.calendar.webui.UIMonthView;
import org.exoplatform.calendar.webui.UIWeekView;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIMiniCalendar.gtmpl", events={@EventConfig(listeners={MoveNextActionListener.class}), @EventConfig(listeners={MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class})})
public class UIMiniCalendar
extends UICalendarView {
    private Map<Integer, String> dataMap = new HashMap();
    private String categoryId_ = null;
    private static final Log LOG = ExoLogger.getExoLogger(UIMiniCalendar.class);

    protected int getWeeksOfTheMonth(int year, int month, int day) {
        Calendar cal = this.getInstanceTempCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return cal.getActualMaximum(4);
    }

    protected Map<Integer, String> getData() {
        return this.dataMap;
    }

    public LinkedHashMap<String, CalendarEvent> getDataMap() {
        return null;
    }

    public Calendar getBeginDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonth();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        int amount = temCal.getFirstDayOfWeek() - temCal.get(7);
        temCal.add(5, amount);
        while (temCal.get(5) < 20 && temCal.get(5) != 1) {
            temCal.add(5, -7);
        }
        return CalendarUtils.getBeginDay((Calendar)temCal);
    }

    public Calendar getEndDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonthView();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        temCal.add(5, this.getWeeksOfTheMonth(this.getCurrentYear(), this.getCurrentMonth(), 1) * 7);
        return this.getBeginDay(temCal);
    }

    public Calendar getBeginDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, 1);
        return CalendarUtils.getBeginDay((Calendar)temCal);
    }

    public Calendar getEndDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, this.getDaysInMonth());
        return CalendarUtils.getEndDay((Calendar)temCal);
    }

    public void setCategoryId(String categoryId) {
        this.categoryId_ = categoryId;
    }

    public String getSelectedCategory() {
        return this.categoryId_;
    }

    public void refresh() throws Exception {
        this.dataMap.clear();
        EventQuery eventQuery = new EventQuery();
        eventQuery.setFromDate(this.getBeginDateOfMonth());
        Calendar cal = this.getEndDateOfMonth();
        cal.add(14, -1);
        eventQuery.setToDate(cal);
        eventQuery.setExcludeRepeatEvent(Boolean.valueOf(true));
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String timezone = CalendarUtils.getCurrentUserCalendarSetting().getTimeZone();
        String currentUser = CalendarUtils.getCurrentUser();
        String[] publicCalendars = this.getPublicCalendars();
        String[] privateCalendars = this.getPrivateCalendars().toArray(new String[0]);
        List map = calendarService.searchHightLightEventSQL(currentUser, eventQuery, privateCalendars, publicCalendars);
        this.dataMap = (Map)map.get(0);
        this.emptyEventCalendars = new ArrayList(((Map)map.get(1)).values());
        map = calendarService.searchHighlightRecurrenceEventSQL(currentUser, eventQuery, timezone, privateCalendars, publicCalendars);
        this.dataMap.putAll((Map)map.get(0));
        this.emptyRecurrentEventCalendars = new ArrayList(((Map)map.get(1)).values());
        UICalendarPortlet calendarPortlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        UICalendarViewContainer viewContainer = (UICalendarViewContainer)calendarPortlet.findFirstComponentOfType(UICalendarViewContainer.class);
        String viewType = viewContainer.getCurrentViewType();
        if (UICalendarViewContainer.DAY_VIEW.equals(viewType)) {
            UIDayView dayView = (UIDayView)viewContainer.getChild(UIDayView.class);
            if (dayView == null) {
                dayView = (UIDayView)viewContainer.addChild(UIDayView.class, null, null);
            }
            dayView.setEmptyEventCalendars(this.emptyEventCalendars);
            dayView.setEmptyRecurrentEventCalendars(this.emptyRecurrentEventCalendars);
        } else if (UICalendarViewContainer.WEEK_VIEW.equals(viewType) || UICalendarViewContainer.WORKING_VIEW.equals(viewType)) {
            UIWeekView weekView = (UIWeekView)viewContainer.getChild(UIWeekView.class);
            if (weekView == null) {
                weekView = (UIWeekView)viewContainer.addChild(UIWeekView.class, null, null);
            }
            weekView.setEmptyEventCalendars(this.emptyEventCalendars);
            weekView.setEmptyRecurrentEventCalendars(this.emptyRecurrentEventCalendars);
        } else if (UICalendarViewContainer.MONTH_VIEW.equals(viewType)) {
            UIMonthView monthView = (UIMonthView)viewContainer.getChild(UIMonthView.class);
            if (monthView == null) {
                monthView = (UIMonthView)viewContainer.addChild(UIMonthView.class, null, null);
            }
            monthView.setEmptyEventCalendars(this.emptyEventCalendars);
            monthView.setEmptyRecurrentEventCalendars(this.emptyRecurrentEventCalendars);
        } else if (UICalendarViewContainer.LIST_VIEW.equals(viewType)) {
            UIListContainer uiView = (UIListContainer)viewContainer.getChild(UIListContainer.class);
            if (uiView == null) {
                uiView = (UIListContainer)viewContainer.addChild(UIListContainer.class, null, null);
            }
            UIListView listView = (UIListView)uiView.getChild(UIListView.class);
            listView.setEmptyEventCalendars(this.emptyEventCalendars);
            listView.setEmptyRecurrentEventCalendars(this.emptyRecurrentEventCalendars);
        }
    }

    public String getDefaultStartTimeOfEvent() {
        return String.valueOf(this.calendar_.getTimeInMillis());
    }
}

