/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.webui.popup.UIExportForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIExportForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIExportForm
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getExoLogger(UIExportForm.class);
    private static final String NAME = "name";
    private static final String EXPORT_TYPE = "ICalendar(.ics)";
    private String calType = "0";
    private Map<String, String> names_ = new HashMap();
    private Map<String, String> longNames_ = new HashMap();
    public String eventId = null;

    public UIExportForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NAME, NAME, null));
    }

    public void setCalType(String type) {
        this.calType = type;
    }

    public void update(String type, List<Calendar> calendars, String selectedCalendarId) throws Exception {
        this.calType = type;
        this.names_.clear();
        for (UIComponent comp : this.getChildren()) {
            if (!(comp instanceof UICheckBoxInput)) continue;
            this.removeChildById(comp.getId());
        }
        this.initCheckBox(calendars, selectedCalendarId);
        ((UIFormStringInput)this.getChildById(NAME)).setValue((Object)calendars.get(0).getName());
    }

    public void initCheckBox(List<Calendar> calendars, String selectedCalendarId) {
        for (Calendar calendar : calendars) {
            UICheckBoxInput checkBox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
            if (calendar.getId().equals(selectedCalendarId)) {
                checkBox.setChecked(true);
            } else {
                checkBox.setChecked(false);
            }
            if (this.eventId != null) {
                checkBox.setDisabled(true);
            } else {
                checkBox.setDisabled(false);
            }
            this.addUIFormInput((UIFormInput)checkBox);
            this.names_.put(calendar.getId(), calendar.getName());
            this.longNames_.put(calendar.getId(), calendar.getName());
        }
    }

    private String getCalendarName(String calendarId) {
        return (String)this.longNames_.get(calendarId);
    }

    public String getLabel(String id) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String label = this.getId() + ".label." + id;
        try {
            return res.getString(label);
        }
        catch (MissingResourceException e) {
            if (this.names_.get(id) != null) {
                return (String)this.names_.get(id);
            }
            return id;
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ String access$000(UIExportForm x0) {
        return x0.calType;
    }
}

