/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIMonthView;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIMonthView.gtmpl", events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteEvent.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class}), @EventConfig(listeners={UICalendarView.ChangeCategoryActionListener.class}), @EventConfig(listeners={UICalendarView.EventSelectActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmCloseActionListener.class}), @EventConfig(listeners={UICalendarView.AbortCloseActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.QuickAddActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={UICalendarView.MoveEventActionListener.class}), @EventConfig(listeners={UpdateEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteFollowingSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateCancel.class})})
public class UIMonthView
extends UICalendarView {
    private static final Log log = ExoLogger.getExoLogger(UIMonthView.class);
    private LinkedHashMap<String, Event> dataMap_ = new LinkedHashMap();
    private List<Event> eventData_ = new ArrayList();

    protected int getWeeksOfTheMonth(int year, int month, int day) {
        Calendar cal = this.getInstanceTempCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.setMinimalDaysInFirstWeek(1);
        return cal.getActualMaximum(4);
    }

    public void refresh() throws Exception {
        super.refresh();
        this.dataMap_.clear();
        this.eventData_.clear();
        long begin = this.getBeginDateOfMonthView().getTimeInMillis();
        long end = this.getEndDateOfMonthView().getTimeInMillis();
        List allEvents = this.getEventInMonth(begin, end);
        if (this.isInSpace()) {
            this.filterNonSpaceEvent(allEvents);
        }
        for (Event evt : allEvents) {
            if (evt.getRepeatType() == null || evt.getRecurrenceId() == null || evt.getRepeatType().equals(Event.RP_NOREPEAT)) continue;
            HashMap<String, CalendarEvent> recurrMap = (HashMap<String, CalendarEvent>)this.recurrenceEventsMap.get(evt.getId());
            if (recurrMap == null) {
                recurrMap = new HashMap<String, CalendarEvent>();
                this.recurrenceEventsMap.put(evt.getId(), recurrMap);
            }
            recurrMap.put(evt.getRecurrenceId(), (CalendarEvent)evt);
        }
        for (UIComponent comp : this.getChildren()) {
            if (!(comp instanceof UICheckBoxInput)) continue;
            this.removeChildById(comp.getId());
        }
        Iterator eventIter = allEvents.iterator();
        while (eventIter.hasNext()) {
            Event event = (Event)eventIter.next();
            this.dataMap_.put(event.getId(), event);
            this.eventData_.add(event);
            UICheckBoxInput input = !CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType()) && !CalendarUtils.isEmpty((String)event.getRecurrenceId()) ? new UICheckBoxInput(this.getCheckboxId(event), this.getCheckboxId(event), Boolean.valueOf(false)) : new UICheckBoxInput(event.getId(), event.getId(), Boolean.valueOf(false));
            input.setBindingField(event.getCalendarId());
            this.addChild((UIComponent)input);
            eventIter.remove();
        }
    }

    public String getCheckboxId(Event event) throws Exception {
        if (!CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType()) && !CalendarUtils.isEmpty((String)event.getRecurrenceId())) {
            return event.getId() + "-" + event.getRecurrenceId();
        }
        return event.getId();
    }

    public Calendar getBeginDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonth();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        int amount = temCal.getFirstDayOfWeek() - temCal.get(7);
        temCal.add(5, amount);
        while (temCal.get(5) < 20 && temCal.get(5) != 1) {
            temCal.add(5, -7);
        }
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonthView();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        temCal.add(5, this.getWeeksOfTheMonth(this.getCurrentYear(), this.getCurrentMonth(), 1) * 7);
        return this.getBeginDay(temCal);
    }

    public Calendar getBeginDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, 1);
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfMonth() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, this.getDaysInMonth());
        return this.getEndDay(temCal);
    }

    public Calendar getBeginDateOfWeek() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        if (temCal.getFirstDayOfWeek() > temCal.get(7)) {
            temCal.add(3, -1);
        }
        int amout = temCal.getFirstDayOfWeek() - temCal.get(7);
        temCal.add(5, amout);
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfWeek() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setFirstDayOfWeek(2);
        temCal.setTime(this.getBeginDateOfWeek().getTime());
        int amout = 6;
        temCal.add(5, amout);
        return this.getEndDay(temCal);
    }

    protected List<CalendarEvent> getSelectedEvents() {
        UICheckBoxInput checkbox;
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (String id : this.dataMap_.keySet()) {
            checkbox = (UICheckBoxInput)this.getChildById(id);
            if (checkbox == null || !checkbox.isChecked()) continue;
            events.add(CalendarEvent.build((Event)((Event)this.dataMap_.get(id))));
        }
        if (this.recurrenceEventsMap.isEmpty()) {
            return events;
        }
        for (String eventId : this.recurrenceEventsMap.keySet()) {
            for (String recurId : ((Map)this.recurrenceEventsMap.get(eventId)).keySet()) {
                checkbox = (UICheckBoxInput)this.getChildById(eventId + "-" + recurId);
                if (checkbox == null || !checkbox.isChecked()) continue;
                events.add((CalendarEvent)((Map)this.recurrenceEventsMap.get(eventId)).get(recurId));
            }
        }
        return events;
    }

    public LinkedHashMap<String, Event> getDataMap() {
        return this.dataMap_;
    }

    protected List<Event> getEventData() {
        return this.eventData_;
    }

    public String getDefaultStartTimeOfEvent() {
        if (this.isCurrentMonth(this.calendar_.get(2), this.calendar_.get(1))) {
            return String.valueOf(System.currentTimeMillis());
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.calendar_.getTime());
        int month = c.get(2);
        while (c.get(2) == month) {
            c.add(5, 1);
        }
        c.add(5, -1);
        return String.valueOf(c.getTimeInMillis());
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

