/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.webui.UIActionBar;
import org.exoplatform.calendar.webui.UICalendarPortletEditMode;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.UICalendarWorkingContainer;
import org.exoplatform.calendar.webui.UIPreview;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UIPopupAction;
import org.exoplatform.calendar.webui.popup.UIPopupContainer;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIConfirmation;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/calendar/webui/UICalendarPortlet.gtmpl")
public class UICalendarPortlet
extends UIPortletApplication {
    private static Log log = ExoLogger.getLogger(UICalendarPortlet.class);
    private String spaceGroupId;

    public UICalendarPortlet() throws Exception {
        this.addChild(UIConfirmation.class, null, null);
        UIActionBar uiActionBar = (UIActionBar)this.addChild(UIActionBar.class, null, null);
        uiActionBar.setCurrentView(CalendarUtils.getViewInSetting());
        this.addChild(UICalendarWorkingContainer.class, null, null);
        UIPopupAction uiPopup = (UIPopupAction)this.addChild(UIPopupAction.class, null, null);
        uiPopup.setId("UICalendarPopupAction");
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId("UICalendarPopupWindow");
        this.addChild(UICalendarPortletEditMode.class, null, null);
    }

    public CalendarSetting getCalendarSetting() throws Exception {
        return CalendarUtils.getCurrentUserCalendarSetting();
    }

    public void setCalendarSetting(CalendarSetting setting) throws Exception {
        CalendarUtils.setCurrentCalendarSetting((CalendarSetting)setting);
    }

    public Calendar getUserCalendar() {
        return CalendarUtils.getInstanceOfCurrentCalendar();
    }

    public String getSettingTimeZone() throws Exception {
        TimeZone tz = DateUtils.getTimeZone((String)this.getCalendarSetting().getTimeZone());
        long timezoneOffset = tz.getOffset(Calendar.getInstance().getTimeInMillis());
        return String.valueOf(timezoneOffset / 1000L / 60L);
    }

    public String getWeekStartOn() throws Exception {
        return this.getCalendarSetting().getWeekStartOn();
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public String getRemoteUser() throws Exception {
        return CalendarUtils.getCurrentUser();
    }

    public String getUserToken() throws Exception {
        ContinuationService continuation = CalendarUtils.getContinuationService();
        try {
            return continuation.getUserToken(this.getRemoteUser());
        }
        catch (Exception e) {
            log.debug((Object)"\n\n can not get UserToken", (Throwable)e);
            return "";
        }
    }

    protected String getCometdContextName() {
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(EXoContinuationBayeux.class);
        return bayeux == null ? "cometd" : bayeux.getCometdContextName();
    }

    public String getRestContextName() {
        return PortalContainer.getInstance().getRestContextName();
    }

    public static String getSpaceId() {
        String spaceIdStr = "";
        PortalRequestContext pContext = Util.getPortalRequestContext();
        if (!pContext.getSiteType().equals((Object)SiteType.GROUP) || !pContext.getSiteName().startsWith("/spaces")) {
            return null;
        }
        String requestPath = pContext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route er = ExoRouter.route((String)requestPath);
        if (er == null) {
            return spaceIdStr;
        }
        String spacePrettyName = (String)er.localArgs.get("spacePrettyName");
        SpaceService sService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        Space space = sService.getSpaceByPrettyName(spacePrettyName);
        if (space == null) {
            return spaceIdStr;
        }
        spaceIdStr = space.getId();
        return spaceIdStr == null ? "" : spaceIdStr;
    }

    public static String getGroupIdOfSpace() {
        String spaceGroupId = "";
        PortalRequestContext pContext = Util.getPortalRequestContext();
        String requestPath = pContext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route er = ExoRouter.route((String)requestPath);
        if (er == null) {
            return spaceGroupId;
        }
        String spacePrettyName = (String)er.localArgs.get("spacePrettyName");
        SpaceService sService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        Space space = sService.getSpaceByPrettyName(spacePrettyName);
        if (space == null) {
            return spaceGroupId;
        }
        spaceGroupId = space.getGroupId();
        return spaceGroupId == null ? "" : spaceGroupId;
    }

    public String getSpaceGroupId() {
        if (this.spaceGroupId != null) {
            return this.spaceGroupId;
        }
        String spaceIdStr = "";
        PortalRequestContext pContext = Util.getPortalRequestContext();
        String requestPath = pContext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route er = ExoRouter.route((String)requestPath);
        this.spaceGroupId = spaceIdStr;
        if (er == null) {
            return spaceIdStr;
        }
        String spacePrettyName = (String)er.localArgs.get("spacePrettyName");
        SpaceService sService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        Space space = sService.getSpaceByPrettyName(spacePrettyName);
        this.spaceGroupId = spaceIdStr;
        if (space == null) {
            return spaceIdStr;
        }
        spaceIdStr = space.getGroupId();
        this.spaceGroupId = spaceIdStr == null ? "" : spaceIdStr;
        return this.spaceGroupId;
    }

    public static boolean isInSpace() {
        return StringUtils.isNotEmpty((CharSequence)UICalendarPortlet.getSpaceId());
    }

    public boolean isInSpaceContext() {
        return StringUtils.isNotEmpty((CharSequence)this.getSpaceGroupId());
    }

    public void processInvitationURL(WebuiRequestContext context, PortalRequestContext pContext, String url) throws Exception {
        String isAjax = pContext.getRequestParameter("ajaxRequest");
        if (isAjax != null && Boolean.parseBoolean(isAjax)) {
            return;
        }
        String username = CalendarUtils.getCurrentUser();
        User user = CalendarUtils.getOrganizationService().getUserHandler().findUserByName(username);
        String formTime = CalendarUtils.getCurrentTime((UIComponent)this);
        CalendarService calService = CalendarUtils.getCalendarService();
        if (url.contains(CalendarUtils.INVITATION_IMPORT_URL)) {
            url = url.substring(url.indexOf(CalendarUtils.INVITATION_IMPORT_URL) + CalendarUtils.INVITATION_IMPORT_URL.length());
            String[] params = url.split("/");
            String inviter = params[0];
            String eventId = params[1];
            int calType = Integer.parseInt(params[2]);
            CalendarEvent event = calService.getEventById(eventId);
            if (event != null) {
                event.setCalType(String.valueOf(calType));
                calService.confirmInvitation(inviter, user.getEmail(), username, calType, event.getCalendarId(), eventId, 1);
                UIPopupAction uiParentPopup = (UIPopupAction)this.getChild(UIPopupAction.class);
                UIPopupContainer uiPopupContainer = (UIPopupContainer)uiParentPopup.activate(UIPopupContainer.class, 800);
                uiPopupContainer.setId(UIPopupContainer.UIEVENTPOPUP);
                UIEventForm uiEventForm = (UIEventForm)uiPopupContainer.addChild(UIEventForm.class, null, null);
                uiEventForm.initForm(this.getCalendarSetting(), null, formTime);
                uiEventForm.update(CalendarUtils.PRIVATE_TYPE, CalendarUtils.getCalendarOption());
                uiEventForm.importInvitationEvent(this.getCalendarSetting(), event, Utils.getDefaultCalendarId((String)username), formTime);
                uiEventForm.setSelectedEventState(UIEventForm.ITEM_BUSY);
                uiEventForm.setEmailRemindBefore(String.valueOf(5));
                uiEventForm.setEmailReminder(false);
                uiEventForm.setEmailRepeat(Boolean.valueOf(false));
                context.addUIComponentToUpdateByAjax((UIComponent)uiParentPopup);
            } else {
                context.getUIApplication().addMessage(new ApplicationMessage("UICalendarPortlet.msg.event-was-not-found", null, 0));
            }
            return;
        }
        if (url.contains(CalendarUtils.INVITATION_DETAIL_URL)) {
            url = url.substring(url.indexOf(CalendarUtils.INVITATION_DETAIL_URL) + CalendarUtils.INVITATION_DETAIL_URL.length());
            String[] params = url.split("/");
            String eventId = params[1];
            Date startDate = calService.getEventById(eventId).getFromDateTime();
            Date endDate = calService.getEventById(eventId).getToDateTime();
            UICalendarWorkingContainer uiCalendarWorkingContainer = (UICalendarWorkingContainer)this.getChild(UICalendarWorkingContainer.class);
            UICalendarViewContainer uiCalendarViewContainer = (UICalendarViewContainer)uiCalendarWorkingContainer.getChild(UICalendarViewContainer.class);
            uiCalendarViewContainer.setStartDate(startDate);
            UIActionBar uiActionBar = (UIActionBar)this.getChild(UIActionBar.class);
            if (this.isOneDay(startDate.toString().split(" "), endDate.toString().split(" "))) {
                uiCalendarViewContainer.initView(UICalendarViewContainer.DAY_VIEW, Boolean.valueOf(true));
                uiActionBar.setCurrentView(UICalendarViewContainer.TYPES[0]);
            } else {
                uiCalendarViewContainer.initView(UICalendarViewContainer.WEEK_VIEW, Boolean.valueOf(true));
                uiActionBar.setCurrentView(UICalendarViewContainer.TYPES[1]);
            }
            context.addUIComponentToUpdateByAjax((UIComponent)uiActionBar);
            context.addUIComponentToUpdateByAjax((UIComponent)uiCalendarViewContainer);
        }
    }

    private boolean isOneDay(String[] begin, String[] end) {
        return begin[1].equals(end[1]) && begin[2].equals(end[2]) && begin[5].equals(end[5]);
    }

    private void processEventDetailsURL(WebuiRequestContext webuiRequestContext, String eventId, String recurId) throws Exception {
        CalendarService calService = CalendarUtils.getCalendarService();
        CalendarEvent event = null;
        String username = CalendarUtils.getCurrentUser();
        if (recurId != null && !recurId.isEmpty()) {
            CalendarSetting calSetting = calService.getCalendarSetting(username);
            String timezoneId = calSetting.getTimeZone();
            TimeZone timezone = DateUtils.getTimeZone((String)timezoneId);
            CalendarEvent orgEvent = calService.getEventById(eventId);
            if (orgEvent != null) {
                SimpleDateFormat sdf = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
                sdf.setTimeZone(timezone);
                Date occurDate = sdf.parse(recurId);
                Calendar cal = Calendar.getInstance(timezone);
                cal.setTime(occurDate);
                Calendar from = Utils.getBeginDay((Calendar)cal);
                Calendar to = Utils.getEndDay((Calendar)cal);
                Map occMap = calService.getOccurrenceEvents(orgEvent, from, to, timezoneId);
                event = (CalendarEvent)occMap.get(recurId);
            }
        } else {
            event = calService.getEventById(eventId);
        }
        if (event == null) {
            webuiRequestContext.getUIApplication().addMessage(new ApplicationMessage("UICalendarPortlet.msg.have-no-permission-to-view-event", null, 1));
        } else {
            event.setCalType(String.valueOf(calService.getTypeOfCalendar(username, event.getCalendarId())));
            this.openEventPreviewPopup(event, webuiRequestContext);
        }
    }

    private void openEventPreviewPopup(CalendarEvent event, WebuiRequestContext webuiRequestContext) throws Exception {
        UIPopupAction uiPopupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        uiPopupAction.deActivate();
        UIPopupContainer uiPopupContainer = (UIPopupContainer)uiPopupAction.activate(UIPopupContainer.class, 700);
        uiPopupContainer.setId("UIEventPreview");
        ((UIPopupWindow)uiPopupAction.getChild(UIPopupWindow.class)).setShowCloseButton(false);
        UIPreview uiPreview = (UIPreview)uiPopupContainer.addChild(UIPreview.class, null, null);
        uiPreview.setEvent((Event)event);
        uiPreview.setId("UIPreviewPopup");
        uiPreview.setShowPopup(true);
        uiPreview.setPreviewByUrl(true);
        webuiRequestContext.addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
    }

    private void processExternalUrl(WebuiRequestContext webuiRequestContext) throws Exception {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        String requestedURL = pContext.getRequest().getRequestURL().toString();
        if (requestedURL.contains(CalendarUtils.INVITATION_URL)) {
            try {
                this.processInvitationURL(webuiRequestContext, pContext, requestedURL);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Invitation url is not valid", (Throwable)e);
                }
            }
        } else if (requestedURL.contains("/details/")) {
            String eventId = requestedURL.substring(requestedURL.indexOf("/details/") + "/details/".length());
            if (!eventId.startsWith("Event")) {
                return;
            }
            if (eventId.endsWith("/")) {
                eventId = eventId.substring(0, eventId.lastIndexOf("/"));
            }
            String occurenceId = "";
            String[] array = eventId.split("/");
            if (array.length >= 2) {
                eventId = array[0];
                occurenceId = array[1];
            }
            this.processEventDetailsURL(webuiRequestContext, eventId, occurenceId);
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        this.processExternalUrl(context);
        super.processRender(app, context);
    }

    public void showConfirmWindow(UIComponent comp, String message) {
        UIConfirmation uiConfirmation = (UIConfirmation)this.getChild(UIConfirmation.class);
        uiConfirmation.setCaller((Object)comp);
        uiConfirmation.setMessage(message);
        this.createActionConfirms(uiConfirmation);
        ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)uiConfirmation);
    }

    public void createActionConfirms(UIConfirmation uiConfirmation) {
        String no;
        String yes;
        ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
        try {
            yes = resourceBundle.getString("UICalendarPortlet.confirm.yes");
        }
        catch (Exception ex) {
            log.warn((Object)"Can not find resource bundle for key: UICalendarPortlet.confirm.yes");
            yes = "UICalendarPortlet.confirm.yes";
        }
        try {
            no = resourceBundle.getString("UICalendarPortlet.confirm.no");
        }
        catch (Exception ex) {
            log.warn((Object)"Can not find resource bundle for key: UICalendarPortlet.confirm.no");
            no = "UICalendarPortlet.confirm.no";
        }
        ArrayList<UIConfirmation.ActionConfirm> actionConfirms = new ArrayList<UIConfirmation.ActionConfirm>();
        actionConfirms.add(new UIConfirmation.ActionConfirm("ConfirmClose", yes));
        actionConfirms.add(new UIConfirmation.ActionConfirm("AbortClose", no));
        uiConfirmation.setActions(actionConfirms);
    }
}

