/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.model.query.CalendarQuery;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.calendar.webui.UICalendarContainer;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.popup.UIQuickAddEvent;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;

@ComponentConfig(template="app:/templates/calendar/webui/UICalendarWorkingContainer.gtmpl")
public class UICalendarWorkingContainer
extends UIContainer {
    private Map<String, List<Calendar>> calendars = new HashMap();
    private LinkedHashMap<String, String> colorMap = new LinkedHashMap();
    private CalendarService calService = (CalendarService)this.getApplicationComponent(CalendarService.class);
    private ExtendedCalendarService xCalService = (ExtendedCalendarService)this.getApplicationComponent(ExtendedCalendarService.class);

    public UICalendarWorkingContainer() throws Exception {
        ((UICalendarContainer)this.addChild(UICalendarContainer.class, null, null)).setRendered(true);
        ((UICalendarViewContainer)this.addChild(UICalendarViewContainer.class, null, null)).setRendered(true);
    }

    public void init() throws Exception {
        PortletRequestContext context = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        Object initilized = context.getAttribute(this.getClass().toString());
        if (initilized != null) {
            return;
        }
        context.setAttribute(this.getClass().toString(), (Object)true);
        this.colorMap.clear();
        this.calendars.clear();
        Identity identity = ConversationState.getCurrent().getIdentity();
        CalendarQuery query = new CalendarQuery();
        query.setIdentity(identity);
        List tmp = this.xCalService.getCalendarHandler().findCalendars(query);
        for (org.exoplatform.calendar.model.Calendar cal : tmp) {
            LinkedList<Calendar> cals;
            Calendar calendar = Calendar.build((org.exoplatform.calendar.model.Calendar)cal);
            int t = this.calService.getTypeOfCalendar(identity.getUserId(), cal.getId());
            Calendar.Type type = Calendar.Type.getType((int)t);
            String typeName = Calendar.Type.UNDEFINED.equals((Object)type) ? String.valueOf(t) : type.name();
            if (calendar.isShared(identity.getUserId())) {
                typeName = Calendar.Type.SHARED.name();
            }
            if ((cals = (LinkedList<Calendar>)this.calendars.get(typeName)) == null) {
                cals = new LinkedList<Calendar>();
                this.calendars.put(typeName, cals);
            }
            cals.add(calendar);
            this.colorMap.put(cal.getId(), cal.getCalendarColor());
        }
        CalendarSetting setting = CalendarUtils.getCalendarService().getCalendarSetting(CalendarUtils.getCurrentUser());
        for (String key : setting.getSharedCalendarsColors()) {
            this.colorMap.put(key.split(CalendarUtils.COLON)[0], key.split(CalendarUtils.COLON)[1]);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.init();
        this.active();
        super.processRender(context);
    }

    public void active() throws Exception {
        UIQuickAddEvent quickAddTask;
        UIQuickAddEvent quickAddForm;
        UIPopupWindow uiWindowE = (UIPopupWindow)this.getChildById("UIQuickAddEventPopupWindow");
        if (uiWindowE == null) {
            uiWindowE = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "UIQuickAddEventPopupWindow");
        }
        if ((quickAddForm = (UIQuickAddEvent)uiWindowE.getUIComponent()) == null) {
            quickAddForm = (UIQuickAddEvent)this.createUIComponent(UIQuickAddEvent.class, null, null);
        }
        List calendarOption = CalendarUtils.getCalendarOption();
        ((UIFormSelectBoxWithGroups)quickAddForm.getChildById(UIQuickAddEvent.FIELD_CALENDAR)).setOptions(calendarOption);
        quickAddForm.getUIFormSelectBox(UIQuickAddEvent.FIELD_CATEGORY).setOptions(CalendarUtils.getCategory());
        quickAddForm.setEvent(true);
        quickAddForm.setId("UIQuickAddEvent");
        quickAddForm.init(CalendarUtils.getCalendarService().getCalendarSetting(CalendarUtils.getCurrentUser()), String.valueOf(new Date().getTime()), String.valueOf(new Date().getTime()));
        uiWindowE.setUIComponent((UIComponent)quickAddForm);
        uiWindowE.setWindowSize(540, 0);
        UIPopupWindow uiWindowT = (UIPopupWindow)this.getChildById("UIQuickAddTaskPopupWindow");
        if (uiWindowT == null) {
            uiWindowT = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "UIQuickAddTaskPopupWindow");
        }
        if ((quickAddTask = (UIQuickAddEvent)uiWindowT.getUIComponent()) == null) {
            quickAddTask = (UIQuickAddEvent)this.createUIComponent(UIQuickAddEvent.class, null, null);
        }
        quickAddTask.setEvent(false);
        quickAddTask.setId("UIQuickAddTask");
        quickAddTask.init(CalendarUtils.getCalendarService().getCalendarSetting(CalendarUtils.getCurrentUser()), String.valueOf(new Date().getTime()), String.valueOf(new Date().getTime()));
        ((UIFormSelectBoxWithGroups)quickAddTask.getChildById(UIQuickAddEvent.FIELD_CALENDAR)).setOptions(calendarOption);
        quickAddTask.getUIFormSelectBox(UIQuickAddEvent.FIELD_CATEGORY).setOptions(CalendarUtils.getCategory());
        uiWindowT.setUIComponent((UIComponent)quickAddTask);
        uiWindowT.setWindowSize(540, 0);
    }

    public Map<String, List<Calendar>> getCalendarMap() {
        return this.calendars;
    }

    public Map<String, String> getColorMap() {
        return this.colorMap;
    }
}

