/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.webui.popup.UICalendarForm;
import org.exoplatform.calendar.webui.popup.UISelectComponent;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="app:/templates/calendar/webui/UIPopup/UIGroupCalendarTab.gtmpl")
public class UIGroupCalendarTab
extends UIFormInputWithActions {
    private static final Log LOG = ExoLogger.getExoLogger(UIGroupCalendarTab.class);
    private Map<String, List<UIFormInputWithActions.ActionData>> actionField_;
    private Set<String> groupsList;
    private Set<String> groupsListInitial;

    protected UIForm getParentFrom() {
        return (UIForm)this.getParent();
    }

    public void processRender(WebuiRequestContext arg0) throws Exception {
        super.processRender(arg0);
    }

    public void setGroupsListInitial() {
        this.groupsListInitial = new HashSet(this.groupsList);
    }

    public String[] getDeletedGroup() {
        ArrayList<String> deletedGroups = new ArrayList<String>();
        for (String groupId : this.groupsListInitial) {
            if (this.groupsList.contains(groupId)) continue;
            deletedGroups.add(groupId);
        }
        return deletedGroups.toArray(new String[0]);
    }

    public UIGroupCalendarTab(String id) throws Exception {
        super(id);
        this.setComponentConfig(this.getClass(), null);
        this.actionField_ = new HashMap();
        this.groupsList = new HashSet();
    }

    public void resetTab() {
        Iterator it = this.groupsList.iterator();
        while (it.hasNext()) {
            String groupId = (String)it.next();
            UIFormStringInput groupPermission = (UIFormStringInput)this.getChildById(groupId + "_permission");
            groupPermission.setValue(null);
            groupPermission.setRendered(false);
            it.remove();
        }
        UIFormStringInput addGroupInput = (UIFormStringInput)this.getChildById("AddGroupInput");
        addGroupInput.setValue((Object)"");
    }

    public void addGroupPermissionEntry(String groupId) throws Exception {
        if (!this.addGroupToDisplay(groupId)) {
            return;
        }
        if (this.getChildById(groupId + "_permission") != null) {
            UIFormStringInput groupPermissionInput = (UIFormStringInput)this.getChildById(groupId + "_permission");
            groupPermissionInput.setRendered(true);
            groupPermissionInput.setValue((Object)CalendarUtils.getCurrentUser());
            return;
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput(groupId + "_permission", groupId + "_permission", CalendarUtils.getCurrentUser()));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData selectUserAction = new UIFormInputWithActions.ActionData();
        selectUserAction.setActionListener("SelectPermission");
        selectUserAction.setActionName("SelectUser");
        selectUserAction.setActionParameter(UISelectComponent.TYPE_USER + ":" + groupId + "_permission");
        selectUserAction.setActionType(0);
        selectUserAction.setCssIconClass("uiIconUser uiIconLightGray");
        actions.add(selectUserAction);
        UIFormInputWithActions.ActionData selectMembershipAction = new UIFormInputWithActions.ActionData();
        selectMembershipAction.setActionListener("SelectPermission");
        selectMembershipAction.setActionName("SelectMemberShip");
        selectMembershipAction.setActionParameter(UISelectComponent.TYPE_MEMBERSHIP + ":" + groupId + "_permission");
        selectMembershipAction.setActionType(0);
        selectMembershipAction.setCssIconClass("uiIconMembership uiIconLightGray");
        actions.add(selectMembershipAction);
        UIFormInputWithActions.ActionData deletePermissionAction = new UIFormInputWithActions.ActionData();
        deletePermissionAction.setActionListener("DeletePermission");
        deletePermissionAction.setActionName("DeletePermission");
        deletePermissionAction.setActionParameter(UISelectComponent.TYPE_GROUP + ":" + groupId + "_permission");
        deletePermissionAction.setActionType(0);
        deletePermissionAction.setCssIconClass("uiIconDelete uiIconLightGray");
        actions.add(deletePermissionAction);
        this.setActionField(groupId + "_permission", actions);
    }

    public void removeGroupPermissionEntry(String groupId) {
        if (!this.containsGroup(groupId)) {
            return;
        }
        this.removeGroup(groupId);
        UIFormStringInput groupPermissionInput = this.getUIStringInput(groupId + "_permission");
        if (groupPermissionInput != null) {
            groupPermissionInput.setValue((Object)"");
            groupPermissionInput.setRendered(false);
        }
    }

    public boolean addGroupToDisplay(String groupId) throws Exception {
        if (!UICalendarForm.isGroupBelongingToUserGroups((String)groupId)) {
            return false;
        }
        return this.groupsList.add(groupId);
    }

    public void removeGroup(String groupId) {
        this.groupsList.remove(groupId);
    }

    public String[] getGroupsAddedToTheCalendar() {
        ArrayList<String> groupsAdded = new ArrayList<String>();
        for (String groupId : this.groupsList) {
            String groupPermission = (String)((UIFormStringInput)this.getChildById(groupId + "_permission")).getValue();
            if (groupPermission == null || (groupPermission = groupPermission.trim()).isEmpty()) continue;
            groupsAdded.add(groupId);
        }
        return groupsAdded.toArray(new String[0]);
    }

    public String[] getDisplayedGroups() {
        return this.groupsList.toArray(new String[0]);
    }

    public boolean containsGroup(String groupId) {
        return this.groupsList.contains(groupId);
    }

    public void setActionField(String fieldName, List<UIFormInputWithActions.ActionData> actions) {
        this.actionField_.put(fieldName, actions);
    }

    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (List)this.actionField_.get(fieldName);
    }

    private String truncateGroupId(String groupId) {
        String[] groupIdParts = groupId.split(CalendarUtils.SLASH);
        char[] newGroupId = groupIdParts[groupIdParts.length - 1].toCharArray();
        newGroupId[0] = Character.toUpperCase(newGroupId[0]);
        return new String(newGroupId).replaceAll("[^a-zA-Z0-9]+", " ");
    }
}

